<?php
/**
 * Theme Custom Post Type(CPTs)
 * @package Senatory
 * @since 1.0.0
 */

if (!defined('ABSPATH')) {
    exit(); //exit if access directly
}

if (!class_exists('Senatory_Custom_Post_Type')) {
    class Senatory_Custom_Post_Type
    {

        //$instance variable
        private static $instance;

        public function __construct()
        {
            //register post type
            add_action('init', array($this, 'register_custom_post_type'));
        }

        /**
         * get Instance
         * @since  2.0.0
         */
        public static function getInstance()
        {
            if (null == self::$instance) {
                self::$instance = new self();
            }

            return self::$instance;
        }

        /**
         * Register Custom Post Type
         * @since  2.0.0
         */
        public function register_custom_post_type()
        {
            if (!defined('ELEMENTOR_VERSION')) {
                return;
            }
            $all_post_type = array(
                [
                    'post_type' => 'service',
                    'args' => array(
                        'label' => esc_html__('Service', 'senatory-core'),
                        'description' => esc_html__('Service', 'senatory-core'),
                        'labels' => array(
                            'name' => esc_html_x('Service', 'Post Type General Name', 'senatory-core'),
                            'singular_name' => esc_html_x('Service', 'Post Type Singular Name', 'senatory-core'),
                            'menu_name' => esc_html__('Service', 'senatory-core'),
                            'all_items' => esc_html__('Services', 'senatory-core'),
                            'view_item' => esc_html__('View Service', 'senatory-core'),
                            'add_new_item' => esc_html__('Add New Service', 'senatory-core'),
                            'add_new' => esc_html__('Add New Service', 'senatory-core'),
                            'edit_item' => esc_html__('Edit Service', 'senatory-core'),
                            'update_item' => esc_html__('Update Service', 'senatory-core'),
                            'search_items' => esc_html__('Search Service', 'senatory-core'),
                            'not_found' => esc_html__('Not Found', 'senatory-core'),
                            'not_found_in_trash' => esc_html__('Not found in Trash', 'senatory-core'),
                            'featured_image' => esc_html__('Service Image', 'senatory-core'),
                            'remove_featured_image' => esc_html__('Remove Service Image', 'senatory-core'),
                            'set_featured_image' => esc_html__('Set Service Image', 'senatory-core'),
                        ),
                        'supports' => array('title', 'thumbnail', 'excerpt', 'editor', 'comments'),
                        'hierarchical' => false,
                        'public' => true,
                        'has_archive'       => true,
                        "publicly_queryable" => true,
                        'show_ui' => true,
                        'show_in_menu' => true,
                        "rewrite" => array('slug' => 'all-services', 'with_front' => true),
                        'can_export' => true,
                        'capability_type' => 'post',
                        "show_in_rest" => true,
                        'query_var' => true
                    )
                ],

                [
                    'post_type' => 'team',
                    'args' => array(
                        'label' => esc_html__('Team', 'senatory-core'),
                        'description' => esc_html__('Team', 'senatory-core'),
                        'labels' => array(
                            'name' => esc_html_x('Team', 'Post Type General Name', 'senatory-core'),
                            'singular_name' => esc_html_x('Team', 'Post Type Singular Name', 'senatory-core'),
                            'menu_name' => esc_html__('Team', 'senatory-core'),
                            'all_items' => esc_html__('Team', 'senatory-core'),
                            'view_item' => esc_html__('View Team', 'senatory-core'),
                            'add_new_item' => esc_html__('Add New Team', 'senatory-core'),
                            'add_new' => esc_html__('Add New Team', 'senatory-core'),
                            'edit_item' => esc_html__('Edit Team', 'senatory-core'),
                            'update_item' => esc_html__('Update Team', 'senatory-core'),
                            'search_items' => esc_html__('Search Team', 'senatory-core'),
                            'not_found' => esc_html__('Not Found', 'senatory-core'),
                            'not_found_in_trash' => esc_html__('Not found in Trash', 'senatory-core'),
                            'featured_image' => esc_html__('Team Image', 'senatory-core'),
                            'remove_featured_image' => esc_html__('Remove Team Image', 'senatory-core'),
                            'set_featured_image' => esc_html__('Set Team Image', 'senatory-core'),
                        ),
                        'supports' => array('title', 'thumbnail', 'excerpt', 'editor', 'comments'),
                        'hierarchical' => false,
                        'public' => true,
                        'has_archive'       => true,
                        "publicly_queryable" => true,
                        'show_ui' => true,
                        'show_in_menu' => true,
                        "rewrite" => array('slug' => 'all-teams', 'with_front' => true),
                        'can_export' => true,
                        'capability_type' => 'post',
                        "show_in_rest" => true,
                        'query_var' => true
                    )
                ],
				
				[
					'post_type' => 'issue',
					'args'      => array(
						'label'              => esc_html__( 'Issue', 'senatory-core' ),
						'description'        => esc_html__( 'Issue', 'senatory-core' ),
						'labels'             => array(
							'name'               => esc_html_x( 'Issue', 'Post Type General Name', 'senatory-core' ),
							'singular_name'      => esc_html_x( 'Issue', 'Post Type Singular Name', 'senatory-core' ),
							'menu_name'          => esc_html__( 'Issue', 'senatory-core' ),
							'all_items'          => esc_html__( 'Issues', 'senatory-core' ),
							'view_item'          => esc_html__( 'View Issue', 'senatory-core' ),
							'add_new_item'       => esc_html__( 'Add New Issue', 'senatory-core' ),
							'add_new'            => esc_html__( 'Add New Issue', 'senatory-core' ),
							'edit_item'          => esc_html__( 'Edit Issue', 'senatory-core' ),
							'update_item'        => esc_html__( 'Update Issue', 'senatory-core' ),
							'search_items'       => esc_html__( 'Search Issue', 'senatory-core' ),
							'not_found'          => esc_html__( 'Not Found', 'senatory-core' ),
							'not_found_in_trash' => esc_html__( 'Not found in Trash', 'senatory-core' ),
							'featured_image' => esc_html__( 'Issue Image', 'senatory-core' ),
							'remove_featured_image' => esc_html__( 'Remove Issue Image', 'senatory-core' ),
							'set_featured_image' => esc_html__( 'Set Issue Image', 'senatory-core' ),
						),
						'supports'           => array( 'title','thumbnail','excerpt','editor','comments' ),
						'hierarchical'       => false,
						'public'             => true,
						"publicly_queryable" => true,
						'show_ui'            => true,
						'show_in_menu'       => true,
						"rewrite" => array( 'slug' => 'all-issues', 'with_front' => true),
						'can_export'         => true,
						'capability_type'    => 'post',
                        "show_in_rest"       => true,
						'query_var'          => true
					)
				],
				
				
            );

            if (!empty($all_post_type) && is_array($all_post_type)) {

                foreach ($all_post_type as $post_type) {
                    call_user_func_array('register_post_type', $post_type);
                }
            }


            /**
             * Custom Taxonomy Register
             * @since 1.0.0
            */

            $all_custom_taxonmy = array(
                array(
                    'taxonomy' => 'service-cat',
                    'object_type' => 'service',
                    'args' => array(
                        "labels" => array(
                            "name" => esc_html__("Service Category", 'senatory-core'),
                            "singular_name" => esc_html__("Service Category", 'senatory-core'),
                            "menu_name" => esc_html__("Service Category", 'senatory-core'),
                            "all_items" => esc_html__("All Service Category", 'senatory-core'),
                            "add_new_item" => esc_html__("Add New Service Category", 'senatory-core')
                        ),
                        "public" => true,
                        "hierarchical" => true,
                        "show_ui" => true,
                        "show_in_menu" => true,
                        "show_in_nav_menus" => true,
                        "query_var" => true,
                        "rewrite" => array('slug' => 'service-cat', 'with_front' => true),
                        "show_admin_column" => true,
                        "show_in_rest" => true,
                        "show_in_quick_edit" => true,
                    )
                ),

                array(
                    'taxonomy' => 'team-cat',
                    'object_type' => 'service',
                    'args' => array(
                        "labels" => array(
                            "name" => esc_html__("Team Category", 'senatory-core'),
                            "singular_name" => esc_html__("Team Category", 'senatory-core'),
                            "menu_name" => esc_html__("Team Category", 'senatory-core'),
                            "all_items" => esc_html__("All Team Category", 'senatory-core'),
                            "add_new_item" => esc_html__("Add New Team Category", 'senatory-core')
                        ),
                        "public" => true,
                        "hierarchical" => true,
                        "show_ui" => true,
                        "show_in_menu" => true,
                        "show_in_nav_menus" => true,
                        "query_var" => true,
                        "rewrite" => array('slug' => 'team-cat', 'with_front' => true),
                        "show_admin_column" => true,
                        "show_in_rest" => true,
                        "show_in_quick_edit" => true,
                    )
                ),
				
				array(
					'taxonomy' => 'issue-cat',
					'object_type' => 'issue',
					'args' => array(
						"labels" => array(
							"name" => esc_html__( "Issue Category", 'senatory-core' ),
							"singular_name" => esc_html__( "Issue Category", 'senatory-core' ),
							"menu_name" => esc_html__( "Issue Category", 'senatory-core' ),
							"all_items" => esc_html__( "All Issue Category", 'senatory-core' ),
							"add_new_item" => esc_html__( "Add New Issue Category", 'senatory-core' )
						),
						"public" => true,
						"hierarchical" => true,
						"show_ui" => true,
						"show_in_menu" => true,
						"show_in_nav_menus" => true,
						"query_var" => true,
						"rewrite" => array( 'slug' => 'issue-cat', 'with_front' => true),
						"show_admin_column" => true,
						"show_in_rest" => true,
						"show_in_quick_edit" => true,
					)
				),
				



            );

            if (is_array($all_custom_taxonmy) && !empty($all_custom_taxonmy)) {
                foreach ($all_custom_taxonmy as $taxonomy) {
                    call_user_func_array('register_taxonomy', $taxonomy);
                }
            }

            flush_rewrite_rules();
        }

    }//end class

    if (class_exists('Senatory_Custom_Post_Type')) {
        Senatory_Custom_Post_Type::getInstance();
    }
}