<?php
/**
 * Elementor Widget
 * @package Senatory
 * @since 1.0.0
 */

namespace Elementor;
class Senatory_Avatar_Video extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'senatory-avatar-video-widget';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Avatar 01', 'senatory-core');
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'bl_icon eicon-person';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['senatory_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {

        $this->start_controls_section(
            'settings_section',
            [
                'label' => esc_html__('General Settings', 'senatory-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'avatar_image',
            [
                'label' => esc_html__('Avatar Image', 'senatory-core'),
                'type' => Controls_Manager::MEDIA,
                'show_label' => false,
                'description' => esc_html__('avatar image', 'senatory-master'),
                'default' => [
                    'src' => Utils::get_placeholder_image_src()
                ],
            ]
        );

        
        $this->add_control(
            'video_url',
            [
                'label' => esc_html__('Video URL', 'senatory-core'),
                'type' => Controls_Manager::URL,
                'description' => esc_html__('Video Url', 'senatory-core'),
                'default' => [
                    'url' => 'https://www.youtube.com/watch?v=-ZwQtICNbRc'
                ]
            ]
        );

        $this->add_control(
            'icon', 
            [
                'label' => esc_html__('Icon', 'senatory-core'),
                'type' => Controls_Manager::ICONS,
                'description' => esc_html__('Icon', 'senatory-core'),
                'default' => [
                    'value' => 'flaticon-envelope',
                    'library' => 'solid',
                ]
            ]
        );



        $this->end_controls_section();

    }

    /**
     * Render Elementor widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        ?>
            <div class="party-single-thumb">
            <img src="<?php echo esc_url($settings['avatar_image']['url']); ?>" alt="candidate">
            <div class="party-single-thumb-video">
                <a class="video-play style-01 style-05 mfp-iframe" href="<?php echo esc_url($settings['video_url']['url']); ?>">
                    <?php
                        Icons_Manager::render_icon($settings['icon'], ['aria-hidden' => 'true']);
                    ?>
                </a>
            </div>
            </div>
        <?php
    }
}

Plugin::instance()->widgets_manager->register_widget_type(new Senatory_Avatar_Video());