<?php
/**
 * Elementor Widget
 * @package Senatory
 * @since 1.0.0
 */

namespace Elementor;
class Senatory_banner_five_Widget extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'senatory-banner-five-widget';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Bannner Five Section', 'senatory-core');
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'bl_icon eicon-archive-title';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['senatory_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {

        $this->start_controls_section(
            'settings_section',
            [
                'label' => esc_html__('Section Contents', 'senatory-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'sub_slo',
            [
                'label' => __('Banner Slogun', 'senatory-core'),
                'type' => Controls_Manager::TEXT,
                'label_block'=>true,
                'default' => __('LETS STAND TOGETHER', 'senatory-core'),
            ]
        );

          $this->add_control(
            'desig',
            [
                'label' => __('Politicians Name', 'senatory-core'),
                'type' => Controls_Manager::TEXT,
                'label_block'=>true,
                'default' => __('City Mayor', 'senatory-core'),
            ]
        );

          $this->add_control(
            'title',
            [
                'label' => __('Title', 'senatory-core'),
                'type' => Controls_Manager::TEXT,
                'label_block'=>true,
                'default' => __('We Can Make Our City Great Again!', 'senatory-core'),
            ]
        );
        $this->add_control(
            'sub_title',
            [
                'label' => __('Sub Tile', 'senatory-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => __('President represented Delaware for 36 years in the U.S. Senate before becoming the 47th Vice President of the United States. As President, Harison will restore America’s leadership
                 and build our communities back better.', 'senatory-core'),
            ]
        );


        $this->add_control(
            'custom_logo_upload',
            [
                'label' => esc_html__('Desktop Logo', 'senatory-core'),
                'type' => Controls_Manager::MEDIA,
                'show_label' => false,
                'description' => esc_html__('Upload Desktop Logo', 'senatory-core'),
                'default' => [
                    'src' => Utils::get_placeholder_image_src()
                ],
            ]
            );

         $this->add_control(
            'custom_logo_upload1',
            [
                'label' => esc_html__('Mobile Logo', 'senatory-core'),
                'type' => Controls_Manager::MEDIA,
                'show_label' => false,
                'description' => esc_html__('Upload Mobile Logo', 'senatory-core'),
                'default' => [
                    'src' => Utils::get_placeholder_image_src()
                ],
            ]
            );

        $this->add_control(
            'banner_image_5',
            [
                'label' => esc_html__('Banner Bg Image', 'senatory-core'),
                'type' => Controls_Manager::MEDIA,
                'show_label' => false,
                'description' => esc_html__('Upload background image', 'senatory-core'),
                'default' => [
                    'src' => Utils::get_placeholder_image_src()
                ],
            ]
        );

        $this->add_control(
            'image_sec',
            [
                'label' => esc_html__('Banner Image', 'senatory-core'),
                'type' => Controls_Manager::MEDIA,
                'show_label' => false,
                'description' => esc_html__('Upload Banner image', 'senatory-core'),
                'default' => [
                    'src' => Utils::get_placeholder_image_src()
                ],
            ]
        );

        $this->add_control(
            'main_nav',
            [
                'label' => __('Main Menu', 'senatory-core'),
                'type' => Controls_Manager::SELECT2,
                'options' =>  senatory_core()->king_menu_select_choices(),
                'multiple' => false,
                'label_block' => true,
            ]
        );

           //Banner button start
        $this->add_control(
            'button1',
            [
                'label' => __('Banner Button Name', 'senatory-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Read More', 'senatory-core'),
            ]
        );

        $this->add_control(
            'url1',
            [
                'label' => __('Link', 'senatory-core'),
                'type' => \Elementor\Controls_Manager::URL,
                'show_external' => true,
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true,
                ],
            ]
        );
         //banner button end

        //menu button start
        $this->add_control(
            'button2',
            [
                'label' => __('Menu Button Name', 'senatory-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('join now', 'senatory-core'),
            ]
        );

        $this->add_control(
            'url2',
            [
                'label' => __('Link', 'senatory-core'),
                'type' => \Elementor\Controls_Manager::URL,
                'show_external' => true,
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true,
                ],
            ]
        );
         //menu button end

        $this->end_controls_section();
        /* button styling end */

    $this->start_controls_section(
            'content_sty',
            [
                'label' => __('Banner Basic Style', 'senatory-core'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
  
        $this->add_control(
            'post_title_color',    
            [
                'label' => __('Title Color', 'senatory-core'),
                'type' => \Elementor\Controls_Manager::COLOR,        
                'selectors' => [
                    '{{WRAPPER}} .header-area.header-sanatory .header-inner-02 .title' => 'color: {{VALUE}}',
                ],
            ]
        );

         $this->add_control(
            'banner_slogu',    
            [
                'label' => __('Slogun Color', 'senatory-core'),
                'type' => \Elementor\Controls_Manager::COLOR,        
                'selectors' => [
                     '{{WRAPPER}} .header-area.header-sanatory .header-inner-02 .subtitle' => 'color: {{VALUE}}',
                ],
            ]
        );

           $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 's_typo',
                'label' => __('Slogun Typography', 'senatory-core'),
                'selector' => '.header-area.header-sanatory .header-inner-02 .subtitle',
            ]
        );


        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'ttih',
                'label' => __('Title Typography', 'senatory-core'),
                'selector' => '{{WRAPPER}} .header-area.header-sanatory .header-inner-02 .title, {{WRAPPER}} .header-area.header-sanatory .header-inner-02 .subtitle',
            ]
        );


        $this->add_control(
            'post_content_color',    
            [
                'label' => __('Content Color', 'senatory-core'),
                'type' => \Elementor\Controls_Manager::COLOR,        
                'selectors' => [
                    '{{WRAPPER}} .header-area.header-sanatory .header-inner-02 p' => 'color: {{VALUE}}',
                ],
            ]
        );

           $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'tctih',
                'label' => __('Content Typography', 'senatory-core'),   
                'selector' => '{{WRAPPER}} .header-area.header-sanatory .header-inner-02 p',
            ]
        );


        $this->add_control(
            'extra_c',
            [
                'label' => esc_html__( 'Extra Content', 'senatory-core' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );


         $this->add_control(
            'extra_color',    
            [
                'label' => __('Extra Content Color', 'senatory-core'),
                'type' => \Elementor\Controls_Manager::COLOR,        
                'selectors' => [
                    '{{WRAPPER}} .header-area.header-sanatory .header-inner-02 .subtitle span' => 'color: {{VALUE}}',
                ],
            ]
        );

           $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'extra_tye',
                'label' => __('Extra Content Typography', 'senatory-core'),   
                'selector' => '{{WRAPPER}} .header-area.header-sanatory .header-inner-02 .subtitle span',
            ]
        );

    $this->end_controls_section();

 
      $this->start_controls_section(
            'banner_butsty',
            [
                'label' => __('Banner Button Style', 'senatory-core'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'ttihbtn',
                'label' => __('Button Typography', 'senatory-core'),
                'selector' => '{{WRAPPER}} .btn-wrapper .boxed-btn.read-btn',
            ]
        );

            $this->add_control(
            'testi_sub_bg',    
            [
                'label' => __('Button Font Color', 'senatory-core'),
                'type' => \Elementor\Controls_Manager::COLOR,        
                'selectors' => [
                    '{{WRAPPER}} .btn-wrapper .boxed-btn.read-btn' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'border',
                'label' => esc_html__( 'Banner Button Border', 'senatory-core' ),
                'show_label'=>true,
                'selector' => '{{WRAPPER}} .btn-wrapper .boxed-btn.read-btn',
            ]
        );

         $this->end_controls_section();

          $this->start_controls_section(
            'mneu_butsty',
            [
                'label' => __('Menu Style', 'senatory-core'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

         $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'menu_bg',
                'label' => esc_html__('Menu Background ', 'senatory-master'),
                'types' => [ 'classic', 'gradient' ],
                'selector' => '{{WRAPPER}} .navbar-area.nav-style-03 .nav-container',

            ]
        );

           $this->add_control(
            'font_color',    
            [
                'label' => __('Menu Font Color', 'senatory-core'),
                'type' => \Elementor\Controls_Manager::COLOR,        
                'selectors' => [
                    '{{WRAPPER}} .navbar-area.nav-style-03 .nav-container .navbar-collapse .navbar-nav li a' => 'color: {{VALUE}}',
                ],
            ]
        );

       $this->add_control(
            'heading1',
            [
                'label' => esc_html__( 'Menu Button Border', 'senatory-core' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'Menu_Button_Border',
                'label' => esc_html__( 'Menu Button Border', 'senatory-core' ),
                'show_label'=>true,
                'selector' => '{{WRAPPER}} .btn-wrapper .boxed-btn.btn-sanatory.style-04',
            ]
        );

            $this->add_control(
            'heading2',
            [
                'label' => esc_html__( 'Menu Button Hover', 'senatory-core' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

           $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'Menu_Button_Bordera',
                'label' => esc_html__('Menu Button Border hover ', 'senatory-master'),
                'types' => [ 'classic', 'gradient' ],
                'selector' => '{{WRAPPER}} .btn-wrapper .boxed-btn.btn-sanatory.style-04:hover',

            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'm_b_typo',
                'label' => __('Menu Button Typography', 'senatory-core'),
                'selector' => '{{WRAPPER}} .btn-wrapper .boxed-btn.btn-sanatory.style-04',
            ]
        );

            $this->add_control(
            'heading3',
            [
                'label' => esc_html__( 'Menu Item Typography', 'senatory-core' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

               $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'm_o_typo',
                'label' => __('Menu Typography', 'senatory-core'),
                'selector' => '{{WRAPPER}} .navbar-area.nav-style-03 .nav-container .navbar-collapse .navbar-nav li a',
            ]
        );


        $this->end_controls_section();

    }

    /**
     * Render Elementor widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $main_menu = $settings['main_nav'];
        ?>
		
  <div class="header-style-05">
    <!-- Mobile Supported Navbar Start -->
    <nav class="navbar navbar-area style-01 d-lg-none d-md-block navbar-expand-lg nav-style-02">
      <div class="container nav-container">
        <div class="responsive-mobile-menu">
          <div class="logo-wrapper">
            <a href="<?php echo site_url(); ?>" class="logo">
              <img src="<?php echo esc_url($settings['custom_logo_upload1']['url']); ?>" alt="" />
            </a>
          </div>
          <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#themeIm_main_menu"
            aria-expanded="false" aria-label="Toggle navigation">
            <span class="navbar-toggler-icon"></span>
          </button>
        </div>
            <?php
            wp_nav_menu(array(
                'menu_class' => 'navbar-nav',
                'container' => 'div',
                 'menu' =>    $main_menu,
                'container_class' => 'collapse navbar-collapse',
                'container_id' => 'themeIm_main_menu'
            ));
            ?>
        <div class="nav-right-content style-01">
          <div class="btn-wrapper">
            <a href="#" class="boxed-btn political-btn">Donate <i class="icomoon-paper-plan"></i></a>
          </div>
        </div>
      </div>
    </nav>
    <!-- Mobile Supported Navbar End -->
    <!-- Banner Section Area Start Here -->
    <div class="header-area header-sanatory header-bg-04" style="background-image:url(<?php echo esc_url($settings['banner_image_5']['url']); ?>);">
        <div class="container custom-container-02">
            <div class="home-five-banner">
                <div class="row align-items-center">
                    <div class="col-lg-6">
                        <div class="header-inner-02">
                            <h4 class="subtitle"><?php  echo esc_html($settings['sub_slo']); ?><i class="icomoon-star"></i><i class="icomoon-star"></i><i class="icomoon-star"></i> <span><?php echo esc_html($settings['desig']); ?></span></h4>
                            <h1 class="title"><?php  echo ($settings['title']); ?></h1>  
                            <p><?php echo esc_html($settings['sub_title']); ?></p>
                            <div class="btn-wrapper">
                                <a href="<?php echo esc_attr($settings['url1']['url']); ?>" class="boxed-btn read-btn"><i class="fas fa-arrow-right"></i><?php echo esc_html($settings['button1']); ?></a>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-5 offset-lg-1">
                        <?php if(!empty($settings['image_sec']['url'])): ?>
                        <div class="thumbnail">
                            <img src="<?php echo esc_url($settings['image_sec']['url']); ?>" alt="mayor image">
                        </div>
                    <?php endif ?>
                    </div>
                </div>
            </div>
            <!-- Navbr area Start -->
            <nav class="navbar navbar-area navbar-expand-lg nav-style-03">
                <div class="container nav-container home-five">
                    <div class="responsive-mobile-menu">
                    <div class="logo-wrapper">
                          <a href="<?php echo site_url(); ?>" class="logo">
                          <img src="<?php echo esc_url($settings['custom_logo_upload']['url']); ?>" alt="" />
                        </a>
                    </div>
                    <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#themeIm_main_menu"
                        aria-expanded="false" aria-label="Toggle navigation">
                        <span class="navbar-toggler-icon"></span>
                    </button>
                    </div>
                 
                          <?php
                            wp_nav_menu(array(
                                'menu_class' => 'navbar-nav',
                                'container' => 'div',
                                 'menu' =>    $main_menu,
                                'container_class' => 'collapse navbar-collapse',
                                'container_id' => 'themeIm_main_menu'
                            ));
                            ?>
                  
                    <div class="nav-right-content">
                        <div class="btn-wrapper">
                            <a href="<?php echo esc_attr($settings['url2']['url']); ?>" class="boxed-btn btn-sanatory style-04"><?php echo esc_html($settings['button2']); ?><i class="icomoon-paper-plan"></i></a>
                        </div>
                    </div>
                </div>
            </nav>
            <!-- navbar area end -->
        </div>
    </div>
    <!-- Banner Section Area End Here -->
  </div>
  
  

        <?php
    }
}

Plugin::instance()->widgets_manager->register_widget_type(new Senatory_banner_five_Widget());