<?php
/**
 * Elementor Widget
 * @package Senatory
 * @since 1.0.0
 */

namespace Elementor;
class Senatory_Blog_Grid_Two_Widget extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'senatory-blog-grid-two-widget';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Blog Grid : 02', 'senatory-master');
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'bl_icon eicon-archive-title';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['senatory_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {

        $this->start_controls_section(
            'settings_section',
            [
                'label' => esc_html__('Section Contents', 'senatory-master'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

		
		$this->add_control(
            'column',
            [
                'label' => esc_html__('Column', 'senatory-core'),
                'type' => Controls_Manager::SELECT,
                'options' => array(
                    '12'=>  esc_html__('01 Column', 'senatory-core'),
                    '6' =>  esc_html__('02 Column', 'senatory-core'),
                    '4' =>  esc_html__('03 Column', 'senatory-core'),
                    '3' =>  esc_html__('04 Column', 'senatory-core')
                ),
                'description' => esc_html__('Select grid column', 'senatory-core'),
                'default' => '6',
            ]
        );
		
		        $this->add_control('total', [
            'label' => esc_html__('Total Posts', 'senatory-core'),
            'type' => Controls_Manager::TEXT,
            'default' => '-1',
            'description' => esc_html__('enter how many post you want in masonry , enter -1 for unlimited post.')
        ]);
		
		
        $this->add_control('category', [
            'label' => esc_html__('Category', 'senatory-core'),
            'type' => Controls_Manager::SELECT2,
            'multiple' => true,
            'options' => senatory_core()->get_terms_names('category', 'id'),
            'description' => esc_html__('select category as you want, leave it blank for all category', 'senatory-core'),
        ]);
		
		
        $this->add_control('order', [
            'label' => esc_html__('Order', 'senatory-core'),
            'type' => Controls_Manager::SELECT,
            'options' => array(
                'ASC' => esc_html__('Ascending', 'senatory-core'),
                'DESC' => esc_html__('Descending', 'senatory-core'),
            ),
            'default' => 'ASC',
            'description' => esc_html__('select order', 'senatory-core')
        ]);
		
		
        $this->add_control('orderby', [
            'label' => esc_html__('OrderBy', 'senatory-core'),
            'type' => Controls_Manager::SELECT,
            'options' => array(
                'ID' => esc_html__('ID', 'senatory-core'),
                'title' => esc_html__('Title', 'senatory-core'),
                'date' => esc_html__('Date', 'senatory-core'),
                'rand' => esc_html__('Random', 'senatory-core'),
                'comment_count' => esc_html__('Most Comments', 'senatory-core'),
            ),
            'default' => 'ID',
            'description' => esc_html__('select order', 'senatory-core')
        ]);
		
		
        $this->add_control(
            'pagination',
            [
                'label' => esc_html__('Pagination', 'senatory-core'),
                'type' => Controls_Manager::SWITCHER,
                'description' => esc_html__('you can set yes to show pagination.', 'senatory-core'),
                'default' => 'no'
            ]
        );
        $this->add_control(
            'blog_btn_text',
            [
                'label' => esc_html__('Button Text', 'senatory-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Read More', 'senatory-core'),
                'description' => esc_html__('Enter button text', 'senatory-core'),
            ]
        );
        $this->end_controls_section();
		
		
		
		 $this->start_controls_section(
            'boxx_section',
            [
                'label' => esc_html__('Vision Boxes', 'senatory-master'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

		
		$repeater = new \Elementor\Repeater();


        $repeater->add_control(
            'box-title', [
                'label' => esc_html__('Title', 'senatory-master'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('We Will Win The Elections', 'senatory-master'),
                'description' => esc_html__('Enter title', 'senatory-master')
            ]
        );

        $repeater->add_control(
            'box-text', [
                'label' => esc_html__('Box Content', 'senatory-master'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('Together we can make Better country', 'senatory-master'),
                'description' => esc_html__('Enter box content', 'senatory-master')
            ]
        );
		
		$repeater->add_control(
            'icon', [
                'label' => esc_html__('Icon', 'senatory-master'),
                'type' => Controls_Manager::ICONS,
                'description' => esc_html__('Select Icon', 'senatory-master'),
                'default' => [
                    'value' => 'flaticon-statistics',
                    'library' => 'solid',
                ]
            ]
        );

        $this->add_control('boxvision_sliders', [
            'label' => esc_html__('Vision Box Items', 'senatory-master'),
            'type' => Controls_Manager::REPEATER,
            'fields' => $repeater->get_controls(),
            
            'default' => [
                [
                    
                    'description' => esc_html__('President represented Delaware for 36 years in the US', 'senatory-master'),
                    'title' => esc_html__('Together we can make Better country', 'senatory-master'),
                ]
            ],

        ]);
		
		
		
		$this->end_controls_section();
		
		
		
        $this->start_controls_section(
            'css_styles',
            [
                'label' => esc_html__('Styling Settings', 'senatory-master'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

		$this->add_control('slider_title_color', [
            'label' => esc_html__('Title Color', 'senatory-master'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .news-single-items-two .content .title" => "color: {{VALUE}}"
            ]
        ]);
		$this->add_control('blog_grid_desc_color', [
            'label' => esc_html__('Description Color', 'senatory-master'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .news-single-items-two .content p" => "color: {{VALUE}}"
            ]
        ]);
		$this->add_control('blog_grid_readmore_color', [
            'label' => esc_html__('Read More Color', 'senatory-master'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .news-single-items-two .content .btn-wrapper .event-btn" => "color: {{VALUE}}"
            ]
        ]);
        $this->add_control(
			'item_bdr_radius',
			[
				'label' => esc_html__( 'Item Border Radius', 'senatory-core' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 5,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 5,
				],
				'selectors' => [
					'{{WRAPPER}} .news-single-items .news-bg, .news-single-items .news-bg::before' => 'border-radius: {{SIZE}}{{UNIT}};',
				],
			]
		);
        $this->add_control(
			'item_cat_position',
			[
				'label' => esc_html__( 'Category X-Position', 'senatory-core' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 5,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 0,
				],
				'selectors' => [
					'{{WRAPPER}} .news-single-items-two .thumbnail .tag' => 'left: {{SIZE}}{{UNIT}};',
				],
			]
		);
        $this->add_control(
			'item_cat_bdr_radius',
			[
				'label' => esc_html__( 'Category Border Radius', 'senatory-core' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 5,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 5,
				],
				'selectors' => [
					'{{WRAPPER}} .news-single-items-two .thumbnail .tag' => 'border-radius: {{SIZE}}{{UNIT}};',
				],
			]
		);
        $this->add_control('slider_subtitle_color', [
            'label' => esc_html__('Slider Sub Title Color', 'senatory-master'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .custom-testimonial-one-wrap .party-single-item.style-02 .content .subtitle p" => "color: {{VALUE}}"
            ]
        ]);
		

        $this->end_controls_section();


		
		
        /* button styling end */

        /* typography settings start */
        $this->start_controls_section('typography_settings', [
            'label' => esc_html__('Typography Settings', 'senatory-master'),
            'tab' => Controls_Manager::TAB_STYLE
        ]);
       
	  
	  	$this->add_group_control(Group_Control_Typography::get_type(), [
            'label' => esc_html__('Title Typography', 'senatory-core'),
            'name' => 'title_typography',
            'description' => esc_html__('select title typography', 'senatory-core'),
            'selector' => "{{WRAPPER}} .vision-single-item-wrapper .our-vision-single-item .content .title"
        ]);
		
		
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'label' => esc_html__('Description Typography', 'senatory-core'),
            'name' => 'description_typography',
            'description' => esc_html__('select description typography', 'senatory-core'),
            'selector' => "{{WRAPPER}} .vision-single-item-wrapper .our-vision-single-item .content p"
        ]);
	  
		
		
        $this->end_controls_section();
        /* typography settings end */

    }

    /**
     * Render Elementor widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {

	    $settings = $this->get_settings_for_display();
        $rand_numb = rand(333, 999999999);
        //query settings
        $total_posts = $settings['total'];
        $category = $settings['category'];
        $order = $settings['order'];
        $orderby = $settings['orderby'];
        //other settings
        $pagination = $settings['pagination'] ? false : true;

        //setup query
        $args = array(
            'post_type' => 'post',
            'posts_per_page' => $total_posts,
            'order' => $order,
            'orderby' => $orderby,
            'post_status' => 'publish',
            'ignore_sticky_posts' => 1,
        );

        if (!empty($category)) {
            $args['tax_query'] = array(
                array(
                    'taxonomy' => 'category',
                    'field' => 'term_id',
                    'terms' => $category
                )
            );
        }
        $post_data = new \WP_Query($args);
        ?>
		
		
        <div class="issues-around-us-section style-01">
        <div class="container">
            <div class="row">
                <?php
                while ($post_data->have_posts()):$post_data->the_post(); ?>

                <div class="col-lg-<?php echo esc_attr($settings['column']); ?> col-md-6">
                    <div class="news-single-items-two">
                        <div class="thumbnail">
                            <?php if(has_post_thumbnail()) {
                                the_post_thumbnail('', ['class' => 'blog_image']);
                            } ?>
                            <span class="tag">
                            <?php
                                $blog_category = get_the_category(); echo   $blog_category[0]->cat_name;
                            ?>
                            </span>
                        </div>
                        <div class="content">
                            <div class="post-meta">
                                <div class="author">
                                    <div class="icon">
                                        <?php echo get_avatar( get_the_author_meta('user_email'), $size = '40'); ?>
                                    </div>
                                    <p class="admin"><?php echo esc_html( get_the_author() ); ?></p>
                                </div>
                                <div class="post-date">
                                    <div class="icon">
                                        <img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/calender-02.png" alt="">
                                    </div>
                                    <p class="date"><p><?php echo esc_html(get_the_date( 'F j, Y' )); ?></p>
                                </div>
                            </div>
                            <h4 class="title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h4>
                            <p><?php echo wp_trim_words( get_the_content(), 15, false ); ?></p>
                            <div class="btn-wrapper">
                                <a href="<?php the_permalink(); ?>" class="boxed-btn event-btn"><i class="fas fa-arrow-right"></i>
                                <?php if(!empty($settings['blog_btn_text'])){ echo esc_html($settings['blog_btn_text']); } ?>
                            </a>
                            </div>
                        </div>
                    </div>
                </div>

                <?php
                endwhile;
                wp_reset_query();
                ?>
            </div>

            <!-- Pagination -->
            <?php if( $settings['pagination'] === 'yes' ): ?>
                <div class="row justify-content-center">
                    <div class="col-lg-12">
                        <div class="blog-pagination style-01 issues-pagination">
                        <?php 
                            $total_pages = $post_data->max_num_pages;
                            if ($total_pages > 1){
                            $current_page = max(1, get_query_var('paged'));

                            echo paginate_links(array(
                                    'base' => get_pagenum_link(1) . '%_%',
                                    'format' => '/page/%#%',
                                    'current' => $current_page,
                                    'total' => $total_pages,
                                    'prev_text'    => '<i class="fas fa-chevron-left"></i>',
                                    'next_text'    => '<i class="fas fa-chevron-right"></i>',
                                ));
                            } 
                        ?> 
                            
                        </div>
                    </div>
                </div>
            <?php endif; ?>

        </div>

        <?php
    }
}

Plugin::instance()->widgets_manager->register_widget_type(new Senatory_Blog_Grid_Two_Widget());