<?php
/**
 * Elementor Widget
 * @package Senatory
 * @since 1.0.0
 */

namespace Elementor;
class Senatory_Contact_Info_list_Widget extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'senatory-contact-info-list-widget';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Contact Info List: 01', 'senatory-master');
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'bl_icon eicon-archive-title';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['senatory_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {

        $this->start_controls_section(
            'settings_section',
            [
                'label' => esc_html__('Contact Info List', 'senatory-master'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $repeater = new \Elementor\Repeater();
        $repeater->add_control(
            'title',
            [
                'label' => esc_html__('Title', 'senatory-core'),
                'type' => Controls_Manager::TEXT,
                'description' => esc_html__('enter title.', 'senatory-core'),
            ]
        );
		
		$repeater->add_control(
            'contact_info',
            [
                'label' => esc_html__('Contact Info', 'senatory-core'),
                'type' => Controls_Manager::TEXTAREA,
                'description' => esc_html__('Enter Contact Info ', 'senatory-core'),
            ]
        );
        $repeater->add_control(
            'info_icon',
            [
                'label' => esc_html__('Icon', 'senatory-master'),
                'type' => Controls_Manager::ICONS,
                'description' => esc_html__('Select Icon', 'senatory-master'),
            ]
        );
		
        
        $this->add_control('contact_info_list', [
            'label' => esc_html__('Contact Info List Items', 'senatory-core'),
            'type' => Controls_Manager::REPEATER,
            'fields' => $repeater->get_controls(),

            'default' => [
                [
                    'title' => esc_html__('Email', 'senatory-core'),
                    'contact_info' =>  esc_html__('information1667@senatory.com', 'senatory-core'),
                    'info_icon' => [
                        'value' => 'far fa-envelope',
                        'library' => 'solid',
                    ]
                ]
            ],

        ]);
		$this->end_controls_section();
		
		
		
        $this->start_controls_section(
            'css_styles',
            [
                'label' => esc_html__('Styling Settings', 'senatory-master'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        
        $this->add_control('background_color', [
            'label' => esc_html__('Background Color', 'senatory-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .icon-box-item-02" => "background: {{VALUE}}"
            ]
        ]);
        $this->add_control('title_color', [
            'label' => esc_html__('Title Color', 'senatory-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .icon-box-item-02 .content .title" => "color: {{VALUE}}"
            ]
        ]);
        $this->add_control('title_styling_divider', [
            'type' => Controls_Manager::DIVIDER
        ]);
		
        $this->add_control('info_color', [
            'label' => esc_html__('Info Color', 'senatory-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .icon-box-item-02 .content p" => "color: {{VALUE}}"
            ]
        ]);
		
		$this->add_control('icon_styling_divider', [
            'type' => Controls_Manager::DIVIDER
        ]);
		
		$this->add_control('icon_color', [
            'label' => esc_html__('Icon Color', 'senatory-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .icon-box-item-02 .icon" => "color: {{VALUE}}"
            ]
        ]);

		$this->add_control('icon_bg_color', [
            'label' => esc_html__('Icon Background', 'senatory-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .icon-box-item-02 .icon" => " background: {{VALUE}}"
            ]
        ]);
        $this->add_group_control(Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'box_shadow',
				'label' => esc_html__( 'Box Shadow', 'senatory-core' ),
				'selector' => '{{WRAPPER}} .icon-box-item-02',
			]
		);		
        $this->add_control(
			'item_bdr_radius',
			[
				'label' => esc_html__( 'Border Radius', 'senatory-core' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 5,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 0,
				],
				'selectors' => [
					'{{WRAPPER}} .icon-box-item-02' => 'border-radius: {{SIZE}}{{UNIT}};',
				],
			]
		);
        $this->end_controls_section();
		

        /* typography settings start */
        $this->start_controls_section('typography_settings', [
            'label' => esc_html__('Typography Settings', 'senatory-master'),
            'tab' => Controls_Manager::TAB_STYLE
        ]);	
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'label' => esc_html__('Title Typography', 'senatory-core'),
            'name' => 'title_typography',
            'description' => esc_html__('select title typography', 'senatory-core'),
            'selector' => "{{WRAPPER}} .icon-box-item-02 .content .title"
        ]);
		
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'label' => esc_html__('Info Typography', 'senatory-core'),
            'name' => 'description_typography',
            'description' => esc_html__('select Info typography', 'senatory-core'),
            'selector' => "{{WRAPPER}} .icon-box-item-02 .content p"
        ]);
		
		
        $this->end_controls_section();
        /* typography settings end */

    }

    /**
     * Render Elementor widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();

        ?>

        <?php if($settings['contact_info_list']): ?>
        <!-- Contact Info List Markup -->
        <?php foreach($settings['contact_info_list'] as $list_data): ?>
        <div class="icon-box-item-02">
            <div class="icon">
                <?php
                    Icons_Manager::render_icon($list_data['info_icon'], ['aria-hidden' => 'true']);
                    ?>
                </div>
            <div class="content">
                <span class="title"><?php echo wp_kses_post( $list_data['title'] ); ?></span>
                <p><?php echo wp_kses_post( $list_data['contact_info'] ); ?></p>
            </div>
        </div>
        <?php endforeach; ?>
        <?php endif; ?>





        <?php
    }
}

Plugin::instance()->widgets_manager->register_widget_type(new Senatory_Contact_Info_list_Widget());