<?php
/**
 * Elementor Widget
 * @package Senatory
 * @since 1.0.0
 */

namespace Elementor;
class Senatory_Countdown_One_Widget extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'senatory-countdown-one-widget';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Senatory : Countdown 01', 'senatory-core');
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-archive-title';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['senatory_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function _register_controls()
    {

        $this->start_controls_section(
            'settings_section',
            [
                'label' => esc_html__('Section Contents', 'senatory-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'date', [
                'label' => esc_html__('Date ', 'senatory-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('18-20 July', 'senatory-core'),
                'date' => esc_html__('Enter date', 'senatory-core'),
            ]
        );
        $this->add_control( 'countdown_date', [
            'label'       => esc_html__( 'Countdown Time', 'sword-core' ),
            'type'        => Controls_Manager::DATE_TIME,
            'default'     => esc_html__( '14', 'sword-core' ),
            'description' => esc_html__( 'enter counterup date', 'sword-core' )
        ] );


        $this->add_responsive_control(
            'align',
            [
                'label' => esc_html__( 'Alignment', 'elementor' ),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => esc_html__( 'Left', 'elementor' ),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__( 'Center', 'elementor' ),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__( 'Right', 'elementor' ),
                        'icon' => 'eicon-text-align-right',
                    ],
                    'justify' => [
                        'title' => esc_html__( 'Justified', 'elementor' ),
                        'icon' => 'eicon-text-align-justify',
                    ],
                ],
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}}' => 'text-align: {{VALUE}};',
                ],
            ]
        );
        $this->end_controls_section();


        $this->start_controls_section(
            'counter_styles',
            [
                'label' => esc_html__('Counter Styling', 'senatory-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control('counter_bg_color', [
            'label' => esc_html__('Counter Background', 'senatory-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .counter-single-item" => "background-color: {{VALUE}}"
            ]
        ]);
        $this->add_control('counter_item_bg_color', [
            'label' => esc_html__('Digit Background', 'senatory-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .counter-single-item .counter-item span" => "background-color: {{VALUE}}"
            ]
        ]);
        $this->add_control('counter_dot_bg_color', [
            'label' => esc_html__('Dot Color', 'senatory-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} ..counter-single-item.style-03 .counter-item::after" => "color: {{VALUE}}"
            ]
        ]);
        $this->add_control('counter_text_color', [
            'label' => esc_html__('Text Color', 'senatory-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .counter-single-item .counter-item h6" => "color: {{VALUE}}"
            ]
        ]);
        $this->add_control('counter_digit_color', [
            'label' => esc_html__('Digit Color', 'senatory-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .counter-single-item .counter-item span" => "color: {{VALUE}}"
            ]
        ]);
        $this->add_responsive_control('padding', [
            'label' => esc_html__('Padding', 'senatory-core'),
            'type' => Controls_Manager::DIMENSIONS,
            'size_units' => ['px', 'em'],
            'allowed_dimensions' => ['top', 'bottom'],
            'selectors' => [
                '{{WRAPPER}} .counter-single-item .counter-item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
            ],
            'description' => esc_html__('set padding for header area ', 'senatory-core')
        ]);
        $this->add_responsive_control('Margin', [
            'label' => esc_html__('Margin', 'senatory-core'),
            'type' => Controls_Manager::DIMENSIONS,
            'size_units' => ['px', 'em'],
            'allowed_dimensions' => ['top', 'bottom'],
            'selectors' => [
                '{{WRAPPER}} .counter-single-item .counter-item' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
            ],
            'description' => esc_html__('set padding for header area ', 'senatory-core')
        ]);

        $this->end_controls_section();


        /* typography settings start */
        $this->start_controls_section('typography_settings', [
            'label' => esc_html__('Typography Settings', 'senatory-core'),
            'tab' => Controls_Manager::TAB_STYLE
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'name' => 'digit_typography',
            'label' => esc_html__('Digit Typography', 'senatory-core'),
            'selector' => "{{WRAPPER}} .counter-single-item.style-03 .counter-item span"
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'name' => 'text_typography',
            'label' => esc_html__('Text Typography', 'senatory-core'),
            'selector' => "{{WRAPPER}} .counter-single-item.style-03 .counter-item h6"
        ]);
        $this->end_controls_section();
        /* typography settings end */

    }

    /**
     * Render Elementor widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();

        ?>
            <div class="counter-single-item style-03 mycountdown" data-countdown="<?php echo esc_attr($settings['countdown_date']);?>">
                <ul class="pl-0">
                    <li class="counter-item">
                        <span class="days"></span>
                        <h6> <?php echo esc_html__('Month','sword-core');?> </h6>
                    </li>
                    <li class="counter-item">
                        <span class="hours"></span>
                        <h6> <?php echo esc_html__('Hours','sword-core');?> </h6>
                    </li>
                    <li class="counter-item">
                        <span class="mins"></span>
                        <h6> <?php echo esc_html__('Minute','sword-core');?> </h6>
                    </li>
                    <li class="counter-item">
                        <span class="secs"></span>
                        <h6> <?php echo esc_html__('Second','sword-core');?> </h6>
                    </li>
                </ul>
            </div>

        <?php
    }
}
Plugin::instance()->widgets_manager->register_widget_type(new Senatory_Countdown_One_Widget());