<?php
/**
 * Elementor Widget
 * @package Senatory
 * @since 1.0.0
 */

namespace Elementor;
class Senatory_Donation_Button_One_Widget extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'senatory-donation-button-one';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Donation Button: 01', 'senatory-master');
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'bl_icon eicon-archive-title';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['senatory_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {

        $this->start_controls_section(
            'settings_heading',
            [
                'label' => esc_html__('General Settings', 'senatory-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'donation_btn_txt',
            [
                'label' => esc_html__('Button Text', 'senatory-core'),
                'type' => Controls_Manager::TEXT,
                'description' => esc_html__('Enter Donation Button Text.', 'senatory-core'),
                'default' => esc_html__('Donate Now', 'senatory-core')
            ]
        );
		$this->add_control(
			'donation_btn_link',
			[
                'label' => esc_html__('Button Link', 'senatory-core'),
				'type' => Controls_Manager::URL,
				'placeholder' => esc_html__( 'Paste Link or Type', 'senatory-core' ),
				'options' => [ 'url', 'is_external', 'nofollow' ],
				'default' => [
					'url' => '',
					'is_external' => true,
					'nofollow' => true,
				],
				'label_block' => true,
			]
		);

        $this->add_control(
            'alignment',
            [
                'label' => esc_html__('Alignment', 'senatory-core'),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => esc_html__('Left', 'senatory-core'),
                        'icon' => 'fa fa-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__('Center', 'senatory-core'),
                        'icon' => 'fa fa-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__('Right', 'senatory-core'),
                        'icon' => 'fa fa-align-right',
                    ],
                ],
                'default' => 'left',
                'toggle' => true,
                'selectors' => [
                    "{{WRAPPER}} .theme-custom-titlebar .content" => "text-align: {{VALUE}}"
                ]
            ]
        );
        $this->end_controls_section();

        // STYLING TAB
        $this->start_controls_section(
            'styling_heading',
            [
                'label' => esc_html__('Styling Settings', 'senatory-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->start_controls_tabs(
            'button_style_tabs'
        );

        $this->start_controls_tab(
            'button_style_normal_tab',
            [
                'label' => esc_html__('Normal', 'senatory-core'),
            ]
        );
        $this->add_control('btn_text_color', [
            'label' => esc_html__('Button Text Color', 'senatory-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .btn-wrapper.home-six .boxed-btn.btn-sanatory" => "color: {{VALUE}}"
            ]
        ]);
        $this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'btn_bg',
				'label' => esc_html__( 'Background', 'senatory-core' ),
				'types' => [ 'classic', 'gradient', 'video' ],
				'selector' => '{{WRAPPER}} .btn-wrapper.home-six .boxed-btn.btn-sanatory',
			]
		);
        $this->add_control('icon_color', [
            'label' => esc_html__('Icon Color', 'senatory-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .btn-wrapper.home-six .boxed-btn.btn-sanatory i" => "color: {{VALUE}}"
            ]
        ]);
		$this->add_control(
			'btn_border_radius',
			[
				'label' => esc_html__( 'Border Radius', 'senatory-core' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 0,
				],
				'selectors' => [
					'{{WRAPPER}} .btn-wrapper.home-six .boxed-btn.btn-sanatory' => 'border-radius: {{SIZE}}{{UNIT}};',
				],
			]
		);
        $this->end_controls_tab();


        // Hover Style

        $this->start_controls_tab(
            'button_style_hover_tab',
            [
                'label' => esc_html__('Normal', 'senatory-core'),
            ]
        );
        $this->add_control('btn_text_hover_color', [
            'label' => esc_html__('Button Text Color', 'senatory-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .btn-wrapper.home-six .boxed-btn.btn-sanatory:hover" => "color: {{VALUE}}"
            ]
        ]);
        $this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'btn_hover_bg',
				'label' => esc_html__( 'Background', 'senatory-core' ),
				'types' => [ 'classic', 'gradient', 'video' ],
				'selector' => '{{WRAPPER}} .btn-wrapper.home-six .boxed-btn.btn-sanatory:hover',
			]
		);
        $this->add_control('icon_hover_color', [
            'label' => esc_html__('Icon Color', 'senatory-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .btn-wrapper.home-six .boxed-btn.btn-sanatory:hover i" => "color: {{VALUE}}"
            ]
        ]);

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->end_controls_section();

        $this->start_controls_section(
            'styling_typogrpahy_heading',
            [
                'label' => esc_html__('Typography Settings', 'senatory-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(Group_Control_Typography::get_type(), [
            'name' => 'btn_text_typography',
            'label' => esc_html__('Title Typography', 'senatory-core'),
            'selector' => "{{WRAPPER}} .btn-wrapper.home-six .boxed-btn.btn-sanatory"
        ]);

        $this->end_controls_section();


    }

    /**
     * Render Elementor widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();
    
        ?>
        <div class="party-single-item<?php echo esc_attr(('center' === $settings['alignment']) ? 'title-centerr' : ' '); ?> <?php echo esc_attr(('right' === $settings['alignment']) ? 'title-rightt' : ' '); ?>">

            <!-- Donation Button -->
            <div class="btn-wrapper home-six">
                <a href="#" class="price-btn">$25</a>
                <a href="#" class="price-btn">$50</a>
                <a href="#" class="price-btn">$100</a>
                <a href="#" class="boxed-btn donate-btn btn-sanatory">Donation Now <i class="fas fa-paper-plane"></i></a>
            </div>

        </div>


        <?php
    }
}

Plugin::instance()->widgets_manager->register_widget_type(new Senatory_Donation_Button_One_Widget());