<?php
/**
 * Elementor Widget
 * @package Senatory
 * @since 1.0.0
 */

namespace Elementor;
class Senatory_event_widget extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'senatory-event2-widget';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Footer Event', 'senatory-master');
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'bl_icon eicon-archive-title';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['senatory_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {

  $this->start_controls_section(
            'settings_section',
            [
                'label' => esc_html__('General Settings', 'senatory-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
    $this->add_control(
            'title',
            [
                'label' => __('Title', 'senatory-core'),
                'type' => Controls_Manager::TEXT,
                'label_block'=>true,
                'default' => __('Events Campaigns', 'senatory-core'),
            ]
        );

        $this->add_control('countdown_date', [
            'label' => esc_html__('Countdown Time', 'senatory-core'),
            'type' => Controls_Manager::DATE_TIME,
            'default' => esc_html__('14', 'senatory-core'),
            'description' => esc_html__('enter counterup date', 'senatory-core')
        ]);
        $this->add_control(
            'time_format',
            [
                'label' => esc_html__('Need 24 Hour Time Formate?', 'events-addon-for-elementor'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'events-addon-for-elementor'),
                'label_off' => esc_html__('Hide', 'events-addon-for-elementor'),
                'return_value' => 'true',
            ]
        );


        $this->add_control('total', [
            'label' => esc_html__('Total Posts', 'senatory-core'),
            'type' => Controls_Manager::TEXT,
            'default' => '-1',
            'description' => esc_html__('enter how many post you want in masonry , enter -1 for unlimited post.')
        ]);


        $this->add_control('category', [
            'label' => esc_html__('Category', 'senatory-core'),
            'type' => Controls_Manager::SELECT2,
            'multiple' => false,
            'options' => senatory_core()->get_terms_names('tribe_events_cat'),
            'description' => esc_html__('select category as you want, leave it blank for all category', 'senatory-core'),
        ]);

        $this->add_control('order', [
            'label' => esc_html__('Order', 'senatory-core'),
            'type' => Controls_Manager::SELECT,
            'options' => array(
                'ASC' => esc_html__('Ascending', 'senatory-core'),
                'DESC' => esc_html__('Descending', 'senatory-core'),
            ),
            'default' => 'ASC',
            'description' => esc_html__('select order', 'senatory-core')
        ]);


        $this->add_control('orderby', [
            'label' => esc_html__('OrderBy', 'senatory-core'),
            'type' => Controls_Manager::SELECT,
            'options' => array(
                'ID' => esc_html__('ID', 'senatory-core'),
                'title' => esc_html__('Title', 'senatory-core'),
                'date' => esc_html__('Date', 'senatory-core'),
                'rand' => esc_html__('Random', 'senatory-core'),
                'comment_count' => esc_html__('Most Comments', 'senatory-core'),
            ),
            'default' => 'ID',
            'description' => esc_html__('select order', 'senatory-core')
        ]);


        $this->add_control('excerpt_length', [
            'label' => esc_html__('Excerpt Length', 'senatory-core'),
            'type' => Controls_Manager::SELECT,
            'options' => array(
                20 => esc_html__('Short', 'senatory-core'),
                55 => esc_html__('Regular', 'senatory-core'),
                100 => esc_html__('Long', 'senatory-core'),
            ),
            'default' => 15,
            'description' => esc_html__('select excerpt length', 'senatory-core')
        ]);

        $this->end_controls_section();


            $this->start_controls_section(
            'content_sty',
            [
                'label' => __('Style', 'senatory-master'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
  
   
        $this->add_control(
            'post_title_color',    
            [
                'label' => __('Title Color', 'senatory-master'),
                'type' => \Elementor\Controls_Manager::COLOR,        
                'selectors' => [
                    '{{WRAPPER}} .widget.footer-widget .widget-title' => 'color: {{VALUE}}',
                ],
            ]
        );


        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'ttih',
                'label' => __('Title Typography', 'senatory-master'),
                'selector' => '{{WRAPPER}} .widget.footer-widget .widget-title',
            ]
        );

        $this->add_control(
            'content_color',    
            [
                'label' => __('Content Color', 'senatory-master'),
                'type' => \Elementor\Controls_Manager::COLOR,        
                'selectors' => [
                    '{{WRAPPER}} .footer-widget.widget a' => 'color: {{VALUE}}',
                ],
            ]
        );


           $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'tctih',
                'label' => __('Content Typography', 'senatory-master'),   
                'selector' => '{{WRAPPER}} .footer-widget.widget a',
            ]
        );

        $this->add_control(
            'post_excerpt_color',
            [
                'label' => __('Excerpt Color', 'senatory-master'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .widget.footer-widget p' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'ttihexc',
                'label' => __('Excerpt Typography', 'senatory-master'),
                'selector' => '{{WRAPPER}} .widget.footer-widget p',
            ]
        );

 
        $this->end_controls_section();
    }

    /**
     * Render Elementor widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();

        $total_posts = $settings['total'];
        $category = $settings['category'];
        $order = $settings['order'];
        $orderby = $settings['orderby'];
        global $post;
        $all_events = tribe_get_events(array(
            'posts_per_page' => $total_posts,
            'tribe_events_cat' => $category,
            'orderby' => $orderby,
            'order' => $order,
        ));
        ?>
        <div class="footer-widget widget widget_nav_menu">
            <h4 class="widget-title">
              <?php echo ($settings['title']); ?>
              <span class="line">
                <span class="dot"></span>
                <span class="dot"></span>
                <span class="dot style-02"></span>
                <span class="dot"></span>
                <span class="dot"></span>
              </span>
            </h4>
            <div class="footer-event-item">
                 <?php
                    foreach ($all_events as $data):
                        $post_id = $data->ID;
                        $event_start_time = get_post_meta($post_id, '_EventStartDate', true);
                        $post_categories = get_the_terms($post_id, 'tribe_events_cat');
                        ?>
              <div class="content">
                <div class="designation">
                     <?php if (!empty($post_categories)): ?>
                  <span class="event">
                      <?php foreach ($post_categories as $cats) : ?>
                    <?php echo esc_attr($cats->name) ?>
                    <?php endforeach; ?>
                    </span>
                    <?php endif; ?>
                  <span class="date"><?php echo esc_html(date('F j, Y', strtotime($event_start_time))) ?></span>
                </div>
                <h6 class="title"><a href="<?php the_permalink($post_id); ?>"><?php echo esc_html($data->post_title); ?></a></h6>
                <p>
                  <?php echo senatory_core()->tribe_event_excerpt($settings['excerpt_length'], $data->post_content); ?>
                </p>
              </div>
              <?php
                    endforeach;
                    wp_reset_query();
                    ?>
            </div>
          </div>
      
        <?php
    }
}

Plugin::instance()->widgets_manager->register_widget_type(new Senatory_event_widget());