<?php
/**
 * Elementor Widget
 * @package Senatory
 * @since 1.0.0
 */

namespace Elementor;
class Senatory_Event_Grid_Three_Widget extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'senatory-event-grid-three-widget';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Event: Grid 03', 'senatory-core');
    }


    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'bl_icon eicon-archive-title';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['senatory_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {

        $this->start_controls_section(
            'settings_section',
            [
                'label' => esc_html__('General Settings', 'senatory-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'column',
            [
                'label' => esc_html__('Column', 'senatory-core'),
                'type' => Controls_Manager::SELECT,
                'options' => array(
                    '3' => esc_html__('04 Column', 'senatory-core'),
                    '4' => esc_html__('03 Column', 'senatory-core'),
                    '6' => esc_html__('02 Column', 'senatory-core'),
                    '12' => esc_html__('Full Column', 'senatory-core'),
                ),
                'description' => esc_html__('Select grid column', 'senatory-core'),
                'default' => '12'
            ]
        );

        $this->add_control('countdown_date', [
            'label' => esc_html__('Countdown Time', 'senatory-core'),
            'type' => Controls_Manager::DATE_TIME,
            // 'default' => esc_html__('14', 'senatory-core'),
            'description' => esc_html__('enter counterup date', 'senatory-core')
        ]);
        $this->add_control(
            'time_format',
            [
                'label' => esc_html__('Need 24 Hour Time Formate?', 'events-addon-for-elementor'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'events-addon-for-elementor'),
                'label_off' => esc_html__('Hide', 'events-addon-for-elementor'),
                'return_value' => 'true',
            ]
        );

        $this->add_control('total', [
            'label' => esc_html__('Total Posts', 'senatory-core'),
            'type' => Controls_Manager::TEXT,
            'default' => '1',
            'description' => esc_html__('enter how many post you want in masonry , enter -1 for unlimited post.')
        ]);

        $this->add_control('category', [
            'label' => esc_html__('Category', 'senatory-core'),
            'type' => Controls_Manager::SELECT2,
            'multiple' => false,
            'options' => senatory_core()->get_terms_names('tribe_events_cat'),
            'description' => esc_html__('select category as you want, leave it blank for all category', 'senatory-core'),
        ]);

        $this->add_control('order', [
            'label' => esc_html__('Order', 'senatory-core'),
            'type' => Controls_Manager::SELECT,
            'options' => array(
                'ASC' => esc_html__('Ascending', 'senatory-core'),
                'DESC' => esc_html__('Descending', 'senatory-core'),
            ),
            'default' => 'DESC',
            'description' => esc_html__('select order', 'senatory-core')
        ]);


        $this->add_control('orderby', [
            'label' => esc_html__('OrderBy', 'senatory-core'),
            'type' => Controls_Manager::SELECT,
            'options' => array(
                'ID' => esc_html__('ID', 'senatory-core'),
                'title' => esc_html__('Title', 'senatory-core'),
                'date' => esc_html__('Date', 'senatory-core'),
                'rand' => esc_html__('Random', 'senatory-core'),
                'comment_count' => esc_html__('Most Comments', 'senatory-core'),
            ),
            'default' => 'ID',
            'description' => esc_html__('select order', 'senatory-core')
        ]);


        $this->add_control('excerpt_length', [
            'label' => esc_html__('Excerpt Length', 'senatory-core'),
            'type' => Controls_Manager::SELECT,
            'options' => array(
                20 => esc_html__('Short', 'senatory-core'),
                55 => esc_html__('Regular', 'senatory-core'),
                100 => esc_html__('Long', 'senatory-core'),
            ),
            'default' => 20,
            'description' => esc_html__('select excerpt length', 'senatory-core')
        ]);


        $this->end_controls_section();

        $this->start_controls_section(
            'styling_settings_section',
            [
                'label' => esc_html__('Styling Settings', 'senatory-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'content_background',
				'label' => esc_html__( 'Background', 'plugin-name' ),
				'types' => [ 'classic', 'gradient', 'video' ],
				'selector' => '{{WRAPPER}} .campaign-single-item.home-six',
			]
		);
        $this->add_control('title_color', [
            'label' => esc_html__('Title Color', 'senatory-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .campaign-single-item.home-six .campaign-bg .content-wrap .content .title" => "color: {{VALUE}}"
            ]
        ]);
        $this->add_control('title_hover_color', [
            'label' => esc_html__('Title Hover Color', 'senatory-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .campaign-single-item.home-six .campaign-bg .content-wrap .content .title:hover" => "color: {{VALUE}}"
            ]
        ]);

        $this->add_control('time_color', [
            'label' => esc_html__('Time Color', 'senatory-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .campaign-single-item.home-six .counter-single-item.style-04 .counter-item span" => "color: {{VALUE}}",
            ]
        ]); 
        $this->end_controls_section();

        $this->start_controls_section(
            'typography_settings_section',
            [
                'label' => esc_html__('Typography Settings', 'senatory-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'label' => esc_html__('Title Typography', 'senatory-core'),
            'name' => 'title_typography',
            'description' => esc_html__('select title typography', 'senatory-core'),
            'selector' => "{{WRAPPER}} .single-event-item .content .author-mate .title"
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'label' => esc_html__('Description Typography', 'senatory-core'),
            'name' => 'description_typography',
            'description' => esc_html__('select description typography', 'senatory-core'),
            'selector' => "{{WRAPPER}} .single-event-item p"
        ]);
        $this->end_controls_section();
    }

    /**
     * Render Elementor widget output on the frontend.
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $rand_numb = rand(333, 999999999);
        $countdown_date = $settings['countdown_date'];

        //query settings
        $total_posts = $settings['total'];
        $category = $settings['category'];
        $order = $settings['order'];
        $orderby = $settings['orderby'];
        global $post;
        $all_events = tribe_get_events(array(
            'posts_per_page' => $total_posts,
            'tribe_events_cat' => $category,
            'orderby' => $orderby,
            'order' => $order,
        ));

        ?>

        <?php
            foreach ($all_events as $data):
                $post_id = $data->ID;
                $img_id = get_post_thumbnail_id($post_id) ? get_post_thumbnail_id($post_id) : false;
                $img_url_val = $img_id ? wp_get_attachment_image_src($img_id, 'full', false) : '';
                $img_url = is_array($img_url_val) && !empty($img_url_val) ? $img_url_val[0] : '';
                $event_start_time = get_post_meta($post_id, '_EventStartDate', true);
                $post_categories = get_the_terms($post_id, 'tribe_events_cat');

                $countdown_date = $settings['countdown_date'] ?? $event_start_time;

                ?>

            <div class="campaign-single-item home-six" style="background-image: url(<?php echo esc_url($img_url); ?>);">

                <div class="campaign-bg">

                    <div class="content-wrap">
                        <div class="content">
                            <div class="designation">
                            <?php if (!empty($post_categories)): ?>
                                <span class="event">
                                    <?php foreach ($post_categories as $cats) : ?>
                                        <?php echo esc_attr($cats->name) ?>
                                    <?php endforeach; ?>
                                </span>
                            <?php endif; ?>
                                <span class="date"><?php echo esc_html(date('F j, Y', strtotime($event_start_time))) ?></span>
                            </div>
                            <a href="<?php the_permalink($post_id); ?>"><h5 class="title"><?php echo esc_html($data->post_title); ?></h5></a>
                        </div>
                        <div id="mycountdown2-<?php echo esc_attr($rand_numb); ?>" class="mycountdown2 counter-single-item style-04" data-countdown='<?php echo esc_attr($event_start_time); ?>'>
                            <ul>
                                <li class="counter-item">
                                    <span class="dayss"></span>
                                    <h6> <?php echo esc_html__('Days', 'senatory'); ?> </h6>
                                </li>
                                <li class="counter-item">
                                    <span class="hourss"></span>
                                    <h6> <?php echo esc_html__('Hours', 'senatory'); ?> </h6>
                                </li>
                                <li class="counter-item">
                                    <span class="minss"></span>
                                    <h6> <?php echo esc_html__('Minute', 'senatory'); ?> </h6>
                                </li>
                                <li class="counter-item">
                                    <span class="secss"></span>
                                    <h6> <?php echo esc_html__('Second', 'senatory'); ?> </h6>
                                </li>
                            </ul>
                        </div>
                    </div>

                </div>
            </div>

            <?php
                endforeach;
                wp_reset_query();
            ?>

        <?php
    }
}

Plugin::instance()->widgets_manager->register_widget_type(new Senatory_Event_Grid_Three_Widget());