<?php
/**
 * Elementor Widget
 * @package Senatory
 * @since 1.0.0
 */

namespace Elementor;
class Senatory_Galleryy_Slider_One_Widget extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'senatory-gallery-area-slider';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Gallery Carousel', 'senatory-core');
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'bl_icon eicon-archive-title';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['senatory_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {

        $this->start_controls_section(
            'settings_section',
            [
                'label' => esc_html__('Gallery Section', 'senatory-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );




        $repeater = new \Elementor\Repeater();



		$repeater->add_control(
            'gallery_image', [
                'label' => esc_html__('Gallery Image', 'senatory-core'),
                'type' => Controls_Manager::MEDIA,
                'show_label' => false,
                'description' => esc_html__('Upload gallery image', 'senatory-core'),
                'default' => [
                    'src' => Utils::get_placeholder_image_src()
                ],
            ]
        );



        $this->add_control('gallery_sliders', [
            'label' => esc_html__('Gallery Items', 'senatory-core'),
            'type' => Controls_Manager::REPEATER,
            'fields' => $repeater->get_controls(),

        ]);


        $this->end_controls_section();


        $this->start_controls_section(
            'slider_settings_section',
            [
                'label' => esc_html__('Slider Settings', 'senatory-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'items',
            [
                'label' => esc_html__('Items', 'senatory-core'),
                'type' => Controls_Manager::TEXT,
                'description' => esc_html__('you can set how many item show in slider', 'senatory-core'),
                'default' => '4'
            ]
        );

        $this->add_control(
            'margin',
            [
                'label' => esc_html__('Margin', 'senatory-core'),
                'description' => esc_html__('you can set margin for slider', 'senatory-core'),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                        'step' => 5,
                    ]
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 0,
                ],
                
                'size_units' => ['px'],
                'condition' => array(
                    'autoplay' => 'yes'
                )
            ]
        );

        $this->add_control(
            'loop',
            [
                'label' => esc_html__('Loop', 'senatory-core'),
                'type' => Controls_Manager::SWITCHER,
                'description' => esc_html__('you can set yes/no to enable/disable', 'senatory-core'),
                'default' => 'yes'
            ]
        );

        $this->add_control(
            'nav',
            [
                'label' => esc_html__('Nav', 'senatory-core'),
                'type' => Controls_Manager::SWITCHER,
                'description' => esc_html__('you can set yes/no to enable/disable', 'senatory-core'),
                'default' => 'yes'
            ]
        );

        $this->add_control(
            'nav_right_arrow',
            [
                'label' => esc_html__('Nav Right Icon', 'senatory-core'),
                'type' => Controls_Manager::ICONS,
                'description' => esc_html__('you can set yes/no to enable/disable', 'senatory-core'),
                'default' => [
                    'value' => 'fas fa-angle-right',
                    'library' => 'solid',
                ],
            ]
        );

        $this->add_control(
            'nav_left_arrow',
            [
                'label' => esc_html__('Nav Left Icon', 'senatory-core'),
                'type' => Controls_Manager::ICONS,
                'description' => esc_html__('you can set yes/no to enable/disable', 'senatory-core'),
                'default' => [
                    'value' => 'fas fa-angle-left',
                    'library' => 'solid',
                ],
            ]
        );

        $this->add_control(
            'autoplay',
            [
                'label' => esc_html__('Autoplay', 'senatory-core'),
                'type' => Controls_Manager::SWITCHER,
                'description' => esc_html__('you can set yes/no to enable/disable', 'senatory-core'),
                'default' => 'yes'
            ]
        );

        $this->add_control(
            'autoplaytimeout',
            [
                'label' => esc_html__('Autoplay Timeout', 'senatory-core'),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 10000,
                        'step' => 2,
                    ]
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 5000,
                ],
                'size_units' => ['px'],
                'condition' => array(
                    'autoplay' => 'yes'
                )
            ]

        );

        $this->end_controls_section();

        $this->start_controls_section(
            'css_styles',
            [
                'label' => esc_html__('Styling Settings', 'senatory-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control('slider_title_color', [
            'label' => esc_html__('Slider Title Color', 'senatory-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .header-area .title" => "color: {{VALUE}}"
            ]
        ]);

        $this->add_control('slider_subtitle_bg_color', [
            'label' => esc_html__('Slider Sub Title Background Color', 'senatory-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .header-area .header-inner .subtitle" => "background-color: {{VALUE}}"
            ]
        ]);

        $this->add_control('slider_subtitle_color', [
            'label' => esc_html__('Slider Sub Title Color', 'senatory-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .header-area .header-inner .subtitle" => "color: {{VALUE}}"
            ]
        ]);

        $this->add_responsive_control('padding', [
            'label' => esc_html__('Padding', 'senatory-core'),
            'type' => Controls_Manager::DIMENSIONS,
            'size_units' => ['px', 'em'],
            'allowed_dimensions' => ['top', 'bottom'],
            'selectors' => [
                '{{WRAPPER}} .header-area' => 'padding-top: {{TOP}}{{UNIT}};padding-bottom: {{BOTTOM}}{{UNIT}};'
            ],
            'description' => esc_html__('set padding for header area ', 'senatory-core')
        ]);

        $this->add_control('overlay_color', [
            'label' => esc_html__('Overlay Color', 'senatory-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .header-area.header-bg::before' => 'background-color:{{VALUE}};'
            ],
        ]);

        $this->end_controls_section();

        /* button styling */
        $this->start_controls_section('header_button_section', [
            'label' => esc_html__('Button Settings', 'senatory-core'),
            'tab' => Controls_Manager::TAB_STYLE
        ]);

        $this->start_controls_tabs('button_styling');

        $this->start_controls_tab('normal_style', [
            'label' => esc_html__('Button Normal', "senatory-core")
        ]);

        $this->add_control('button_normal_color', [
            'label' => esc_html__('Button Color', 'senatory-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .header-area .header-bottom .btn-wrapper .boxed-btn" => "color: {{VALUE}}"
            ]
        ]);

        $this->add_control('divider_01', [
            'type' => Controls_Manager::DIVIDER
        ]);

        $this->add_group_control(Group_Control_Background::get_type(), [
            'name' => 'button_background',
            'label' => esc_html__('Button Background ', 'senatory-core'),
            'selector' => "{{WRAPPER}} .header-area .header-bottom .btn-wrapper .boxed-btn"
        ]);

        $this->add_control('divider_02', [
            'type' => Controls_Manager::DIVIDER
        ]);

        $this->add_group_control(Group_Control_Border::get_type(), [
            'name' => 'header_button_border',
            'label' => esc_html__('Border', 'senatory-core'),
            'selector' => "{{WRAPPER}} .header-area .header-bottom .btn-wrapper .boxed-btn"
        ]);
        $this->add_control('divider_060', [
            'type' => Controls_Manager::DIVIDER
        ]);
        $this->add_control('info_button_normal_color', [
            'label' => esc_html__('Info Button Text Color', 'senatory-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .header-area .header-buttom-content p" => "color: {{VALUE}}"
            ]
        ]);
        $this->add_control('info_number_button_normal_color', [
            'label' => esc_html__('Info Button Number Color', 'senatory-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .header-area .header-buttom-content span" => "color: {{VALUE}}"
            ]
        ]);
        $this->end_controls_tab();

        $this->start_controls_tab('hover_style', [
            'label' => esc_html__('Button Hover', "senatory-core")
        ]);
        $this->add_control('button_hover_normal_color', [
            'label' => esc_html__('Button Color', 'senatory-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .header-area .header-bottom .btn-wrapper .boxed-btn:hover" => "color: {{VALUE}}"
            ]
        ]);
        $this->add_control('divider_03', [
            'type' => Controls_Manager::DIVIDER
        ]);
        $this->add_group_control(Group_Control_Background::get_type(), [
            'name' => 'button_hover_background',
            'label' => esc_html__('Button Background ', 'senatory-core'),
            'selector' => "{{WRAPPER}} .header-area .header-bottom .btn-wrapper .boxed-btn:hover"
        ]);
        $this->add_control('divider_04', [
            'type' => Controls_Manager::DIVIDER
        ]);
        $this->add_group_control(Group_Control_Border::get_type(), [
            'name' => 'header_hover_button_border',
            'label' => esc_html__('Border', 'senatory-core'),
            'selector' => "{{WRAPPER}} .header-area .header-bottom .btn-wrapper .boxed-btn:hover"
        ]);
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->add_control('divider_05', [
            'type' => Controls_Manager::DIVIDER
        ]);
        $this->add_control(
            'button_border_radius',
            [
                'label' => esc_html__('Border Radius', 'senatory-core'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .header-area .header-bottom .btn-wrapper .boxed-btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();
        /* button styling end */

        /* typography settings start */
        $this->start_controls_section('typography_settings', [
            'label' => esc_html__('Typography Settings', 'senatory-core'),
            'tab' => Controls_Manager::TAB_STYLE
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'name' => 'title_typography',
            'label' => esc_html__('Title Typography', 'senatory-core'),
            'selector' => "{{WRAPPER}} .header-area .title"
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'name' => 'subtitle_typography',
            'label' => esc_html__('Sub Title Typography', 'senatory-core'),
            'selector' => "{{WRAPPER}} .header-area .header-inner .subtitle"
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'name' => 'button_typography',
            'label' => esc_html__('Button Typography', 'senatory-core'),
            'selector' => "{{WRAPPER}} .header-area .header-bottom .btn-wrapper .boxed-btn"
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'name' => 'info_button_typography',
            'label' => esc_html__('Info Text Typography', 'senatory-core'),
            'selector' => "{{WRAPPER}} .header-area .header-buttom-content p"
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'name' => 'info_number_button_typography',
            'label' => esc_html__('Info number Typography', 'senatory-core'),
            'selector' => "{{WRAPPER}} .header-area .header-buttom-content span"
        ]);
        $this->end_controls_section();
        /* typography settings end */

    }

    /**
     * Render Elementor widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $all_header_items = $settings['gallery_sliders'];
        $rand_numb = rand(333, 999999999);

        //slider settings
        $loop = $settings['loop'] ? 'true' : 'false';
        $items = $settings['items'] ? $settings['items'] : 4;
        $autoplay = $settings['autoplay'] ? 'true' : 'false';
        $nav = $settings['nav'] ? 'true' : 'false';
        $navleft = Senatory_core()->render_elementor_icons($settings['nav_left_arrow']);
        $navright = Senatory_core()->render_elementor_icons($settings['nav_right_arrow']);
        $autoplaytimeout = isset($settings['autoplaytimeout']['size']) ? $settings['autoplaytimeout']['size'] : '1000';
        ?>
        
        


  <!-- Photo Gallery Section Start Here -->
  <div class="gallery-carousel-custom political-gallery-item style-01">
      <div class="container-fluid">
        <div class="row">
		
		
	<div class="theme-carousel-testimonials-seven testimonial-carousel-seven testimonial-new-block-seven"
     id="testimonials-areaa-scarousell-<?php echo esc_attr($rand_numb); ?>"
     data-loop="<?php echo esc_attr($loop); ?>"
     data-margin="<?php echo esc_attr($settings['margin']['size']); ?>"
     data-items="<?php echo esc_attr($items); ?>"
     data-autoplay="<?php echo esc_attr($autoplay); ?>"
     data-nav="<?php echo esc_attr($nav); ?>"
     data-navleft="<?php echo esc_attr($navleft); ?>"
     data-navright="<?php echo esc_attr($navright); ?>"
     data-autoplaytimeout="<?php echo esc_attr($autoplaytimeout); ?>"
>


<?php
    foreach ($all_header_items as $item):
?>	

		<div class="gallery-single-items wow animate__ animate__fadeInUp animated" style="visibility: visible; animation-name: fadeInUp;">
		  <div class="thumb style-01">
			  <img src="<?php echo esc_url($item['gallery_image']['url']); ?>" alt="our work image">
			  <div class="cart-icon">
				  <a class="image-popup" href="<?php echo esc_url($item['gallery_image']['url']); ?>"><i class="fas fa-plus"></i></a>
			  </div>
		  </div>
		</div>
			
<?php endforeach; ?>
			
			
          </div>
        </div>
      </div>
  </div>
  <!-- Photo Gallery Section Start Here -->
  
  
  

        <?php
    }
}

Plugin::instance()->widgets_manager->register_widget_type(new Senatory_Galleryy_Slider_One_Widget());