<?php
/**
 * Elementor Widget
 * @package Senatory
 * @since 1.0.0
 */

namespace Elementor;
class Senatory_Timeline_Boxes_Area_Widget extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'senatory-timeline-widget';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Timeline Area', 'senatory-core');
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'bl_icon eicon-archive-title';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['senatory_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {

        $this->start_controls_section(
            'settings_section',
            [
                'label' => esc_html__('Section Contents', 'senatory-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );


        $this->add_control(
            'title',
            [
                'label' => esc_html__('Title', 'senatory-core'),
                'type' => Controls_Manager::TEXT,
                'description' => esc_html__('enter title.', 'senatory-core'),
                'default' => esc_html__('See History Timeline.', 'senatory-core')
            ]
        );


        $this->add_control(
            'sub-title',
            [
                'label' => esc_html__('Sub Title', 'senatory-core'),
                'type' => Controls_Manager::TEXTAREA,
                'description' => esc_html__('Enter Sub title.', 'senatory-core'),
                'default' => esc_html__('Our Party Visions.', 'senatory-core')
            ]
        );


        $this->end_controls_section();


        $this->start_controls_section(
            'boxx_section',
            [
                'label' => esc_html__('Timeline Boxes', 'senatory-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );


        $repeater = new \Elementor\Repeater();


        $repeater->add_control(
            'background_image', [
                'label' => esc_html__('Box Image', 'senatory-core'),
                'type' => Controls_Manager::MEDIA,
                'show_label' => false,
                'description' => esc_html__('Upload image', 'senatory-core'),
                'default' => [
                    'src' => Utils::get_placeholder_image_src()
                ],
            ]
        );

        $repeater->add_control(
            'box-title', [
                'label' => esc_html__('Title', 'senatory-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('We Will Win The Elections', 'senatory-core'),
                'description' => esc_html__('Enter title', 'senatory-core')
            ]
        );

        $repeater->add_control(
            'box-text', [
                'label' => esc_html__('Box Content', 'senatory-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('Together we can make Better country', 'senatory-core'),
                'description' => esc_html__('Enter box content', 'senatory-core')
            ]
        );

        $repeater->add_control(
            'box-month', [
                'label' => esc_html__('Box Month', 'senatory-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('January', 'senatory-core'),
                'description' => esc_html__('Enter box content', 'senatory-core')
            ]
        );

        $repeater->add_control(
            'box-year', [
                'label' => esc_html__('Box Year', 'senatory-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('2018', 'senatory-core'),
                'description' => esc_html__('Enter box year', 'senatory-core')
            ]
        );


        $this->add_control('boxvision_sliders', [
            'label' => esc_html__('Vision Box Items', 'senatory-core'),
            'type' => Controls_Manager::REPEATER,
            'fields' => $repeater->get_controls(),

            'default' => [
                [

                    'description' => esc_html__('President represented Delaware for 36 years in the US', 'senatory-core'),
                    'title' => esc_html__('Together we can make Better country', 'senatory-core'),
                ]
            ],

        ]);


        $this->end_controls_section();


        $this->start_controls_section(
            'css_styles',
            [
                'label' => esc_html__('Styling Settings', 'senatory-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control('slider_title_color', [
            'label' => esc_html__('Slider Title Color', 'senatory-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .header-area .title" => "color: {{VALUE}}"
            ]
        ]);

        $this->add_control('slider_subtitle_bg_color', [
            'label' => esc_html__('Slider Sub Title Background Color', 'senatory-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .header-area .header-inner .subtitle" => "background-color: {{VALUE}}"
            ]
        ]);

        $this->add_control('slider_subtitle_color', [
            'label' => esc_html__('Slider Sub Title Color', 'senatory-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .header-area .header-inner .subtitle" => "color: {{VALUE}}"
            ]
        ]);

        $this->add_responsive_control('padding', [
            'label' => esc_html__('Padding', 'senatory-core'),
            'type' => Controls_Manager::DIMENSIONS,
            'size_units' => ['px', 'em'],
            'allowed_dimensions' => ['top', 'bottom'],
            'selectors' => [
                '{{WRAPPER}} .header-area' => 'padding-top: {{TOP}}{{UNIT}};padding-bottom: {{BOTTOM}}{{UNIT}};'
            ],
            'description' => esc_html__('set padding for header area ', 'senatory-core')
        ]);

        $this->add_control('overlay_color', [
            'label' => esc_html__('Overlay Color', 'senatory-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .header-area.header-bg::before' => 'background-color:{{VALUE}};'
            ],
        ]);

        $this->end_controls_section();

        /* button styling */
        $this->start_controls_section('header_button_section', [
            'label' => esc_html__('Button Settings', 'senatory-core'),
            'tab' => Controls_Manager::TAB_STYLE
        ]);

        $this->start_controls_tabs('button_styling');

        $this->start_controls_tab('normal_style', [
            'label' => esc_html__('Button Normal', "senatory-core")
        ]);

        $this->add_control('button_normal_color', [
            'label' => esc_html__('Button Color', 'senatory-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .header-area .header-bottom .btn-wrapper .boxed-btn" => "color: {{VALUE}}"
            ]
        ]);

        $this->add_control('divider_01', [
            'type' => Controls_Manager::DIVIDER
        ]);

        $this->add_group_control(Group_Control_Background::get_type(), [
            'name' => 'button_background',
            'label' => esc_html__('Button Background ', 'senatory-core'),
            'selector' => "{{WRAPPER}} .header-area .header-bottom .btn-wrapper .boxed-btn"
        ]);

        $this->add_control('divider_02', [
            'type' => Controls_Manager::DIVIDER
        ]);

        $this->add_group_control(Group_Control_Border::get_type(), [
            'name' => 'header_button_border',
            'label' => esc_html__('Border', 'senatory-core'),
            'selector' => "{{WRAPPER}} .header-area .header-bottom .btn-wrapper .boxed-btn"
        ]);
        $this->add_control('divider_060', [
            'type' => Controls_Manager::DIVIDER
        ]);
        $this->add_control('info_button_normal_color', [
            'label' => esc_html__('Info Button Text Color', 'senatory-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .header-area .header-buttom-content p" => "color: {{VALUE}}"
            ]
        ]);
        $this->add_control('info_number_button_normal_color', [
            'label' => esc_html__('Info Button Number Color', 'senatory-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .header-area .header-buttom-content span" => "color: {{VALUE}}"
            ]
        ]);
        $this->end_controls_tab();

        $this->start_controls_tab('hover_style', [
            'label' => esc_html__('Button Hover', "senatory-core")
        ]);
        $this->add_control('button_hover_normal_color', [
            'label' => esc_html__('Button Color', 'senatory-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .header-area .header-bottom .btn-wrapper .boxed-btn:hover" => "color: {{VALUE}}"
            ]
        ]);
        $this->add_control('divider_03', [
            'type' => Controls_Manager::DIVIDER
        ]);
        $this->add_group_control(Group_Control_Background::get_type(), [
            'name' => 'button_hover_background',
            'label' => esc_html__('Button Background ', 'senatory-core'),
            'selector' => "{{WRAPPER}} .header-area .header-bottom .btn-wrapper .boxed-btn:hover"
        ]);
        $this->add_control('divider_04', [
            'type' => Controls_Manager::DIVIDER
        ]);
        $this->add_group_control(Group_Control_Border::get_type(), [
            'name' => 'header_hover_button_border',
            'label' => esc_html__('Border', 'senatory-core'),
            'selector' => "{{WRAPPER}} .header-area .header-bottom .btn-wrapper .boxed-btn:hover"
        ]);
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->add_control('divider_05', [
            'type' => Controls_Manager::DIVIDER
        ]);
        $this->add_control(
            'button_border_radius',
            [
                'label' => esc_html__('Border Radius', 'senatory-core'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .header-area .header-bottom .btn-wrapper .boxed-btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();
        /* button styling end */

        /* typography settings start */
        $this->start_controls_section('typography_settings', [
            'label' => esc_html__('Typography Settings', 'senatory-core'),
            'tab' => Controls_Manager::TAB_STYLE
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'name' => 'title_typography',
            'label' => esc_html__('Title Typography', 'senatory-core'),
            'selector' => "{{WRAPPER}} .header-area .title"
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'name' => 'subtitle_typography',
            'label' => esc_html__('Sub Title Typography', 'senatory-core'),
            'selector' => "{{WRAPPER}} .header-area .header-inner .subtitle"
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'name' => 'button_typography',
            'label' => esc_html__('Button Typography', 'senatory-core'),
            'selector' => "{{WRAPPER}} .header-area .header-bottom .btn-wrapper .boxed-btn"
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'name' => 'info_button_typography',
            'label' => esc_html__('Info Text Typography', 'senatory-core'),
            'selector' => "{{WRAPPER}} .header-area .header-buttom-content p"
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'name' => 'info_number_button_typography',
            'label' => esc_html__('Info number Typography', 'senatory-core'),
            'selector' => "{{WRAPPER}} .header-area .header-buttom-content span"
        ]);
        $this->end_controls_section();
        /* typography settings end */

    }

    /**
     * Render Elementor widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $all_header_items = $settings['boxvision_sliders'];

        ?>


        <!-- Our History Timeline Section Start Here -->
        <div class="history-timeline-section">
            <img src="<?php echo SENATORY_CORE_IMG . '/shape-10.png'; ?>" class="history-shape-02" alt="">
            <img src="<?php echo SENATORY_CORE_IMG . '/Ellipse-01.png'; ?>" class="history-shape-03" alt="">
            <img src="<?php echo SENATORY_CORE_IMG . '/Ellipse-02.png'; ?>" class="history-shape-04" alt="">
            <img src="<?php echo SENATORY_CORE_IMG . '/Ellipse-03.png'; ?>" class="history-shape-05" alt="">

            <div class="container custom-container">
                <div class="row justify-content-center">
                    <div class="col-lg-6">
                        <div class="section-title">
                            <h4 class="title wow animate__animated animate__fadeInUp"><?php echo esc_html($settings['title']) ?></h4>
                            <p class="description wow animate__animated animate__fadeInUp">
                                <?php echo wp_kses_post($settings['sub-title']); ?>
                            </p>
                        </div>
                    </div>
                </div>
                <div class="history-item-wrap">
                    <?php
                    foreach ($all_header_items as $item):
                        ?>
                        <div class="history-single-item">
                            <span class="circle"></span>
                            <div class="history-single-item-content wow animate__animated animate__fadeInLeft">
                                <div class="thumb"
                                     style="background-image: url(<?php echo esc_url($item['background_image']['url']); ?>)">
                                </div>
                                <div class="content">
                                    <h4 class="title"><?php echo esc_html($item['box-title']) ?></h4>
                                    <p><?php echo wp_kses_post($item['box-text']); ?></p>
                                </div>
                            </div>
                            <div class="history-year wow animate__animated animate__fadeInRight">
                                <p class="month"><?php echo esc_html($item['box-month']) ?></p>
                                <h6 class="year"><?php echo esc_html($item['box-year']) ?></h6>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </div>
        <!-- Our History Timeline Section Start Here -->


        <?php
    }
}

Plugin::instance()->widgets_manager->register_widget_type(new Senatory_Timeline_Boxes_Area_Widget());