<?php
/**
 * Elementor Widget
 * @package Senatory
 * @since 1.0.0
 */

namespace Elementor;
class Senatory_Banner_Area_Widget extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'senatory-banner-home-widget';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Banner Section', 'senatory-master');
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'bl_icon eicon-archive-title';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['senatory_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {

        $this->start_controls_section(
            'settings_section',
            [
                'label' => esc_html__('Section Contents', 'senatory-master'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );


        $this->add_control(
            'banner_image',
            [
                'label' => esc_html__('Banner Bg Image', 'senatory-core'),
                'type' => Controls_Manager::MEDIA,
                'show_label' => false,
                'description' => esc_html__('Upload background image', 'senatory-master'),
                'default' => [
                    'src' => Utils::get_placeholder_image_src()
                ],
            ]
        );


        $this->add_control(
            'title',
            [
                'label' => esc_html__('Title', 'senatory-core'),
                'type' => Controls_Manager::TEXT,
                'description' => esc_html__('enter title.', 'senatory-core'),
                'default' => esc_html__('Join The Fight for Our Freedom', 'senatory-core')
            ]
        );


        $this->add_control(
            'sub-title',
            [
                'label' => esc_html__('Sub Title', 'senatory-core'),
                'type' => Controls_Manager::TEXT,
                'description' => esc_html__('Enter Sub title.', 'senatory-core'),
                'default' => esc_html__('Our Party Visions', 'senatory-core')
            ]
        );

        $this->add_control(
            'banner-text',
            [
                'label' => esc_html__('Content', 'senatory-core'),
                'type' => Controls_Manager::TEXTAREA,
                'description' => esc_html__('enter title.', 'senatory-core'),
                'default' => esc_html__('Every pleasures is to welcomed pain avoided owing to the duty.', 'senatory-core')
            ]
        );


        $this->add_control(
            'form-content',
            [
                'label' => esc_html__('Banner form section', 'senatory-core'),
                'type' => Controls_Manager::WYSIWYG,
                'description' => esc_html__('Enter form shortcode.', 'senatory-core'),
                'default' => esc_html__('Form Here', 'senatory-core')
            ]
        );


        $this->add_control(
            'banner-phone',
            [
                'label' => esc_html__('Banner Phone Number', 'senatory-core'),
                'type' => Controls_Manager::TEXTAREA,
                'description' => esc_html__('enter title.', 'senatory-core'),
                'default' => esc_html__('009-215-5599', 'senatory-core')
            ]
        );

        $this->add_control(
            'banner-email',
            [
                'label' => esc_html__('Banner Email', 'senatory-core'),
                'type' => Controls_Manager::TEXTAREA,
                'description' => esc_html__('enter title.', 'senatory-core'),
                'default' => esc_html__('info@gmail.com', 'senatory-core')
            ]
        );

        $this->end_controls_section();


        $this->start_controls_section(
            'css_styles',
            [
                'label' => esc_html__('Styling Settings', 'senatory-master'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control('slider_title_color', [
            'label' => esc_html__('Slider Title Color', 'senatory-master'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .header-banner-wrapper.header-area.header-sanatory .header-inner.political .title" => "color: {{VALUE}}"
            ]
        ]);


        $this->add_control('slider_subtitle_color', [
            'label' => esc_html__('Slider Sub Title Color', 'senatory-master'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .header-banner-wrapper.header-area .subtitle" => "color: {{VALUE}}"
            ]
        ]);

        $this->add_control('slider_des_color', [
            'label' => esc_html__('Testimonial Content Color', 'senatory-master'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .header-banner-wrapper.header-area.header-sanatory .header-inner.political p" => "color: {{VALUE}}"
            ]
        ]);


        $this->end_controls_section();

        /* typography settings start */
        $this->start_controls_section('typography_settings', [
            'label' => esc_html__('Typography Settings', 'senatory-master'),
            'tab' => Controls_Manager::TAB_STYLE
        ]);

        /* typography settings start */
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'label' => esc_html__('Title Typography', 'senatory-core'),
            'name' => 'title_typography',
            'description' => esc_html__('select title typography', 'senatory-core'),
            'selector' => "{{WRAPPER}} .header-banner-wrapper.header-area.header-sanatory .header-inner.political .title"
        ]);

        $this->add_group_control(Group_Control_Typography::get_type(), [
            'label' => esc_html__('Sub Title Typography', 'senatory-core'),
            'name' => 'sbtitle_typography',
            'description' => esc_html__('select sub title typography', 'senatory-core'),
            'selector' => "{{WRAPPER}} .header-banner-wrapper.header-area .subtitle"
        ]);


        $this->add_group_control(Group_Control_Typography::get_type(), [
            'label' => esc_html__('Description Typography', 'senatory-core'),
            'name' => 'description_typography',
            'description' => esc_html__('select description typography', 'senatory-core'),
            'selector' => "{{WRAPPER}} .header-banner-wrapper.header-area.header-sanatory .header-inner.political p"
        ]);


        $this->end_controls_section();
        /* typography settings end */

    }

    /**
     * Render Elementor widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();

        ?>


        <div class="header-banner-wrapper header-area header-sanatory header-bg-02"
             style="background-image:url(<?php echo esc_url($settings['banner_image']['url']); ?>);">
            <div class="container nav-container custom-container">
                <div class="row">
                    <div class="col-lg-9">
                        <div class="header-inner political">
                            <!-- header inner -->
                            <div class="subtitle">
                                <span><?php echo esc_html($settings['sub-title']); ?></span>
                                <span class="line"></span>
                                <span class="line-02"></span>
                            </div>
                            <h1 class="title"><?php echo esc_html($settings['title']) ?> </h1>
                            <p>
                                <?php echo wp_kses_post($settings['banner-text']); ?>
                            </p>
                            <?php echo wp_kses_post($settings['form-content']); ?>
                        </div>
                        <!-- //.header inner -->
                    </div>
                </div>
            </div>
        </div>
        <!-- Header section End -->


        <?php
    }
}

Plugin::instance()->widgets_manager->register_widget_type(new Senatory_Banner_Area_Widget());