<?php
/**
 * Elementor Widget
 * @package Senatory
 * @since 1.0.0
 */

namespace Elementor;
class Senatory_Banner_Two_Widget extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'senatory-banner-two-home-widget';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Banner Section 02', 'senatory-master');
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'bl_icon eicon-archive-title';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['senatory_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {

        $this->start_controls_section(
            'settings_section',
            [
                'label' => esc_html__('Section Contents', 'senatory-master'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'banner_image',
            [
                'label' => esc_html__('Banner Bg Image', 'senatory-core'),
                'type' => Controls_Manager::MEDIA,
                'show_label' => false,
                'description' => esc_html__('Upload background image', 'senatory-master'),
                'default' => [
                    'src' => Utils::get_placeholder_image_src()
                ],
            ]
        );

        $this->add_control(
            'site_logo',
            [
                'label' => esc_html__('Site Logo', 'senatory-core'),
                'type' => Controls_Manager::MEDIA,
                'show_label' => false,
                'description' => esc_html__('Upload Site Logo', 'senatory-master'),
                'default' => [
                    'src' => Utils::get_placeholder_image_src()
                ],
            ]
            );

        $this->add_control(
            'title',
            [
                'label' => esc_html__('Title', 'senatory-core'),
                'type' => Controls_Manager::TEXT,
                'description' => esc_html__('enter title.', 'senatory-core'),
                'default' => esc_html__('Join The Fight for Our Freedom', 'senatory-core')
            ]
        );


        $this->add_control(
            'sub-title',
            [
                'label' => esc_html__('Sub Title', 'senatory-core'),
                'type' => Controls_Manager::TEXT,
                'description' => esc_html__('Enter Sub title.', 'senatory-core'),
                'default' => esc_html__('Our Party Visions', 'senatory-core')
            ]
        );

        $this->add_control(
            'banner-text',
            [
                'label' => esc_html__('Content', 'senatory-core'),
                'type' => Controls_Manager::TEXTAREA,
                'description' => esc_html__('enter title.', 'senatory-core'),
                'default' => esc_html__('Every pleasures is to welcomed pain avoided owing to the duty.', 'senatory-core')
            ]
        );

        $this->add_control(
            'button-text',
            [
                'label' => esc_html__('Button', 'senatory-core'),
                'type' => Controls_Manager::TEXT,
                'description' => esc_html__('enter button title.', 'senatory-core'),
                'default' => esc_html__('Read More', 'senatory-core')
            ]
        );

        $this->add_control(
            'button-url',
            [
                'label' => esc_html__('URL', 'senatory-core'),
                'type' => Controls_Manager::URL,
                'description' => esc_html__('enter button target.', 'senatory-core'),
                'default' => [
                    'url' => '#'
                ]
            ]
        );

        $this->add_control(
            'icon', [
                'label' => esc_html__('Icon', 'senatory-core'),
                'type' => Controls_Manager::ICONS,
                'description' => esc_html__('Select Icon', 'senatory-core'),
                'default' => [
                    'value' => 'flaticon-statistics',
                    'library' => 'solid',
                ]
            ]
        );

        $this->add_control(
            'email',
            [
                'label' => esc_html__('Email', 'senatory-core'),
                'type' => Controls_Manager::TEXT,
                'description' => esc_html__('email address title.', 'senatory-core'),
                'default' => esc_html__('hello@senatory.com', 'senatory-core')
            ]
        );

        $this->add_control(
            'email-icon', [
                'label' => esc_html__('Email Icon', 'senatory-core'),
                'type' => Controls_Manager::ICONS,
                'description' => esc_html__('Select Email Icon', 'senatory-core'),
                'default' => [
                    'value' => 'flaticon-envelope',
                    'library' => 'solid',
                ]
            ]
        );

        $this->add_control(
            'donation-text',
            [
                'label' => esc_html__('Donation Text', 'senatory-core'),
                'type' => Controls_Manager::TEXT,
                'description' => esc_html__('enter Donation title.', 'senatory-core'),
                'default' => esc_html__('Donation Now', 'senatory-core')
            ]
        );

        $this->add_control(
            'donation-url',
            [
                'label' => esc_html__('Donation URL', 'senatory-core'),
                'type' => Controls_Manager::URL,
                'description' => esc_html__('enter Donation target.', 'senatory-core'),
                'default' => [
                    'url' => '#'
                ]
            ]
        );

        $this->add_control(
            'donation-icon', [
                'label' => esc_html__('Donation Icon', 'senatory-core'),
                'type' => Controls_Manager::ICONS,
                'description' => esc_html__('Select Donation Icon', 'senatory-core'),
                'default' => [
                    'value' => 'icon-paper-plan',
                    'library' => 'solid',
                ]
            ]
        );


        $repeater = new \Elementor\Repeater();


        $repeater->add_control(
            'icon', [
                'label' => esc_html__('Icon', 'senatory-master'),
                'type' =>  Controls_Manager::ICONS,
                'description' => esc_html__('Select Social Icon', 'senatory-core'),
                'default' => [
                    'value' => 'icon-paper-plan',
                    'library' => 'solid',
                ]
            ]
        );

        $repeater->add_control(
            'url', [
                'label' => esc_html__('Url', 'senatory-master'),
                'type' => Controls_Manager::URL,
                'description' => esc_html__('enter Donation target.', 'senatory-core'),
                'default' => [
                    'url' => '#'
                ]
            ]
        );

        $this->add_control('social_icons', [
            'label' => esc_html__('Add Social Icons', 'senatory-core'),
            'type' => Controls_Manager::REPEATER,
            'fields' => $repeater->get_controls(),
        ]);
    

        $this->end_controls_section();


        $this->start_controls_section(
            'css_styles',
            [
                'label' => esc_html__('Styling Settings', 'senatory-master'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'background',
				'label' => esc_html__( 'Background', 'senatory-core' ),
				'types' => [  'gradient', ],
				'selector' => '{{WRAPPER}} .header-area.header-bg-02::before',
			]
		);
        $this->end_controls_section();

        /* typography settings start */
        $this->start_controls_section('typography_settings', [
            'label' => esc_html__('Typography Settings', 'senatory-core'),
            'tab' => Controls_Manager::TAB_STYLE
        ]);

        /* typography settings start */
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'label' => esc_html__('Title Typography', 'senatory-core'),
            'name' => 'title_typography',
            'description' => esc_html__('select title typography', 'senatory-core'),
            'selector' => "{{WRAPPER}} .header-area.style-04 .header-inner.style-02 .subtitle"
        ]);

        /* typography settings start */
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'label' => esc_html__('Details Typography', 'senatory-core'),
            'name' => 'details_typography',
            'description' => esc_html__('select Details typography', 'senatory-core'),
            'selector' => "{{WRAPPER}} .header-area.style-04 .header-inner .title.style-02"
        ]);

        $this->end_controls_section();
        /* typography settings end */

    }

    /**
     * Render Elementor widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $social_icons = $settings['social_icons'];
        
        ?>

        <!-- Header section End -->

        <div class="header-area style-02 style-04 header-sanatory header-bg-02" style="background-image:url(<?php echo esc_url($settings['banner_image']['url']); ?>);">
            <div class="header-nav-wrapper">
            <div class="header-top">
                <div class="top-single-items">
                <div class="top-single-item">
                    <div class="icon">
                        <?php
                            Icons_Manager::render_icon($settings['email-icon'], ['aria-hidden' => 'true']);
                        ?>
                    </div>
                    <div class="content">
                    <h5 class="title"><?php echo esc_html($settings['email']); ?></h5>
                    </div>
                </div>
                
                
                <div class="top-single-item">
                    <select class="form-select">
                    <option selected>Language</option>
                    <option value="1">Arabic</option>
                    <option value="2">Bangla</option>
                    <option value="3">English</option>
                    </select>
                </div>
                </div>
                <div class="logo-wrapper">
                <a href="<?php echo site_url(); ?>" class="logo">
                    <img src="<?php echo esc_url($settings['site_logo']['url']); ?>" alt="" />
                </a>
                </div>

                <!-- nav menu area -->
                    <?php
                        wp_nav_menu(array(
                            'theme_location' => 'main-menu',
                            'menu_class' => 'header-nav',
                            'container_class' => 'collapse navbar-collapse',
                        ));
                    ?>


                <div class="btn-wrapper">
                    <a href="<?php echo esc_url($settings['donation-url']['url']); ?>" class="boxed-btn btn-sanatory">
                        <?php echo esc_html($settings['donation-text']); ?>
                        <?php
                            Icons_Manager::render_icon($settings['donation-icon'], ['aria-hidden' => 'true']);
                        ?>
                    </a>
                </div>
                <div class="top-social">
                <ul class="top-social-share">
                    <?php foreach($social_icons as $item) { ?>
                        <li>
                            <a href="<?php echo esc_url($item['url']['url']); ?>">
                                <?php
                                    Icons_Manager::render_icon($item['icon'], ['aria-hidden' => 'true']);
                                ?>
                            </a>
                        </li>
                    <?php
                    }
                    ?>
                </ul>
                </div>
            </div>
            </div>
            <div class="container nav-container">
                <div class="row justify-content-center">
                    <div class="col-lg-9">
                    <div class="header-inner style-02 political text-center">
                        <!-- header inner -->
                        <div class="subtitle">
                         <svg viewBox="0 0 191.6 78.6" class="lottie-shape title-shape">
                            <path class="path" fill="none" stroke="#DD131A" stroke-width="4.5" stroke-linecap="round"
                                  d="M186.3,17.5c0,0-36.4-18.2-92.3-14.7S1.4,29.6,2.9,47.8s34.4,25.9,62.6,28s79.9-1.5,108.2-14.9
        s12.8-31.8-5.9-37.7c-26.4-8.4-49.5-9.5-49.5-9.5"/>
                        </svg>
                        <span><?php echo esc_html($settings['title']); ?></span> <?php echo esc_html($settings['sub-title']); ?>
                        </div>
                        <h1 class="title style-02"><?php echo esc_html($settings['banner-text']); ?></h1>
                        <div class="btn-wrapper desktop-center">
                            <a href="#" class="boxed-btn btn-sanatory style-01 text-uppercase"><i class="fas fa-arrow-right"></i> Read More</a>
                        </div>
                    </div>
                        <!-- //.header inner -->
                    </div>
                </div>
            </div>
        </div>
        <?php
    }
}

Plugin::instance()->widgets_manager->register_widget_type(new Senatory_Banner_Two_Widget());