<?php
/**
 * Elementor Widget
 * @package Senatory
 * @since 1.0.0
 */

namespace Elementor;
class Senatory_Header_Area_Slider_One_Widget extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'senatory-header-slider-one-widget';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Header Slider: 01', 'senatory-core');
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'bl_icon eicon-archive-title';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['senatory_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {

        $this->start_controls_section(
            'settings_section',
            [
                'label' => esc_html__('Section Contents', 'senatory-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'background_image', [
                'label' => esc_html__('Slide Background Image', 'senatory-core'),
                'type' => Controls_Manager::MEDIA,
                'show_label' => false,
                'description' => esc_html__('Upload background image', 'senatory-core'),
                'default' => [
                    'src' => Utils::get_placeholder_image_src()
                ],
            ]
        );

        $repeater->add_control(
            'banner_image', [
                'label' => esc_html__('Slide Banner Image', 'senatory-core'),
                'type' => Controls_Manager::MEDIA,
                'show_label' => false,
                'description' => esc_html__('Upload banner image', 'senatory-core'),
                'default' => [
                    'src' => Utils::get_placeholder_image_src()
                ],
            ]
        );

        $repeater->add_control(
            'title', [
                'label' => esc_html__('Title', 'senatory-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('Together we can make Better country', 'senatory-core'),
                'description' => esc_html__('Enter title', 'senatory-core')
            ]
        );

        $repeater->add_control(
            'sub-title', [
                'label' => esc_html__('Sub Title', 'senatory-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('Vote for the best candidate', 'senatory-core'),
                'description' => esc_html__('Enter Sub title', 'senatory-core')
            ]
        );


        $repeater->add_control(
            'description_status', [
                'label' => esc_html__('Description Show/Hide', 'senatory-core'),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'yes',
                'description' => esc_html__('Show/hide description', 'senatory-core')
            ]
        );

        $repeater->add_control(
            'description', [
                'label' => esc_html__('Slide Description', 'senatory-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('President represented Delaware for 36 years in the US', 'senatory-core'),
                'description' => esc_html__('enter description', 'senatory-core'),
                'condition' => ['description_status' => 'yes']
            ]
        );

        $repeater->add_control(
            'btn_status', [
                'label' => esc_html__('Button Show/Hide', 'senatory-core'),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'yes',
                'description' => esc_html__('show/hide button', 'senatory-core')
            ]
        );

        $repeater->add_control(
            'btn_text', [
                'label' => esc_html__('Button Text', 'senatory-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Discover More', 'senatory-core'),
                'description' => esc_html__('Enter button text', 'senatory-core'),
                'condition' => ['btn_status' => 'yes']
            ]
        );

        $repeater->add_control(
            'btn_link', [
                'label' => esc_html__('Button URL', 'senatory-core'),
                'type' => Controls_Manager::URL,
                'default' => [
                    'url' => '#'
                ],
                'description' => esc_html__('Enter button url', 'senatory-core'),
                'condition' => ['btn_status' => 'yes']
            ]
        );


        $repeater->add_control(
            'btn-icon',
            [
                'label' => esc_html__('Button Icon', 'senatory-core'),
                'type' => Controls_Manager::ICONS,
                'description' => esc_html__('select btn Icon.', 'senatory-core'),
                'default' => [
                    'value' => 'fas fa-arrow-right',
                    'library' => 'solid',
                ]
            ]
        );

        $repeater->add_control(
            'btn_status_video', [
                'label' => esc_html__('Video Button Show/Hide', 'senatory-core'),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'yes',
                'description' => esc_html__('show/hide video button', 'senatory-core')
            ]
        );


        $repeater->add_control(
            'btn_link_video', [
                'label' => esc_html__('Video Button URL', 'senatory-core'),
                'type' => Controls_Manager::URL,
                'default' => [
                    'url' => '#'
                ],
                'description' => esc_html__('Enter button video url', 'senatory-core'),
                'condition' => ['btn_status_video' => 'yes']
            ]
        );

        $repeater->add_control(
            'video-icon',
            [
                'label' => esc_html__('Video Icon', 'senatory-core'),
                'type' => Controls_Manager::ICONS,
                'description' => esc_html__('select btn Icon.', 'senatory-core'),
                'default' => [
                    'value' => 'fas fa-play',
                    'library' => 'solid',
                ]
            ]
        );


        $this->add_control('header_sliders', [
            'label' => esc_html__('Header Slider Items', 'senatory-core'),
            'type' => Controls_Manager::REPEATER,
            'fields' => $repeater->get_controls(),

            'default' => [
                [
                    'background_image' => array(
                        'url' => Utils::get_placeholder_image_src()
                    ),
                    'description_status' => 'yes',
                    'description' => esc_html__('President represented Delaware for 36 years in the US', 'senatory-core'),
                    'title' => esc_html__('Together we can make Better country', 'senatory-core'),
                ]
            ],

        ]);

        $this->end_controls_section();


        $this->start_controls_section(
            'slider_settings_section',
            [
                'label' => esc_html__('Slider Settings', 'senatory-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'items',
            [
                'label' => esc_html__('Items', 'senatory-core'),
                'type' => Controls_Manager::TEXT,
                'description' => esc_html__('you can set how many item show in slider', 'senatory-core'),
                'default' => '1'
            ]
        );

        $this->add_control(
            'margin',
            [
                'label' => esc_html__('Margin', 'senatory-core'),
                'description' => esc_html__('you can set margin for slider', 'senatory-core'),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                        'step' => 5,
                    ]
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 0,
                ],

                'size_units' => ['px'],
                'condition' => array(
                    'autoplay' => 'yes'
                )
            ]
        );

        $this->add_control(
            'loop',
            [
                'label' => esc_html__('Loop', 'senatory-core'),
                'type' => Controls_Manager::SWITCHER,
                'description' => esc_html__('you can set yes/no to enable/disable', 'senatory-core'),
                'default' => 'yes'
            ]
        );

        $this->add_control(
            'dots',
            [
                'label' => esc_html__('Dots', 'senatory-core'),
                'type' => Controls_Manager::SWITCHER,
                'description' => esc_html__('you can set yes/no to enable/disable', 'senatory-core'),
                'default' => 'yes'
            ]
        );

        $this->add_control(
            'nav',
            [
                'label' => esc_html__('Nav', 'senatory-core'),
                'type' => Controls_Manager::SWITCHER,
                'description' => esc_html__('you can set yes/no to enable/disable', 'senatory-core'),
                'default' => 'no'
            ]
        );

        $this->add_control(
            'nav_right_arrow',
            [
                'label' => esc_html__('Nav Right Icon', 'senatory-core'),
                'type' => Controls_Manager::ICONS,
                'description' => esc_html__('you can set yes/no to enable/disable', 'senatory-core'),
                'default' => [
                    'value' => 'fas fa-angle-right',
                    'library' => 'solid',
                ],
            ]
        );

        $this->add_control(
            'nav_left_arrow',
            [
                'label' => esc_html__('Nav Left Icon', 'senatory-core'),
                'type' => Controls_Manager::ICONS,
                'description' => esc_html__('you can set yes/no to enable/disable', 'senatory-core'),
                'default' => [
                    'value' => 'fas fa-angle-left',
                    'library' => 'solid',
                ],
            ]
        );

        $this->add_control(
            'autoplay',
            [
                'label' => esc_html__('Autoplay', 'senatory-core'),
                'type' => Controls_Manager::SWITCHER,
                'description' => esc_html__('you can set yes/no to enable/disable', 'senatory-core'),
                'default' => 'yes'
            ]
        );

        $this->add_control(
            'autoplaytimeout',
            [
                'label' => esc_html__('Autoplay Timeout', 'senatory-core'),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 10000,
                        'step' => 2,
                    ]
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 5000,
                ],
                'size_units' => ['px'],
                'condition' => array(
                    'autoplay' => 'yes'
                )
            ]

        );

        $this->end_controls_section();

        $this->start_controls_section(
            'css_styles',
            [
                'label' => esc_html__('Styling Settings', 'senatory-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control('slider_title_color', [
            'label' => esc_html__('Slider Title Color', 'senatory-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .header-slider-one-wrapperr .header-area.header-sanatory .header-inner .title" => "color: {{VALUE}}"
            ]
        ]);


        $this->add_control('slider_subtitle_color', [
            'label' => esc_html__('Slider Sub Title Color', 'senatory-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .header-slider-one-wrapperr .header-area.header-sanatory .header-inner h5" => "color: {{VALUE}}"
            ]
        ]);

        $this->add_control('slider_des_color', [
            'label' => esc_html__('Slider Description Text Color', 'senatory-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .header-slider-one-wrapperr .header-area.header-sanatory .header-inner p" => "color: {{VALUE}}"
            ]
        ]);


        $this->add_control('overlay_color', [
            'label' => esc_html__('Overlay Color', 'senatory-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .header-slider-one-wrapperr .header-area.header-bg::before' => 'background-color:{{VALUE}};'
            ],
        ]);

        $this->end_controls_section();


        /* button styling */

        $this->start_controls_section('header_button_section', [
            'label' => esc_html__('Button Settings', 'senatory-core'),
            'tab' => Controls_Manager::TAB_STYLE
        ]);

        $this->start_controls_tabs('button_styling');

        $this->start_controls_tab('normal_style', [
            'label' => esc_html__('Button Normal', "senatory-core")
        ]);

        $this->add_control('button_normal_color', [
            'label' => esc_html__('Button Color', 'senatory-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .btn-wrapper .boxed-btn.btn-sanatory.style-01" => "color: {{VALUE}}"
            ]
        ]);

        $this->add_control('divider_01', [
            'type' => Controls_Manager::DIVIDER
        ]);

        $this->add_control('button_background', [
            'label' => esc_html__('Button Background', 'senatory-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .btn-wrapper .boxed-btn.btn-sanatory.style-01" => "background-color: {{VALUE}}"
            ]
        ]);

        $this->add_control('divider_02', [
            'type' => Controls_Manager::DIVIDER
        ]);

        $this->add_group_control(Group_Control_Border::get_type(), [
            'name' => 'slide_button_border',
            'label' => esc_html__('Border', 'senatory-core'),
            'selector' => "{{WRAPPER}} .btn-wrapper .boxed-btn.btn-sanatory.style-01",
        ]);


        $this->end_controls_tab();

        $this->start_controls_tab('hover_style', [
            'label' => esc_html__('Button Hover', "senatory-core")
        ]);

        $this->add_control('button_hover_normal_color', [
            'label' => esc_html__('Button Hover Color', 'senatory-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .btn-wrapper .boxed-btn.btn-sanatory.style-01:hover" => "color: {{VALUE}}"
            ]
        ]);

        $this->add_control('divider_03', [
            'type' => Controls_Manager::DIVIDER
        ]);

        $this->add_control('button_hover_background', [
            'label' => esc_html__('Button Hover Background', 'senatory-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .btn-wrapper .boxed-btn.btn-sanatory.style-01:hover" => "background-color: {{VALUE}}"
            ]
        ]);


        $this->add_control('divider_04', [
            'type' => Controls_Manager::DIVIDER
        ]);


        $this->add_group_control(Group_Control_Border::get_type(), [
            'name' => 'slide_button_border_hover',
            'label' => esc_html__('Border', 'senatory-core'),
            'selector' => "{{WRAPPER}} .btn-wrapper .boxed-btn.btn-sanatory.style-01:hover",
        ]);


        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->add_control('divider_05', [
            'type' => Controls_Manager::DIVIDER
        ]);

        $this->add_control(
            'button_border_radius',
            [
                'label' => esc_html__('Border Radius', 'senatory-core'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .btn-wrapper .boxed-btn.btn-sanatory.style-01' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control('padding', [
            'label' => esc_html__('Button Padding', 'senatory-core'),
            'type' => Controls_Manager::DIMENSIONS,
            'size_units' => ['px', 'em'],
            'allowed_dimensions' => ['top', 'bottom', 'left', 'right'],
            'selectors' => [
                '{{WRAPPER}} .btn-wrapper .boxed-btn.btn-sanatory.style-01' => 'padding-top: {{TOP}}{{UNIT}};padding-bottom: {{BOTTOM}}{{UNIT}};padding-left: {{LEFT}}{{UNIT}}; padding-right: {{RIGHT}}{{UNIT}};'
            ],
            'description' => esc_html__('Set button padding', 'senatory-core')
        ]);


        $this->end_controls_section();
        /* button styling end */

        /* typography settings start */
        $this->start_controls_section('typography_settings', [
            'label' => esc_html__('Typography Settings', 'senatory-core'),
            'tab' => Controls_Manager::TAB_STYLE
        ]);

        $this->add_group_control(Group_Control_Typography::get_type(), [
            'name' => 'title_typography',
            'label' => esc_html__('Title Typography', 'senatory-core'),
            'selector' => "{{WRAPPER}} .header-slider-one-wrapperr .header-area.header-sanatory .header-inner .title"
        ]);


        $this->add_group_control(Group_Control_Typography::get_type(), [
            'name' => 'subtitle_typography',
            'label' => esc_html__('Sub Title Typography', 'senatory-core'),
            'selector' => "{{WRAPPER}} .header-slider-one-wrapperr .header-area.header-sanatory .header-inner h5"
        ]);

        $this->add_group_control(Group_Control_Typography::get_type(), [
            'name' => 'des_typography',
            'label' => esc_html__('Description Typography', 'senatory-core'),
            'selector' => "{{WRAPPER}} .header-slider-one-wrapperr .header-area.header-sanatory .header-inner p"
        ]);

        $this->add_group_control(Group_Control_Typography::get_type(), [
            'name' => 'button_typography',
            'label' => esc_html__('Button Typography', 'senatory-core'),
            'selector' => "{{WRAPPER}} .btn-wrapper .boxed-btn.btn-sanatory.style-01"
        ]);


        $this->end_controls_section();
        /* typography settings end */

    }

    /**
     * Render Elementor widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $all_header_items = $settings['header_sliders'];
        $rand_numb = rand(333, 999999999);

        //slider settings
        $loop = $settings['loop'] ? 'true' : 'false';
        $items = $settings['items'] ? $settings['items'] : 1;
        $autoplay = $settings['autoplay'] ? 'true' : 'false';
        $nav = $settings['nav'] ? 'true' : 'false';
        $dots = $settings['dots'] ? 'true' : 'false';
        $navleft = Senatory_core()->render_elementor_icons($settings['nav_left_arrow']);
        $navright = Senatory_core()->render_elementor_icons($settings['nav_right_arrow']);
        $autoplaytimeout = isset($settings['autoplaytimeout']['size']) ? $settings['autoplaytimeout']['size'] : '1000';
        ?>


        <div class="header-slider-one-wrapperr">


            <div class="header-carousel-one header-slider-one"
                 id="header-one-carousel-<?php echo esc_attr($rand_numb); ?>"
                 data-loop="<?php echo esc_attr($loop); ?>"
                 data-margin="<?php echo esc_attr($settings['margin']['size']); ?>"
                 data-items="<?php echo esc_attr($items); ?>"
                 data-autoplay="<?php echo esc_attr($autoplay); ?>"
                 data-nav="<?php echo esc_attr($nav); ?>"
                 data-dots="<?php echo esc_attr($dots); ?>"
                 data-navleft="<?php echo esc_attr($navleft); ?>"
                 data-navright="<?php echo esc_attr($navright); ?>"
                 data-autoplaytimeout="<?php echo esc_attr($autoplaytimeout); ?>"
            >


                <?php
                foreach ($all_header_items as $item):
                    $img_url = wp_get_attachment_image_src($item['background_image']['id'], 'full');
                    ?>


                    <div class="header-area header-sanatory header-bg"
                         style="background-image: url(<?php echo esc_url($item['background_image']['url']) ?>)">
                        <div class="senatory-bg-img"
                             style="background-image: url(<?php echo esc_url($item['banner_image']['url']) ?>)"></div>
                        <svg viewBox="0 0 191.6 78.6" class="lottie-shape">
                            <path class="path" fill="none" stroke="#DD131A" stroke-width="4.5" stroke-linecap="round"
                                  d="M186.3,17.5c0,0-36.4-18.2-92.3-14.7S1.4,29.6,2.9,47.8s34.4,25.9,62.6,28s79.9-1.5,108.2-14.9
        s12.8-31.8-5.9-37.7c-26.4-8.4-49.5-9.5-49.5-9.5"/>
                        </svg>
                        <div class="container nav-container custom-container">
                            <div class="row">
                                <div class="col-lg-8">
                                    <div class="header-inner">
                                        <!-- header inner -->
                                        <h1 class="title"><?php echo esc_html($item['title']) ?></h1>
                                        <h5 class="subtitle-01">
                                            <i class="fas fa-circle"></i><?php echo esc_html($item['sub-title']) ?>
                                        </h5>
                                        <?php if ($item['description_status'] == 'yes'): ?>
                                            <p><?php echo esc_html($item['description']) ?></p>
                                        <?php endif; ?>
                                        <div class="btn-wrapper  padding-top-35 padding-bottom-50">
                                            <?php if ($item['btn_status'] == 'yes'): ?>
                                                <a href="<?php echo esc_url($item['btn_link']['url']) ?>"
                                                   class="boxed-btn btn-sanatory style-01"><?php Icons_Manager::render_icon($item['btn-icon'], ['aria-hidden' => 'true']); ?><?php echo esc_html($item['btn_text']) ?></a>
                                            <?php endif; ?>
                                            <?php if ($item['btn_status_video'] == 'yes'): ?>
                                                <a class="video-play mfp-iframe"
                                                   href="<?php echo esc_url($item['btn_link_video']['url']) ?>">
                                                    <?php Icons_Manager::render_icon($item['video-icon'], ['aria-hidden' => 'true']); ?>
                                                </a>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                    <!-- //.header inner -->
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
        <?php
    }
}

Plugin::instance()->widgets_manager->register_widget_type(new Senatory_Header_Area_Slider_One_Widget());