<?php
/**
 * Elementor Widget
 * @package Senatory
 * @since 1.0.0
 */

namespace Elementor;
class Senatory_Banner_Area_Two_Widget extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'senatory-banner-two-widget';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Banner Two Section', 'senatory-core');
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'bl_icon eicon-archive-title';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['senatory_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {

        $this->start_controls_section(
            'settings_section',
            [
                'label' => esc_html__('Section Contents', 'senatory-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );



        $this->add_control(
            'bg_image',
            [
                'label' => esc_html__('Section Bcakground Image', 'senatory-core'),
                'type' => Controls_Manager::MEDIA,
                'show_label' => false,
                'description' => esc_html__('Upload background image', 'senatory-core'),
                'default' => [
                    'src' => Utils::get_placeholder_image_src()
                ],
            ]
        );
		
        $this->add_control(
            'banner_image',
            [
                'label' => esc_html__('Banner Image', 'senatory-core'),
                'type' => Controls_Manager::MEDIA,
                'show_label' => false,
                'description' => esc_html__('Upload banner image', 'senatory-core'),
                'default' => [
                    'src' => Utils::get_placeholder_image_src()
                ],
            ]
        );
		
		$this->add_control(
            'logo_image',
            [
                'label' => esc_html__('Logo Image', 'senatory-core'),
                'type' => Controls_Manager::MEDIA,
                'show_label' => false,
                'description' => esc_html__('Upload logo image', 'senatory-core'),
                'default' => [
                    'src' => Utils::get_placeholder_image_src()
                ],
            ]
        );


        $this->add_control(
            'title',
            [
                'label' => esc_html__('Title', 'senatory-core'),
                'type' => Controls_Manager::TEXTAREA,
                'description' => esc_html__('enter title.', 'senatory-core'),
                'default' => esc_html__('Join The Fight for Our Freedom', 'senatory-core')
            ]
        );


        $this->add_control(
            'sub-title',
            [
                'label' => esc_html__('Sub Title', 'senatory-core'),
                'type' => Controls_Manager::TEXTAREA,
                'description' => esc_html__('Enter Sub title.', 'senatory-core'),
                'default' => esc_html__('Our Party Visions', 'senatory-core')
            ]
        );

        $this->add_control(
            'description_status',
            [
                'label' => esc_html__('Description Show/Hide', 'senatory-core'),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'yes',
                'description' => esc_html__('Show/hide description', 'senatory-core')
            ]
        );
		
		$this->add_control(
            'banner-text',
            [
                'label' => esc_html__('Content', 'senatory-core'),
                'type' => Controls_Manager::TEXTAREA,
                'description' => esc_html__('Enter Short Description.', 'senatory-core'),
                'default' => esc_html__('Every pleasures is to welcomed pain avoided owing to the duty.', 'senatory-core'),
				'condition' => ['description_status' => 'yes']
            ]
        );


		$this->add_control(
            'btn_status',
            [
                'label' => esc_html__('Button Show/Hide', 'senatory-core'),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'yes',
                'description' => esc_html__('show/hide button', 'senatory-core')
            ]
        );
		
		
		$this->add_control(
            'btn_text',
            [
                'label' => esc_html__('Button Text', 'senatory-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Discover More', 'senatory-core'),
                'description' => esc_html__('Enter button text', 'senatory-core'),
                'condition' => ['btn_status' => 'yes']
            ]
        );
		
		
		$this->add_control(
            'btn_link',
            [
                'label' => esc_html__('Button URL', 'senatory-core'),
                'type' => Controls_Manager::URL,
                'default' => [
                    'url' => '#'
                ],
                'description' => esc_html__('Enter button url', 'senatory-core'),
                'condition' => ['btn_status' => 'yes']
            ]
        );
		
		$this->add_control(
            'btn-icon',
            [
                'label' => esc_html__('Button Icon', 'senatory-core'),
                'type' => Controls_Manager::ICONS,
                'description' => esc_html__('select btn Icon.', 'senatory-core'),
                'default' => [
                    'value' => 'fas fa-arrow-right',
                    'library' => 'solid',
                ]
            ]
        );
		
		
		$this->add_control(
            'btn_status_video', [
                'label' => esc_html__('Video Button Show/Hide', 'senatory-core'),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'yes',
                'description' => esc_html__('show/hide video button', 'senatory-core')
            ]
        );


        $this->add_control(
            'btn_link_video', [
                'label' => esc_html__('Video Button URL', 'senatory-core'),
                'type' => Controls_Manager::URL,
                'default' => [
                    'url' => '#'
                ],
                'description' => esc_html__('Enter button video url', 'senatory-core'),
                'condition' => ['btn_status_video' => 'yes']
            ]
        );
		
		$this->add_control(
            'video-icon',
            [
                'label' => esc_html__('Video Icon', 'senatory-core'),
                'type' => Controls_Manager::ICONS,
                'description' => esc_html__('select btn Icon.', 'senatory-core'),
                'default' => [
                    'value' => 'fas fa-play',
                    'library' => 'solid',
                ]
            ]
        );
		
		$this->add_control(
            'btn_video_text',
            [
                'label' => esc_html__('Video Button Text', 'senatory-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Presentation', 'senatory-core'),
                'description' => esc_html__('Enter video button text', 'senatory-core'),
            ]
        );


        $this->end_controls_section();

		
	    $this->start_controls_section(
            'css_styles',
            [
                'label' => esc_html__('Styling Settings', 'senatory-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control('slider_title_color', [
            'label' => esc_html__('Slider Title Color', 'senatory-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .theme-banner-two-area.header-area.header-sanatory .header-inner .title.style-01" => "color: {{VALUE}}"
            ]
        ]);


        $this->add_control('slider_subtitle_color', [
            'label' => esc_html__('Slider Sub Title Color', 'senatory-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .theme-banner-two-area.header-area .subtitle.style-01" => "color: {{VALUE}}"
            ]
        ]);

		$this->add_control('slider_des_color', [
            'label' => esc_html__('Slider Description Text Color', 'senatory-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .theme-banner-two-area.header-area.header-sanatory .header-inner p.style-01" => "color: {{VALUE}}"
            ]
        ]);
	

        $this->end_controls_section();
		

        /* button styling */
		
        $this->start_controls_section('header_button_section', [
            'label' => esc_html__('Button Settings', 'senatory-core'),
            'tab' => Controls_Manager::TAB_STYLE
        ]);

        $this->start_controls_tabs('button_styling');

        $this->start_controls_tab('normal_style', [
            'label' => esc_html__('Button Normal', "senatory-core")
        ]);

        $this->add_control('button_normal_color', [
            'label' => esc_html__('Button Color', 'senatory-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .theme-banner-two-area .btn-wrapper .boxed-btn.btn-sanatory.style-01" => "color: {{VALUE}}"
            ]
        ]);

        $this->add_control('divider_01', [
            'type' => Controls_Manager::DIVIDER
        ]);
		
		$this->add_control('button_background', [
            'label' => esc_html__('Button Background', 'senatory-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .theme-banner-two-area .btn-wrapper .boxed-btn.btn-sanatory.style-01" => "background-color: {{VALUE}}"
            ]
        ]);

        $this->add_control('divider_02', [
            'type' => Controls_Manager::DIVIDER
        ]);

        $this->add_group_control(Group_Control_Border::get_type(), [
            'name' => 'slide_button_border',
            'label' => esc_html__('Border', 'senatory-core'),
            'selector' => "{{WRAPPER}} .theme-banner-two-area .btn-wrapper .boxed-btn.btn-sanatory.style-01",
        ]);
		

        $this->end_controls_tab();

        $this->start_controls_tab('hover_style', [
            'label' => esc_html__('Button Hover', "senatory-core")
        ]);
		
        $this->add_control('button_hover_normal_color', [
            'label' => esc_html__('Button Hover Color', 'senatory-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .theme-banner-two-area .btn-wrapper .boxed-btn.btn-sanatory.style-01:hover" => "color: {{VALUE}}"
            ]
        ]);
		
        $this->add_control('divider_03', [
            'type' => Controls_Manager::DIVIDER
        ]);
		
		$this->add_control('button_hover_background', [
            'label' => esc_html__('Button Hover Background', 'senatory-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .theme-banner-two-area .btn-wrapper .boxed-btn.btn-sanatory.style-01:hover" => "background-color: {{VALUE}}"
            ]
        ]);
		
		
        $this->add_control('divider_04', [
            'type' => Controls_Manager::DIVIDER
        ]);
		
 
	    $this->add_group_control(Group_Control_Border::get_type(), [
            'name' => 'slide_button_border_hover',
            'label' => esc_html__('Border', 'senatory-core'),
            'selector' => "{{WRAPPER}} .theme-banner-two-area .btn-wrapper .boxed-btn.btn-sanatory.style-01:hover",
        ]);
 
		
        $this->end_controls_tab();
        $this->end_controls_tabs();
		
        $this->add_control('divider_05', [
            'type' => Controls_Manager::DIVIDER
        ]);
		
        $this->add_control(
            'button_border_radius',
            [
                'label' => esc_html__('Border Radius', 'senatory-core'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .theme-banner-two-area .btn-wrapper .boxed-btn.btn-sanatory.style-01' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
		
		$this->add_responsive_control('padding', [
            'label' => esc_html__('Button Padding', 'senatory-core'),
            'type' => Controls_Manager::DIMENSIONS,
            'size_units' => ['px', 'em'],
            'allowed_dimensions' => ['top', 'bottom', 'left', 'right'],
            'selectors' => [
                '{{WRAPPER}} .theme-banner-two-area .btn-wrapper .boxed-btn.btn-sanatory.style-01' => 'padding-top: {{TOP}}{{UNIT}};padding-bottom: {{BOTTOM}}{{UNIT}};padding-left: {{LEFT}}{{UNIT}}; padding-right: {{RIGHT}}{{UNIT}};'
            ],
            'description' => esc_html__('Set button padding', 'senatory-core')
        ]);
		
		
        $this->end_controls_section();
        /* button styling end */

        /* typography settings start */
        $this->start_controls_section('typography_settings', [
            'label' => esc_html__('Typography Settings', 'senatory-core'),
            'tab' => Controls_Manager::TAB_STYLE
        ]);
		
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'name' => 'title_typography',
            'label' => esc_html__('Title Typography', 'senatory-core'),
            'selector' => "{{WRAPPER}} .theme-banner-two-area.header-area.header-sanatory .header-inner .title.style-01"
        ]);
		
		
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'name' => 'subtitle_typography',
            'label' => esc_html__('Sub Title Typography', 'senatory-core'),
            'selector' => "{{WRAPPER}} .theme-banner-two-area.header-area .subtitle.style-01"
        ]);
		
		$this->add_group_control(Group_Control_Typography::get_type(), [
            'name' => 'des_typography',
            'label' => esc_html__('Description Typography', 'senatory-core'),
            'selector' => "{{WRAPPER}} .theme-banner-two-area.header-area.header-sanatory .header-inner p.style-01"
        ]);
		
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'name' => 'button_typography',
            'label' => esc_html__('Button Typography', 'senatory-core'),
            'selector' => "{{WRAPPER}} .theme-banner-two-area .btn-wrapper .boxed-btn.btn-sanatory.style-01"
        ]);
		
		
        $this->end_controls_section();
        /* typography settings end */
		
		





    }

    /**
     * Render Elementor widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();

        ?>
		
	<div class="theme-banner-two-area header-area header-sanatory header-bg-03" style="background-image:url(<?php echo esc_url($settings['bg_image']['url']); ?>);">
        <div class="senatory-bg-img-02" style="background-image: url(<?php echo esc_url($settings['banner_image']['url']); ?>);"></div>
        <img src="<?php echo esc_url($settings['logo_image']['url']); ?>" class="senatory-banner" alt="">
        <span class="dot"></span>
        <span class="dot-02"></span>
        <span class="dot-03"></span>
        <span class="dot-04"></span>
        <span class="dot-05"></span>
        <span class="dot-06"></span>
        <span class="dot-07"></span>
        <span class="dot-08"></span>
        <span class="dot-09"></span>
        <div class="container nav-container home-three custom-container">
            <div class="row">
                <div class="col-lg-12">
                  <div class="header-inner">
                    <!-- header inner -->
                    <div class="subtitle style-01">
                        <span><?php echo esc_html($settings['sub-title']) ?></span>
                    </div>
                    <h1 class="title style-01"><?php echo esc_html($settings['title']) ?></h1>
					
					<?php if ($settings['description_status'] == 'yes'): ?>
                    <p class="style-01"><?php echo esc_html($settings['banner-text']) ?></p>
					<?php endif; ?>
					 
                    <div class="btn-wrapper desktop-center">
					
						<?php if ($settings['btn_status'] == 'yes'): ?>
                        <a href="<?php echo esc_url($settings['btn_link']['url']) ?>" class="boxed-btn btn-sanatory style-01 text-uppercase"><?php echo esc_html($settings['btn_text']) ?><?php Icons_Manager::render_icon($settings['btn-icon'], ['aria-hidden' => 'true']); ?></a>
						<?php endif; ?>
						
						<?php if ($settings['btn_status_video'] == 'yes'): ?>
                        <a class="video-play style-04 mfp-iframe" href="<?php echo esc_url($settings['btn_link_video']['url']) ?>">
                          <?php Icons_Manager::render_icon($settings['video-icon'], ['aria-hidden' => 'true']); ?> <span><?php echo esc_html($settings['btn_video_text']) ?></span>
                        </a>
						<?php endif; ?>
						
                    </div>
                  </div>
                    <!-- //.header inner -->
                </div>
            </div>
        </div>
    </div>
    <!-- Header section End -->
	
	

        <?php
    }
}

Plugin::instance()->widgets_manager->register_widget_type(new Senatory_Banner_Area_Two_Widget());