<?php
/**
 * Elementor Widget
 * @package Senatory
 * @since 1.0.0
 */

namespace Elementor;
class Senatory_Events_Icon_Box_Widget extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'senatory-eventts-iconbox-widget';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Event Info Boxx', 'senatory-master');
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'bl_icon eicon-archive-title';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['senatory_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {

        $this->start_controls_section(
            'settings_section',
            [
                'label' => esc_html__('Event Info Box', 'senatory-master'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );




        $this->add_control(
            'title',
            [
                'label' => esc_html__('Title', 'senatory-core'),
                'type' => Controls_Manager::TEXT,
                'description' => esc_html__('enter title.', 'senatory-core'),
                'default' => esc_html__('Human Rights', 'senatory-core')
            ]
        );
		
		$this->add_control(
            'description',
            [
                'label' => esc_html__('Content Box', 'senatory-core'),
                'type' => Controls_Manager::TEXTAREA,
                'description' => esc_html__('enter title.', 'senatory-core'),
                'default' => esc_html__('California', 'senatory-core')
            ]
        );


        $this->add_control(
            'box-icon',
            [
                'label' => esc_html__('Icon', 'senatory-master'),
                'type' => Controls_Manager::ICONS,
                'description' => esc_html__('Select Icon', 'senatory-master'),
                'default' => [
                    'value' => 'icon-tips-bulb',
                    'library' => 'solid',
                ]
            ]
        );

		
		$this->add_control(
            'shape_image',
            [
                'label' => esc_html__('Box Background Shape Image', 'senatory-core'),
                'type' => Controls_Manager::MEDIA,
                'show_label' => false,
                'description' => esc_html__('Upload bg image', 'senatory-core'),
                'default' => [
                    'src' => Utils::get_placeholder_image_src()
                ],
            ]
        );
		
		
		$this->end_controls_section();
		
		
		
        $this->start_controls_section(
            'css_styles',
            [
                'label' => esc_html__('Styling Settings', 'senatory-master'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        
        $this->add_control('background_color', [
            'label' => esc_html__('Background Color', 'senatory-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .campaign-single-items-02" => "background: {{VALUE}}"
            ]
        ]);
		

        $this->add_control('title_color', [
            'label' => esc_html__('Title Color', 'senatory-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .campaign-single-items-02 .content .title-wrapper .title h5" => "color: {{VALUE}}"
            ]
        ]);
		
		
        $this->add_control('title_styling_divider', [
            'type' => Controls_Manager::DIVIDER
        ]);
		
        $this->add_control('description_color', [
            'label' => esc_html__('Description Color', 'senatory-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .campaign-single-items-02 .content p" => "color: {{VALUE}}"
            ]
        ]);
		
		$this->add_control('icon_styling_divider', [
            'type' => Controls_Manager::DIVIDER
        ]);
		
		$this->add_control('iconn_color', [
            'label' => esc_html__('Icon Color', 'senatory-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .campaign-single-items-02 .icon" => "color: {{VALUE}}"
            ]
        ]);

		$this->add_control('iconn_bg_color', [
            'label' => esc_html__('Icon Background Color', 'senatory-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .campaign-single-items-02 .icon" => " background: {{VALUE}}"
            ]
        ]);

		$this->add_control('dash_bg_color', [
            'label' => esc_html__('Dash Background Color', 'senatory-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .campaign-single-items-02 .content .title-wrapper .line .dot" => "background: {{VALUE}}"
            ]
        ]);

        $this->add_group_control(Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'box_shadow',
				'label' => esc_html__( 'Box Shadow', 'senatory-core' ),
				'selector' => '{{WRAPPER}} .campaign-single-items-02',
			]
		);
        
		$this->add_control('box_bottom', [
            'label' => esc_html__( 'Box Bottom background', 'senatory-core' ),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .campaign-single-items-02::after" => "background: {{VALUE}}"
            ]
        ]);
		
        $this->add_control(
			'item_bdr_radius',
			[
				'label' => esc_html__( 'Border Radius', 'senatory-core' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 5,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 0,
				],
				'selectors' => [
					'{{WRAPPER}} .theme-event-info-box.campaign-single-items-02' => 'border-radius: {{SIZE}}{{UNIT}};',
				],
			]
		);
        $this->end_controls_section();
		

        /* typography settings start */
        $this->start_controls_section('typography_settings', [
            'label' => esc_html__('Typography Settings', 'senatory-master'),
            'tab' => Controls_Manager::TAB_STYLE
        ]);
		
				
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'label' => esc_html__('Title Typography', 'senatory-core'),
            'name' => 'title_typography',
            'description' => esc_html__('select title typography', 'senatory-core'),
            'selector' => "{{WRAPPER}} .campaign-single-items-02 .content .title-wrapper .title h5"
        ]);
		
		
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'label' => esc_html__('Description Typography', 'senatory-core'),
            'name' => 'description_typography',
            'description' => esc_html__('select description typography', 'senatory-core'),
            'selector' => "{{WRAPPER}} .campaign-single-items-02 .content p"
        ]);
		
		
        $this->end_controls_section();
        /* typography settings end */

    }

    /**
     * Render Elementor widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();

        ?>
		

		<div class="theme-event-info-box campaign-single-items-02 wow animate__animated animate__fadeInLeft">
			<div class="icon">
				<?php
				Icons_Manager::render_icon($settings['box-icon'], ['aria-hidden' => 'true']);
				?>
			</div>
			<div class="content">
				<div class="title-wrapper">
					<div class="title">
					  <h5><?php echo esc_html($settings['title']) ?></h5>
					</div>
					<div class="line">
					  <span class="dot"></span>
					  <span class="dot"></span>
					  <span class="dot style-02"></span>
					  <span class="dot"></span>
					  <span class="dot"></span>
					</div>
				</div>
				<p><?php echo wp_kses_post( $settings['description'] ); ?></p>
			</div>
			
			<img src="<?php echo esc_url($settings['shape_image']['url']); ?>" class="shape" alt="" />
			
			
		</div>
		  


        <?php
    }
}

Plugin::instance()->widgets_manager->register_widget_type(new Senatory_Events_Icon_Box_Widget());