<?php
/**
 * Elementor Widget
 * @package Senatory
 * @since 1.0.0
 */

namespace Elementor;
class Senatory_Service_Icon_Box_Two_Widget extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'senatory-iconbox-service-two-widget';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Services Info Box : 02', 'senatory-master');
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'bl_icon eicon-archive-title';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['senatory_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {

        $this->start_controls_section(
            'settings_section',
            [
                'label' => esc_html__('Event Info Box', 'senatory-master'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
    
        $this->add_control(
            'title',
            [
                'label' => esc_html__('Title', 'senatory-core'),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'description' => esc_html__('Enter title.', 'senatory-core'),
                'default' => esc_html__('School & University', 'senatory-core')
            ]
        );
		
		$this->add_control(
            'description',
            [
                'label' => esc_html__('Content Box', 'senatory-core'),
                'type' => Controls_Manager::TEXTAREA,
                'description' => esc_html__('Enter Description.', 'senatory-core'),
                'default' => esc_html__('Efficiently orchestrate resource sucking human capital whereas future-proof outsourcing.', 'senatory-core')
            ]
        );

		
        $this->add_control(
            'icon_selector',
            [
                'label' => esc_html__('Icon Selector', 'foodfly-core'),
                'type' => Controls_Manager::SELECT,
                'default' => 'icon',
                'options' => [
                    'image' => esc_html__('Image', 'foodfly-core'),
                    'icon' => esc_html__('Icon', 'foodfly-core'),
                ],

            ]
        );
        $this->add_control(
            'box_icon',
            [
                'label' => esc_html__('Icon', 'senatory-master'),
                'type' => Controls_Manager::ICONS,
                'description' => esc_html__('Select Icon', 'senatory-master'),
				'default' => [
					'value' => 'far fa-heart',
					'library' => 'fa-solid',
				],
                'condition' => ['icon_selector' => 'icon']
            ]
        );
		$this->add_control(
            'icon_image',
            [
                'label' => esc_html__('Box Background Shape Image', 'senatory-core'),
                'type' => Controls_Manager::MEDIA,
                'show_label' => false,
                'description' => esc_html__('Upload bg image', 'senatory-core'),
                'default' => [
                    'src' => Utils::get_placeholder_image_src()
                ],
                'condition' => ['icon_selector' => 'image']
            ]
        );


		$this->add_control(
            'btn_text', [
                'label' => esc_html__('Button Text', 'senatory-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Read More', 'senatory-core'),
                'description' => esc_html__('Enter button text', 'senatory-core'),
            ]
        );
        $this->add_control(
            'button-icon',
            [
                'label' => esc_html__('Button Icon', 'senatory-master'),
                'type' => Controls_Manager::ICONS,
                'description' => esc_html__('Select Button Icon', 'senatory-master'),
                'default' => [
					'value' => 'fas fa-arrow-right',
					'library' => 'fa-solid',
				],
            ]
        );
        $this->add_control(
            'btn_link', [
                'label' => esc_html__('Button URL', 'senatory-core'),
                'type' => Controls_Manager::URL,
                'default' => [
                    'url' => '#'
                ],
                'description' => esc_html__('Enter button url', 'senatory-core'),
            ]
        );
        $this->add_control(
            'alignment',
            [
                'label' => esc_html__('Alignment', 'senatory-core'),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => esc_html__('Left', 'senatory-core'),
                        'icon' => 'fa fa-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__('Center', 'senatory-core'),
                        'icon' => 'fa fa-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__('Right', 'senatory-core'),
                        'icon' => 'fa fa-align-right',
                    ],
                ],
                'default' => 'center',
                'toggle' => true,
                'selectors' => [
                    "{{WRAPPER}} .services-single-item-02" => "text-align: {{VALUE}}"
                ]
            ]
        );
		
		
		$this->end_controls_section();
		
		
		
        $this->start_controls_section(
            'css_styles',
            [
                'label' => esc_html__('Styling Settings', 'senatory-master'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->start_controls_tabs('button_styling');
        
        $this->start_controls_tab('normal_style', [
            'label' => esc_html__('Normal', "senatory-core")
        ]);
        $this->add_control('title_color', [
            'label' => esc_html__('Title Color', 'senatory-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .services-single-item-02 .content .title" => "color: {{VALUE}}"
            ]
        ]);
		
		
        $this->add_control('title_styling_divider', [
            'type' => Controls_Manager::DIVIDER
        ]);
		
        $this->add_control('description_color', [
            'label' => esc_html__('Description Color', 'senatory-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .services-single-item-02 .content .description" => "color: {{VALUE}}"
            ]
        ]);
		
		$this->add_control('icon_styling_divider', [
            'type' => Controls_Manager::DIVIDER
        ]);
		
		$this->add_control('iconn_color', [
            'label' => esc_html__('Icon Color', 'senatory-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .services-single-item-02 .icon" => "color: {{VALUE}}"
            ]
        ]);

        $this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'icon_bg_color',
				'label' => esc_html__( 'Icon Background', 'senatory-core' ),
				'types' => [ 'classic', 'gradient', 'video' ],
				'selector' => '{{WRAPPER}} .services-single-item-02 .icon',
                'default'   => '#D5D5E6'
			]
		);
		$this->add_control('btn_icon_color', [
            'label' => esc_html__('Button Icon Color', 'senatory-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .services-single-item-02 .btn-wrapper .boxed-btn.event-btn i" => "color: {{VALUE}}"
            ]
        ]);
        		
        $this->add_control('item_styling_divider', [
            'type' => Controls_Manager::DIVIDER
        ]);
		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'item_border',
				'label' => esc_html__( 'Border', 'senatory-core' ),
				'selector' => '{{WRAPPER}} .services-single-section .services-single-item-02',
			]
		);
        $this->end_controls_tab();

        // Hover 
                
        $this->start_controls_tab('hover_style', [
            'label' => esc_html__('Hover', "senatory-core")
        ]);
        $this->add_control('title_hover_color', [
            'label' => esc_html__('Title Color', 'senatory-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .services-single-item-02 .content .title" => "color: {{VALUE}}"
            ]
        ]);
		
		
        $this->add_control('title_styling_divider', [
            'type' => Controls_Manager::DIVIDER
        ]);
		
        $this->add_control('description_hover_color', [
            'label' => esc_html__('Description Color', 'senatory-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .services-single-item-02 .content .description:hover" => "color: {{VALUE}}"
            ]
        ]);
		
		$this->add_control('icon_styling_divider', [
            'type' => Controls_Manager::DIVIDER
        ]);
		
		$this->add_control('icon_hover_color', [
            'label' => esc_html__('Icon Color', 'senatory-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .services-single-item-02:hover .icon" => "color: {{VALUE}}"
            ]
        ]);

        $this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'icon_hover_bg',
				'label' => esc_html__( 'Icon Hover Background', 'senatory-core' ),
				'types' => [ 'classic', 'gradient', 'video' ],
				'selector' => '{{WRAPPER}} .services-single-item-02:hover .icon',
                'default'   => '#D5D5E6'
			]
		);
		$this->add_control('btn_hover_icon_color', [
            'label' => esc_html__('Button Icon Color', 'senatory-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .services-single-item-02 .btn-wrapper .boxed-btn.event-btn:hover i" => "color: {{VALUE}}"
            ]
        ]);

        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();
		

        /* typography settings start */
        $this->start_controls_section('typography_settings', [
            'label' => esc_html__('Typography Settings', 'senatory-master'),
            'tab' => Controls_Manager::TAB_STYLE
        ]);
		
				
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'label' => esc_html__('Title Typography', 'senatory-core'),
            'name' => 'title_typography',
            'description' => esc_html__('select title typography', 'senatory-core'),
            'selector' => "{{WRAPPER}} .services-single-item-02 .content .title"
        ]);
		
		
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'label' => esc_html__('Description Typography', 'senatory-core'),
            'name' => 'description_typography',
            'description' => esc_html__('select description typography', 'senatory-core'),
            'selector' => "{{WRAPPER}} .services-single-item-02 .content .description"
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'label' => esc_html__('Icon Typography', 'senatory-core'),
            'name' => 'icon_typography',
            'description' => esc_html__('select description typography', 'senatory-core'),
            'selector' => "{{WRAPPER}} .services-single-item-02 .icon"
        ]);
		
		
        $this->end_controls_section();
        /* typography settings end */

    }

    /**
     * Render Elementor widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();

        ?>
		

  <!-- Service Single Items Start Here -->
  <div class="services-single-section style-01">
      <div class="container">
          <div class="row">
              <div class="service-single-items-wrapper">



                          <div class="services-single-item-02">
                                <div class="icon_wrapper">
                                    <div class="icon">
                                        <?php if($settings['icon_image']['url']): ?>
                                            <img src="<?php echo esc_url($settings['icon_image']['url']); ?>" class="style-01" alt="<?php echo esc_attr(['icon_image']['alt']); ?>">
                                        <?php endif; ?>

                                        <?php if($settings['box_icon']):
                                            Icons_Manager::render_icon($settings['box_icon'], ['aria-hidden' => 'true']);
                                        endif; ?>
                                    </div>
                                </div>
                              <div class="content">
                              <h4 class="title"><a href="<?php echo esc_url($settings['btn_link']['url']) ?>"><?php echo esc_html($settings['title']) ?></a></h4>
                              <p class="description"><?php echo wp_kses_post( $settings['description'] ); ?></p>
                              </div>
                              <div class="btn-wrapper desktop-center">
                              <a href="<?php echo esc_url($settings['btn_link']['url']) ?>" class="boxed-btn event-btn">
                                <?php if($settings['button-icon']):
                                        Icons_Manager::render_icon($settings['button-icon'], ['aria-hidden' => 'true']);
                                    endif; ?>
                                </a>
                              </div>
                          </div>

              </div>
          </div>
      </div>
  </div>
  <!-- Service Single Items End Here -->

			  
			  

        <?php
    }
}

Plugin::instance()->widgets_manager->register_widget_type(new Senatory_Service_Icon_Box_Two_Widget());