<?php
/**
 * Elementor Widget
 * @package Senatory
 * @since 1.0.0
 */

namespace Elementor;
class Senatory_Img_Box_Widget extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'senatory-imgbox-widget';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Image Box Quote', 'senatory-core');
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'bl_icon eicon-archive-title';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['senatory_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {

        $this->start_controls_section(
            'settings_section',
            [
                'label' => esc_html__('Section Contents', 'senatory-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );



        $this->add_control(
            'box_image',
            [
                'label' => esc_html__('Box Image', 'senatory-core'),
                'type' => Controls_Manager::MEDIA,
                'show_label' => false,
                'description' => esc_html__('Upload box image', 'senatory-core'),
                'default' => [
                    'src' => Utils::get_placeholder_image_src()
                ],
            ]
        );
		

        $this->add_control(
            'title',
            [
                'label' => esc_html__('Title', 'senatory-core'),
                'type' => Controls_Manager::TEXTAREA,
                'description' => esc_html__('enter title.', 'senatory-core'),
                'default' => esc_html__('Successfully Providing the Best Solution from 20 years', 'senatory-core')
            ]
        );



        $this->end_controls_section();

		
	    $this->start_controls_section(
            'css_styles',
            [
                'label' => esc_html__('Styling Settings', 'senatory-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control('slider_title_color', [
            'label' => esc_html__('Slider Title Color', 'senatory-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .custom-meet-box-img .meet-member-img .member-quotes .title" => "color: {{VALUE}}"
            ]
        ]);


        $this->end_controls_section();
		

        /* typography settings start */
        $this->start_controls_section('typography_settings', [
            'label' => esc_html__('Typography Settings', 'senatory-core'),
            'tab' => Controls_Manager::TAB_STYLE
        ]);
		
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'name' => 'title_typography',
            'label' => esc_html__('Title Typography', 'senatory-core'),
            'selector' => "{{WRAPPER}} .custom-meet-box-img .meet-member-img .member-quotes .title"
        ]);
		
		

        $this->end_controls_section();
        /* typography settings end */



    }

    /**
     * Render Elementor widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();

        ?>
	
	<div class="custom-meet-box-img">
	
		<div class="meet-member-img" style="background-image: url(<?php echo esc_url($settings['box_image']['url']); ?>);">
			<div class="member-quotes">
				<h5 class="title"><?php echo esc_html($settings['title']) ?></h5>
				<div class="icon">
                    <img src="<?php echo SENATORY_CORE_IMG.'/quotes-02.svg';?>" alt="">
				</div>
			</div>
		</div>
	
	</div>
					
					
	

        <?php
    }
}

Plugin::instance()->widgets_manager->register_widget_type(new Senatory_Img_Box_Widget());