<?php
/**
 * Elementor Widget
 * @package Senatory
 * @since 1.0.0
 */

namespace Elementor;
class Senatory_newsletter_widget extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'senatory-newsletter-widget';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Newsletter Section', 'senatory-master');
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'bl_icon eicon-archive-title';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['senatory_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {

        $this->start_controls_section(
            'settings_section',
            [
                'label' => esc_html__('Section Contents', 'senatory-master'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

    $this->add_control(
            'banner_newsletter',
            [
                'label' => esc_html__('Background Image', 'senatory-core'),
                'type' => Controls_Manager::MEDIA,
                'show_label' => false,
                'description' => esc_html__('Upload background image', 'senatory-master'),
                'default' => [
                    'src' => Utils::get_placeholder_image_src()
                ],
            ]
        );

      $this->add_control(
            'title',
            [
                'label' => __('Title', 'senatory-master'),
                'type' => Controls_Manager::TEXT,
                'default' => __('Join Our Newsletter', 'senatory-master'),
            ]
        );


       $this->add_control(
            'form',
            [
                'label' => __( 'Form Shortcode here', 'senatory-master' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,

            ]
        );


        $this->end_controls_section();

    }

    /**
     * Render Elementor widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();
		
        ?>
      <div class="footer-widget widget widget_subscribe subscribe-bg"
        style="background-image: url(<?php echo esc_url($settings['banner_newsletter']['url']); ?>);">
        <div class="shape-01"></div>
        <div class="shape-02"></div>
        <div class="header-content">
          <h4 class="title"><?php echo esc_html($settings['title']); ?></h4>
        </div>
       <?php echo do_shortcode($settings['form']); ?>
      </div>

        <?php
    }
}

Plugin::instance()->widgets_manager->register_widget_type(new Senatory_newsletter_widget());