<?php
/**
 * Elementor Widget
 * @package Senatory
 * @since 1.0.0
 */

namespace Elementor;
class Senatory_Journey_Slider_Widget extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'senatory-journey-slider';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Journey Slider', 'senatory-master');
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'bl_icon eicon-archive-title';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['senatory_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {

        $this->start_controls_section(
            'settings_section',
            [
                'label' => esc_html__('Section Contents', 'senatory-master'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $repeater = new \Elementor\Repeater();


        $repeater->add_control(
            'banner_image', [
                'label' => esc_html__('Slide Banner Image', 'senatory-core'),
                'type' => Controls_Manager::MEDIA,
                'show_label' => false,
                'description' => esc_html__('Upload banner image', 'senatory-core'),
                'default' => [
                    'src' => Utils::get_placeholder_image_src()
                ],
            ]
        );

        $repeater->add_control(
            'title', [
                'label' => esc_html__('Title', 'senatory-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('Together we can make Better country', 'senatory-core'),
                'description' => esc_html__('Enter title', 'senatory-core')
            ]
        );

        $repeater->add_control(
            'year', [
                'label' => esc_html__('Year', 'senatory-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('2005', 'senatory-core'),
                'description' => esc_html__('Enter Year', 'senatory-core')
            ]
        );


        $repeater->add_control(
            'description', [
                'label' => esc_html__('Slide Description', 'senatory-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('President represented Delaware for 36 years in the US', 'senatory-core'),
                'description' => esc_html__('enter description', 'senatory-core'),
            ]
        );


        $this->add_control('testimonails_sliders', [
            'label' => esc_html__('Slider Items', 'senatory-master'),
            'type' => Controls_Manager::REPEATER,
            'fields' => $repeater->get_controls(),

            'default' => [
                [

                    'description' => esc_html__('President represented Delaware for 36 years in the US', 'senatory-master'),
                    'title' => esc_html__('Together we can make Better country', 'senatory-master'),
                ]
            ],

        ]);


        $this->end_controls_section();


        $this->start_controls_section(
            'slider_settings_section',
            [
                'label' => esc_html__('Slider Settings', 'senatory-master'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'items',
            [
                'label' => esc_html__('Items', 'senatory-master'),
                'type' => Controls_Manager::TEXT,
                'description' => esc_html__('you can set how many item show in slider', 'senatory-master'),
                'default' => '1'
            ]
        );


        $this->add_control(
            'center',
            [
                'label' => esc_html__('Center', 'senatory-core'),
                'type' => Controls_Manager::SWITCHER,
                'description' => esc_html__('you can set yes/no to enable/disable', 'senatory-core'),

            ]
        );

        $this->add_control(
            'margin',
            [
                'label' => esc_html__('Margin', 'senatory-master'),
                'description' => esc_html__('you can set margin for slider', 'senatory-master'),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                        'step' => 5,
                    ]
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 0,
                ],

                'size_units' => ['px'],
                'condition' => array(
                    'autoplay' => 'yes'
                )
            ]
        );

        $this->add_control(
            'loop',
            [
                'label' => esc_html__('Loop', 'senatory-master'),
                'type' => Controls_Manager::SWITCHER,
                'description' => esc_html__('you can set yes/no to enable/disable', 'senatory-master'),
                'default' => 'yes'
            ]
        );

        $this->add_control(
            'nav',
            [
                'label' => esc_html__('Nav', 'senatory-master'),
                'type' => Controls_Manager::SWITCHER,
                'description' => esc_html__('you can set yes/no to enable/disable', 'senatory-master'),
                'default' => 'no'
            ]
        );

        $this->add_control(
            'nav_right_arrow',
            [
                'label' => esc_html__('Nav Right Icon', 'senatory-master'),
                'type' => Controls_Manager::ICONS,
                'description' => esc_html__('you can set yes/no to enable/disable', 'senatory-master'),
                'default' => [
                    'value' => 'fas fa-angle-right',
                    'library' => 'solid',
                ],
            ]
        );

        $this->add_control(
            'nav_left_arrow',
            [
                'label' => esc_html__('Nav Left Icon', 'senatory-master'),
                'type' => Controls_Manager::ICONS,
                'description' => esc_html__('you can set yes/no to enable/disable', 'senatory-master'),
                'default' => [
                    'value' => 'fas fa-angle-left',
                    'library' => 'solid',
                ],
            ]
        );

        $this->add_control(
            'autoplay',
            [
                'label' => esc_html__('Autoplay', 'senatory-master'),
                'type' => Controls_Manager::SWITCHER,
                'description' => esc_html__('you can set yes/no to enable/disable', 'senatory-master'),
                'default' => 'yes'
            ]
        );

        $this->add_control(
            'autoplaytimeout',
            [
                'label' => esc_html__('Autoplay Timeout', 'senatory-master'),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 10000,
                        'step' => 2,
                    ]
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 5000,
                ],
                'size_units' => ['px'],
                'condition' => array(
                    'autoplay' => 'yes'
                )
            ]

        );

        $this->end_controls_section();

        $this->start_controls_section(
            'css_styles',
            [
                'label' => esc_html__('Styling Settings', 'senatory-master'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control('slider_title_color', [
            'label' => esc_html__('Slider Title Color', 'senatory-master'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .header-area .title" => "color: {{VALUE}}"
            ]
        ]);

        $this->add_control('slider_subtitle_bg_color', [
            'label' => esc_html__('Slider Sub Title Background Color', 'senatory-master'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .header-area .header-inner .subtitle" => "background-color: {{VALUE}}"
            ]
        ]);

        $this->add_control('slider_subtitle_color', [
            'label' => esc_html__('Slider Sub Title Color', 'senatory-master'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .header-area .header-inner .subtitle" => "color: {{VALUE}}"
            ]
        ]);

        $this->add_responsive_control('padding', [
            'label' => esc_html__('Padding', 'senatory-master'),
            'type' => Controls_Manager::DIMENSIONS,
            'size_units' => ['px', 'em'],
            'allowed_dimensions' => ['top', 'bottom'],
            'selectors' => [
                '{{WRAPPER}} .header-area' => 'padding-top: {{TOP}}{{UNIT}};padding-bottom: {{BOTTOM}}{{UNIT}};'
            ],
            'description' => esc_html__('set padding for header area ', 'senatory-master')
        ]);

        $this->add_control('overlay_color', [
            'label' => esc_html__('Overlay Color', 'senatory-master'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .header-area.header-bg::before' => 'background-color:{{VALUE}};'
            ],
        ]);

        $this->end_controls_section();

        /* typography settings start */
        $this->start_controls_section('typography_settings', [
            'label' => esc_html__('Typography Settings', 'senatory-master'),
            'tab' => Controls_Manager::TAB_STYLE
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'name' => 'title_typography',
            'label' => esc_html__('Title Typography', 'senatory-master'),
            'selector' => "{{WRAPPER}} .header-area .title"
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'name' => 'subtitle_typography',
            'label' => esc_html__('Sub Title Typography', 'senatory-master'),
            'selector' => "{{WRAPPER}} .header-area .header-inner .subtitle"
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'name' => 'button_typography',
            'label' => esc_html__('Button Typography', 'senatory-master'),
            'selector' => "{{WRAPPER}} .header-area .header-bottom .btn-wrapper .boxed-btn"
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'name' => 'info_button_typography',
            'label' => esc_html__('Info Text Typography', 'senatory-master'),
            'selector' => "{{WRAPPER}} .header-area .header-buttom-content p"
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'name' => 'info_number_button_typography',
            'label' => esc_html__('Info number Typography', 'senatory-master'),
            'selector' => "{{WRAPPER}} .header-area .header-buttom-content span"
        ]);
        $this->end_controls_section();
        /* typography settings end */

    }

    /**
     * Render Elementor widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $all_header_items = $settings['testimonails_sliders'];
        $rand_numb = rand(333, 999999999);


        //slider settings
        $loop = $settings['loop'] ?? 'false';
        $center = $settings['center'] ? 'true' : 'false';
        $items = $settings['items'] ? $settings['items'] : 1;
        $autoplay = $settings['autoplay'] ? 'true' : 'false';
        $autoplaytimeout = $settings['autoplaytimeout']['size'] ?? '';
        $slider_settings = [
            "loop" => esc_attr($settings['loop']),
            "margin" => esc_attr($settings['margin']['size'] ?? 0),
            "items" => esc_attr($settings['items'] ?? 1),
            "center" => esc_attr($settings['center']),
            "autoplay" => esc_attr($settings['autoplay']),
            "autoplaytimeout" => esc_attr($settings['autoplaytimeout']['size'] ?? 0),
        ]


        ?>


        <!-- Jour Journey Section Start Her -->
        <div class="our-journey-section">
            <div class="container custom-container">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="history-slider">
                            <img src="<?php echo SENATORY_CORE_IMG . '/shape-09.png'; ?>" class="history-shape" alt="">
                            <div class="history-slider-one"
                                 id="history-one-carousel-<?php echo esc_attr($rand_numb); ?>"
                                 data-settings='<?php echo json_encode($slider_settings) ?>'>

                                <?php
                                foreach ($all_header_items as $item):
                                    ?>

                                    <div class="thumb">
                                        <div class="journey-bg"
                                             style="background-image: url(<?php echo esc_url($item['banner_image']['url']) ?>);">
                                            <div class="content">
                                                <h4 class="title"><?php echo esc_html($item['title']) ?>
                                                    <span>(<?php echo esc_html($item['year']) ?>)</span></h4>
                                                <p><?php echo esc_html($item['description']) ?></p>
                                            </div>
                                        </div>
                                    </div>
                                <?php endforeach; ?>
                            </div>
                            <div class="slick-slider-controls">
                                <div class="slick-nav"></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Jour Journey Section End Her -->


        <?php
    }
}

Plugin::instance()->widgets_manager->register_widget_type(new Senatory_Journey_Slider_Widget());