<?php
/**
 * Elementor Widget
 * @package Senatory
 * @since 1.0.0
 */

namespace Elementor;
class Senatory_donation_quote_Widget extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'senatory-donation-quote-widget';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Donation Quoate Post', 'senatory-core');
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'bl_icon eicon-archive-title';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['senatory_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {

        $this->start_controls_section(
            'settings_section',
            [
                'label' => esc_html__('Section Contents', 'senatory-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'quoeete',
            [
                'label' => __('Quote Text', 'senatory-core'),
                'type' => Controls_Manager::TEXTAREA,
                'label_block'=>true,
                'default' => __('It’s through mistakes that you actually can grow. You have to get bad in order to get good in daily life.', 'senatory-core'),
            ]
        );

         $this->add_control(
            'quot_autho',
            [
                'label' => __('Quote Author', 'senatory-core'),
                'type' => Controls_Manager::TEXTAREA,
                'label_block'=>true,
                'default' => __('Tanner Garbutt', 'senatory-core'),
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'content_sty',
            [
                'label' => __('Quoate Basic Style', 'senatory-core'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
  
        $this->add_control(
            'title_color',    
            [
                'label' => __('Quoate Text Color', 'senatory-core'),
                'type' => \Elementor\Controls_Manager::COLOR,        
                'selectors' => [
                    '{{WRAPPER}} blockquote:not(.has-light-gray-color):not(.has-very-dark-gray-color):not(.is-style-large):not(.is-style-large) p' => 'color: {{VALUE}}',
                ],
            ]
        );

         $this->add_control(
            'title_ico',    
            [
                'label' => __('Icon Color', 'senatory-core'),
                'type' => \Elementor\Controls_Manager::COLOR,        
                'selectors' => [
                    '{{WRAPPER}} blockquote:not(.has-light-gray-color):not(.has-very-dark-gray-color):not(.is-style-large):not(.is-style-large):before, {{WRAPPER}} blockquote:not(.has-light-gray-color):not(.has-very-dark-gray-color):not(.is-style-large):not(.is-style-large):after' => 'color: {{VALUE}}',
                ],
            ]
        );

          $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 's_typo',
                'label' => __('Quoate Typography', 'senatory-core'),
                'selector' => 'blockquote:not(.has-light-gray-color):not(.has-very-dark-gray-color):not(.is-style-large):not(.is-style-large) p',
            ]
        );

         $this->add_control(
            'hea_quote',
            [
                'label' => esc_html__( 'Quoate Border', 'senatory-core' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

         $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'border',
                'label' => esc_html__( 'Quoate Border', 'senatory-core' ),
                'show_label'=>true,
                'selector' => '{{WRAPPER}} blockquote:not(.has-light-gray-color):not(.has-very-dark-gray-color):not(.is-style-large):not(.is-style-large)',
            ]
        );

        $this->end_controls_section();
    }

    /**
     * Render Elementor widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();
      
        ?>
		<blockquote>
            <p><?php echo esc_html($settings['quoeete']); ?></p>
            <p class="author-name"> - <?php echo esc_html($settings['quot_autho']); ?></p>
         </blockquote>
    
        <?php
    }
}

Plugin::instance()->widgets_manager->register_widget_type(new Senatory_donation_quote_Widget());