<?php
/**
 * Elementor Widget
 * @package Senatory
 * @since 1.0.0
 */

namespace Elementor;
class Senatory_Services_Box_Slider_Widget extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'senatory-services-box-slider';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Services Box', 'senatory-master');
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'bl_icon eicon-archive-title';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['senatory_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {

        $this->start_controls_section(
            'settings_section',
            [
                'label' => esc_html__('Section Contents', 'senatory-master'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $repeater = new \Elementor\Repeater();


        $repeater->add_control(
            'title', [
                'label' => esc_html__('Title', 'senatory-master'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('Together we can make Better country', 'senatory-master'),
                'description' => esc_html__('Enter title', 'senatory-master')
            ]
        );


        $repeater->add_control(
            'description_status', [
                'label' => esc_html__('Description Show/Hide', 'senatory-master'),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'yes',
                'description' => esc_html__('Show/hide description', 'senatory-master')
            ]
        );

        $repeater->add_control(
            'description', [
                'label' => esc_html__('Description', 'senatory-master'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('President represented Delaware for 36 years in the US', 'senatory-master'),
                'description' => esc_html__('enter description', 'senatory-master'),
                'condition' => ['description_status' => 'yes']
            ]
        );


        $repeater->add_control(
            'icon', [
                'label' => esc_html__('Icon', 'senatory-master'),
                'type' => Controls_Manager::ICONS,
                'description' => esc_html__('Select Icon', 'senatory-master'),
                'default' => [
                    'value' => 'flaticon-statistics',
                    'library' => 'solid',
                ]
            ]
        );

        $repeater->add_control(
            'shape_image', [
                'label' => esc_html__('Features Box Shape', 'senatory-master'),
                'type' => Controls_Manager::MEDIA,
                'show_label' => false,
                'description' => esc_html__('Upload shape image', 'senatory-master'),
                'default' => [
                    'src' => Utils::get_placeholder_image_src()
                ],
            ]
        );


        $this->add_control('features_sliders', [
            'label' => esc_html__('Featues Box Items', 'senatory-master'),
            'type' => Controls_Manager::REPEATER,
            'fields' => $repeater->get_controls(),

            'default' => [
                [

                    'description_status' => 'yes',
                    'description' => esc_html__('President represented Delaware for 36 years in the US', 'senatory-master'),
                    'title' => esc_html__('Together we can make Better country', 'senatory-master'),
                ]
            ],

        ]);


        $this->end_controls_section();


        $this->start_controls_section(
            'slider_settings_section',
            [
                'label' => esc_html__('Slider Settings', 'senatory-master'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'items',
            [
                'label' => esc_html__('Items', 'senatory-master'),
                'type' => Controls_Manager::TEXT,
                'description' => esc_html__('you can set how many item show in slider', 'senatory-master'),
                'default' => '3'
            ]
        );

        $this->add_control(
            'margin',
            [
                'label' => esc_html__('Margin', 'senatory-master'),
                'description' => esc_html__('you can set margin for slider', 'senatory-master'),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                        'step' => 5,
                    ]
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 0,
                ],

                'size_units' => ['px'],
                'condition' => array(
                    'autoplay' => 'yes'
                )
            ]
        );

        $this->add_control(
            'loop',
            [
                'label' => esc_html__('Loop', 'senatory-master'),
                'type' => Controls_Manager::SWITCHER,
                'description' => esc_html__('you can set yes/no to enable/disable', 'senatory-master'),
                'default' => 'yes'
            ]
        );

        $this->add_control(
            'nav',
            [
                'label' => esc_html__('Nav', 'senatory-master'),
                'type' => Controls_Manager::SWITCHER,
                'description' => esc_html__('you can set yes/no to enable/disable', 'senatory-master'),
                'default' => 'yes'
            ]
        );

        $this->add_control(
            'nav_right_arrow',
            [
                'label' => esc_html__('Nav Right Icon', 'senatory-master'),
                'type' => Controls_Manager::ICONS,
                'description' => esc_html__('you can set yes/no to enable/disable', 'senatory-master'),
                'default' => [
                    'value' => 'fas fa-angle-right',
                    'library' => 'solid',
                ],
            ]
        );

        $this->add_control(
            'nav_left_arrow',
            [
                'label' => esc_html__('Nav Left Icon', 'senatory-master'),
                'type' => Controls_Manager::ICONS,
                'description' => esc_html__('you can set yes/no to enable/disable', 'senatory-master'),
                'default' => [
                    'value' => 'fas fa-angle-left',
                    'library' => 'solid',
                ],
            ]
        );

        $this->add_control(
            'autoplay',
            [
                'label' => esc_html__('Autoplay', 'senatory-master'),
                'type' => Controls_Manager::SWITCHER,
                'description' => esc_html__('you can set yes/no to enable/disable', 'senatory-master'),
                'default' => 'yes'
            ]
        );

        $this->add_control(
            'autoplaytimeout',
            [
                'label' => esc_html__('Autoplay Timeout', 'senatory-master'),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 10000,
                        'step' => 2,
                    ]
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 5000,
                ],
                'size_units' => ['px'],
                'condition' => array(
                    'autoplay' => 'yes'
                )
            ]

        );

        $this->end_controls_section();


        $this->start_controls_section(
            'icon_styling_section',
            [
                'label' => esc_html__('Icon Styling', 'senatory-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->start_controls_tabs(
            'title_style_tabs'
        );

        $this->start_controls_tab(
            'title_style_normal_tab',
            [
                'label' => esc_html__('Normal', 'senatory-core'),
            ]
        );
        $this->add_control('icon_color', [
            'label' => esc_html__('Icon Color', 'senatory-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .custom-servicesbox .features-box-icon i" => "color: {{VALUE}}"
            ]
        ]);

        $this->end_controls_tab();

        $this->start_controls_tab(
            'title_style_hover_tab',
            [
                'label' => esc_html__('Hover', 'senatory-core'),
            ]
        );

        $this->add_control('icon_hover_color', [
            'label' => esc_html__('Icon Hover Color', 'senatory-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .custom-servicesbox .single-testimonial-item:hover .features-box-icon i" => "color: {{VALUE}}"
            ]
        ]);

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->end_controls_section();

        $this->start_controls_section(
            'content_styling_section',
            [
                'label' => esc_html__('Content Styling', 'senatory-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->start_controls_tabs(
            'style_tabs'
        );

        $this->start_controls_tab(
            'style_normal_tab',
            [
                'label' => esc_html__('Normal', 'senatory-core'),
            ]
        );

        $this->add_control('normal_background_color', [
            'label' => esc_html__('Box Background Color', 'senatory-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .custom-servicesbox .single-testimonial-item" => "background-color: {{VALUE}};"
            ]
        ]);


        $this->add_control('normal_title_color', [
            'label' => esc_html__('Title Color', 'senatory-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .custom-servicesbox .single-testimonial-item .content .title" => "color: {{VALUE}};"
            ]
        ]);


        $this->add_control('normal_description_color', [
            'label' => esc_html__('Description Color', 'senatory-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .custom-servicesbox .single-testimonial-item .content .description" => "color: {{VALUE}};"
            ]
        ]);;


        $this->end_controls_tab();

        $this->start_controls_tab(
            'style_hover_tab',
            [
                'label' => esc_html__('Hover', 'senatory-core'),
            ]
        );

        $this->add_control('normal_hover_background_color', [
            'label' => esc_html__('Box Hover Background Color', 'senatory-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .custom-servicesbox .single-testimonial-item:hover" => "background-color: {{VALUE}};"
            ]
        ]);

        $this->add_control('hover_title_color', [
            'label' => esc_html__('Title Color', 'senatory-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .custom-servicesbox .single-testimonial-item:hover .content .title" => "color: {{VALUE}};"
            ]
        ]);


        $this->add_control('hover_description_color', [
            'label' => esc_html__('Description Color', 'senatory-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .custom-servicesbox .single-testimonial-item:hover .content .description" => "color: {{VALUE}};"
            ]
        ]);


        $this->end_controls_tab();

        $this->end_controls_tabs();
        $this->end_controls_section();

        $this->start_controls_section(
            'typography_settings_section',
            [
                'label' => esc_html__('Typography Settings', 'senatory-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(Group_Control_Typography::get_type(), [
            'name' => 'title_typography',
            'label' => esc_html__('Title Typography', 'senatory-core'),
            'selector' => "{{WRAPPER}} .custom-servicesbox .single-testimonial-item .content .title"
        ]);


        $this->add_group_control(Group_Control_Typography::get_type(), [
            'name' => 'description_typography',
            'label' => esc_html__('Description Typography', 'senatory-core'),
            'selector' => "{{WRAPPER}} .custom-servicesbox .single-testimonial-item .content .description"
        ]);


        $this->end_controls_section();


    }

    /**
     * Render Elementor widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $all_header_items = $settings['features_sliders'];
        $rand_numb = rand(333, 999999999);

        //slider settings
        $loop = $settings['loop'] ? 'true' : 'false';
        $items = $settings['items'] ? $settings['items'] : 1;
        $autoplay = $settings['autoplay'] ? 'true' : 'false';
        $nav = $settings['nav'] ? 'true' : 'false';
        $navleft = Senatory_core()->render_elementor_icons($settings['nav_left_arrow']);
        $navright = Senatory_core()->render_elementor_icons($settings['nav_right_arrow']);
        $autoplaytimeout = isset($settings['autoplaytimeout']['size']) ? $settings['autoplaytimeout']['size'] : '1000';
        ?>


        <div class="header-bottom-area custom-servicesbox">
            <div class="container">
                <div class="row">


                    <div class="featured-carousel-one testimonial-carousel"
                         id="featured-one-carousel-<?php echo esc_attr($rand_numb); ?>"
                         data-loop="<?php echo esc_attr($loop); ?>"
                         data-margin="<?php echo esc_attr($settings['margin']['size']); ?>"
                         data-items="<?php echo esc_attr($items); ?>"
                         data-autoplay="<?php echo esc_attr($autoplay); ?>"
                         data-nav="<?php echo esc_attr($nav); ?>"
                         data-navleft="<?php echo esc_attr($navleft); ?>"
                         data-navright="<?php echo esc_attr($navright); ?>"
                         data-autoplaytimeout="<?php echo esc_attr($autoplaytimeout); ?>"
                    >


                        <?php
                        foreach ($all_header_items as $item):
                            ?>
                            <div class="single-testimonial-item wow animate__animated animate__fadeInUp">
                                <img src="<?php echo esc_url($item['shape_image']['url']); ?>" class="shape-01" alt=""/>
                                <div class="icon features-box-icon">
                                    <?php
                                    Icons_Manager::render_icon($item['icon'], ['aria-hidden' => 'true']);
                                    ?>
                                </div>
                                <div class="content">
                                    <h4 class="title"><?php echo esc_html($item['title']) ?></h4>

                                    <?php if ($item['description_status'] == 'yes'): ?>
                                        <p class="description"><?php echo esc_html($item['description']) ?></p>
                                    <?php endif; ?>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                </div>
            </div>
        </div>


        <?php
    }
}

Plugin::instance()->widgets_manager->register_widget_type(new Senatory_Services_Box_Slider_Widget());