<?php
/**
 * Elementor Widget
 * @package Senatory
 * @since 1.0.0
 */

namespace Elementor;
class Senatory_Team_Member_Box_Two_Widget extends Widget_Base {

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name() {
        return 'senatory-team-box-two-widget';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title() {
        return esc_html__( 'Team Box: 02', 'senatory-core' );
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon() {
        return 'bl_icon eicon-archive-title';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories() {
        return [ 'senatory_widgets' ];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls() {

        $this->start_controls_section(
            'settings_section',
            [
                'label' => esc_html__( 'General Settings', 'senatory-core' ),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );
		
		$this->add_control('total', [
            'label' => esc_html__('Total Posts', 'senatory-core'),
            'type' => Controls_Manager::TEXT,
            'default' => '-1',
            'description' => esc_html__('enter how many course you want in masonry , enter -1 for unlimited course.')
        ]);
        $this->add_control('order', [
            'label' => esc_html__('Order', 'senatory-core'),
            'type' => Controls_Manager::SELECT,
            'options' => array(
                'ASC' => esc_html__('Ascending', 'senatory-core'),
                'DESC' => esc_html__('Descending', 'senatory-core'),
            ),
            'default' => 'ASC',
            'description' => esc_html__('select order', 'senatory-core')
        ]);
		

        $this->end_controls_section();


        $this->start_controls_section(
            'team_member_styling_settings_section',
            [
                'label' => esc_html__( 'Styling Settings', 'senatory-core' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
		
		
        $this->add_control('name_color',[
            'label' => esc_html__('Name Color','senatory-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .team-section-area.style-01 .team-single-items .content .member-name" => "color: {{VALUE}}"
            ]
        ]);
		
		
        $this->add_control('designation_color',[
            'label' => esc_html__('Designation Color','senatory-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .team-section-area.style-01 .team-single-items .content .designation" => "color: {{VALUE}}"
            ]
        ]);
		
		$this->end_controls_section();


        /* typography settings start */
        $this->start_controls_section('typography_settings', [
            'label' => esc_html__('Typography Settings', 'senatory-master'),
            'tab' => Controls_Manager::TAB_STYLE
        ]);
		
				
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'label' => esc_html__('Name Typography', 'senatory-core'),
            'name' => 'title_typography',
            'description' => esc_html__('select title typography', 'senatory-core'),
            'selector' => "{{WRAPPER}} .team-section-area.style-01 .team-single-items .content .member-name"
        ]);
		
		
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'label' => esc_html__('Description Typography', 'senatory-core'),
            'name' => 'description_typography',
            'description' => esc_html__('select description typography', 'senatory-core'),
            'selector' => "{{WRAPPER}} .team-section-area.style-01 .team-single-items .content .member-name .designation"
        ]);
		
		
        $this->end_controls_section();
        /* typography settings end */


    }

    /**
     * Render Elementor widget output on the frontend.
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render() {
		
		
        $settings = $this->get_settings_for_display();
		$all_header_items = $settings['features_sliders'];

        $total_posts = $settings['total'];
        $order = $settings['order'];

        $args = array(
            'post_type' => 'team',
            'posts_per_page' => $total_posts,
            'order' => $order,
        );

        $post_data = new \WP_Query($args);
        ?>


         <!-- Team Section Start here -->
         <div class="team-section-area style-01">
            <div class="container">
                <div class="row">
                    <?php $team_query = new \WP_Query(array('post_type'=> 'team')); 

                    while ($post_data->have_posts()) : $post_data->the_post();

                        $post_id = get_the_ID();
                        $img_id = get_post_thumbnail_id($post_id) ? get_post_thumbnail_id($post_id) : false;
                        $img_url_val = $img_id ? wp_get_attachment_image_src($img_id, 'senatory_classic_team', false) : '';
                        $img_url = is_array($img_url_val) && !empty($img_url_val) ? $img_url_val[0] : '';
                        $img_alt = get_post_meta($img_id, '_wp_attachment_image_alt', true);

                        $team_single_meta_data = get_post_meta(get_the_ID(), 'senatory_team_options', true);

                        $team_designation = isset($team_single_meta_data['designation']) && !empty($team_single_meta_data['designation']) ? $team_single_meta_data['designation'] : ''; 

                        $social_icons = isset($team_single_meta_data['social-icons']) && !empty($team_single_meta_data['social-icons']) ? $team_single_meta_data['social-icons'] : ''; 
                        ?>
                        <div class="col-lg-4 col-md-6">
                            <div class="team-single-items">
                                <div class="thumbnail">
                                        <img src="<?php echo esc_url($img_url)?>" alt="<?php echo $img_alt?>">
                                    <ul class="social-area">
                                    <?php
                                        if (!empty($social_icons)) {
                                            foreach ($social_icons as $s_info) {
                                                printf('<li><a href="%2$s"><i class="%1$s"></i></a></li>', $s_info['icon'], $s_info['url']);
                                            }
                                        }
                                    ?>
                                    </ul>
                                </div>
                                <div class="content">
                                    <h6 class="member-name"><a href="<?php the_permalink() ?>"><?php echo esc_html(get_the_title($post_id)) ?></a></h6>
                                    <p class="designation"><?php echo esc_html($team_designation); ?></p>
                                </div>  
                            </div>
                        </div>


                    <?php  endwhile; ?>

                </div>

        <!-- Pagination -->
        <div class="row justify-content-center">
            <div class="col-lg-6 col-md-9 col-12">
                <div class="blog-pagination style-01 desktop-center">

                <?php 
                    $total_pages = $post_data->max_num_pages;
                    if ($total_pages > 1){
                    $current_page = max(1, get_query_var('paged'));

                    echo paginate_links(array(
                            'base' => get_pagenum_link(1) . '%_%',
                            'format' => '/page/%#%',
                            'current' => $current_page,
                            'total' => $total_pages,
                            'prev_text'    => '<i class="fas fa-chevron-left"></i>',
                            'next_text'    => '<i class="fas fa-chevron-right"></i>',
                        ));
                    } 
                ?>                          
                </div>
            </div>
        </div>

            </div>
        </div>
        <!-- Team Section End here -->

    <?php }
}

Plugin::instance()->widgets_manager->register_widget_type( new Senatory_Team_Member_Box_Two_Widget() );