<?php
/**
 * Elementor Widget
 * @package Senatory
 * @since 1.0.0
 */

namespace Elementor;
class Senatory_Team_Member_One_Widget extends Widget_Base {

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name() {
        return 'senatory-team-member-one-widget';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title() {
        return esc_html__( 'Team Slider: 01', 'senatory-core' );
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon() {
        return 'bl_icon eicon-archive-title';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories() {
        return [ 'senatory_widgets' ];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls() {

        $this->start_controls_section(
            'slider_settings_section',
            [
                'label' => esc_html__( 'Slider Settings', 'senatory-core' ),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'items',
            [
                'label'       => esc_html__( 'Items', 'senatory-core' ),
                'type'        => Controls_Manager::TEXT,
                'description' => esc_html__( 'you can set how many item show in slider', 'senatory-core' ),
                'default'     => '5'
            ]
        );
        $this->add_control(
            'margin',
            [
                'label'       => esc_html__( 'Margin', 'senatory-core' ),
                'description' => esc_html__( 'you can set margin for slider', 'senatory-core' ),
                'type'        => Controls_Manager::SLIDER,
                'range'       => [
                    'px' => [
                        'min'  => 0,
                        'max'  => 100,
                        'step' => 5,
                    ]
                ],
                'default'     => [
                    'unit' => 'px',
                    'size' => 0,
                ],
                'size_units'  => [ 'px' ],
                'condition'   => array(
                    'autoplay' => 'yes'
                )
            ]
        );
        $this->add_control(
            'loop',
            [
                'label'       => esc_html__( 'Loop', 'senatory-core' ),
                'type'        => Controls_Manager::SWITCHER,
                'description' => esc_html__( 'you can set yes/no to enable/disable', 'senatory-core' ),
                'default'     => 'yes'
            ]
        );
		
		$this->add_control(
            'center',
            [
                'label' => esc_html__('Center', 'senatory-master'),
                'type' => Controls_Manager::SWITCHER,
                'description' => esc_html__('you can set yes/no to enable/disable', 'senatory-master'),
                'default' => 'yes'
            ]
        );
		
		$this->add_control(
            'nav',
            [
                'label' => esc_html__('Nav', 'senatory-master'),
                'type' => Controls_Manager::SWITCHER,
                'description' => esc_html__('you can set yes/no to enable/disable', 'senatory-master'),
                'default' => 'yes'
            ]
        );

        $this->add_control(
            'nav_right_arrow',
            [
                'label' => esc_html__('Nav Right Icon', 'senatory-master'),
                'type' => Controls_Manager::ICONS,
                'description' => esc_html__('you can set yes/no to enable/disable', 'senatory-master'),
                'default' => [
                    'value' => 'fas fa-angle-right',
                    'library' => 'solid',
                ],
            ]
        );

        $this->add_control(
            'nav_left_arrow',
            [
                'label' => esc_html__('Nav Left Icon', 'senatory-master'),
                'type' => Controls_Manager::ICONS,
                'description' => esc_html__('you can set yes/no to enable/disable', 'senatory-master'),
                'default' => [
                    'value' => 'fas fa-angle-left',
                    'library' => 'solid',
                ],
            ]
        );
		
		
        $this->add_control(
            'autoplay',
            [
                'label'       => esc_html__( 'Autoplay', 'senatory-core' ),
                'type'        => Controls_Manager::SWITCHER,
                'description' => esc_html__( 'you can set yes/no to enable/disable', 'senatory-core' ),
                'default'     => 'yes'
            ]
        );
        $this->add_control(
            'autoplaytimeout',
            [
                'label'      => esc_html__( 'Autoplay Timeout', 'senatory-core' ),
                'type'       => Controls_Manager::SLIDER,
                'range'      => [
                    'px' => [
                        'min'  => 0,
                        'max'  => 10000,
                        'step' => 2,
                    ]
                ],
                'default'    => [
                    'unit' => 'px',
                    'size' => 5000,
                ],
                'size_units' => [ 'px' ],
                'condition'  => array(
                    'autoplay' => 'yes'
                )
            ]

        );
        $this->end_controls_section();

        $this->start_controls_section(
            'team_member_styling_settings_section',
            [
                'label' => esc_html__( 'Styling Settings', 'senatory-core' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
		
		
        $this->add_control('name_color',[
            'label' => esc_html__('Name Color','senatory-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .volunteer-single-items .content .author-meta .author-name" => "color: {{VALUE}}"
            ]
        ]);
		
		
        $this->add_control('designation_color',[
            'label' => esc_html__('Designation Color','senatory-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .volunteer-single-items .content .author-meta .designation" => "color: {{VALUE}}"
            ]
        ]);
		
        $this->add_control('border_tem_color',[
            'label' => esc_html__('Border Color','senatory-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .volunteer-single-items:hover" => "border-color: {{VALUE}}"
            ]
        ]);
		
		$this->end_controls_section();


        /* typography settings start */
        $this->start_controls_section('typography_settings', [
            'label' => esc_html__('Typography Settings', 'senatory-master'),
            'tab' => Controls_Manager::TAB_STYLE
        ]);
		
				
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'label' => esc_html__('Title Typography', 'senatory-core'),
            'name' => 'title_typography',
            'description' => esc_html__('select title typography', 'senatory-core'),
            'selector' => "{{WRAPPER}} .volunteer-single-items .content .author-meta .author-name"
        ]);
		
		
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'label' => esc_html__('Description Typography', 'senatory-core'),
            'name' => 'description_typography',
            'description' => esc_html__('select description typography', 'senatory-core'),
            'selector' => "{{WRAPPER}} .volunteer-single-items .content .author-meta .designation"
        ]);
		
		
        $this->end_controls_section();
        /* typography settings end */


    }

    /**
     * Render Elementor widget output on the frontend.
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render() {
        $settings              = $this->get_settings_for_display();
        $all_team_member_items = $settings['team_member_items'];
        $rand_numb             = rand( 333, 999999999 );

        //slider settings
        $loop            = $settings['loop'] ? 'true' : 'false';
        $items           = $settings['items'] ? $settings['items'] : 5;
        $autoplay        = $settings['autoplay'] ? 'true' : 'false';
		$nav = $settings['nav'] ? 'true' : 'false';
		$center = $settings['center'] ? 'true' : 'false';
        $navleft = Senatory_core()->render_elementor_icons($settings['nav_left_arrow']);
        $navright = Senatory_core()->render_elementor_icons($settings['nav_right_arrow']);
        $autoplaytimeout = $settings['autoplaytimeout']['size'];

        $args = array(
            'post_type' => 'team',
        );

        $post_data = new \WP_Query($args);


        ?>
		
		
		
  <!-- Volunteer Section Start -->
  <div class="volunteer-section-area volunteer-members-wrapperr">
    <div class="container-fluid">
      <div class="row">
	  
		<div class="testimonial-carousel-two"
                 id="team-member-one-carousel-<?php echo esc_attr( $rand_numb ); ?>"
                 data-loop="<?php echo esc_attr( $loop ); ?>"
                 data-margin="<?php echo esc_attr( $settings['margin']['size'] ); ?>"
                 data-items="<?php echo esc_attr( $items ); ?>"
                 data-autoplay="<?php echo esc_attr( $autoplay ); ?>"
				 data-nav="<?php echo esc_attr($nav); ?>"
				 data-center="<?php echo esc_attr($center); ?>"
				 data-navleft="<?php echo esc_attr($navleft); ?>"
				 data-navright="<?php echo esc_attr($navright); ?>"
                 data-autoplaytimeout="<?php echo esc_attr( $autoplaytimeout ); ?>"
        >
	
    <?php $team_query = new \WP_Query(array('post_type'=> 'team')); 

        while ($post_data->have_posts()) : $post_data->the_post();

            $post_id = get_the_ID();
            $img_id = get_post_thumbnail_id($post_id) ? get_post_thumbnail_id($post_id) : false;
            $img_url_val = $img_id ? wp_get_attachment_image_src($img_id, 'senatory_classic_team', false) : '';
            $img_url = is_array($img_url_val) && !empty($img_url_val) ? $img_url_val[0] : '';
            $img_alt = get_post_meta($img_id, '_wp_attachment_image_alt', true);

            $team_single_meta_data = get_post_meta(get_the_ID(), 'senatory_team_options', true);

            $team_designation = isset($team_single_meta_data['designation']) && !empty($team_single_meta_data['designation']) ? $team_single_meta_data['designation'] : '';
            $social_icons = isset($team_single_meta_data['social-icons']) && !empty($team_single_meta_data['social-icons']) ? $team_single_meta_data['social-icons'] : ''; 
            ?>

            <div class="volunteer-single-items">
                <div class="thum">
                  <img src="<?php echo esc_url($img_url)?>" alt="<?php echo $img_alt?>">
                </div>
                <div class="content">
                  <div class="author-meta">
                    <a href="<?php the_permalink() ?>"><span class="author-name"><?php echo esc_html(get_the_title($post_id)) ?></span></a>
                    <p class="designation"><?php echo esc_html($team_designation); ?></p>
                  </div>
    			  
                  <div class="social-links">
    					<?php
                            if (!empty($social_icons)) {
                                foreach ($social_icons as $s_info) {
                                    printf('<a href="%2$s"><i class="%1$s"></i></a>', $s_info['icon'], $s_info['url']);
                                }
                            }
                        ?>		
    									
                  </div>
    			  
    			  
                </div>
            </div>
		  
    <?php  endwhile; ?>
		  
		  
        </div>
		
		
		
      </div>
    </div>
  </div>
  <!-- Volunteer Section End -->

  

		
		
        <?php
    }
}

Plugin::instance()->widgets_manager->register_widget_type( new Senatory_Team_Member_One_Widget() );