<?php
/**
 * Elementor Widget
 * @package Senatory
 * @since 1.0.0
 */

namespace Elementor;
class Senatory_Testimonials_Slider_Five_Widget extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
       return 'senatory-testimonials-slider-five';
    }
    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Testimonials Slider: 05', 'senatory-core');
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'bl_icon eicon-archive-title';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['senatory_widgets'];
    }

    	/**
	 * Get widget keywords.
	 *
	 * Retrieve the list of keywords the list widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return array Widget keywords.
	 */
	public function get_keywords() {
		return [ 'testimonial', 'testimonial slider', 'carousel', 'slider', 'senatory' ];
	}

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {

        $this->start_controls_section(
            'settings_section',
            [
                'label' => esc_html__('Section Contents', 'senatory-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
		
        $this->add_control(
            'sub-title', [
                'label' => esc_html__('Sub Title', 'senatory-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('Public Comments', 'senatory-core'),
                'description' => esc_html__('Enter sub title', 'senatory-core')
            ]
        );
        $this->add_control(
            'title', [
                'label' => esc_html__('Title', 'senatory-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('What People\'s Say About our political party', 'senatory-core'),
                'description' => esc_html__('Enter title', 'senatory-core')
            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'icon_selector',
            [
                'label' => esc_html__('Icon Selector', 'foodfly-core'),
                'type' => Controls_Manager::SELECT,
                'default' => 'icon',
                'options' => [
                    'image' => esc_html__('Icon Image', 'foodfly-core'),
                    'icon' => esc_html__('Icon', 'foodfly-core'),
                ],

            ]
        );
        $repeater->add_control(
            'icon',
            [
                'label' => esc_html__('Icon', 'senatory-core'),
                'type' => Controls_Manager::ICONS,
                'description' => esc_html__('select Icon.', 'senatory-core'),
                'default' => [
                    'value' => 'fas fa-phone-alt',
                    'library' => 'solid',
                ],
                'condition' => ['icon_selector' => 'icon']
            ]
        );
        $repeater->add_control(
            'icon_image',
            [
                'label' => esc_html__('Icon Image', 'senatory-core'),
                'type' => Controls_Manager::MEDIA,
                'description' => esc_html__('Choose Icon Image.', 'senatory-core'),
                'default' => [
                    'src' => Utils::get_placeholder_image_src()
                ],
                'condition' => ['icon_selector' => 'image']
            ]
        );
        $repeater->add_control(
            'description', [
                'label' => esc_html__('Description', 'senatory-core'),
                'type' => Controls_Manager::TEXTAREA,
                'description' => esc_html__('enter description', 'senatory-core'),

            ]
        );
        $repeater->add_control(
            'reviewer-name', [
                'label' => esc_html__('Reviewer Name', 'senatory-core'),
                'type' => Controls_Manager::TEXTAREA,
                'description' => esc_html__('Enter Reviewer Name', 'senatory-core')
            ]
        );
        $repeater->add_control(
            'designation', [
                'label' => esc_html__('Designation', 'senatory-core'),
                'type' => Controls_Manager::TEXTAREA,
                'description' => esc_html__('Enter Reviewer Designation', 'senatory-core')
            ]
        );
		
		$repeater->add_control(
            'reviewer_image', [
                'label' => esc_html__('Author Image', 'senatory-core'),
                'type' => Controls_Manager::MEDIA,
                'show_label' => false,
                'description' => esc_html__('Upload Reviewer Image', 'senatory-core'),
                'default' => [
                    'src' => Utils::get_placeholder_image_src()
                ],
            ]
        );
        $this->add_control('testimonails_sliders', [
            'label' => esc_html__('Testimonial Items', 'senatory-core'),
            'type' => Controls_Manager::REPEATER,
            'fields' => $repeater->get_controls(),
            
            'default' => [
                [
                    
                    'description'   => esc_html__('"Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum Occaecat cupidatat non proident,sunt in culpa qui officia deserunt mollit anim id, sint occaecat cupidatat non proident, sunt in culpa qui "', 'senatory-core'),
                    'reviewer-name' => esc_html__('William Smit', 'senatory-core'),
                    'designation'   => esc_html__('PARTY Member', 'senatory-core'),
                ]
            ],

        ]);


        $this->end_controls_section();


        $this->start_controls_section(
            'slider_settings_section',
            [
                'label' => esc_html__('Slider Settings', 'senatory-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'items',
            [
                'label' => esc_html__('Items', 'senatory-core'),
                'type' => Controls_Manager::TEXT,
                'description' => esc_html__('you can set how many item show in slider', 'senatory-core'),
                'default' => '3'
            ]
        );

        $this->add_control(
            'autoplay',
            [
                'label' => esc_html__('Autoplay', 'senatory-core'),
                'type' => Controls_Manager::SWITCHER,
                'description' => esc_html__('you can set yes/no to enable/disable', 'senatory-core'),
                'default' => 'yes'
            ]
        );

        $this->add_control(
            'autoplaytimeout',
            [
                'label' => esc_html__('Autoplay Timeout', 'senatory-core'),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 10000,
                        'step' => 2,
                    ]
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 1000,
                ],
                'size_units' => ['px'],
                'condition' => array(
                    'autoplay' => 'yes'
                )
            ]

        );
        $this->add_control(
            'margin',
            [
                'label' => esc_html__('Margin', 'senatory-core'),
                'description' => esc_html__('you can set margin for slider', 'senatory-core'),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                        'step' => 5,
                    ]
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 30,
                ],
                
                'size_units' => ['px'],
                'condition' => array(
                    'autoplay' => 'yes'
                )
            ]
        );

        $this->add_control(
            'loop',
            [
                'label' => esc_html__('Loop', 'senatory-core'),
                'type' => Controls_Manager::SWITCHER,
                'description' => esc_html__('you can set yes/no to enable/disable', 'senatory-core'),
                'default' => 'yes'
            ]
        );

        $this->add_control(
            'nav',
            [
                'label' => esc_html__('Nav', 'senatory-core'),
                'type' => Controls_Manager::SWITCHER,
                'description' => esc_html__('you can set yes/no to enable/disable', 'senatory-core'),
                'default' => 'yes'
            ]
        );

        $this->add_control(
            'nav_right_arrow',
            [
                'label' => esc_html__('Nav Right Icon', 'senatory-core'),
                'type' => Controls_Manager::ICONS,
                'description' => esc_html__('you can set yes/no to enable/disable', 'senatory-core'),
                'default' => [
                    'value' => 'fas fa-angle-right',
                    'library' => 'solid',
                ],
            ]
        );

        $this->add_control(
            'nav_left_arrow',
            [
                'label' => esc_html__('Nav Left Icon', 'senatory-core'),
                'type' => Controls_Manager::ICONS,
                'description' => esc_html__('you can set yes/no to enable/disable', 'senatory-core'),
                'default' => [
                    'value' => 'fas fa-angle-left',
                    'library' => 'solid',
                ],
            ]
        );


        $this->end_controls_section();

        $this->start_controls_section(
            'css_styles',
            [
                'label' => esc_html__('Styling Settings', 'senatory-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'section_bg_color',
                'label' => esc_html__('Section Background', 'senatory-core'),
				'types' => [ 'classic', 'gradient'],
                'selector' => '{{WRAPPER}} .testimonial-section-area.home-six',
                'default'   => '#181816'
			]
		);
        $this->add_control('slider_title_color', [
            'label' => esc_html__('Title Color', 'senatory-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .testimonial-section-area.home-six .title" => "color: {{VALUE}}"
            ]
        ]);
        $this->add_control('slider_subtitle_color', [
            'label' => esc_html__('Slider Sub Title Color', 'senatory-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .testimonial-section-area.home-six .sub-title-02" => "color: {{VALUE}}"
            ]
        ]);
        $this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'subtitle_bg_color',
                'label' => esc_html__('Sub Title Background', 'senatory-core'),
				'types' => [ 'classic', 'gradient'],
                'selector' => '{{WRAPPER}} .testimonial-section-area.home-six .sub-title-02::before',
			]
		);
        $this->add_control('slider_icon_color', [
            'label' => esc_html__('Icon Color', 'senatory-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .testimonial-section-area.home-six .sub-title-02 i" => "color: {{VALUE}}"
            ]
        ]);
        // Separator / Heading
		$this->add_control(
			'header_o1',
			[
				'label' => esc_html__( 'Testimonai Items', 'plugin-name' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
        $this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'item_bg_color',
                'label' => esc_html__('Item Background', 'senatory-core'),
				'types' => [ 'classic', 'gradient'],
                'selector' => '{{WRAPPER}} .testimonial-section-area.home-six .testimonial-single-item',
			]
		);
        $this->add_control('description_color', [
            'label' => esc_html__('Description Color', 'senatory-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .testimonial-section-area.home-six .testimonial-single-item .content p" => "color: {{VALUE}}"
            ]
        ]);
        $this->add_control('author_color', [
            'label' => esc_html__('Author Color', 'senatory-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .testimonial-section-area.home-six .testimonial-single-item .content .author-meta .description .name" => "color: {{VALUE}}"
            ]
        ]);
        $this->add_control('designation_color', [
            'label' => esc_html__('Designation Color', 'senatory-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .testimonial-section-area.home-six .testimonial-single-item .content .author-meta .description .designation" => "color: {{VALUE}}"
            ]
        ]);
        $this->add_control('item_icon_color', [
            'label' => esc_html__('Icon Color', 'senatory-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .testimonial-section-area.home-six .testimonial-single-item .icon i" => "color: {{VALUE}}"
            ]
        ]);
        $this->add_responsive_control('padding', [
            'label' => esc_html__('Padding', 'senatory-core'),
            'type' => Controls_Manager::DIMENSIONS,
            'size_units' => ['px', 'em'],
            'selectors' => [
                '{{WRAPPER}} .testimonial-section-area.home-six .testimonial-single-item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}'
            ],
            'description' => esc_html__('Set Padding for Slider Items ', 'senatory-core')
        ]);
        $this->end_controls_section();

        /* button styling */
        $this->start_controls_section('header_button_section', [
            'label' => esc_html__('Navigation Settings', 'senatory-core'),
            'tab' => Controls_Manager::TAB_STYLE
        ]);

        $this->start_controls_tabs('button_styling');

        $this->start_controls_tab('normal_style', [
            'label' => esc_html__('Button Normal', "senatory-core")
        ]);
        $this->add_group_control(Group_Control_Background::get_type(), [
            'name' => 'button_background',
            'label' => esc_html__('Button Background ', 'senatory-core'),
            'selector' => "{{WRAPPER}} .testimonial-section-area.home-six .testimonial-carousel-nine .owl-nav .owl-prev,
            .testimonial-section-area.home-six .testimonial-carousel-nine .owl-nav .owl-next"
        ]);
        $this->add_control('button_text_color', [
            'label' => esc_html__('Color', 'senatory-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .testimonial-section-area.home-six .testimonial-carousel-nine .owl-nav .owl-prev,
                .testimonial-section-area.home-six .testimonial-carousel-nine .owl-nav .owl-next" => "color: {{VALUE}}"
            ]
        ]);
        $this->add_control(
            'button_border_radius',
            [
                'label' => esc_html__('Border Radius', 'senatory-core'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .testimonial-section-area.home-six .testimonial-carousel-nine .owl-nav .owl-prev,
                    .testimonial-section-area.home-six .testimonial-carousel-nine .owl-nav .owl-next' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_tab();
        // Hover Tab
        $this->start_controls_tab('hover_style', [
            'label' => esc_html__('Button Hover', "senatory-core")
        ]);
        $this->add_control('button_hover_normal_color', [
            'label' => esc_html__('Button Color', 'senatory-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .testimonial-section-area.home-six .testimonial-carousel-nine .owl-nav .owl-prev:hover,
                .testimonial-section-area.home-six .testimonial-carousel-nine .owl-nav .owl-next:hover" => "color: {{VALUE}}"
            ]
        ]);
        $this->add_group_control(Group_Control_Background::get_type(), [
            'name' => 'button_hover_background',
            'label' => esc_html__('Button Background ', 'senatory-core'),
            'selector' => "{{WRAPPER}} .testimonial-section-area.home-six .testimonial-carousel-nine .owl-nav .owl-prev:hover,
            .testimonial-section-area.home-six .testimonial-carousel-nine .owl-nav .owl-next:hover"
        ]);

        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();
        /* button styling end */

        /* typography settings start */
        $this->start_controls_section('typography_settings', [
            'label' => esc_html__('Typography Settings', 'senatory-core'),
            'tab' => Controls_Manager::TAB_STYLE
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'name' => 'title_typography',
            'label' => esc_html__('Title Typography', 'senatory-core'),
            'selector' => "{{WRAPPER}} .testimonial-section-area.home-six .title"
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'name' => 'subtitle_typography',
            'label' => esc_html__('Sub Title Typography', 'senatory-core'),
            'selector' => "{{WRAPPER}} .testimonial-section-area.home-six .sub-title-02"
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'name' => 'desc_typography',
            'label' => esc_html__('Description Typography', 'senatory-core'),
            'selector' => "{{WRAPPER}} .testimonial-section-area.home-six .testimonial-single-item .content p"
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'name' => 'author_typography',
            'label' => esc_html__('Author Typography', 'senatory-core'),
            'selector' => "{{WRAPPER}} .testimonial-section-area.home-six .author-meta .description .name"
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'name' => 'designation_typography',
            'label' => esc_html__('Designation Typography', 'senatory-core'),
            'selector' => "{{WRAPPER}} .testimonial-section-area.home-six .author-meta .description .designation"
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'name' => 'icon_typography',
            'label' => esc_html__('Icon Typography', 'senatory-core'),
            'selector' => "{{WRAPPER}} .testimonial-section-area.home-six .testimonial-single-item .icon i"
        ]);

        $this->end_controls_section();
        /* typography settings end */

    }

    /**
     * Render Elementor widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $all_slider_items = $settings['testimonails_sliders'];
        $rand_numb = rand(333, 999999999);

        //slider settings
        $loop = $settings['loop'] ? true : false;
        $items = $settings['items'] ? $settings['items'] : '1';
        $margin = $settings['margin']['size'] ?? '30';
        $autoplay = $settings['autoplay'] ? true : false;
        $nav = $settings['nav'] ? true : false;
        $navleft = Senatory_core()->render_elementor_icons($settings['nav_left_arrow']);
        $navright = Senatory_core()->render_elementor_icons($settings['nav_right_arrow']);
        $autoplaytimeout = isset($settings['autoplaytimeout']['size']) ? $settings['autoplaytimeout']['size'] : '1000';

        $slider_settings = [
            "loop"            => $loop,
            "margin"          => $margin,
            "items"           => $items,
            "autoplay"        => $autoplay,
            "nav"             => $nav,
            "dataCenter"      => $center,
            "navleft"         => $navleft,
            "navright"        => $navright,
            "autoplaytimeout" => $autoplaytimeout
        ];
        ?>
            <!-- Testimonial Section Start -->
            <div class="testimonial-section-area testimonial-bg home-six">

                <div class="container">
                <div class="row align-items-center">
                    <div class="col-lg-6">
                        <div class="section-title">
                            <p class="sub-title-02"><i class="icomoon-star"></i><?php echo esc_html($settings['sub-title']) ?></p>
                            <h4 class="title style-01"><?php echo esc_html($settings['title']) ?></h4>
                        </div>
                    </div>
                    <div class="col-lg-6">
                        <div class="testimonial-slider-area">
                            <div class="testimonial-carousel-nine" id="senatory-testimonial-five-<?php echo esc_attr($rand_numb); ?>" data-settings='<?php echo json_encode($slider_settings) ?>'>

                                <!-- Testimonial Item -->
                                <?php foreach($all_slider_items as $item): ?>
                                <div class="testimonial-single-item">
                                    
                                        <div class="icon">
                                            <?php if($item['icon_image']['url']): ?>
                                                <img src="<?php echo esc_url($item['icon_image']['url']); ?>" class="style-01" alt="<?php echo esc_attr(['icon_image']['alt']); ?>">
                                            <?php endif; ?>

                                            <?php if($item['icon']):
                                                Icons_Manager::render_icon($item['icon'], ['aria-hidden' => 'true']);
                                            endif; ?>
                                        </div>
          
                                    <div class="content">
                                        <p><?php echo esc_html($item['description']) ?></p>
                                        <div class="author-meta">
                                            <?php if(!empty($item['reviewer_image']['url'])): ?>
                                            <div class="author">
                                                <img src="<?php echo esc_url($item['reviewer_image']['url']); ?>" alt="">
                                            </div>
                                            <?php endif; ?>
                                            <div class="description">
                                                <h6 class="name"><?php echo esc_html($item['reviewer-name']) ?></h6>
                                                <p class="designation"><?php echo esc_html($item['designation']) ?></p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                
                                <?php endforeach; ?>
                                <!-- End Testimonial Item -->

                            </div>
                        </div>
                    </div>
                </div>
                </div>
            </div>
            <!-- Testimonial Secition End -->


            <?php
    }
}

Plugin::instance()->widgets_manager->register_widget_type(new Senatory_Testimonials_Slider_Five_Widget());