<?php
/**
 * Elementor Widget
 * @package Senatory
 * @since 1.0.0
 */

namespace Elementor;
class Senatory_Testimonials_Slider_One_Widget extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'senatory-testimonials-area-one-slider';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Testimonials Slider: 01', 'senatory-master');
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'bl_icon eicon-archive-title';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['senatory_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {

        $this->start_controls_section(
            'settings_section',
            [
                'label' => esc_html__('Section Contents', 'senatory-master'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );



        $this->add_control(
            'bg_image',
            [
                'label' => esc_html__('Section Background Image', 'senatory-core'),
                'type' => Controls_Manager::MEDIA,
                'show_label' => false,
                'description' => esc_html__('Upload background image', 'senatory-master'),
                'default' => [
                    'src' => Utils::get_placeholder_image_src()
                ],
            ]
        );



        $repeater = new \Elementor\Repeater();


        $repeater->add_control(
            'title', [
                'label' => esc_html__('Title', 'senatory-master'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('People Say About us', 'senatory-master'),
                'description' => esc_html__('Enter title', 'senatory-master')
            ]
        );

        $repeater->add_control(
            'sub-title', [
                'label' => esc_html__('Sub Title', 'senatory-master'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('Together we can make Better country', 'senatory-master'),
                'description' => esc_html__('Enter sub title', 'senatory-master')
            ]
        );


        $repeater->add_control(
            'reviewer-name', [
                'label' => esc_html__('Reviewer Name', 'senatory-master'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('William Smith', 'senatory-master'),
                'description' => esc_html__('Enter Reviewer Name', 'senatory-master')
            ]
        );


        $repeater->add_control(
            'description', [
                'label' => esc_html__('Description', 'senatory-master'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('Excepteur sint occaecat cupidatat non proident', 'senatory-master'),
                'description' => esc_html__('enter description', 'senatory-master'),

            ]
        );

		
		



        $this->add_control('testimonails_sliders', [
            'label' => esc_html__('Testimonial Items', 'senatory-master'),
            'type' => Controls_Manager::REPEATER,
            'fields' => $repeater->get_controls(),
            
            'default' => [
                [
                    
                    'description' => esc_html__('President represented Delaware for 36 years in the US', 'senatory-master'),
                    'title' => esc_html__('Together we can make Better country', 'senatory-master'),
                ]
            ],

        ]);


        $this->end_controls_section();


        $this->start_controls_section(
            'slider_settings_section',
            [
                'label' => esc_html__('Slider Settings', 'senatory-master'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'items',
            [
                'label' => esc_html__('Items', 'senatory-master'),
                'type' => Controls_Manager::TEXT,
                'description' => esc_html__('you can set how many item show in slider', 'senatory-master'),
                'default' => '1'
            ]
        );

        $this->add_control(
            'margin',
            [
                'label' => esc_html__('Margin', 'senatory-master'),
                'description' => esc_html__('you can set margin for slider', 'senatory-master'),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                        'step' => 5,
                    ]
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 0,
                ],
                
                'size_units' => ['px'],
                'condition' => array(
                    'autoplay' => 'yes'
                )
            ]
        );

        $this->add_control(
            'loop',
            [
                'label' => esc_html__('Loop', 'senatory-master'),
                'type' => Controls_Manager::SWITCHER,
                'description' => esc_html__('you can set yes/no to enable/disable', 'senatory-master'),
                'default' => 'yes'
            ]
        );

        $this->add_control(
            'nav',
            [
                'label' => esc_html__('Nav', 'senatory-master'),
                'type' => Controls_Manager::SWITCHER,
                'description' => esc_html__('you can set yes/no to enable/disable', 'senatory-master'),
                'default' => 'no'
            ]
        );

        $this->add_control(
            'nav_right_arrow',
            [
                'label' => esc_html__('Nav Right Icon', 'senatory-master'),
                'type' => Controls_Manager::ICONS,
                'description' => esc_html__('you can set yes/no to enable/disable', 'senatory-master'),
                'default' => [
                    'value' => 'fas fa-angle-right',
                    'library' => 'solid',
                ],
            ]
        );

        $this->add_control(
            'nav_left_arrow',
            [
                'label' => esc_html__('Nav Left Icon', 'senatory-master'),
                'type' => Controls_Manager::ICONS,
                'description' => esc_html__('you can set yes/no to enable/disable', 'senatory-master'),
                'default' => [
                    'value' => 'fas fa-angle-left',
                    'library' => 'solid',
                ],
            ]
        );

        $this->add_control(
            'autoplay',
            [
                'label' => esc_html__('Autoplay', 'senatory-master'),
                'type' => Controls_Manager::SWITCHER,
                'description' => esc_html__('you can set yes/no to enable/disable', 'senatory-master'),
                'default' => 'yes'
            ]
        );

        $this->add_control(
            'autoplaytimeout',
            [
                'label' => esc_html__('Autoplay Timeout', 'senatory-master'),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 10000,
                        'step' => 2,
                    ]
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 5000,
                ],
                'size_units' => ['px'],
                'condition' => array(
                    'autoplay' => 'yes'
                )
            ]

        );

        $this->end_controls_section();

        $this->start_controls_section(
            'css_styles',
            [
                'label' => esc_html__('Styling Settings', 'senatory-master'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control('slider_title_color', [
            'label' => esc_html__('Slider Title Color', 'senatory-master'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .custom-testimonial-one-wrap .party-single-item.style-02 .content .title" => "color: {{VALUE}}"
            ]
        ]);


        $this->add_control('slider_subtitle_color', [
            'label' => esc_html__('Slider Sub Title Color', 'senatory-master'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .custom-testimonial-one-wrap .party-single-item.style-02 .content .subtitle p" => "color: {{VALUE}}"
            ]
        ]);
		
		$this->add_control('slider_des_color', [
            'label' => esc_html__('Testimonial Content Color', 'senatory-master'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .custom-testimonial-one-wrap .party-single-item.style-02 .content .quotes .description" => "color: {{VALUE}}"
            ]
        ]);


        $this->end_controls_section();


        /* typography settings start */
        $this->start_controls_section('typography_settings', [
            'label' => esc_html__('Typography Settings', 'senatory-master'),
            'tab' => Controls_Manager::TAB_STYLE
        ]);

		
		$this->add_group_control(Group_Control_Typography::get_type(), [
            'label' => esc_html__('Title Typography', 'senatory-core'),
            'name' => 'title_typography',
            'description' => esc_html__('select title typography', 'senatory-core'),
            'selector' => "{{WRAPPER}} .custom-testimonial-one-wrap .party-single-item.style-02 .content .title"
        ]);
		
		$this->add_group_control(Group_Control_Typography::get_type(), [
            'label' => esc_html__('Sub Title Typography', 'senatory-core'),
            'name' => 'sbtitle_typography',
            'description' => esc_html__('select sub title typography', 'senatory-core'),
            'selector' => "{{WRAPPER}} .custom-testimonial-one-wrap .party-single-item.style-02 .content .subtitle p"
        ]);
		
		
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'label' => esc_html__('Description Typography', 'senatory-core'),
            'name' => 'description_typography',
            'description' => esc_html__('select description typography', 'senatory-core'),
            'selector' => "{{WRAPPER}} .custom-testimonial-one-wrap .party-single-item.style-02 .content .quotes .description"
        ]);
		
		
		
        $this->end_controls_section();
        /* typography settings end */

    }

    /**
     * Render Elementor widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $all_header_items = $settings['testimonails_sliders'];
        $rand_numb = rand(333, 999999999);

        //slider settings
        $loop = $settings['loop'] ? 'true' : 'false';
        $items = $settings['items'] ? $settings['items'] : 1;
        $autoplay = $settings['autoplay'] ? 'true' : 'false';
        $nav = $settings['nav'] ? 'true' : 'false';
        $navleft = Senatory_core()->render_elementor_icons($settings['nav_left_arrow']);
        $navright = Senatory_core()->render_elementor_icons($settings['nav_right_arrow']);
        $autoplaytimeout = isset($settings['autoplaytimeout']['size']) ? $settings['autoplaytimeout']['size'] : '1000';
        ?>
        
        


  <!-- Testimonial Section Start -->
  <div class="custom-testimonial-one-wrap testimonial-section-area testimonial-bg"
    style="background-image: url(<?php echo esc_url($settings['bg_image']['url']); ?>);">

    <div class="container custom-container">
      <div class="row">
        <div class="col-lg-12">
          <div class="testimonial-carousel-area">



<div class="theme-carousel-testimonials testimonial-carousel-three testimonial-new-block-two"
     id="testimonials-areaa-carousell-<?php echo esc_attr($rand_numb); ?>"
     data-loop="<?php echo esc_attr($loop); ?>"
     data-margin="<?php echo esc_attr($settings['margin']['size']); ?>"
     data-items="<?php echo esc_attr($items); ?>"
     data-autoplay="<?php echo esc_attr($autoplay); ?>"
     data-nav="<?php echo esc_attr($nav); ?>"
     data-navleft="<?php echo esc_attr($navleft); ?>"
     data-navright="<?php echo esc_attr($navright); ?>"
     data-autoplaytimeout="<?php echo esc_attr($autoplaytimeout); ?>"
>


<?php
    foreach ($all_header_items as $item):
?>

              <div class="party-single-item style-02">
                <div class="content">
                  <div class="subtitle">
                    <p><?php echo esc_html($item['sub-title']) ?></p>
                    <div class="icon">
                      <i class="icon-star"></i>
                      <i class="icon-star"></i>
                      <i class="icon-star"></i>
                    </div>
                  </div>
                  <h4 class="title"><?php echo esc_html($item['title']) ?></h4>
                  <div class="quotes">
                    <p class="description"><?php echo esc_html($item['description']) ?></p>
                    <i class="icomoon-quotes"></i>
					<img src="<?php echo SENATORY_CORE_IMG.'/shape-02.png';?>" class="quotes-shape" alt="">
					
                  </div>
                  <div class="author-meta">
                    <span class="author-name"><?php echo esc_html($item['reviewer-name']) ?></span>
                    <span class="line"></span>
                  </div>
                </div>
              </div>

<?php endforeach; ?>


            </div>
          </div>
        </div>
      </div>
    </div>
  </div>


  <!-- Testimonial Secition End -->





        <?php
    }
}

Plugin::instance()->widgets_manager->register_widget_type(new Senatory_Testimonials_Slider_One_Widget());