<?php
/**
 * Elementor Widget
 * @package Senatory
 * @since 1.0.0
 */

namespace Elementor;
class Senatory_Counterup_One_Widget extends Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @return string Widget name.
	 * @since 1.0.0
	 * @access public
	 *
	 */
	public function get_name() {
		return 'senatory-counterup-one-widget';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @return string Widget title.
	 * @since 1.0.0
	 * @access public
	 *
	 */
	public function get_title() {
		return esc_html__( 'Counterup: 01', 'senatory-core' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @return string Widget icon.
	 * @since 1.0.0
	 * @access public
	 *
	 */
	public function get_icon() {
		return 'bl_icon eicon-archive-title';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @return array Widget categories.
	 * @since 1.0.0
	 * @access public
	 *
	 */
	public function get_categories() {
		return [ 'senatory_widgets' ];
	}

	/**
	 * Register Elementor widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function register_controls() {

		$this->start_controls_section(
			'settings_section',
			[
				'label' => esc_html__( 'General Settings', 'senatory-core' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'theme',
			[
				'label'       => esc_html__( 'Theme', 'senatory-core' ),
				'type'        => Controls_Manager::SELECT,
				'options'     => [
					'black' => esc_html__( 'Black', 'senatory-core' ),
					'white' => esc_html__( 'White', 'senatory-core' ),
				],
				'default'     => 'black',
				'description' => esc_html__( 'select theme.', 'senatory-core' )
			]
		);
		
		$this->add_control( 'title', [
			'label'       => esc_html__( 'Title', 'senatory-core' ),
			'type'        => Controls_Manager::TEXT,
			'default'     => esc_html__( 'Successfully Delivered', 'senatory-core' ),
			'description' => esc_html__( 'enter title', 'senatory-core' )
		] );
		
		$this->add_control( 'number', [
			'label'       => esc_html__( 'Number', 'senatory-core' ),
			'type'        => Controls_Manager::TEXT,
			'default'     => esc_html__( '25,007', 'senatory-core' ),
			'description' => esc_html__( 'enter counterup number', 'senatory-core' )
		] );
		
		$this->add_control( 'sign', [
			'label'       => esc_html__( 'sign', 'senatory-core' ),
			'type'        => Controls_Manager::TEXT,
			'default'     => esc_html__( '+', 'senatory-core' ),
			'description' => esc_html__( 'enter counterup sign', 'senatory-core' )
		] );
		
        if ( version_compare( ELEMENTOR_VERSION, '2.6.0', '>=' ) ) {
            $this->add_control(
                'icon',
                [
                    'label'       => esc_html__( 'Icon', 'senatory-core' ),
                    'type'        => Controls_Manager::ICONS,
                    'description' => esc_html__( 'select Icon.', 'senatory-core' ),
                    'default'     => [
                        'value'   => 'fas fa-star',
                        'library' => 'solid',
                    ]
                ]
            );
        } else {
            $this->add_control(
                'icon',
                [
                    'label'       => esc_html__( 'Icon', 'senatory-core' ),
                    'type'        => Controls_Manager::ICON,
                    'description' => esc_html__( 'select Icon.', 'senatory-core' ),
                ]
            );
        }

		
		$this->end_controls_section();

		$this->start_controls_section(
			'styling_settings_section',
			[
				'label' => esc_html__( 'Styling Settings', 'senatory-core' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		
        $this->add_control( 'icon_color', [
            'label'     => esc_html__( 'Icon Color', 'senatory-core' ),
            'type'      => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .single-counterup-01 .icon" => "color: {{VALUE}}"
            ]
        ] );
		
		
		$this->add_control( 'number_color', [
			'label'     => esc_html__( 'Number Color', 'senatory-core' ),
			'type'      => Controls_Manager::COLOR,
			'selectors' => [
				"{{WRAPPER}} .single-counterup-01 .content .count-wrap span" => "color: {{VALUE}}"
			]
		] );
		
		$this->add_control( 'sign_color', [
			'label'     => esc_html__( 'Sign Color', 'senatory-core' ),
			'type'      => Controls_Manager::COLOR,
			'selectors' => [
				"{{WRAPPER}} .single-counterup-01 .content .count-wrap" => "color: {{VALUE}}"
			]
		] );
		
		$this->add_control( 'title_color', [
			'label'     => esc_html__( 'Title Color', 'senatory-core' ),
			'type'      => Controls_Manager::COLOR,
			'selectors' => [
				"{{WRAPPER}} .single-counterup-01 .content .title" => "color: {{VALUE}}"
			]
		] );
		
		
		$this->end_controls_section();

		$this->start_controls_section(
			'typography_settings_section',
			[
				'label' => esc_html__( 'Typography Settings', 'senatory-core' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'number_typography',
				'label'    => esc_html__( 'Number Typography', 'senatory-core' ),
				'selector' => '{{WRAPPER}} .single-counterup-01 .count-wrap',
			]
		);
		
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'title_typography',
				'label'    => esc_html__( 'Title Typography', 'senatory-core' ),
				'selector' => '{{WRAPPER}} .single-counterup-01 .content .title',
			]
		);
		
		$this->end_controls_section();
	}

	/**
	 * Render Elementor widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {

		$settings = $this->get_settings_for_display();

		$title  = $settings['title'];
		$number = $settings['number'];
		
		$this->add_render_attribute( 'counterup_wrapper', 'class', 'single-counterup-01' );
		$this->add_render_attribute( 'counterup_wrapper', 'class', $settings['theme'] );

		?>
		
		
	<div class="single-counterup-01 style-04">
		<div class="content">
		<div class="count-wrap"><span class="count-num"><?php echo esc_html( $number ); ?></span><?php echo esc_html( $settings['sign'] ) ?></div>
		<h4 class="title"><?php echo esc_html( $title ); ?></h4>
		</div>
	</div>	
		
		
	
		<?php
		
		
	}
}

Plugin::instance()->widgets_manager->register_widget_type( new Senatory_Counterup_One_Widget() );