<?php
/**
 * Elementor Widget
 * @package Senatory
 * @since 1.0.0
 */

namespace Elementor;
class Senatory_Video_Widget extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'senatory-video-box';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Video Button Box', 'senatory-master');
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'bl_icon eicon-archive-title';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['senatory_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {

		$this->start_controls_section(
            'settings_heading',
            [
                'label' => esc_html__('General Settings', 'senatory-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
		
		
        $this->add_control('video_text_status',
            [
                'label' => esc_html__('Video Text Show/Hide', 'senatory-core'),
                'type' => Controls_Manager::SWITCHER,
                'description' => esc_html__('show/hide Video Text', 'senatory-core'),
                'default' => 'yes',
            ]);
			
			
        $this->add_control(
            'video-title',
            [
                'label' => esc_html__('Video Text', 'senatory-core'),
                'type' => Controls_Manager::TEXTAREA,
                'description' => esc_html__('enter  title.', 'senatory-core'),
                'default' => esc_html__('Watch the video', 'senatory-core'),
            ]
        );
		
		$this->add_control(
            'video-link',
            [
                'label' => esc_html__('Video Link', 'senatory-core'),
                'type' => Controls_Manager::URL,
                'description' => esc_html__('Enter video url.', 'senatory-core'),
                'default' => [
                    'url' => '#'
                ],
            ]
        );
		
		$this->add_control(
            'icon',
            [
                'label' => esc_html__('Play Icon', 'senatory-core'),
                'type' => Controls_Manager::ICONS,
                'description' => esc_html__('select Icon.', 'senatory-core'),
                'default' => [
                    'value' => 'fas fa-phone-alt',
                    'library' => 'solid',
                ],
            ]
        );
		
		

        $this->end_controls_section();

        $this->start_controls_section(
            'styling_heading',
            [
                'label' => esc_html__('Styling Settings', 'senatory-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
		
		
        $this->add_control('title_color', [
            'label' => esc_html__('Title Color', 'senatory-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .theme-custom-videobox.video-section span" => "color: {{VALUE}}"
            ]
        ]);
		
        $this->add_control('title_styling_divider', [
            'type' => Controls_Manager::DIVIDER
        ]);
		
		
		$this->add_control('icon_color', [
            'label' => esc_html__('Icon Color', 'senatory-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .theme-custom-videobox .video-play i" => "color: {{VALUE}}"
            ]
        ]);
		
        $this->end_controls_section();
		
        $this->start_controls_section(
            'styling_typogrpahy_heading',
            [
                'label' => esc_html__('Typography Settings', 'senatory-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
		
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'name' => 'title_typography',
            'label' => esc_html__('Title Typography', 'senatory-core'),
            'selector' => "{{WRAPPER}} .theme-custom-videobox.video-section span"
        ]);
		

        $this->end_controls_section();
		

    }

    /**
     * Render Elementor widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();

        ?>
        
		
		<div class="theme-custom-videobox video-section wow animate__animated animate__fadeInUp">
		
			<?php if (!empty($settings['video_text_status'])) : ?>
			<span><?php echo esc_html__($settings['video-title']) ?></span>
			<?php endif; ?>
			
			<a class="video-play style-01 mfp-iframe" href="<?php echo esc_url($settings['video-link']['url']) ?>">
			
				<?php
				Icons_Manager::render_icon($settings['icon'], ['aria-hidden' => 'true']);
				?>
					
			
			</a>
	  </div>
			  


        <?php
    }
}

Plugin::instance()->widgets_manager->register_widget_type(new Senatory_Video_Widget());