<?php
/**
 * Elementor Widget
 * @package Senatory
 * @since 1.0.0
 */

namespace Elementor;
class Senatory_Vision_Boxes_Widget extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'senatory-vision-box-widget';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Vision Boxes Area', 'senatory-master');
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'bl_icon eicon-archive-title';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['senatory_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {

        $this->start_controls_section(
            'settings_section',
            [
                'label' => esc_html__('Section Contents', 'senatory-master'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );


        $this->add_control(
            'box_bg_image',
            [
                'label' => esc_html__('Left Box Bg Image', 'senatory-core'),
                'type' => Controls_Manager::MEDIA,
                'show_label' => false,
                'description' => esc_html__('Upload background image', 'senatory-master'),
                'default' => [
                    'src' => Utils::get_placeholder_image_src()
                ],
            ]
        );


        $this->add_control(
            'title',
            [
                'label' => esc_html__('Title', 'senatory-core'),
                'type' => Controls_Manager::TEXT,
                'description' => esc_html__('enter title.', 'senatory-core'),
                'default' => esc_html__('Join The Fight for Our Freedom', 'senatory-core')
            ]
        );


        $this->add_control(
            'sub-title',
            [
                'label' => esc_html__('Sub Title', 'senatory-core'),
                'type' => Controls_Manager::TEXT,
                'description' => esc_html__('Enter Sub title.', 'senatory-core'),
                'default' => esc_html__('Our Party Visions', 'senatory-core')
            ]
        );


        $this->add_control(
            'btn-text',
            [
                'label' => esc_html__('Button Text', 'senatory-core'),
                'type' => Controls_Manager::TEXT,
                'description' => esc_html__('enter title.', 'senatory-core'),
                'default' => esc_html__('View More', 'senatory-core')
            ]
        );

        $this->add_control(
            'btn-link',
            [
                'label' => esc_html__('Button Link', 'senatory-core'),
                'type' => Controls_Manager::URL,
                'description' => esc_html__('Enter url.', 'senatory-core'),
                'default' => [
                    'url' => '#'
                ],
            ]
        );


        $this->end_controls_section();


        $this->start_controls_section(
            'boxx_section',
            [
                'label' => esc_html__('Vision Boxes', 'senatory-master'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );


        $repeater = new \Elementor\Repeater();


        $repeater->add_control(
            'box-title', [
                'label' => esc_html__('Title', 'senatory-master'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('We Will Win The Elections', 'senatory-master'),
                'description' => esc_html__('Enter title', 'senatory-master')
            ]
        );

        $repeater->add_control(
            'box-text', [
                'label' => esc_html__('Box Content', 'senatory-master'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('Together we can make Better country', 'senatory-master'),
                'description' => esc_html__('Enter box content', 'senatory-master')
            ]
        );

        $repeater->add_control(
            'icon', [
                'label' => esc_html__('Icon', 'senatory-master'),
                'type' => Controls_Manager::ICONS,
                'description' => esc_html__('Select Icon', 'senatory-master'),
                'default' => [
                    'value' => 'flaticon-statistics',
                    'library' => 'solid',
                ]
            ]
        );

        $this->add_control('boxvision_sliders', [
            'label' => esc_html__('Vision Box Items', 'senatory-master'),
            'type' => Controls_Manager::REPEATER,
            'fields' => $repeater->get_controls(),

            'default' => [
                [

                    'description' => esc_html__('President represented Delaware for 36 years in the US', 'senatory-master'),
                    'title' => esc_html__('Together we can make Better country', 'senatory-master'),
                ]
            ],

        ]);


        $this->end_controls_section();


        $this->start_controls_section(
            'css_styles',
            [
                'label' => esc_html__('Styling Settings', 'senatory-master'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control('slider_title_color', [
            'label' => esc_html__('Box Title Color', 'senatory-master'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .vision-single-item-wrapper .our-vision-single-item .content .title" => "color: {{VALUE}}"
            ]
        ]);


        $this->add_control('slider_subtitle_color', [
            'label' => esc_html__('Slider Sub Title Color', 'senatory-master'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .custom-testimonial-one-wrap .party-single-item.style-02 .content .subtitle p" => "color: {{VALUE}}"
            ]
        ]);


        $this->end_controls_section();


        /* button styling end */

        /* typography settings start */
        $this->start_controls_section('typography_settings', [
            'label' => esc_html__('Typography Settings', 'senatory-master'),
            'tab' => Controls_Manager::TAB_STYLE
        ]);


        $this->add_group_control(Group_Control_Typography::get_type(), [
            'label' => esc_html__('Title Typography', 'senatory-core'),
            'name' => 'title_typography',
            'description' => esc_html__('select title typography', 'senatory-core'),
            'selector' => "{{WRAPPER}} .vision-single-item-wrapper .our-vision-single-item .content .title"
        ]);


        $this->add_group_control(Group_Control_Typography::get_type(), [
            'label' => esc_html__('Description Typography', 'senatory-core'),
            'name' => 'description_typography',
            'description' => esc_html__('select description typography', 'senatory-core'),
            'selector' => "{{WRAPPER}} .vision-single-item-wrapper .our-vision-single-item .content p"
        ]);


        $this->end_controls_section();
        /* typography settings end */

    }

    /**
     * Render Elementor widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $all_header_items = $settings['boxvision_sliders'];

        ?>


        <!-- Header bottom Section Start -->
        <div class="header-bottom-area">
            <div class="container custom-container">
                <div class="political-header-bottom m-top-02">
                    <div class="row">
                        <div class="col-lg-4 col-md-12">
                            <div class="our-vision-item wow animate__animated animate__fadeInLeft">
                                <div class="vision-bg"
                                     style="background-image: url(<?php echo esc_url($settings['box_bg_image']['url']); ?>);">
                                    <div class="content">
                                        <div class="subtitle">
                                            <p><?php echo esc_html($settings['sub-title']) ?></p>
                                            <div class="icon">
                                                <i class="icomoon-star"></i>
                                                <i class="icomoon-star"></i>
                                                <i class="icomoon-star"></i>
                                            </div>
                                        </div>
                                        <h4 class="title"><?php echo esc_html($settings['title']) ?></h4>
                                        <div class="btn-wrapper">
                                            <a href="<?php echo esc_url($settings['btn-link']['url']) ?>"
                                               class="boxed-btn btn-sanatory style-01 reverse"><i
                                                        class="fas fa-arrow-right"></i><?php echo esc_html($settings['btn-text']) ?>
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-8">
                            <div class="vision-single-item-wrapper">
                                <div class="row">
                                    <?php
                                    foreach ($all_header_items as $item):
                                        ?>
                                        <div class="col-lg-6 col-md-6">
                                            <div class="our-vision-single-item  wow animate__animated animate__fadeInUp">
                                                <div class="icon vision-box-icon">
                                                    <?php
                                                    Icons_Manager::render_icon($item['icon'], ['aria-hidden' => 'true']);
                                                    ?>
                                                </div>
                                                <div class="content">
                                                    <h4 class="title"><?php echo esc_html($item['box-title']) ?></h4>
                                                    <p><?php echo wp_kses_post($item['box-text']); ?></p>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endforeach; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Header bottom section end -->


        <?php
    }
}

Plugin::instance()->widgets_manager->register_widget_type(new Senatory_Vision_Boxes_Widget());