<?php
/**
 * Elementor Widget
 * @package Senatory
 * @since 1.0.0
 */

namespace Elementor;
class Senatory_Why_Choose2_Area_Widget extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'senatory-why-choosearea2-widget';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Why Choose Area Two', 'senatory-master');
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'bl_icon eicon-archive-title';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['senatory_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {

        $this->start_controls_section(
            'settings_section',
            [
                'label' => esc_html__('Section Contents', 'senatory-master'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );


        $this->add_control(
            'box_bg_imagee',
            [
                'label' => esc_html__('Box Bg Image', 'senatory-core'),
                'type' => Controls_Manager::MEDIA,
                'show_label' => false,
                'description' => esc_html__('Upload background image', 'senatory-master'),
                'default' => [
                    'src' => Utils::get_placeholder_image_src()
                ],
            ]
        );

        $this->add_control(
            'left_bg_image',
            [
                'label' => esc_html__('Left Image', 'senatory-core'),
                'type' => Controls_Manager::MEDIA,
                'show_label' => false,
                'description' => esc_html__('Upload background image', 'senatory-master'),
                'default' => [
                    'src' => Utils::get_placeholder_image_src()
                ],
            ]
        );


        $this->add_control(
            'title',
            [
                'label' => esc_html__('Title', 'senatory-core'),
                'type' => Controls_Manager::TEXT,
                'description' => esc_html__('enter title.', 'senatory-core'),
                'default' => esc_html__('Join The Fight for Our Freedom', 'senatory-core')
            ]
        );


        $this->add_control(
            'sub-title',
            [
                'label' => esc_html__('Sub Title', 'senatory-core'),
                'type' => Controls_Manager::TEXT,
                'description' => esc_html__('Enter Sub title.', 'senatory-core'),
                'default' => esc_html__('Our Party Visions', 'senatory-core')
            ]
        );


        $this->end_controls_section();


        $this->start_controls_section(
            'boxx_section',
            [
                'label' => esc_html__('Choose Boxes', 'senatory-master'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );


        $repeater = new \Elementor\Repeater();


        $repeater->add_control(
            'box-title', [
                'label' => esc_html__('Title', 'senatory-master'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('We Will Win The Elections', 'senatory-master'),
                'description' => esc_html__('Enter title', 'senatory-master')
            ]
        );

        $repeater->add_control(
            'box-text', [
                'label' => esc_html__('Box Content', 'senatory-master'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('Together we can make Better country', 'senatory-master'),
                'description' => esc_html__('Enter box content', 'senatory-master')
            ]
        );

        $repeater->add_control(
            'icon', [
                'label' => esc_html__('Icon', 'senatory-master'),
                'type' => Controls_Manager::ICONS,
                'description' => esc_html__('Select Icon', 'senatory-master'),
                'default' => [
                    'value' => 'icon-tips-bulb',
                    'library' => 'solid',
                ]
            ]
        );

        $this->add_control('boxvision_sliders', [
            'label' => esc_html__('Choose Box Items', 'senatory-master'),
            'type' => Controls_Manager::REPEATER,
            'fields' => $repeater->get_controls(),

            'default' => [
                [

                    'description' => esc_html__('Every pleasures is to welcomed pain avoided owing to the dutythe obligations of business', 'senatory-master'),
                    'title' => esc_html__('Smart Thinking', 'senatory-master'),
                ]
            ],

        ]);


        $this->end_controls_section();


        $this->start_controls_section(
            'content_sty',
            [
                'label' => __('Style', 'senatory-master'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
  
   
        $this->add_control(
            'post_title_color',    
            [
                'label' => __('Title Color', 'senatory-master'),
                'type' => \Elementor\Controls_Manager::COLOR,        
                'selectors' => [
                    '{{WRAPPER}} .section-title .title.style-01, {{WRAPPER}} .why-choose-us-section .single-items-wrapper .why-choose-single-items .content .title' => 'color: {{VALUE}}',
                ],
            ]
        );


        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'ttih',
                'label' => __('Title Typography', 'senatory-master'),
                'selector' => '.section-title .title.style-01, {{WRAPPER}} .why-choose-us-section .single-items-wrapper .why-choose-single-items .content .title',
            ]
        );

        $this->add_control(
            'content_color',    
            [
                'label' => __('Content Color', 'senatory-master'),
                'type' => \Elementor\Controls_Manager::COLOR,        
                'selectors' => [
                    '{{WRAPPER}} .why-choose-us-section .single-items-wrapper .why-choose-single-items .content p' => 'color: {{VALUE}}',
                ],
            ]
        );


           $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'tctih',
                'label' => __('Content Typography', 'senatory-master'),   
                'selector' => '{{WRAPPER}} .why-choose-us-section .single-items-wrapper .why-choose-single-items .content p',
            ]
        );

        $this->add_control(
            'card_bg',
            [
                'label' => esc_html__( 'Card Background', 'senatory-core' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'cv_bpg',
                'label' => esc_html__('Card Background', 'senatory-master'),
                'types' => [ 'classic', 'gradient' ],
                'selector' => '{{WRAPPER}} .why-choose-us-section .single-items-wrapper .why-choose-single-items',

            ]
        );


        $this->add_control(
            'c_hoover',
            [
                'label' => esc_html__( 'Item Card Hover', 'senatory-core' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'cv_v_bg',
                'label' => esc_html__('Card Hover', 'senatory-master'),
                'types' => [ 'classic', 'gradient' ],
                'selector' => '{{WRAPPER}} .why-choose-us-section .single-items-wrapper .why-choose-single-items:hover',

            ]
        );


 
        $this->end_controls_section();
        /* typography settings end */

    }

    /**
     * Render Elementor widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $all_header_items = $settings['boxvision_sliders'];

        ?>
  <!-- Why Choose us secion Start here -->
  <div class="why-choose-us-section style-02 choose-bg" style="background-image: url(<?php echo esc_url($settings['box_bg_imagee']['url']); ?>);">
    <div class="choose-bg-03" style="background-image: url(<?php echo esc_url($settings['left_bg_image']['url']); ?>);"></div>
        <div class="container nav-container">
            <div class="row justify-content-end">
                <div class="col-lg-5">
                    <div class="section-title">
                      <h4 class="title style-01"><?php echo esc_html($settings['title']) ?></h4>
                      <p class="description style-01"><?php echo esc_html($settings['sub-title']) ?></p>
                    </div>
                    <div class="single-items-wrapper">

                    	<?php
                          foreach ($all_header_items as $item):
                          ?>
                      <div class="why-choose-single-items wow animate__animated animate__fadeInUp">
                          <div class="icon">
                            <?php
                                Icons_Manager::render_icon($item['icon'], ['aria-hidden' => 'true']);
                                ?>
                          </div>
                          <div class="content">
                            <h4 class="title"><?php echo esc_html($item['box-title']) ?></h4>
                            <p><?php echo esc_html($item['box-text']) ?></p>
                          </div>
                          <img src="<?php echo SENATORY_CORE_IMG . '/setting-shape.png'; ?>" class="shape" alt="">
                      </div>
                      <?php endforeach; ?>
            
                 
                  </div>
                </div>
            </div>
        </div>
  </div>
  <!-- Why Choose us secion End here -->
  


        <?php
    }
}

Plugin::instance()->widgets_manager->register_widget_type(new Senatory_Why_Choose2_Area_Widget());