<?php
/**
 * Elementor Widget
 * @package Senatory
 * @since 1.0.0
 */

namespace Elementor;
class Senatory_footers_wie_widget extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'senatory-footer-widget';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Footer widget', 'senatory-master');
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'bl_icon eicon-archive-title';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['senatory_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {

        $this->start_controls_section(
            'settings_section',
            [
                'label' => esc_html__('Section Contents', 'senatory-master'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );


    $this->add_control(
            'title',
            [
                'label' => __('Title', 'senatory-core'),
                'type' => Controls_Manager::TEXT,
                'label_block'=>true,
                'default' => __('Menu Title', 'senatory-core'),
            ]
        );

            $this->add_control(
            'main_nav',
            [
                'label' => __('Main Menu', 'senatory-core'),
                'type' => Controls_Manager::SELECT2,
                'options' =>  senatory_core()->king_menu_select_choices(),
                'multiple' => false,
                'label_block' => true,
            ]
        );

        $this->end_controls_section();

    $this->start_controls_section(
            'content_sty',
            [
                'label' => __('Style', 'senatory-master'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
  
   
        $this->add_control(
            'post_title_color',    
            [
                'label' => __('Title Color', 'senatory-master'),
                'type' => \Elementor\Controls_Manager::COLOR,        
                'selectors' => [
                    '{{WRAPPER}} .widget.footer-widget .widget-title' => 'color: {{VALUE}}',
                ],
            ]
        );


        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'ttih',
                'label' => __('Title Typography', 'senatory-master'),
                'selector' => '{{WRAPPER}} .widget.footer-widget .widget-title',
            ]
        );

        $this->add_control(
            'content_color',    
            [
                'label' => __('Content Color', 'senatory-master'),
                'type' => \Elementor\Controls_Manager::COLOR,        
                'selectors' => [
                    '{{WRAPPER}} .widget.footer-widget ul li a' => 'color: {{VALUE}}',
                ],
            ]
        );


           $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'tctih',
                'label' => __('Content Typography', 'senatory-master'),   
                'selector' => '{{WRAPPER}} .widget.footer-widget ul li a',
            ]
        );

 
        $this->end_controls_section();

    }

    /**
     * Render Elementor widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();
         $main_menu = $settings['main_nav'];
		
        ?>
      <div class="footer-widget widget widget_nav_menu">
        <h4 class="widget-title">
          <?php echo ($settings['title']); ?>
          <span class="line">
            <span class="dot"></span>
            <span class="dot"></span>
            <span class="dot style-02"></span>
            <span class="dot"></span>
            <span class="dot"></span>
          </span>
        </h4>
       <?php
            wp_nav_menu(array(
                'menu' =>    $main_menu,
                'item_wraper' => '<ul class="%2$s">3$s</ul>' 
            ));
            ?>
      </div>
        <?php
    }
}

Plugin::instance()->widgets_manager->register_widget_type(new Senatory_footers_wie_widget());