<?php

/**
 * Elementor Addons Init
 * @package senatory
 * @since 1.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit(); // exit if access directly
}


if ( ! class_exists( 'Senatory_Elementor_Widget_Init' ) ) {

	class Senatory_Elementor_Widget_Init {
	   /**
		* $instance
		* @since 1.0.0
		*/
		private static $instance;

	   /**
		* construct()
		* @since 1.0.0
		*/
		public function __construct() {
			add_action( 'elementor/elements/categories_registered', array( $this, '_widget_categories' ) );
			//elementor widget registered
			add_action( 'elementor/widgets/widgets_registered', array( $this, '_widget_registered' ) );
			// elementor editor css
			add_action( 'elementor/editor/after_enqueue_scripts', array( $this, 'load_assets_for_elementor' ) );
			//add icon to elementor new icons fileds
			add_filter( 'elementor/icons_manager/native', array( $this, 'add_custom_icon_to_elementor_icons' ) );
		}

		/**
	     * getInstance()
	     * @since 1.0.0
	     */
		public static function getInstance() {
			if ( null == self::$instance ) {
				self::$instance = new self();
			}

			return self::$instance;
		}

		/**
		 * _widget_categories()
		 * @since 1.0.0
		 */
		public function _widget_categories( $elements_manager ) {
			$elements_manager->add_category(
				'senatory_widgets',
				[
					'title' => esc_html__( 'Senatory Widgets', 'senatory-core' ),
					'icon'  => 'fas fa-plug',
				]
			);
		}

		/**
		 * _widget_registered()
		 * @since 1.0.0
		 */
		public function _widget_registered() {
			if ( ! class_exists( 'Elementor\Widget_Base' ) ) {
				return;
			}
			
			$elementor_widgets = array(
				'avatar-video',
				'about-section-two',
				'contact-info-list',
				'donation-button-one',
				'donation-grid-one',
				'donation-grid-two',
				'countdown-one',
				'icon-box-one',
				'icon-box-service-two',
				'home-slider-one',
				'services-box',
				'heading-title',
				'video-box',
				'events-grid',
				'events-grid-two',
				'events-grid-three',
				'events-grid-four',
				'home-slider-three',
				'features-box',
				'img-box-quote',
				'events-list',
				'events-list-two',
				'gallery-img',
				'testimonial-four',
				'testimonial-five',
				'list-box-one',
				'events-campaign',
				'icon-box-event',
				'team-slider',
				'team-slider-three',
				'theme-counterup',
				'testimonial-one',
				'home-banner-one',
				'home-banner-two',
				'vision-box',
				'vision-box-one',
				'join-party-section',
				'team-slider-two',
				'testimonial-two',
				'blog-grid-section',
				'blog-grid-two',
				'blog-video-grid',
				'blog-list-section',
				'why-choose-section',
				'why-choose-section2',
				'about-section',
				'accordion',
				'history-timeline',
				'principles-info-box',
				'testimonial-three',
				'audio-box',
				'gallery-carousel',
				'video-slider',
				'issue-grid',
				'issue-grid-two',
				'issue-list',
				'contact-info',
				'principles-quick-list',
				'small-info-box',
				'progressbar-section',
				'icon-box-service',
				'our-journey',
				'team-box',
				'team-box-two',
				'banner-five-section',
				'newsletter-section',
				'widgets-section',
				'event-section',
				'scroll-section',
				'quote-post',
				'quoate-heading',

				
			);

			$elementor_widgets = apply_filters( 'senatory_elementor_widget', $elementor_widgets );
			ksort( $elementor_widgets );
			if ( is_array( $elementor_widgets ) && ! empty( $elementor_widgets ) ) {
				foreach ( $elementor_widgets as $widget ) {
					if ( file_exists( SENATORY_CORE_ELEMENTOR . '/addons/elementor-' . $widget . '-widget.php' ) ) {
						require_once SENATORY_CORE_ELEMENTOR . '/addons/elementor-' . $widget . '-widget.php';
					}
				}
			}
		}

		public function add_custom_icon_to_elementor_icons( $icons ) {
			$icons['icomoon'] = [
				'name'          => 'icomoon',
				'label'         => esc_html__( 'icomoon', 'senatory-core' ),
				'url'           => SENATORY_CORE_CSS . '/icomoon.css',
				// icon css file
				'enqueue'       => [ SENATORY_CORE_CSS . '/icomoon.css' ],
				// icon css file
				'prefix'        => 'icomoon-',
				//prefix ( like fas-fa  )
				'displayPrefix' => '',
				//prefix to display icon
				'labelIcon'     => 'icomoon-Anywhere',
				//tab icon of elementor icons library
				'ver'           => '1.0.0',
				'fetchJson'     => SENATORY_CORE_JS . '/icomoon.js',
				//json file with icon list example {"icons: ['icon class']}
				'native'        => true,
			];

			return $icons;
		}

		/**
		 * load custom assets for elementor
		 * @since 1.0.0
		 */
		public function load_assets_for_elementor() {
			wp_enqueue_style( 'icomoon', SENATORY_CORE_CSS . '/icomoon.css' );
			wp_enqueue_style( 'senatory-core-elementor-style', SENATORY_CORE_ADMIN_ASSETS . '/css/elementor-editor.css' );
		}
	}

	if ( class_exists( 'Senatory_Elementor_Widget_Init' ) ) {
		Senatory_Elementor_Widget_Init::getInstance();
	}
}//end if
