<?php
/**
 * Theme Core Init
 * @package senatory
 * @since 1.0.0
 */

if (!defined("ABSPATH")) {
	exit(); //exit if access directly
}

if (!class_exists('Senatory_Core_Init')) {

	class Senatory_Core_Init
	{
	   /**
        * $instance
        * @since 1.0.0
        */
		protected static $instance;

		public function __construct()
		{
			//Load plugin assets
			add_action('wp_enqueue_scripts', array($this, 'plugin_assets'));
			//Load plugin admin assets
			add_action('admin_enqueue_scripts', array($this, 'admin_assets'));
			//load plugin text domain
			add_action('init', array($this, 'load_textdomain'));
			//add custom icon to codester framework
			add_filter('csf_field_icon_add_icons', array($this, 'csf_custom_icon'));
			//load plugin dependency files()
            add_action('plugin_loaded', array($this, 'load_plugin_dependency_files'));
		}

	   /**
        * getInstance()
        * @since 1.0.0
        */
		public static function getInstance()
		{
			if (null == self::$instance) {
				self::$instance = new self();
			}
			return self::$instance;
		}

		/**
		 * Load Plugin Text domain
		 * @since 1.0.0
		 */
		public function load_textdomain()
		{
			load_plugin_textdomain('senatory-core', false, SENATORY_CORE_ROOT_PATH . '/languages');
		}

		/**
		 * Load plugin dependency files()
		 * @since 1.0.0
		 */
		public function load_plugin_dependency_files()
		{
			$includes_files = array(
				array(
					'file-name' => 'codestar-framework',
					'folder-name' => SENATORY_CORE_LIB . '/codestar-framework'
				),
				array(
					'file-name' => 'theme-menu-page',
					'folder-name' => SENATORY_CORE_ADMIN
				),
				array(
					'file-name' => 'theme-custom-post-type',
					'folder-name' => SENATORY_CORE_ADMIN
				),
				array(
					'file-name' => 'theme-post-column-customize',
					'folder-name' => SENATORY_CORE_ADMIN
				),
				array(
					'file-name' => 'theme-senatory-core-excerpt',
					'folder-name' => SENATORY_CORE_INC
				),
				array(
					'file-name' => 'csf-taxonomy',
					'folder-name' => SENATORY_CORE_INC
				),
				array(
					'file-name' => 'theme-core-shortcodes',
					'folder-name' => SENATORY_CORE_INC
				),
				array(
					'file-name' => 'elementor-widget-init',
					'folder-name' => SENATORY_CORE_ELEMENTOR
				),
                array(
                    'file-name' => 'theme-social-share-widget',
                    'folder-name' => SENATORY_CORE_WP_WIDGETS
                ),
                array(
                    'file-name' => 'theme-about-me-widget',
                    'folder-name' => SENATORY_CORE_WP_WIDGETS
                ),
                array(
                    'file-name' => 'theme-post-search-widget',
                    'folder-name' => SENATORY_CORE_WP_WIDGETS
                ),
                array(
                    'file-name' => 'theme-post-tags-menu',
                    'folder-name' => SENATORY_CORE_WP_WIDGETS
                ),
				array(
					'file-name' => 'theme-recent-post-widget',
					'folder-name' => SENATORY_CORE_WP_WIDGETS
				),
				array(
					'file-name' => 'theme-contact-info-widget',
					'folder-name' => SENATORY_CORE_WP_WIDGETS
				),
                array(
                    'file-name' => 'theme-service-category-widget',
                    'folder-name' => SENATORY_CORE_WP_WIDGETS
                ),
                array(
                    'file-name' => 'theme-request-form-widget',
                    'folder-name' => SENATORY_CORE_WP_WIDGETS
                ),
                array(
                    'file-name' => 'theme-post-category-widget',
                    'folder-name' => SENATORY_CORE_WP_WIDGETS
                ),
				array(
					'file-name' => 'theme-demo-data-import',
					'folder-name' => SENATORY_CORE_DEMO_IMPORT
				),
			);

            if (defined('ELEMENTOR_VERSION')) {
                $includes_files[] = array(
                    'file-name' => 'theme-elementor-icon-manager',
                    'folder-name' => SENATORY_CORE_INC
                );
            }
			if (is_array($includes_files) && !empty($includes_files)) {
				foreach ($includes_files as $file) {
					if (file_exists($file['folder-name'] . '/' . $file['file-name'] . '.php')) {
						require_once $file['folder-name'] . '/' . $file['file-name'] . '.php';
					}
				}
			}
		}

		/**
		 * Admin assets
		 * @since 1.0.0
		 */
		public function plugin_assets()
		{
			self::load_plugin_css_files();
			self::load_plugin_js_files();
		}

		/**
		 * Load plugin css files()
		 * @since 1.0.0
		 */
		public function load_plugin_css_files()
		{
			$plugin_version = SENATORY_CORE_VERSION;
			$all_css_files = array(
				array(
					'handle' => 'icomoon',
					'src' => SENATORY_CORE_CSS . '/icomoon.css',
					'deps' => array(),
					'ver' => $plugin_version,
					'media' => 'all'
				),
				array(
					'handle' => 'owl-carousel',
					'src' => SENATORY_CORE_CSS . '/owl.carousel.min.css',
					'deps' => array(),
					'ver' => $plugin_version,
					'media' => 'all'
				),
                array(
                    'handle' => 'slick',
                    'src' => SENATORY_CORE_CSS . '/slick.css',
                    'deps' => array(),
                    'ver' => $plugin_version,
                    'media' => 'all'
                ),
				array(
					'handle' => 'fontawesome',
					'src' => SENATORY_CORE_CSS . '/font-awesome.min.css',
					'deps' => array(),
					'ver' => '5.12.0',
					'media' => 'all'
				),
				array(
					'handle' => 'senatory-core-main-style',
					'src' => SENATORY_CORE_CSS . '/main-style.css',
					'deps' => array(),
					'ver' => $plugin_version,
					'media' => 'all'
				)
			);
			
			if (!senatory_core()->is_senatory_active()) {
				$all_css_files[] = array(
					'handle' => 'animate',
					'src' => SENATORY_CORE_CSS . '/animate.css',
					'deps' => array(),
					'ver' => $plugin_version,
					'media' => 'all'
				);
				$all_css_files[] = array(
					'handle' => 'bootstrap',
					'src' => SENATORY_CORE_CSS . '/bootstrap.min.css',
					'deps' => array(),
					'ver' => $plugin_version,
					'media' => 'all'
				);
				$all_css_files[] = array(
					'handle' => 'magnific-popup',
					'src' => SENATORY_CORE_CSS . '/magnific-popup.css',
					'deps' => array(),
					'ver' => $plugin_version,
					'media' => 'all'
				);
				$all_css_files[] = array(
					'handle' => 'senatory-main-style',
					'src' => SENATORY_CORE_CSS . '/theme-style.css',
					'deps' => array(),
					'ver' => $plugin_version,
					'media' => 'all'
				);
				$all_css_files[] = array(
					'handle' => 'senatory-responsive',
					'src' => SENATORY_CORE_CSS . '/theme-responsive.css',
					'deps' => array(),
					'ver' => $plugin_version,
					'media' => 'all'
				);
			}
			$all_css_files = apply_filters('senatory_core_css', $all_css_files);

			if (is_array($all_css_files) && !empty($all_css_files)) {
				foreach ($all_css_files as $css) {
					call_user_func_array('wp_enqueue_style', $css);
				}
			}
		}

		/**
		 * Load plugin js
		 * @since 1.0.0
		 */
		public function load_plugin_js_files()
		{
			$plugin_version = SENATORY_CORE_VERSION;
	

			$scripts = [
            ['handle' => 'bootstrap', 'src'=> SENATORY_CORE_JS . '/bootstrap.min.js','dep'=> array( 'jquery' ),'version'=> $plugin_version,'in_foot'=> true],
            ['handle' => 'magnific-popup', 'src'=> SENATORY_CORE_JS . '/jquery.magnific-popup.js','dep'=> array( 'jquery' ),'version'=> $plugin_version,'in_foot'=> true],
            ['handle' => 'popper', 'src'=> SENATORY_CORE_JS . '/popper.min.js','dep'=> array( 'jquery' ),'version'=> $plugin_version,'in_foot'=> true],

            ['handle' => 'slick', 'src'=> SENATORY_CORE_JS . '/slick.min.js', 'dep'=> array( 'jquery' ),'version'=> $plugin_version,'in_foot'=> true],

            ['handle' => 'owl-carousel', 'src'=> SENATORY_CORE_JS . '/owl.carousel.min.js', 'dep'=> array( 'jquery' ),'version'=> $plugin_version,'in_foot'=> true],

            ['handle' => 'rProgressbar', 'src'=> SENATORY_CORE_JS . '/jQuery.rProgressbar.min.js', 'dep'=> array( 'jquery' ),'version'=> $plugin_version,'in_foot'=> true],

            ['handle' => 'countdown', 'src'=> SENATORY_CORE_JS . '/jquery.countdown.min.js', 'dep'=> array( 'jquery' ),'version'=> $plugin_version,'in_foot'=> true],

            ['handle' => 'counterup', 'src'=> SENATORY_CORE_JS . '/jquery.counterup.min.js', 'dep'=> array( 'jquery' ),'version'=> $plugin_version,'in_foot'=> true],

            ['handle' => 'waypoints', 'src'=> SENATORY_CORE_JS . '/waypoints.min.js', 'dep'=> array( 'jquery' ),'version'=> $plugin_version,'in_foot'=> true],

            ['handle' => 'wow', 'src'=> SENATORY_CORE_JS . '/wow.min.js', 'dep'=> array( 'jquery' ),'version'=> $plugin_version,'in_foot'=> true],

            ['handle' => 'senatory-core-main-script', 'src'=> SENATORY_CORE_JS . '/main.js','dep'=> array( 'jquery' ),'version'=> $plugin_version,'in_foot'=> true]
            ];

			for ($i=0; $i < sizeof($scripts); $i++) {
                wp_enqueue_script( $scripts[$i]['handle'], $scripts[$i]['src'], $scripts[$i]['dep'], $scripts[$i]['version'], $scripts[$i]['in_foot'] );    
            }
		}

		/**
		 * Admin assets
		 * @since 1.0.0
		 */
		public function admin_assets()
		{
			self::load_admin_css_files();
			self::load_admin_js_files();
		}

		/**
		 * Load plugin admin css files()
		 * @since 1.0.0
		 */
		public function load_admin_css_files()
		{
			$plugin_version = SENATORY_CORE_VERSION;
			$all_css_files = array(
				array(
					'handle' => 'senatory-core-admin-style',
					'src' => SENATORY_CORE_ADMIN_ASSETS . '/css/admin.css',
					'deps' => array(),
					'ver' => $plugin_version,
					'media' => 'all'
				),
				array(
					'handle' => 'icomoon',
					'src' => SENATORY_CORE_CSS . '/icomoon.css',
					'deps' => array(),
					'ver' => $plugin_version,
					'media' => 'all'
				),
			);

			$all_css_files = apply_filters('senatory_admin_css', $all_css_files);
			if (is_array($all_css_files) && !empty($all_css_files)) {
				foreach ($all_css_files as $css) {
					call_user_func_array('wp_enqueue_style', $css);
				}
			}
		}

		/**
		 * Load plugin admin js
		 * @since 1.0.0
		 */
		public function load_admin_js_files()
		{
			

			$plugin_version = SENATORY_CORE_VERSION;

			$scripts = [
            ['handle' => 'bootstrap', 'src'=> SENATORY_CORE_ADMIN_ASSETS . '/js/widget.js','dep'=> array( 'jquery' ),'version'=> $plugin_version,'in_foot'=> true]
            ];
		
			for ($i=0; $i < sizeof($scripts); $i++) {
                wp_enqueue_script( $scripts[$i]['handle'], $scripts[$i]['src'], $scripts[$i]['dep'], $scripts[$i]['version'], $scripts[$i]['in_foot'] );    
            }
		}

		/**
		 * Add Custom Icon To Codester Framework
		 * @since 1.0.0
		 */
		public function csf_custom_icon($icons)
		{
			//adding new icon
			$icons[]  = array(
				'title' => esc_html__('Icomoon', 'senatory-core'),
				'icons' => array(
					'icomoon-phone',
					'icomoon-star',
					'icomoon-envelope',
					'paper-plan',
					'location',
				)
			);

			$icons = array_reverse($icons);

			return $icons;
		}
	} //end class
	if (class_exists('Senatory_Core_Init')) {
		Senatory_Core_Init::getInstance();
	}
}
