<?php
/*
Plugin Name: Senatory Core
Plugin URI: https://themeforest.net/user/themeim/portfolio
Description: Plugin to contain short codes and custom post types of the Senatory theme.
Author: Themeim
Author URI: https://themeim.com/
Version: 2.1.0
Text Domain: senatory-core
*/


/**
 * If this file is called directly, abort.
 * @package senatory
 * @since 1.0.0
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}


/**
 * Plugin directory path
 * @package senatory
 * @since 1.0.0
 */
define( 'SENATORY_CORE_ROOT_PATH', plugin_dir_path( __FILE__ ) );
define( 'SENATORY_CORE_ROOT_URL', plugin_dir_url( __FILE__ ) );
define( 'SENATORY_CORE_SELF_PATH', 'senatory-core/senatory-core.php' );
define( 'SENATORY_CORE_VERSION', '2.1.0' );
define( 'SENATORY_CORE_INC', SENATORY_CORE_ROOT_PATH .'/inc');
define( 'SENATORY_CORE_LIB', SENATORY_CORE_ROOT_PATH .'/lib');
define( 'SENATORY_CORE_ELEMENTOR', SENATORY_CORE_ROOT_PATH .'/elementor');
define( 'SENATORY_CORE_DEMO_IMPORT', SENATORY_CORE_ROOT_PATH .'/demo-import');
define( 'SENATORY_CORE_ADMIN', SENATORY_CORE_ROOT_PATH .'/admin');
define( 'SENATORY_CORE_ADMIN_ASSETS', SENATORY_CORE_ROOT_URL .'admin/assets');
define( 'SENATORY_CORE_WP_WIDGETS', SENATORY_CORE_ROOT_PATH .'/wp-widgets');
define( 'SENATORY_CORE_ASSETS', SENATORY_CORE_ROOT_URL .'assets/');
define( 'SENATORY_CORE_CSS', SENATORY_CORE_ASSETS .'css');
define( 'SENATORY_CORE_JS', SENATORY_CORE_ASSETS .'js');
define( 'SENATORY_CORE_IMG', SENATORY_CORE_ASSETS .'img');


/**
 * Load additional helpers functions
 * @package senatory
 * @since 1.0.0
 */
if (!function_exists('senatory_core')){
	require_once SENATORY_CORE_INC .'/theme-core-helper-functions.php';
	if (!function_exists('senatory_core')){
		function senatory_core(){
			return class_exists('Senatory_Core_Helper_Functions') ? new Senatory_Core_Helper_Functions() : false;
		}
	}
}
//ob flash
remove_action( 'shutdown', 'wp_ob_end_flush_all', 1 );


/**
 * Load Codestar Framework Functions
 * @package senatory
 * @since 1.0.0
 */
if ( !senatory_core()->is_senatory_active()) {
	if ( file_exists( SENATORY_CORE_ROOT_PATH . '/inc/csf-functions.php' ) ) {
		require_once SENATORY_CORE_ROOT_PATH . '/inc/csf-functions.php';
	}
}



/**
 * Core Plugin Init
 * @package senatory
 * @since 1.0.0
 */
if ( file_exists( SENATORY_CORE_ROOT_PATH . '/inc/theme-core-init.php' ) ) {
	require_once SENATORY_CORE_ROOT_PATH . '/inc/theme-core-init.php';
}