<?php
/**
 * Theme Request Form Widget
 * @package Senatory
 * @since 1.0.0
 */

if (!defined('ABSPATH')) {
    exit(); //exit if access directly
}
// Control core classes for avoid errors
if (class_exists('CSF')) {


    // Create a About Widget
    CSF::createWidget('senatory_request_form_widget', array(
        'title' => esc_html__('Senatory: Request Form', 'senatory-core'),
        'classname' => 'request-form-widget',
        'description' => esc_html__('Display Request Form widget', 'senatory-core'),
        'fields' => array(
            array(
                'id' => 'background-image',
                'type' => 'media',
                'title' => esc_html__('Upload Your Photo', 'senatory-core'),
            ),
            array(
                'id' => 'heading',
                'type' => 'text',
                'title' => esc_html__('Enter Your Header Title', 'senatory-core'),
                'default' => esc_html__('Never Miss News', 'senatory-core')
            ),
            array(
                'id' => 'senatory_contact_form_id',
                'type'        => 'select',
                'title' => esc_html__('Contact Form', 'senatory-core'),
                'options' => senatory_core()->get_contact_form_shortcode_list_el(),
            ),
        )
    ));


    if (!function_exists('senatory_request_form_widget')) {
        function senatory_request_form_widget($args, $instance)
        {

            echo $args['before_widget'];

            $instance['background-image'];
            $bg_image = $instance['logo-area'];
            $img_id = $bg_image['id'] ?? '';
            $img_print = $img_id ? wp_get_attachment_image_src($img_id)[0] : '';
            $heading_title = $instance['heading'] ?? '';
            $shortcode = $instance['senatory_contact_form_id'];

            ?>
                <h4 class="widget-headline"><?php echo esc_html($heading_title); ?></h4>
                 <div class="request-form">
                    <?php
                    echo do_shortcode('[contact-form-7  id="' . $shortcode . '"]');
                    ?>
                </div>

            <?php

            echo $args['after_widget'];

        }
    }

}

?>