<?php
/**
 * Theme Social Share Widget
 * @package Senatory
 * @since 1.0.0
 */

if (!defined('ABSPATH')) {
    exit(); //exit if access directly
}
// Control core classes for avoid errors
if (class_exists('CSF')) {


    // Create a About Widget
    CSF::createWidget('senatory_social_share_widget', array(
        'title' => esc_html__('Senatory: Social Share', 'senatory-core'),
        'classname' => 'senatory-social-share-about',
        'description' => esc_html__('Display Social Share widget', 'senatory-core'),
        'fields' => array(
            array(
                'id' => 'heading',
                'type' => 'text',
                'title' => esc_html__('Enter Your Header Title', 'senatory-core'),
                'default' => esc_html__('Never Miss News', 'senatory-core')
            ),
            array(
                'id' => 'senatory-social-icon-repeater',
                'type' => 'repeater',
                'title' => esc_html__('Social Icon', 'senatory-core'),
                'fields' => array(
                    array(
                        'id' => 'senatory-social-icon',
                        'type' => 'icon',
                        'title' => esc_html__('Icon', 'senatory-core'),
                        'default' => 'fab fa-facebook'
                    ),
                    array(
                        'id' => 'senatory-social-text',
                        'type' => 'text',
                        'title' => esc_html__('Enter Your Ulr', 'senatory-core'),
                        'default' => '#'
                    ),
                ),
            ),
        )
    ));


    if (!function_exists('senatory_social_share_widget')) {
        function senatory_social_share_widget($args, $instance)
        {

            echo $args['before_widget'];
            

            $heading_title = $instance['heading'] ?? '';
            $socialIcon = is_array($instance['senatory-social-icon-repeater']) && !empty($instance['senatory-social-icon-repeater']) ? $instance['senatory-social-icon-repeater'] : [];


            ?>
            <div class="social-share-widget">
                <h4 class="widget-headline"><?php echo esc_html($heading_title); ?></h4>
                <ul class="social-icon style-03">
                    <?php
                    foreach ($socialIcon as $icon) {
                        printf('<li><a href="%2$s"><i class="%1$s"></i></a></li>', esc_html($icon['senatory-social-icon']), esc_url($icon['senatory-social-text']));
                    };
                    ?>
                </ul>
            </div>

            <?php

            echo $args['after_widget'];

        }
    }

}

?>