<?php
/**
 * Theme functions & definitations
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package senatory
 */

/**
 * Define Theme Folder Path & URL Constant
 * @package senatory
 * @since 1.0.0
 */

define('SENATORY_THEME_ROOT',get_template_directory());
define('SENATORY_THEME_ROOT_URL',get_template_directory_uri());
define('SENATORY_INC',SENATORY_THEME_ROOT .'/inc');
define('SENATORY_THEME_SETTINGS',SENATORY_INC.'/theme-settings');
define('SENATORY_THEME_SETTINGS_IMAGES',SENATORY_THEME_ROOT_URL.'/inc/theme-settings/images');
define('SENATORY_TGMA',SENATORY_INC.'/plugins/tgma');
define('SENATORY_DYNAMIC_STYLESHEETS',SENATORY_INC.'/theme-stylesheets');
define('SENATORY_CSS',SENATORY_THEME_ROOT_URL.'/assets/css');
define('SENATORY_JS',SENATORY_THEME_ROOT_URL.'/assets/js');
define('SENATORY_ASSETS',SENATORY_THEME_ROOT_URL.'/assets');
define('SENATORY_DEV',true);


/**
 * Theme Initial File
 * @package senatory
 * @since 1.0.0
 */
if (file_exists(SENATORY_INC .'/theme-init.php')){
	require_once SENATORY_INC .'/theme-init.php';
}


/**
 * Codester Framework Functions
 * @package senatory
 * @since 1.0.0
 */
if (file_exists(SENATORY_INC .'/theme-cs-function.php')){
	require_once SENATORY_INC .'/theme-cs-function.php';
}


/**
 * Theme Helpers Functions
 * @package senatory
 * @since 1.0.0
 */
if (file_exists(SENATORY_INC .'/theme-helper-functions.php')){

	require_once SENATORY_INC .'/theme-helper-functions.php';
	if (!function_exists('senatory')){
		function senatory(){
			return class_exists('Senatory_Helper_Functions') ? new Senatory_Helper_Functions() : false;
		}
	}
}

/**
 * Nav menu fallback function
 * @since 1.0.0
 */
 function senatory_theme_fallback_menu()
{
    get_template_part('template-parts/default', 'menu');
}


// Breadcrumb Style 
function breadcrumb_style() {
    // Breadcrumb Separator
    $separator = cs_get_option('senatory_breadcrumb_separator');
    $breadcrumb_list_bg = cs_get_option('senatory_breadcrumb_list_bg');
    ?>
    <style>
    .breadcrumb-wrap .breadcrumb-content ul li + li::before {
        content: '<?php echo esc_html($separator);  ?>' !important;
    }
    .breadcrumb-content .page-list { 
        background: <?php echo esc_html($breadcrumb_list_bg);  ?>;
    }
	<?php 
}
add_action('wp_head', 'breadcrumb_style');