<?php
/**
 * Theme Hooks Customize
 * @package senatory
 * @since 1.0.0
 */

if (!defined("ABSPATH")) {
    exit(); //exit if access directly
}

if (!class_exists('Senatory_Customize')) {

    class Senatory_Customize
    {
        /**
         * $instance
         * @since 1.0.0
         */
        protected static $instance;

        public function __construct()
        {
            //excerpt more
            add_action('excerpt_more', array($this, 'excerpt_more'));
            //preloader
            add_action('senatory_after_body', array($this, 'preloader'));
            //search popup
            add_action('senatory_after_body', array($this, 'search_popup'));
            //breadcrumb
            add_action('senatory_before_page_content', array($this, 'breadcrumb'));
            //back top
            add_action('senatory_after_body', array($this, 'back_top'));
            //order comment form
            add_filter('comment_form_fields', array($this, 'comment_fields_reorder'));
            // contact form 7
            add_filter('wpcf7_autop_or_not', '__return_false');
        }

        /**
         * getInstance()
         * @since 1.0.0
         */
        public static function getInstance()
        {
            if (null == self::$instance) {
                self::$instance = new self();
            }
            return self::$instance;
        }

        /**
         * Excerpt More
         * @since 1.0.0
         */
        public function excerpt_more($more)
        {
            $more = cs_get_option('blog_post_excerpt_more');
            return $more;
        }

        /**
         * Breadcrumb
         * @since 1.0.0
         */
        public function breadcrumb()
        {
            $page_id = senatory()->page_id();
            $check_page = (!is_home() && !is_front_page() && is_singular()) || is_search() || is_author() || is_404() || is_archive() ? true : false;
            $check_home_page = senatory()->is_home_page();
            $page_header_meta = Senatory_Group_Fields_Value::page_container('senatory', 'header_options');
            $header_variant_class = isset($page_header_meta['navbar_type']) ? 'navbar-' . $page_header_meta['navbar_type'] : 'navbar-default';
            $page_breadcrumb_enable = isset($page_header_meta['page_breadcrumb_enable']) && $page_header_meta['page_breadcrumb_enable'] ? $page_header_meta['page_breadcrumb_enable'] : false;
            $breadcrumb_enable = false;


            if (!$check_home_page && !$check_page) {
                $breadcrumb_enable = true;
            } elseif (!$page_breadcrumb_enable && $check_page) {
                $breadcrumb_enable = true;
            }
            $breadcrumb_enable = !cs_get_switcher_option('breadcrumb_enable') ? false : $breadcrumb_enable;

            if (!$breadcrumb_enable) {
                return;
            }

            ?>
            <div class="breadcrumb-wrap <?php echo esc_attr($header_variant_class); ?>">
                <?php if('breadcumb_style_1' === cs_get_option('senatory_breadcrumb_style')): ?>
                <div class="container">
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="breadcrumb-content">
                                <?php
                                if (is_archive()) {
                                    if (class_exists('WooCommerce') && is_shop()) {
                                        printf('<h2 class="page-title">%1$s </h2>', str_replace("Archives: ", "", get_the_archive_title()));
                                    } else {
                                        the_archive_title('<h2 class="page-title">', '</h2>');
                                    }
                                } elseif (is_404()) {
                                    printf('<h2 class="page-title">%1$s</h2>', esc_html__('Error 404', 'senatory'));
                                } elseif (is_search()) {
                                    printf('<h2 class="page-title">%1$s %2$s</h2>', esc_html__('Search Results for:', 'senatory'), get_search_query());
                                } elseif (is_singular('post')) {
                                    printf('<h2 class="page-title">%1$s </h2>', get_the_title());
                                } elseif (is_singular('page')) {
                                    if ($page_header_meta['page_title']) {
                                        printf('<h2 class="page-title">%1$s </h2>', get_the_title());
                                    }
                                } else {
                                    printf('<h2 class="page-title">%1$s </h2>', get_the_title($page_id));
                                }
                                if ($page_header_meta['page_breadcrumb']) {
                                    senatory_breadcrumb();
                                }
                                ?>
                            </div>
                        </div>
                    </div>
                    <?php else: ?>
                    <div class="row justify-content-center">
                        <div class="col-lg-6 col-md-6 col-12">
                            <div class="breadcrumb-content about-inner donation-single">
                                <?php
                                if (is_archive()) {
                                    if (class_exists('WooCommerce') && is_shop()) {
                                        printf('<h2 class="title">%1$s </h2>', str_replace("Archives: ", "", get_the_archive_title()));
                                    } else {
                                        the_archive_title('<h2 class="title">', '</h2>');
                                    }
                                } elseif (is_404()) {
                                    printf('<h2 class="title">%1$s</h2>', esc_html__('Error 404', 'senatory'));
                                } elseif (is_search()) {
                                    printf('<h2 class="title">%1$s %2$s</h2>', esc_html__('Search Results for:', 'senatory'), get_search_query());
                                } elseif (is_singular('post')) {
                                    printf('<h2 class="title">%1$s </h2>', get_the_title());
                                } elseif (is_singular('page')) {
                                    if ($page_header_meta['page_title']) {
                                        printf('<h2 class="title">%1$s </h2>', get_the_title());
                                    }
                                } else {
                                    printf('<h2 class="title">%1$s </h2>', get_the_title($page_id));
                                }
                                if ($page_header_meta['page_breadcrumb']) {
                                    senatory_breadcrumb();
                                }
                                ?>                               
                            </div>
                        </div>
                    </div>

                    <?php endif; ?>

                </div>
            </div>
            <?php
        }

        /**
         * Preloader
         * @since 1.0.0
         */
        public function preloader()
        {
            $preloader_enable = cs_get_switcher_option('preloader_enable');
            if (!$preloader_enable) {
                return;
            }
            ?>
            <div class="preloader" id="preloader">
                <div class="preloader-inner">
                    <div class="loader">
                        <svg
                                id="eJPpT6qIRLO1"
                                xmlns="http://www.w3.org/2000/svg"
                                viewBox="0 0 41 52"
                                shape-rendering="geometricPrecision"
                                text-rendering="geometricPrecision"
                        >
                            <g id="eJPpT6qIRLO2" transform="matrix(1 0 0 1 -219 -96.817001)">
                                <g id="eJPpT6qIRLO3" transform="matrix(1 0 0 1 219.111 139.233001)">
                                    <path
                                            id="eJPpT6qIRLO4"
                                            d="M117.617,183.55L118.923,187.05L122.66,187.209L119.73,189.534L120.73,193.134L117.613,191.067L114.496,193.134L115.496,189.534L112.567,187.209L116.304,187.05Z"
                                            transform="matrix(1 0 0 1 -112.573997 -183.550003)"
                                            opacity="0"
                                            fill="rgb(221,19,26)"
                                            stroke="none"
                                            stroke-width="1"
                                    />
                                    <path
                                            id="eJPpT6qIRLO5"
                                            d="M117.617,183.55L118.923,187.05L122.66,187.209L119.73,189.534L120.73,193.134L117.613,191.067L114.496,193.134L115.496,189.534L112.567,187.209L116.304,187.05Z"
                                            transform="matrix(1 0 0 1 -97.171997 -183.550003)"
                                            opacity="0"
                                            fill="rgb(221,19,26)"
                                            stroke="none"
                                            stroke-width="1"
                                    />
                                    <path
                                            id="eJPpT6qIRLO6"
                                            d="M117.617,183.55L118.923,187.05L122.66,187.209L119.73,189.534L120.73,193.134L117.613,191.067L114.496,193.134L115.496,189.534L112.567,187.209L116.304,187.05Z"
                                            transform="matrix(1 0 0 1 -81.771004 -183.550003)"
                                            opacity="0"
                                            fill="rgb(221,19,26)"
                                            stroke="none"
                                            stroke-width="1"
                                    />
                                </g>
                                <path
                                        id="eJPpT6qIRLO7"
                                        d="M6238.076,2712.141L6238.076,2692.616L6201.827,2692.616L6201.827,2715.847L6208.336,2715.847L6208.336,2699.125L6231.567,2699.125L6231.567,2705.633L6214.843,2705.633L6214.843,2722.356L6201.826,2722.356L6201.826,2728.865L6221.351,2728.865L6221.351,2716.743L6233.472,2728.865L6238.072,2728.865L6238.072,2724.265L6227.532,2713.725L6225.949,2712.144Z"
                                        transform="matrix(1 0 0 1 -5980.451 -2595.798999)"
                                        fill="rgb(221,19,26)"
                                        fill-rule="evenodd"
                                        stroke="none"
                                        stroke-width="1"
                                />
                            </g>
                        </svg>
                    </div>
                </div>
            </div>
            <?php
        }

        /**
         * Back top
         * @since 1.0.0
         */
        public function back_top()
        {
            $back_top_enable = cs_get_switcher_option('back_top_enable');
            $back_top_icon = cs_get_option('back_top_icon') ? cs_get_option('back_top_icon') : 'fas fa-angle-up';
            if (!$back_top_enable) {
                return;
            }
            ?>
            <div class="back-to-top">
                <span class="back-top"><i class="<?php echo esc_attr($back_top_icon); ?>"></i></span>
            </div>
            <?php
        }

        /**
         * Reorder comments form
         * @since 1.0.0
         */
        public function comment_fields_reorder($fileds)
        {
            $comment_filed = $fileds['comment'];
            unset($fileds['comment']);
            $fileds['comment'] = $comment_filed;

            if (isset($fileds['cookies'])) {
                $comment_cookies = $fileds['cookies'];
                unset($fileds['cookies']);
                $fileds['cookies'] = $comment_cookies;
            }

            return $fileds;
        }

        /**
         * @since 1.0.0
         * Search Popup
         */
        public function search_popup()
        {
            ?>
            <div class="body-overlay" id="body-overlay"></div>
            <div class="search-popup" id="search-popup">
                <div class="container">
                    <form action="<?php echo esc_url(home_url('/')) ?>" class="search-form">
                        <div class="form-group">
                            <input type="text" name="s" class="form-control"
                                   placeholder="<?php echo esc_attr__('Search....', 'senatory'); ?>">
                        </div>
                        <button class="submit-btn"><i class="fas fa-search"></i></button>
                    </form>
                </div>
            </div>
            <?php
        }

    }//end class
    if (class_exists('Senatory_Customize')) {
        Senatory_Customize::getInstance();
    }
}
