<?php
/**
 * Theme Customize Options
 * @package senatory
 * @since 1.0.0
 * */

if (!defined('ABSPATH')) {
    exit(); // exit if access directly
}

if (class_exists('CSF')) {
    $prefix = 'senatory';

    CSF::createCustomizeOptions($prefix . '_customize_options');
    /*-------------------------------------
        ** Theme Main panel
    -------------------------------------*/
    CSF::createSection($prefix . '_customize_options', array(
        'title' => esc_html__('Senatory Options', 'senatory'),
        'id' => 'senatory_main_panel',
        'priority' => 11,
    ));


    /*-------------------------------------
        ** Theme Main Color
    -------------------------------------*/
    CSF::createSection($prefix . '_customize_options', array(
        'title' => esc_html__('01. Main Color', 'senatory'),
        'priority' => 10,
        'parent' => 'senatory_main_panel',
        'fields' => array(
            array(
                'id' => 'main_color',
                'type' => 'color',
                'title' => esc_html__('Theme Main Color One', 'senatory'),
                'default' => '#DD131A',
                'desc' => esc_html__('This is theme primary color one, means it will affect most of elements that have default color of our theme primary color', 'senatory')
            ),
            array(
                'id' => 'main_color_two',
                'type' => 'color',
                'title' => esc_html__('Theme Main Color Two', 'senatory'),
                'default' => '#000565',
                'desc' => esc_html__('This is theme primary color two, means it\'ll affect most of elements that have default color of our theme primary color', 'senatory')
            ),
            array(
                'id' => 'secondary_color',
                'type' => 'color',
                'title' => esc_html__('Theme Secondary Color', 'senatory'),
                'default' => '#04072E',
                'desc' => esc_html__('This is theme secondary color, means it\'ll affect most of elements that have default color of our theme secondary color', 'senatory')
            ),
            array(
                'id' => 'heading_color',
                'type' => 'color',
                'title' => esc_html__('Theme Heading Color', 'senatory'),
                'default' => '#04072E',
                'desc' => esc_html__('This is theme heading color, means it\'ll affect all of heading tag like, h1,h2,h3,h4,h5,h6', 'senatory')
            ),
            array(
                'id' => 'paragraph_color',
                'type' => 'color',
                'title' => esc_html__('Theme Paragraph Color', 'senatory'),
                'default' => '#727777',
                'desc' => esc_html__('This is theme paragraph color, means it\'ll affect all of body/paragraph tag like, p,li,a etc', 'senatory')
            ),
        )
    ));
    /*-------------------------------------
        ** Theme Header Options
    -------------------------------------*/

    CSF::createSection($prefix . '_customize_options', array(
        'title' => esc_html__('02. Header One Options', 'senatory'),
        'parent' => 'senatory_main_panel',
        'priority' => 11,
        'fields' => array(
            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Nav Bar Options', 'senatory') . '</h3>'
            ),
            array(
                'id' => 'header_01_nav_bar_bg_color',
                'type' => 'color',
                'title' => esc_html__('Nav Bar One Background Color', 'senatory'),
                'default' => '#fff'
            ),
            array(
                'id' => 'header_01_nav_bar_color',
                'type' => 'color',
                'title' => esc_html__('Nav Bar Text Color', 'senatory'),
                'default' => '#04072e'
            ),
            array(
                'id' => 'header_01_nav_bar_hover_color',
                'type' => 'color',
                'title' => esc_html__('Nav Bar Hover Text Color', 'senatory'),
                'default' => '#dd131a'
            ),
            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Dropdown Options', 'senatory') . '</h3>'
            ),
            array(
                'id' => 'header_01_dropdown_bg_color',
                'type' => 'color',
                'title' => esc_html__('Dropdown Background Color', 'senatory'),
                'default' => '#fff'
            ),
            array(
                'id' => 'header_01_dropdown_color',
                'type' => 'color',
                'title' => esc_html__('Dropdown Text Color', 'senatory'),
                'default' => '#dd131a'
            ),
            array(
                'id' => 'header_01_dropdown_hover_color',
                'type' => 'color',
                'title' => esc_html__('Dropdown Hover Text Color', 'senatory'),
                'default' => '#fff'
            ),
            array(
                'id' => 'header_01_dropdown_hover_bg_color',
                'type' => 'color',
                'title' => esc_html__('Dropdown Hover Background Color', 'senatory'),
                'default' => '#dd131a'
            ),
            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Menu Bar Button Right Icon', 'senatory') . '</h3>'
            ),

            array(
                'id' => 'header_01_menu_icon_color',
                'type' => 'color',
                'title' => esc_html__('Menu Bar Icon Color', 'senatory'),
                'default' => '#fff'
            ),
            array(
                'id' => 'header_01_menu_icon_hover_color',
                'type' => 'color',
                'title' => esc_html__('Menu Bar Icon Hover Color', 'senatory'),
                'default' => '#fff'
            ),
            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Menu Bar Button', 'senatory') . '</h3>'
            ),
            array(
                'id' => 'header_01_menu_btn_bg_color',
                'type' => 'color',
                'title' => esc_html__('Nav Bar Button Background Color', 'senatory'),
                'default' => '#dd131a'
            ),
            array(
                'id' => 'header_01_menu_btn_color',
                'type' => 'color',
                'title' => esc_html__('Nav Bar Button Color', 'senatory'),
                'default' => '#fff'
            ),
            array(
                'id' => 'header_01_menu_btn_hover_bg_color',
                'type' => 'color',
                'title' => esc_html__('Nav Bar Button Hover Background Color', 'senatory'),
                'default' => '#04072e'
            ),
            array(
                'id' => 'header_01_menu_hover_btn_color',
                'type' => 'color',
                'title' => esc_html__('Nav Bar Button Hover Color', 'senatory'),
                'default' => '#fff'
            ),
        )
    ));
    CSF::createSection($prefix . '_customize_options', array(
        'title' => esc_html__('03. Header Two Options', 'senatory'),
        'parent' => 'senatory_main_panel',
        'priority' => 11,
        'fields' => array(
            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Top Bar Options', 'senatory') . '</h3>'
            ),
            array(
                'id' => 'header_02_top_bar_bg_color',
                'type' => 'color',
                'title' => esc_html__('Top Bar Background Color', 'senatory'),
                'default' => '#0E115A'
            ),
            array(
                'id' => 'header_02_top_bar_text_color',
                'type' => 'color',
                'title' => esc_html__('Top Bar Text Color', 'senatory'),
                'default' => '#fff'
            ),
            array(
                'id' => 'header_02_top_bar_right_icon_color',
                'type' => 'color',
                'title' => esc_html__('Top Bar Text Color', 'senatory'),
                'default' => '#fff'
            ),
            array(
                'id' => 'header_02_top_bar_icon_color',
                'type' => 'color',
                'title' => esc_html__('Top Bar Icon Color', 'senatory'),
                'default' => '#fff'
            ),
            array(
                'id' => 'header_02_top_bar_icon_bg_color',
                'type' => 'color',
                'title' => esc_html__('Top Bar Icon Background Color', 'senatory'),
                'default' => '#000565'
            ),
            array(
                'id' => 'header_02_top_bar_hover_color',
                'type' => 'color',
                'title' => esc_html__('Top Bar Hover Color', 'senatory'),
                'default' => '#DD131A'
            ),
            array(
                'id' => 'header_02_top_bar_hover_bg_color',
                'type' => 'color',
                'title' => esc_html__('Top Bar Hover Background Color', 'senatory'),
                'default' => '#fff'
            ),
            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Menu Bar Button Right Icon', 'senatory') . '</h3>'
            ),

            array(
                'id' => 'header_02_menu_icon_color',
                'type' => 'color',
                'title' => esc_html__('Menu Bar Icon Color', 'senatory'),
                'default' => '#04072e'
            ),
            array(
                'id' => 'header_02_menu_icon_hover_color',
                'type' => 'color',
                'title' => esc_html__('Menu Bar Icon Hover Color', 'senatory'),
                'default' => '#DD131A'
            ),
            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Menu Bar Button', 'senatory') . '</h3>'
            ),
            array(
                'id' => 'header_02_top_bar_btn_bg_color',
                'type' => 'color',
                'title' => esc_html__('Nav Bar Button Background Color', 'senatory'),
                'default' => '#DD131A'
            ),
            array(
                'id' => 'header_02_top_bar_btn_color',
                'type' => 'color',
                'title' => esc_html__('Nav Bar Button Color', 'senatory'),
                'default' => '#fff'
            ),
            array(
                'id' => 'header_02_top_bar_btn_hover_bg_color',
                'type' => 'color',
                'title' => esc_html__('Nav Bar Button Hover Background Color', 'senatory'),
                'default' => '#000565'
            ),
            array(
                'id' => 'header_02_top_bar_hover_btn_color',
                'type' => 'color',
                'title' => esc_html__('Nav Bar Button Hover Color', 'senatory'),
                'default' => '#fff'
            ),
            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Nav Bar Options', 'senatory') . '</h3>'
            ),
            array(
                'id' => 'header_02_nav_bar_bg_color',
                'type' => 'color',
                'title' => esc_html__('Nav Bar Background Color', 'senatory'),
                'default' => 'transparent'
            ),
            array(
                'id' => 'header_02_nav_bar_color',
                'type' => 'color',
                'title' => esc_html__('Nav Bar Text Color', 'senatory'),
                'default' => '#707070'
            ),
            array(
                'id' => 'header_02_nav_bar_hover_color',
                'type' => 'color',
                'title' => esc_html__('Nav Bar Hover Text Color', 'senatory'),
                'default' => '#DD131A'
            ),
            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Dropdown Options', 'senatory') . '</h3>'
            ),
            array(
                'id' => 'header_02_dropdown_bg_color',
                'type' => 'color',
                'title' => esc_html__('Dropdown Background Color', 'senatory'),
                'default' => '#FFFDF2'
            ),
            array(
                'id' => 'header_02_dropdown_color',
                'type' => 'color',
                'title' => esc_html__('Dropdown Text Color', 'senatory'),
                'default' => '#707070'
            ),
            array(
                'id' => 'header_02_dropdown_hover_color',
                'type' => 'color',
                'title' => esc_html__('Dropdown Hover Text Color', 'senatory'),
                'default' => '#ffffff'
            ),
            array(
                'id' => 'header_02_dropdown_hover_bg_color',
                'type' => 'color',
                'title' => esc_html__('Dropdown Hover Background Color', 'senatory'),
                'default' => '#DD131A'
            )
        )
    ));
    CSF::createSection($prefix . '_customize_options', array(
        'title' => esc_html__('02. Header Three Options', 'senatory'),
        'parent' => 'senatory_main_panel',
        'priority' => 11,
        'fields' => array(
            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Nav Bar Options', 'senatory') . '</h3>'
            ),
            array(
                'id' => 'header_03_nav_bar_bg_color',
                'type' => 'color',
                'title' => esc_html__('Nav Bar Background Color', 'senatory'),
                'default' => 'transparent'
            ),
            array(
                'id' => 'header_03_nav_bar_color',
                'type' => 'color',
                'title' => esc_html__('Nav Bar Text Color', 'senatory'),
                'default' => '#fff'
            ),
            array(
                'id' => 'header_03_nav_bar_hover_color',
                'type' => 'color',
                'title' => esc_html__('Nav Bar Hover Text Color', 'senatory'),
                'default' => '#dd131a'
            ),
            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Dropdown Options', 'senatory') . '</h3>'
            ),
            array(
                'id' => 'header_03_dropdown_bg_color',
                'type' => 'color',
                'title' => esc_html__('Dropdown Background Color', 'senatory'),
                'default' => '#fff'
            ),
            array(
                'id' => 'header_03_dropdown_color',
                'type' => 'color',
                'title' => esc_html__('Dropdown Text Color', 'senatory'),
                'default' => '#04072E'
            ),
            array(
                'id' => 'header_03_dropdown_hover_color',
                'type' => 'color',
                'title' => esc_html__('Dropdown Hover Text Color', 'senatory'),
                'default' => '#fff'
            ),
            array(
                'id' => 'header_03_dropdown_hover_bg_color',
                'type' => 'color',
                'title' => esc_html__('Dropdown Hover Background Color', 'senatory'),
                'default' => '#04072E'
            ),
            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Menu Bar Button', 'senatory') . '</h3>'
            ),
            array(
                'id' => 'header_03_menu_btn_bg_color',
                'type' => 'color',
                'title' => esc_html__('Nav Bar Button Background Color', 'senatory'),
                'default' => '#fff'
            ),
            array(
                'id' => 'header_03_menu_btn_color',
                'type' => 'color',
                'title' => esc_html__('Nav Bar Button Color', 'senatory'),
                'default' => '#DD131A'
            ),
            array(
                'id' => 'header_03_menu_btn_hover_bg_color',
                'type' => 'color',
                'title' => esc_html__('Nav Bar Button Hover Background Color', 'senatory'),
                'default' => '#DD131A'
            ),
            array(
                'id' => 'header_03_menu_hover_btn_color',
                'type' => 'color',
                'title' => esc_html__('Nav Bar Button Hover Color', 'senatory'),
                'default' => '#fff'
            ),
        )
    ));


    CSF::createSection($prefix . '_customize_options', array(
        'title' => esc_html__('02. Header Four Options', 'senatory'),
        'parent' => 'senatory_main_panel',
        'priority' => 11,
        'fields' => array(
            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Nav Bar Options', 'senatory') . '</h3>'
            ),
            array(
                'id' => 'header_04_nav_bar_bg_color',
                'type' => 'color',
                'title' => esc_html__('Nav Bar Background Color', 'senatory'),
                'default' => 'transparent'
            ),
            array(
                'id' => 'header_04_nav_bar_color',
                'type' => 'color',
                'title' => esc_html__('Nav Bar Text Color', 'senatory'),
                'default' => '#04072e'
            ),
            array(
                'id' => 'header_04_nav_bar_hover_color',
                'type' => 'color',
                'title' => esc_html__('Nav Bar Hover Text Color', 'senatory'),
                'default' => '#dd131a'
            ),
            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Dropdown Options', 'senatory') . '</h3>'
            ),
            array(
                'id' => 'header_04_dropdown_bg_color',
                'type' => 'color',
                'title' => esc_html__('Dropdown Background Color', 'senatory'),
                'default' => '#fff'
            ),
            array(
                'id' => 'header_04_dropdown_color',
                'type' => 'color',
                'title' => esc_html__('Dropdown Text Color', 'senatory'),
                'default' => '#04072E'
            ),
            array(
                'id' => 'header_04_dropdown_hover_color',
                'type' => 'color',
                'title' => esc_html__('Dropdown Hover Text Color', 'senatory'),
                'default' => '#fff'
            ),
            array(
                'id' => 'header_04_dropdown_hover_bg_color',
                'type' => 'color',
                'title' => esc_html__('Dropdown Hover Background Color', 'senatory'),
                'default' => '#04072E'
            ),
            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Menu Bar Button', 'senatory') . '</h3>'
            ),
            array(
                'id' => 'header_04_menu_btn_color',
                'type' => 'color',
                'title' => esc_html__('Nav Bar Button Color', 'senatory'),
                'default' => '#dd131a'
            ),
            array(
                'id' => 'header_04_menu_hover_btn_color',
                'type' => 'color',
                'title' => esc_html__('Nav Bar Button Hover Color', 'senatory'),
                'default' => '#dd131a'
            ),
        )
    ));


    CSF::createSection($prefix . '_customize_options', array(
        'title' => esc_html__('02. Header Five Options', 'senatory'),
        'parent' => 'senatory_main_panel',
        'priority' => 11,
        'fields' => array(
            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Nav Bar Options', 'senatory') . '</h3>'
            ),
            array(
                'id' => 'header_05_nav_bar_bg_color',
                'type' => 'color',
                'title' => esc_html__('Nav Bar Background Color', 'senatory'),
                'default' => '#04072e'
            ),
            array(
                'id' => 'header_05_nav_bar_color',
                'type' => 'color',
                'title' => esc_html__('Nav Bar Text Color', 'senatory'),
                'default' => '#fff'
            ),
            array(
                'id' => 'header_05_nav_bar_hover_color',
                'type' => 'color',
                'title' => esc_html__('Nav Bar Hover Text Color', 'senatory'),
                'default' => '#dd131a'
            ),
            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Dropdown Options', 'senatory') . '</h3>'
            ),
            array(
                'id' => 'header_05_dropdown_bg_color',
                'type' => 'color',
                'title' => esc_html__('Dropdown Background Color', 'senatory'),
                'default' => '#fff'
            ),
            array(
                'id' => 'header_05_dropdown_color',
                'type' => 'color',
                'title' => esc_html__('Dropdown Text Color', 'senatory'),
                'default' => '#04072E'
            ),
            array(
                'id' => 'header_05_dropdown_hover_color',
                'type' => 'color',
                'title' => esc_html__('Dropdown Hover Text Color', 'senatory'),
                'default' => '#fff'
            ),
            array(
                'id' => 'header_05_dropdown_hover_bg_color',
                'type' => 'color',
                'title' => esc_html__('Dropdown Hover Background Color', 'senatory'),
                'default' => '#04072E'
            ),
            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Menu Bar Button', 'senatory') . '</h3>'
            ),
            array(
                'id' => 'header_05_menu_btn_bg_color',
                'type' => 'color',
                'title' => esc_html__('Nav Bar Button Background Color', 'senatory'),
                'default' => '#fff'
            ),
            array(
                'id' => 'header_05_menu_btn_color',
                'type' => 'color',
                'title' => esc_html__('Nav Bar Button Color', 'senatory'),
                'default' => '#DD131A'
            ),
            array(
                'id' => 'header_05_menu_btn_hover_bg_color',
                'type' => 'color',
                'title' => esc_html__('Nav Bar Button Hover Background Color', 'senatory'),
                'default' => '#DD131A'
            ),
            array(
                'id' => 'header_05_menu_hover_btn_color',
                'type' => 'color',
                'title' => esc_html__('Nav Bar Button Hover Color', 'senatory'),
                'default' => '#fff'
            ),
        )
    ));

    /*-------------------------------------
          ** Theme Sidebar Options
      -------------------------------------*/
    CSF::createSection($prefix . '_customize_options', array(
        'title' => esc_html__('05. Sidebar', 'senatory'),
        'priority' => 13,
        'parent' => 'senatory_main_panel',
        'fields' => array(
            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Sidebar Options', 'senatory') . '</h3>'
            ),
            array(
                'id' => 'sidebar_widget_title_color',
                'type' => 'color',
                'title' => esc_html__('Sidebar Widget Title Color', 'senatory'),
                'default' => '#04072E'
            ),
            array(
                'id' => 'sidebar_widget_title_bottom_border_color',
                'type' => 'color',
                'title' => esc_html__('Sidebar Widget Title Border Color', 'senatory'),
                'default' => '#000565'
            ),
            array(
                'id' => 'sidebar_widget_text_color',
                'type' => 'color',
                'title' => esc_html__('Sidebar Widget Text Color', 'senatory'),
                'default' => '#7886a0'
            ),
        )
    ));
    /*-------------------------------------
        ** Theme Footer One Options
    -------------------------------------*/
    CSF::createSection($prefix . '_customize_options', array(
        'title' => esc_html__('06. Footer One', 'senatory'),
        'priority' => 14,
        'parent' => 'senatory_main_panel',
        'fields' => array(
            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Footer Options', 'senatory') . '</h3>'
            ),
            array(
                'id' => 'footer_area_bg_color',
                'type' => 'color',
                'title' => esc_html__('Footer Background Color', 'senatory'),
                'default' => '#04072e',
            ),
            array(
                'id' => 'footer_area_bottom_border_color',
                'type' => 'color',
                'title' => esc_html__('Footer Bottom Border Color', 'senatory'),
                'default' => 'rgba(114, 108, 148, 0.2)',
            ),
            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Footer Widget Options', 'senatory') . '</h3>'
            ),
            array(
                'id' => 'footer_widget_title_color',
                'type' => 'color',
                'title' => esc_html__('Footer Widget Title Color', 'senatory'),
                'default' => '#fff'
            ),
            array(
                'id' => 'footer_widget_text_color',
                'type' => 'color',
                'title' => esc_html__('Footer Widget Text Color', 'senatory'),
                'default' => '#fff'
            ),
            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Tag Cloud Options', 'senatory') . '</h3>'
            ),
            array(
                'id' => 'footer_widget_tag_color',
                'type' => 'color',
                'title' => esc_html__('Footer Tag Text Color', 'senatory'),
                'default' => '#fff'
            ),
            array(
                'id' => 'footer_widget_tag_bg_color',
                'type' => 'color',
                'title' => esc_html__('Footer Tag Background Color', 'senatory'),
                'default' => '#04072E'
            ),
            array(
                'id' => 'footer_widget_tag_border_color',
                'type' => 'color',
                'title' => esc_html__('Footer Tag Border Color', 'senatory'),
                'default' => '#04072E'
            ),
            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Copyright Area Options', 'senatory') . '</h3>'
            ),
            array(
                'id' => 'copyright_area_bg_color',
                'type' => 'color',
                'title' => esc_html__('Copyright Area Background Color', 'senatory'),
                'default' => '#04072e'
            ),
            array(
                'id' => 'copyright_area_text_color',
                'type' => 'color',
                'title' => esc_html__('Copyright Area Text Color', 'senatory'),
                'default' => '#fff'
            ),
        )
    ));

    /*-------------------------------------
     ** Theme Footer Two Options
    -------------------------------------*/
    CSF::createSection($prefix . '_customize_options', array(
        'title' => esc_html__('06. Footer Two', 'senatory'),
        'priority' => 14,
        'parent' => 'senatory_main_panel',
        'fields' => array(
            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Footer Top Options', 'senatory') . '</h3>'
            ),
            array(
                'id' => 'footer_two_menu_text_color',
                'type' => 'color',
                'title' => esc_html__('Footer Top Menu Text Color', 'senatory'),
                'default' => '#fff'
            ),
            array(
                'id' => 'footer_two_menu_text_hover_color',
                'type' => 'color',
                'title' => esc_html__('Footer Top Menu Text Hover Color', 'senatory'),
                'default' => '#DD131A'
            ),
            array(
                'id' => 'footer_two_menu_contact_icon_bg_color',
                'type' => 'color',
                'title' => esc_html__('Footer Top Menu Contact Icon Background Color', 'senatory'),
                'default' => '#04072E'
            ),
            array(
                'id' => 'footer_two_menu_contact_icon_color',
                'type' => 'color',
                'title' => esc_html__('Footer Top Menu Contact Icon Color', 'senatory'),
                'default' => '#04072E'
            ),
            array(
                'id' => 'footer_two_menu_contact_title_color',
                'type' => 'color',
                'title' => esc_html__('Footer Top Menu Contact Title Color', 'senatory'),
                'default' => '#fff'
            ),
            array(
                'id' => 'footer_two_menu_contact_number_color',
                'type' => 'color',
                'title' => esc_html__('Footer Top Menu Contact Number Color', 'senatory'),
                'default' => '#fff'
            ),
            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Footer Options', 'senatory') . '</h3>'
            ),
            array(
                'id' => 'footer_area_two_bg_color',
                'type' => 'color',
                'title' => esc_html__('Footer Background Color', 'senatory'),
                'default' => '#04072e',
            ),
            array(
                'id' => 'footer_area_two_bottom_border_color',
                'type' => 'color',
                'title' => esc_html__('Footer Bottom Border Color', 'senatory'),
                'default' => 'rgba(114, 108, 148, 0.2)',
            ),
            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Footer Widget Options', 'senatory') . '</h3>'
            ),
            array(
                'id' => 'footer_two_widget_title_color',
                'type' => 'color',
                'title' => esc_html__('Footer Widget Title Color', 'senatory'),
                'default' => 'rgba(255, 255, 255, 0.9)'
            ),
            array(
                'id' => 'footer_two_widget_text_color',
                'type' => 'color',
                'title' => esc_html__('Footer Widget Text Color', 'senatory'),
                'default' => 'rgba(255,255,255,0.8)'
            ),
            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Tag Cloud Options', 'senatory') . '</h3>'
            ),
            array(
                'id' => 'footer_widget_two_tag_color',
                'type' => 'color',
                'title' => esc_html__('Footer Tag Text Color', 'senatory'),
                'default' => '#fff'
            ),
            array(
                'id' => 'footer_widget_two_tag_bg_color',
                'type' => 'color',
                'title' => esc_html__('Footer Tag Background Color', 'senatory'),
                'default' => 'transparent'
            ),
            array(
                'id' => 'footer_widget_two_tag_border_color',
                'type' => 'color',
                'title' => esc_html__('Footer Tag Border Color', 'senatory'),
                'default' => '#fff'
            ),
            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Copyright Area Options', 'senatory') . '</h3>'
            ),
            array(
                'id' => 'copyright_two_area_bg_color',
                'type' => 'color',
                'title' => esc_html__('Copyright Area Background Color', 'senatory'),
                'default' => 'transparent'
            ),
            array(
                'id' => 'copyright_two_area_text_color',
                'type' => 'color',
                'title' => esc_html__('Copyright Area Text Color', 'senatory'),
                'default' => 'rgba(255,255,255,0.8)'
            ),
        )
    ));

    /*-------------------------------------
    ** Theme Footer Three Options
    -------------------------------------*/
    CSF::createSection($prefix . '_customize_options', array(
        'title' => esc_html__('06. Footer Three', 'senatory'),
        'priority' => 14,
        'parent' => 'senatory_main_panel',
        'fields' => array(
            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Footer Top Options', 'senatory') . '</h3>'
            ),
            array(
                'id' => 'footer_area_three_cta_shape_bg_color',
                'type' => 'color',
                'title' => esc_html__('Footer Top CTA Shape Background Color', 'senatory'),
                'default' => '#fff'
            ),
            array(
                'id' => 'footer_area_three_cta_text_color',
                'type' => 'color',
                'title' => esc_html__('Footer Top CTA Text Color', 'senatory'),
                'default' => '#fff'
            ),
            array(
                'id' => 'footer_area_three_cta_btn_bg_color',
                'type' => 'color',
                'title' => esc_html__('Footer Top CTA Button Background Color', 'senatory'),
                'default' => '#fff'
            ),
            array(
                'id' => 'footer_area_three_cta_btn_text_color',
                'type' => 'color',
                'title' => esc_html__('Footer Top CTA Button Text Color', 'senatory'),
                'default' => '#dd131a'
            ),
            array(
                'id' => 'footer_area_three_cta_btn_hover_bg_color',
                'type' => 'color',
                'title' => esc_html__('Footer Top CTA Button Background Hover Color', 'senatory'),
                'default' => '#04072E'
            ),
            array(
                'id' => 'footer_area_three_cta_btn_text_hover_color',
                'type' => 'color',
                'title' => esc_html__('Footer Top CTA Button Text Hover Color', 'senatory'),
                'default' => '#fff'
            ),
            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Footer Options', 'senatory') . '</h3>'
            ),
            array(
                'id' => 'footer_area_three_bg_color',
                'type' => 'color',
                'title' => esc_html__('Footer Background Color', 'senatory'),
                'default' => '#04072e',
            ),
            array(
                'id' => 'footer_area_three_bottom_border_color',
                'type' => 'color',
                'title' => esc_html__('Footer Bottom Border Color', 'senatory'),
                'default' => 'rgba(114, 108, 148, 0.2)',
            ),
            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Footer Widget Options', 'senatory') . '</h3>'
            ),
            array(
                'id' => 'footer_three_widget_title_color',
                'type' => 'color',
                'title' => esc_html__('Footer Widget Title Color', 'senatory'),
                'default' => 'rgba(255, 255, 255, 0.9)'
            ),
            array(
                'id' => 'footer_three_widget_text_color',
                'type' => 'color',
                'title' => esc_html__('Footer Widget Text Color', 'senatory'),
                'default' => 'rgba(255,255,255,0.8)'
            ),
            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Tag Cloud Options', 'senatory') . '</h3>'
            ),
            array(
                'id' => 'footer_widget_three_tag_color',
                'type' => 'color',
                'title' => esc_html__('Footer Tag Text Color', 'senatory'),
                'default' => '#fff'
            ),
            array(
                'id' => 'footer_widget_three_tag_bg_color',
                'type' => 'color',
                'title' => esc_html__('Footer Tag Background Color', 'senatory'),
                'default' => 'transparent'
            ),
            array(
                'id' => 'footer_widget_three_tag_border_color',
                'type' => 'color',
                'title' => esc_html__('Footer Tag Border Color', 'senatory'),
                'default' => '#fff'
            ),
            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Copyright Area Options', 'senatory') . '</h3>'
            ),
            array(
                'id' => 'copyright_three_area_bg_color',
                'type' => 'color',
                'title' => esc_html__('Copyright Area Background Color', 'senatory'),
                'default' => 'transparent'
            ),
            array(
                'id' => 'copyright_three_area_text_color',
                'type' => 'color',
                'title' => esc_html__('Copyright Area Text Color', 'senatory'),
                'default' => 'rgba(255,255,255,0.8)'
            ),
        )
    ));


}//endif