<?php
/**
 *Theme Group Fields
 * @package senatory
 * @since 1.0.0
 */

if (!defined('ABSPATH')) {
    exit(); // exit if access directly
}


if (!class_exists('Senatory_Group_Fields')) {

    class Senatory_Group_Fields
    {
        
        /**
         * $instance
         * @since 1.0.0
         */
        private static $instance;


        /**
         * construct()
         * @since 1.0.0
         */
        public function __construct()
        {

        }

        /**
         * getInstance()
         * @since 1.0.0
         */
        public static function getInstance()
        {
            if (null == self::$instance) {
                self::$instance = new self();
            }
            return self::$instance;
        }

        /**
         * Page layout options
         * @since 1.0.0
         */
        public static function page_layout()
        {
            $fields = array(
                array(
                    'type' => 'subheading',
                    'content' => esc_html__('Page Layouts & Colors Options', 'senatory'),
                ),
                array(
                    'id' => 'page_layout',
                    'type' => 'image_select',
                    'title' => esc_html__('Select Page Layout', 'senatory'),
                    'options' => array(
                        'default' => SENATORY_THEME_SETTINGS_IMAGES . '/page/default.png',
                        'left-sidebar' => SENATORY_THEME_SETTINGS_IMAGES . '/page/left-sidebar.png',
                        'right-sidebar' => SENATORY_THEME_SETTINGS_IMAGES . '/page/right-sidebar.png',
                        'blank' => SENATORY_THEME_SETTINGS_IMAGES . '/page/blank.png',
                    ),
                    'default' => 'default'
                ),
                array(
                    'id' => 'page_bg_color',
                    'type' => 'color',
                    'title' => esc_html__('Page Background Color', 'senatory'),
                    'default' => '#ffffff'
                ),
                array(
                    'id' => 'page_content_bg_color',
                    'type' => 'color',
                    'title' => esc_html__('Page Content Background Color', 'senatory'),
                    'default' => '#ffffff'
                ),
                array(
                    'id' => 'page_content_text_color',
                    'type' => 'color',
                    'title' => esc_html__('Page Content Text Color', 'senatory'),
                    'default' => '#5f5f5f'
                )

            );

            return $fields;
        }

        /**
         * Page container options
         * @since 1.0.0
         */
        public static function Page_Container_Options($type)
        {
            $fields = array();
            $allowed_html = senatory()->kses_allowed_html(array('mark'));
            if ('header_options' == $type) {
                $fields = array(
                    array(
                        'type' => 'subheading',
                        'content' => esc_html__('Page Header, Footer & Breadcrumb Options', 'senatory'),
                    ),
                    array(
                        'id' => 'page_title',
                        'type' => 'switcher',
                        'title' => esc_html__('Page Title', 'senatory'),
                        'desc' => wp_kses(__('you can set <mark>ON / OFF</mark> to show/hide page title.', 'senatory'), $allowed_html),
                        'text_on' => esc_html__('Yes', 'senatory'),
                        'text_off' => esc_html__('No', 'senatory'),
                        'default' => true
                    ),
                    array(
                        'id' => 'page_breadcrumb',
                        'type' => 'switcher',
                        'title' => esc_html__('Page Breadcrumb', 'senatory'),
                        'desc' => wp_kses(__('you can set <mark>ON / OFF</mark> to show/hide page breadcrumb.', 'senatory'), $allowed_html),
                        'text_on' => esc_html__('Yes', 'senatory'),
                        'text_off' => esc_html__('No', 'senatory'),
                        'default' => true
                    ),

                    array(
                        'id' => 'navbar_type',
                        'title' => esc_html__('Navbar Type', 'senatory'),
                        'type' => 'image_select',
                        'options' => array(
                            '' => SENATORY_THEME_SETTINGS_IMAGES . '/header/01.png',
                            'style-01' => SENATORY_THEME_SETTINGS_IMAGES . '/header/02.png',
                            'style-02' => SENATORY_THEME_SETTINGS_IMAGES . '/header/03.png',
                            'style-03' => SENATORY_THEME_SETTINGS_IMAGES . '/header/04.png',
                            'style-04' => SENATORY_THEME_SETTINGS_IMAGES . '/header/05.png',
                            'style-05' => SENATORY_THEME_SETTINGS_IMAGES . '/header/06.png',
                          
                        ),
                        'default' => '',
                        'desc' => wp_kses(__('you can set <mark>navbar type</mark> transparent type or solid background.', 'senatory'), $allowed_html),
                    ),

                    array(
                        'id' => 'footer_type',
                        'title' => esc_html__('Footer Type', 'senatory'),
                        'type' => 'image_select',
                        'options' => array(
                            '' => SENATORY_THEME_SETTINGS_IMAGES . '/footer/01.png',
                            'style-01' => SENATORY_THEME_SETTINGS_IMAGES . '/footer/02.png',
                            'style-02' => SENATORY_THEME_SETTINGS_IMAGES . '/footer/03.png',
                            'style-03' => SENATORY_THEME_SETTINGS_IMAGES . '/footer/04.png',
                            'style-04' => SENATORY_THEME_SETTINGS_IMAGES . '/footer/05.webp'
                        ),
                        'default' => '',
                        'desc' => wp_kses(__('you can set <mark>footer type</mark> transparent type or solid background.', 'senatory'), $allowed_html),
                    ),


                );
            } elseif ('container_options' == $type) {
                $fields = array(
                    array(
                        'type' => 'subheading',
                        'content' => esc_html__('Page Width & Padding Options', 'senatory'),
                    ),
                    array(
                        'id' => 'page_container',
                        'type' => 'switcher',
                        'title' => esc_html__('Page Full Width', 'senatory'),
                        'desc' => wp_kses(__('you can set <mark>ON / OFF</mark> to set page container full width.', 'senatory'), $allowed_html),
                        'text_on' => esc_html__('Yes', 'senatory'),
                        'text_off' => esc_html__('No', 'senatory'),
                        'default' => false
                    ),
                    array(
                        'type' => 'subheading',
                        'content' => esc_html__('Page Spacing Options', 'senatory'),
                    ),
                    array(
                        'id' => 'page_spacing_top',
                        'title' => esc_html__('Page Spacing Top', 'senatory'),
                        'type' => 'slider',
                        'desc' => wp_kses(__('you can set <mark>Padding Top</mark> for page container.', 'senatory'), $allowed_html),
                        'min' => 0,
                        'max' => 500,
                        'step' => 1,
                        'unit' => 'px',
                        'default' => 120,
                    ),
                    array(
                        'id' => 'page_spacing_bottom',
                        'title' => esc_html__('Page Spacing Bottom', 'senatory'),
                        'type' => 'slider',
                        'desc' => wp_kses(__('you can set <mark>Padding Bottom</mark> for page container.', 'senatory'), $allowed_html),
                        'min' => 0,
                        'max' => 500,
                        'step' => 1,
                        'unit' => 'px',
                        'default' => 120,
                    ),
                    array(
                        'type' => 'subheading',
                        'content' => esc_html__('Page Content Spacing Options', 'senatory'),
                    ),
                    array(
                        'id' => 'page_content_spacing',
                        'type' => 'switcher',
                        'title' => esc_html__('Page Content Spacing', 'senatory'),
                        'desc' => wp_kses(__('you can set <mark>ON / OFF</mark> to set page content spacing.', 'senatory'), $allowed_html),
                        'text_on' => esc_html__('Yes', 'senatory'),
                        'text_off' => esc_html__('No', 'senatory'),
                        'default' => false
                    ),
                    array(
                        'id' => 'page_content_spacing_top',
                        'title' => esc_html__('Page Spacing Bottom', 'senatory'),
                        'type' => 'slider',
                        'desc' => wp_kses(__('you can set <mark>Padding Top</mark> for page content area.', 'senatory'), $allowed_html),
                        'min' => 0,
                        'max' => 500,
                        'step' => 1,
                        'unit' => 'px',
                        'default' => 0,
                        'dependency' => array('page_content_spacing', '==', 'true')
                    ),
                    array(
                        'id' => 'page_content_spacing_bottom',
                        'title' => esc_html__('Page Spacing Bottom', 'senatory'),
                        'type' => 'slider',
                        'desc' => wp_kses(__('you can set <mark>Padding Bottom</mark> for page content area.', 'senatory'), $allowed_html),
                        'min' => 0,
                        'max' => 500,
                        'step' => 1,
                        'unit' => 'px',
                        'default' => 0,
                        'dependency' => array('page_content_spacing', '==', 'true')
                    ),
                    array(
                        'id' => 'page_content_spacing_left',
                        'title' => esc_html__('Page Spacing Left', 'senatory'),
                        'type' => 'slider',
                        'desc' => wp_kses(__('you can set <mark>Padding Left</mark> for page content area.', 'senatory'), $allowed_html),
                        'min' => 0,
                        'max' => 500,
                        'step' => 1,
                        'unit' => 'px',
                        'default' => 0,
                        'dependency' => array('page_content_spacing', '==', 'true')
                    ),
                    array(
                        'id' => 'page_content_spacing_right',
                        'title' => esc_html__('Page Spacing Right', 'senatory'),
                        'type' => 'slider',
                        'desc' => wp_kses(__('you can set <mark>Padding Right</mark> for page content area.', 'senatory'), $allowed_html),
                        'min' => 0,
                        'max' => 500,
                        'step' => 1,
                        'unit' => 'px',
                        'default' => 0,
                        'dependency' => array('page_content_spacing', '==', 'true')
                    ),
                );
            }

            return $fields;
        }


        /**
         * Page layout options
         * @since 1.0.0
         */
        public static function page_layout_options($title, $prefix)
        {
            $allowed_html = senatory()->kses_allowed_html(array('mark'));
            $fields = array(
                array(
                    'type' => 'subheading',
                    'content' => '<h3>' . $title . esc_html__(' Page Options', 'senatory') . '</h3>',
                ),
                array(
                    'id' => $prefix . '_layout',
                    'type' => 'image_select',
                    'title' => esc_html__('Select Page Layout', 'senatory'),
                    'options' => array(
                        'right-sidebar' => SENATORY_THEME_SETTINGS_IMAGES . '/page/right-sidebar.png',
                        'left-sidebar' => SENATORY_THEME_SETTINGS_IMAGES . '/page/left-sidebar.png',
                        'no-sidebar' => SENATORY_THEME_SETTINGS_IMAGES . '/page/no-sidebar.png',
                    ),
                    'default' => 'right-sidebar'
                ),
                array(
                    'id' => $prefix . '_bg_color',
                    'type' => 'color',
                    'title' => esc_html__('Page Background Color', 'senatory'),
                    'default' => '#ffffff'
                ),
                array(
                    'id' => $prefix . '_spacing_top',
                    'title' => esc_html__('Page Spacing Top', 'senatory'),
                    'type' => 'slider',
                    'desc' => wp_kses(__('you can set <mark>Padding Top</mark> for page content area.', 'senatory'), $allowed_html),
                    'min' => 0,
                    'max' => 500,
                    'step' => 1,
                    'unit' => 'px',
                    'default' => 120,
                ),
                array(
                    'id' => $prefix . '_spacing_bottom',
                    'title' => esc_html__('Page Spacing Bottom', 'senatory'),
                    'type' => 'slider',
                    'desc' => wp_kses(__('you can set <mark>Padding Bottom</mark> for page content area.', 'senatory'), $allowed_html),
                    'min' => 0,
                    'max' => 500,
                    'step' => 1,
                    'unit' => 'px',
                    'default' => 120,
                ),
            );

            return $fields;
        }

        /**
         * Post meta
         * @since 1.0.0
         */
        public static function post_meta($prefix, $title)
        {
            $allowed_html = senatory()->kses_allowed_html(array('mark'));
            $fields = array(
                array(
                    'type' => 'subheading',
                    'content' => '<h3>' . $title . esc_html__(' Post Options', 'senatory') . '</h3>',
                ),
                array(
                    'id' => $prefix . '_posted_by',
                    'type' => 'switcher',
                    'title' => esc_html__('Posted By', 'senatory'),
                    'desc' => wp_kses(__('you can set <mark>ON / OFF</mark> to show / hide posted by.', 'senatory'), $allowed_html),
                    'text_on' => esc_html__('Yes', 'senatory'),
                    'text_off' => esc_html__('No', 'senatory'),
                    'default' => true
                )
            );

            if ('blog_post' == $prefix) {
                $fields[] = array(
                    'id' => $prefix . '_posted_cat',
                    'type' => 'switcher',
                    'title' => esc_html__('Posted Category', 'senatory'),
                    'desc' => wp_kses(__('you can set <mark>ON / OFF</mark> to show / hide posted category.', 'senatory'), $allowed_html),
                    'text_on' => esc_html__('Yes', 'senatory'),
                    'text_off' => esc_html__('No', 'senatory'),
                    'default' => true
                );
                $fields[] = array(
                    'id' => $prefix . '_readmore_btn',
                    'type' => 'switcher',
                    'title' => esc_html__('Read More Button', 'senatory'),
                    'desc' => wp_kses(__('you can set <mark>ON / OFF</mark> to show / hide read more button.', 'senatory'), $allowed_html),
                    'text_on' => esc_html__('Yes', 'senatory'),
                    'text_off' => esc_html__('No', 'senatory'),
                    'default' => true
                );
                $fields[] = array(
                    'id' => $prefix . '_readmore_btn_text',
                    'type' => 'text',
                    'title' => esc_html__('Read More Text', 'senatory'),
                    'desc' => wp_kses(__('you can set read more <mark>button text</mark> to button text.', 'senatory'), $allowed_html),
                    'default' => esc_html__('Read More', 'senatory'),
                    'dependency' => array($prefix . '_readmore_btn', '==', 'true')
                );
                $fields[] = array(
                    'id' => $prefix . '_excerpt_more',
                    'type' => 'text',
                    'title' => esc_html__('Excerpt More', 'senatory'),
                    'desc' => wp_kses(__('you can set read more <mark>button text</mark> to button text.', 'senatory'), $allowed_html),
                    'attributes' => array(
                        'placeholder' => esc_html__('....', 'senatory')
                    )
                );
                $fields[] = array(
                    'id' => $prefix . '_excerpt_length',
                    'type' => 'select',
                    'options' => array(
                        '25' => esc_html__('Short', 'senatory'),
                        '55' => esc_html__('Regular', 'senatory'),
                        '100' => esc_html__('Long', 'senatory'),
                    ),
                    'title' => esc_html__('Excerpt Length', 'senatory'),
                    'desc' => wp_kses(__('you can set <mark> excerpt length</mark> for post.', 'senatory'), $allowed_html),
                );
            } elseif ('blog_single_post' == $prefix) {

                $fields[] = array(
                    'id' => $prefix . '_posted_category',
                    'type' => 'switcher',
                    'title' => esc_html__('Posted Category', 'senatory'),
                    'desc' => wp_kses(__('you can set <mark>ON / OFF</mark> to show / hide posted category.', 'senatory'), $allowed_html),
                    'text_on' => esc_html__('Yes', 'senatory'),
                    'text_off' => esc_html__('No', 'senatory'),
                    'default' => true
                );
                $fields[] = array(
                    'id' => $prefix . '_posted_tag',
                    'type' => 'switcher',
                    'title' => esc_html__('Posted Tags', 'senatory'),
                    'desc' => wp_kses(__('you can set <mark>ON / OFF</mark> to show / hide post tags.', 'senatory'), $allowed_html),
                    'text_on' => esc_html__('Yes', 'senatory'),
                    'text_off' => esc_html__('No', 'senatory'),
                    'default' => true
                );
                $fields[] = array(
                    'id' => $prefix . '_posted_share',
                    'type' => 'switcher',
                    'title' => esc_html__('Post Share', 'senatory'),
                    'desc' => wp_kses(__('you can set <mark>ON / OFF</mark> to show / hide post share.', 'senatory'), $allowed_html),
                    'text_on' => esc_html__('Yes', 'senatory'),
                    'text_off' => esc_html__('No', 'senatory'),
                    'default' => true
                );
                $fields[] = array(
                    'id' => $prefix . '_post_navigation',
                    'type' => 'switcher',
                    'title' => esc_html__('Post Navigation', 'senatory'),
                    'desc' => wp_kses(__('you can set <mark>ON / OFF</mark> to show / hide post navigation.', 'senatory'), $allowed_html),
                    'text_on' => esc_html__('Yes', 'senatory'),
                    'text_off' => esc_html__('No', 'senatory'),
                    'default' => true
                );
                $fields[] = array(
                    'id' => $prefix . '_next_post_nav_btn',
                    'type' => 'switcher',
                    'title' => esc_html__('Post Navigation With Image', 'senatory'),
                    'desc' => wp_kses(__('you can set <mark>ON / OFF</mark> to show / hide post navigation button.', 'senatory'), $allowed_html),
                    'text_on' => esc_html__('Yes', 'senatory'),
                    'text_off' => esc_html__('No', 'senatory'),
                    'default' => true
                );
                $fields[] = array(
                    'id' => $prefix . '_get_related_post',
                    'type' => 'switcher',
                    'title' => esc_html__('Get Related Post', 'senatory'),
                    'desc' => wp_kses(__('you can set <mark>ON / OFF</mark> to show / hide get related post button.', 'senatory'), $allowed_html),
                    'text_on' => esc_html__('Yes', 'senatory'),
                    'text_off' => esc_html__('No', 'senatory'),
                    'default' => true
                );
                $fields[] = array(
                    'id' => $prefix . '_author_bio',
                    'type' => 'switcher',
                    'title' => esc_html__('Author Bio', 'senatory'),
                    'desc' => wp_kses(__('you can set <mark>ON / OFF</mark> to show / hide author bio button.', 'senatory'), $allowed_html),
                    'text_on' => esc_html__('Yes', 'senatory'),
                    'text_off' => esc_html__('No', 'senatory'),
                    'default' => true
                );
            }

            return $fields;
        }

    }//end class

}//end if

