<?php
/**
 * Theme Metabox Options
 * @package senatory
 * @since 1.0.0
 */

if (!defined('ABSPATH')) {
    exit(); // exit if access directly
}

if (class_exists('CSF')) {

    $allowed_html = senatory()->kses_allowed_html(array('mark'));

    $prefix = 'senatory';

    /*-------------------------------------
        Post Format Options
    -------------------------------------*/
    CSF::createMetabox($prefix . '_post_video_options', array(
        'title' => esc_html__('Video Post Format Options', 'senatory'),
        'post_type' => 'post',
        'post_formats' => 'video'
    ));
    CSF::createSection($prefix . '_post_video_options', array(
        'fields' => array(
            array(
                'id' => 'video_url',
                'type' => 'text',
                'title' => esc_html__('Enter Video URL', 'senatory'),
                'desc' => wp_kses(__('enter <mark>video url</mark> to show in frontend', 'senatory'), $allowed_html)
            )
        )
    ));
    CSF::createMetabox($prefix . '_post_gallery_options', array(
        'title' => esc_html__('Gallery Post Format Options', 'senatory'),
        'post_type' => 'post',
        'post_formats' => 'gallery'
    ));
    CSF::createSection($prefix . '_post_gallery_options', array(
        'fields' => array(
            array(
                'id' => 'gallery_images',
                'type' => 'gallery',
                'title' => esc_html__('Select Gallery Photos', 'senatory'),
                'desc' => wp_kses(__('select <mark>gallery photos</mark> to show in frontend', 'senatory'), $allowed_html)
            )
        )
    ));

    /*-------------------------------------
      Page Container Options
    -------------------------------------*/
    CSF::createMetabox($prefix . '_page_container_options', array(
        'title' => esc_html__('Page Options', 'senatory'),
        'post_type' => array('page'),
    ));
    CSF::createSection($prefix . '_page_container_options', array(
        'title' => esc_html__('Layout & Colors', 'senatory'),
        'icon' => 'fa fa-columns',
        'fields' => senatory_Group_Fields::page_layout()
    ));
    CSF::createSection($prefix . '_page_container_options', array(
        'title' => esc_html__('Header Footer & Breadcrumb', 'senatory'),
        'icon' => 'fa fa-header',
        'fields' => senatory_Group_Fields::Page_Container_Options('header_options')
    ));
    CSF::createSection($prefix . '_page_container_options', array(
        'title' => esc_html__('Width & Padding', 'senatory'),
        'icon' => 'fa fa-file-o',
        'fields' => senatory_Group_Fields::Page_Container_Options('container_options')
    ));


    /*-------------------------------------
     Team Options
    -------------------------------------*/
    CSF::createMetabox($prefix . '_team_options', array(
        'title' => esc_html__('Team Options', 'senatory'),
        'post_type' => array('team'),
        'priority' => 'high'
    ));
    CSF::createSection($prefix . '_team_options', array(
        'title' => esc_html__('Team Designation', 'senatory'),
        'id' => 'senatory-team-designation',
        'fields' => array(
            array(
                'id' => 'designation',
                'type' => 'text',
                'title' => esc_html__('Designation', 'senatory'),
            ),
            array(
                'id' => 'description',
                'type' => 'textarea',
                'title' => esc_html__('Description', 'senatory'),
            ),
        )
    ));
    CSF::createSection($prefix . '_team_options', array(
        'title' => esc_html__('Team Info', 'senatory'),
        'id' => 'senatory-info',
        'fields' => array(
            array(
                'id' => 'team-info',
                'type' => 'repeater',
                'title' => esc_html__('Team Info', 'senatory'),
                'fields' => array(

                    array(
                        'id' => 'title',
                        'type' => 'text',
                        'title' => esc_html__('Title', 'senatory')
                    ),
                    array(
                        'id' => 'icon',
                        'type' => 'icon',
                        'title' => esc_html__('Icon', 'senatory')
                    ),

                ),
            ),
        )
    ));
    CSF::createSection($prefix . '_team_options', array(
        'title' => esc_html__('Social Info', 'senatory'),
        'id' => 'social-info',
        'fields' => array(
            array(
                'id' => 'social-icons',
                'type' => 'repeater',
                'title' => esc_html__('Social Info', 'senatory'),
                'fields' => array(

                    array(
                        'id' => 'title',
                        'type' => 'text',
                        'title' => esc_html__('Title', 'senatory')
                    ),
                    array(
                        'id' => 'icon',
                        'type' => 'icon',
                        'title' => esc_html__('Icon', 'senatory')
                    ),
                    array(
                        'id' => 'url',
                        'type' => 'text',
                        'title' => esc_html__('URL', 'senatory')
                    ),

                ),
            ),
        )
    ));

    //	Deals Meta Box
    CSF::createMetabox($prefix . '_deals_options', array(
        'title' => esc_html__('Deals Options', 'senatory'),
        'post_type' => 'deals',
    ));
    CSF::createSection($prefix . '_deals_options', array(
        'fields' => array(
            array(
                'id' => 'deals_subtitle',
                'type' => 'text',
                'title' => esc_html__('Deals Subtitle', 'senatory'),
                'default' => esc_html__('Embraer P-300E Specification ', 'senatory'),
            ),

            array(
                'id' => 'deals_jet_models_option',
                'type' => 'text',
                'title' => esc_html__('Deals Jet Models', 'senatory'),
                'default' => esc_html__('Legacy 600', 'senatory'),
            ),
            array(
                'id' => 'deals_jet_seats_option',
                'type' => 'text',
                'title' => esc_html__('Jet Seats', 'senatory'),
                'default' => esc_html__('8 - 14 Seats', 'senatory'),
            ),
            array(
                'id' => 'deals_price_option',
                'type' => 'text',
                'title' => esc_html__('Deals Price', 'senatory'),
                'default' => esc_html__('$9,000/ hr ', 'senatory'),
            )
        )
    ));

    //	Packages Meta Box
    CSF::createMetabox($prefix . '_packages_options', array(
        'title' => esc_html__('Packages Options', 'senatory'),
        'post_type' => 'packages',
    ));
    CSF::createSection($prefix . '_packages_options', array(
        'fields' => array(
            array(
                'id' => 'packages_duration_option',
                'type' => 'text',
                'title' => esc_html__('Packages Duration', 'senatory'),
                'default' => esc_html__('2 hours 25 min', 'senatory'),
            ),
            array(
                'id' => 'packages_price_option',
                'type' => 'text',
                'title' => esc_html__('Packages Price', 'senatory'),
                'default' => esc_html__('$115.00', 'senatory'),
            ),
            array(
                'id' => 'packages_date_option',
                'type' => 'text',
                'title' => esc_html__('Packages Date', 'senatory'),
                'default' => esc_html__('Thursday, Nov 4, 2021', 'senatory'),
            ),
            array(
                'id' => 'packages_number_option',
                'type' => 'text',
                'title' => esc_html__('Packages Person Number', 'senatory'),
            )
        )
    ));
    
    //	Courses Meta Box
    CSF::createMetabox($prefix.'_courses_options',array(
        'title' => esc_html__('Courses Options','senatory'),
        'post_type' => 'courses',
    ));

    CSF::createSection($prefix . '_courses_options', array(
        'title' => esc_html__('Social Info', 'senatory'),
        'id' => 'social-info',
        'fields' => array(
            array(
                'id' => 'course_price_option',
                'type' => 'text',
                'title' => esc_html__('Course Price', 'senatory'),
                'default' => esc_html__('$65.00', 'senatory'),
            ),
            array(
                'id' => 'course_start_date_option',
                'type' => 'text',
                'title' => esc_html__('Start From', 'senatory'),
                'default' => esc_html__('Thursday, Nov 4, 2022', 'senatory'),
            ),
            array(
                'id' => 'study-option',
                'type' => 'repeater',
                'title' => esc_html__('Study Options', 'senatory'),
                'fields' => array(

                    array(
                        'id' => 'qualification',
                        'type' => 'text',
                        'title' => esc_html__('Qualification', 'senatory'),
                        'default' => esc_html__('Bachelor of Aviation (Hons)', 'senatory'),
                    ),
                    array(
                        'id' => 'length',
                        'type' => 'text',
                        'title' => esc_html__('Length', 'senatory'),
                        'default' => esc_html__('9 months full time', 'senatory'),
                    ),
                    array(
                        'id' => 'code',
                        'type' => 'text',
                        'title' => esc_html__('Code', 'senatory'),
                        'default' => esc_html__('ba1x', 'senatory'),
                    ),
                ),
            ),
            array(
                'id' => 'course_module_option',
                'type' => 'text',
                'title' => esc_html__('Course Module Title', 'senatory'),
                'default' => esc_html__('Download full course Module', 'senatory'),
            ),
            array(
                'id' => 'course_module_button_title',
                'type' => 'text',
                'title' => esc_html__('Course Module Button Title', 'senatory'),
                'default' => esc_html__('Download', 'senatory'),
            ),
            array(
                'id' => 'course_module_button_url',
                'type' => 'text',
                'title' => esc_html__('Course Module Button URL', 'senatory'),
                'default' => esc_html__('#', 'senatory'),
            ),
        )
    ));



    CSF::createMetabox($prefix.'_event_options',array(
        'title' => esc_html__('Event Options','senatory'),
        'post_type' => 'tribe_events',
    ));

    CSF::createSection($prefix.'_event_options',array(
        'fields' => array(
            array(
                'id' => 'event_breadcrumb_image',
                'type' => 'media',
                'title' => esc_html__('Event Breadcrumb Image', 'senatory'),
                'library' => 'image',
                'desc' => wp_kses(__('you can upload <mark> logo</mark> here it will overwrite customizer uploaded logo', 'senatory'), $allowed_html),
            ),


            array(
              'id'      => 'event_form',
              'type'    => 'text',
              'title'   => 'Form Shortcode',
              'default' => 'Form'
            ),

        )
    ));







}//endif