<?php
/**
 * Theme Options
 * @package senatory
 * @since 1.0.0
 */

if (!defined('ABSPATH')) {
    exit(); // exit if access directly
}
// Control core classes for avoid errors
if (class_exists('CSF')) {

    $allowed_html = senatory()->kses_allowed_html(array('mark'));
    $prefix = 'senatory';
    // Create options
    CSF::createOptions($prefix . '_theme_options', array(
        'menu_title' => esc_html__('Theme Options', 'senatory'),
        'menu_slug' => 'senatory_theme_options',
        'menu_parent' => 'senatory_theme_options',
        'menu_type' => 'submenu',
        'footer_credit' => ' ',
        'menu_icon' => 'fa fa-filter',
        'show_footer' => false,
        'enqueue_webfont' => false,
        'show_search' => true,
        'show_reset_all' => true,
        'show_reset_section' => true,
        'show_all_options' => false,
        'theme' => 'dark',
        'framework_title' => senatory()->get_theme_info('name')
    ));

    /*-------------------------------------------------------
        ** General  Options
    --------------------------------------------------------*/
    CSF::createSection($prefix . '_theme_options', array(
        'title' => esc_html__('General', 'senatory'),
        'id' => 'general_options',
        'icon' => 'fas fa-cogs',
    ));
    /* Preloader */
    CSF::createSection($prefix . '_theme_options', array(
        'title' => esc_html__('Preloader', 'senatory'),
        'id' => 'theme_general_preloader_options',
        'icon' => 'fa fa-spinner',
        'parent' => 'general_options',
        'fields' => array(
            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Preloader Options', 'senatory') . '</h3>'
            ),
            array(
                'id' => 'preloader_enable',
                'title' => esc_html__('Preloader', 'senatory'),
                'type' => 'switcher',
                'desc' => wp_kses(__('you can set <mark>Yes / No</mark> to enable/disable preloader', 'senatory'), $allowed_html),
                'default' => true,
            ),
            array(
                'id' => 'preloader_bg_color',
                'title' => esc_html__('Background Color', 'senatory'),
                'type' => 'color',
                'default' => '#ffffff',
                'desc' => wp_kses(__('you can set <mark>overlay color</mark> for preloader background image', 'senatory'), $allowed_html),
                'dependency' => array('preloader_enable', '==', 'true')
            ),
        )
    ));

    /*-------------------------------------------------------
           ** Typography  Options
    --------------------------------------------------------*/
    CSF::createSection($prefix . '_theme_options', array(
        'id' => 'typography',
        'title' => esc_html__('Typography', 'senatory'),
        'icon' => 'fas fa-text-height',
        'parent' => 'general_options',
        'fields' => array(
            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Body Font Options', 'senatory') . '</h3>',
            ),

            array(
                'type' => 'typography',
                'title' => esc_html__('Body Typography', 'senatory'),
                'id' => '_body_font',
                'default' => array(
                    'font-family' => 'Roboto',
                    'font-size' => '14',
                    'line-height' => '26',
                    'unit' => 'px',
                    'type' => 'google',
                ),
                'color' => false,
                'subset' => false,
                'text_align' => false,
                'text_transform' => false,
                'letter_spacing' => false,
                'line_height' => false,
                'desc' => wp_kses(__('You can set <mark>font</mark> for all html tags (if not use different heading font)', 'senatory'), $allowed_html),
            ),

            array(
                'id' => 'body_font_variant',
                'type' => 'select',
                'title' => esc_html__('Load Font Variant', 'senatory'),
                'multiple' => true,
                'chosen' => true,
                'options' => array(
                    '300' => esc_html__('Light 300', 'senatory'),
                    '400' => esc_html__('Regular 400', 'senatory'),
                    '500' => esc_html__('Medium 500', 'senatory'),
                    '600' => esc_html__('Semi Bold 600', 'senatory'),
                    '700' => esc_html__('Bold 700', 'senatory'),
                    '800' => esc_html__('Extra Bold 800', 'senatory'),
                ),
                'default' => array('400', '700')
            ),

            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Heading Font Options', 'senatory') . '</h3>',
            ),

            array(
                'type' => 'switcher',
                'id' => 'heading_font_enable',
                'title' => esc_html__('Heading Font', 'senatory'),
                'desc' => wp_kses(__('You can set <mark>yes</mark> to select different heading font', 'senatory'), $allowed_html),
                'default' => true
            ),

            array(
                'type' => 'typography',
                'title' => esc_html__('Heading Typography', 'senatory'),
                'id' => 'heading_font',
                'default' => array(
                    'font-family' => 'Barlow Semi Condensed',
                    'type' => 'google',
                ),
                'color' => false,
                'subset' => false,
                'text_align' => false,
                'text_transform' => false,
                'letter_spacing' => false,
                'font_size' => false,
                'line_height' => false,
                'desc' => wp_kses(__('you can set <mark>font</mark> for  for heading tag .eg: h1,h2mh3,h4,h5,h6', 'senatory'), $allowed_html),
                'dependency' => array('heading_font_enable', '==', 'true')
            ),

            array(
                'id' => 'heading_font_variant',
                'type' => 'select',
                'title' => esc_html__('Load Font Variant', 'senatory'),
                'multiple' => true,
                'chosen' => true,
                'options' => array(
                    '300' => esc_html__('Light 300', 'senatory'),
                    '400' => esc_html__('Regular 400', 'senatory'),
                    '500' => esc_html__('Medium 500', 'senatory'),
                    '600' => esc_html__('Semi Bold 600', 'senatory'),
                    '700' => esc_html__('Bold 700', 'senatory'),
                    '800' => esc_html__('Extra Bold 800', 'senatory'),
                ),
                'default' => array('400', '500', '600', '700', '800'),
                'dependency' => array('heading_font_enable', '==', 'true')
            ),

        )
    ));

    /* Preloader */
    CSF::createSection($prefix . '_theme_options', array(
        'title' => esc_html__('Back To Top', 'senatory'),
        'id' => 'theme_general_back_top_options',
        'icon' => 'fa fa-arrow-up',
        'parent' => 'general_options',
        'fields' => array(
            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Back Top Options', 'senatory') . '</h3>'
            ),
            array(
                'id' => 'back_top_enable',
                'title' => esc_html__('Back Top', 'senatory'),
                'type' => 'switcher',
                'desc' => wp_kses(__('you can set <mark>Yes / No</mark> to show/hide back to top', 'senatory'), $allowed_html),
                'default' => true,
            ),
            array(
                'id' => 'back_top_icon',
                'title' => esc_html__('Back Top Icon', 'senatory'),
                'type' => 'icon',
                'default' => 'fa fa-angle-up',
                'desc' => wp_kses(__('you can set <mark>icon</mark> for back to top.', 'senatory'), $allowed_html),
                'dependency' => array('back_top_enable', '==', 'true')
            ),
        )
    ));
    CSF::createSection($prefix . '_theme_options', array(
        'title' => esc_html__('SVG Upload', 'senatory'),
        'id' => 'theme_general_poll_options',
        'icon' => 'fa-solid fa-frame',
        'parent' => 'general_options',
        'fields' => array(
            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('SVG Upload Options', 'senatory') . '</h3>'
            ),

            array(
                'id' => 'enable_svg_upload',
                'type' => 'switcher',
                'title' => esc_html__('Enable Svg Upload ?', 'senatory'),
                'desc' => esc_html__('If you want to enable or disable svg upload you can set ( YES / NO )', 'senatory'),
                'default' => false,
            ),

        )
    ));

    CSF::createSection($prefix . '_theme_options', array(
        'title' => esc_html__('Poll Bar', 'senatory'),
        'id' => 'theme_general_poll_options',
        'icon' => 'fa fa-arrow-up',
        'parent' => 'general_options',
        'fields' => array(
            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Poll Bar Options', 'senatory') . '</h3>'
            ),

            array(
                'id' => 'poll_logo',
                'type' => 'media',
                'title' => esc_html__('Poll Bar Image', 'senatory'),
                'library' => 'image',
                'desc' => wp_kses(__('you can upload <mark> logo</mark> here ', 'senatory'), $allowed_html),
            ),

            array(
                'id' => 'poll_enable',
                'title' => esc_html__('Enable Poll Popup', 'senatory'),
                'type' => 'switcher',
                'desc' => wp_kses(__('you can set <mark>Yes / No</mark> to show/hide poll bar', 'senatory'), $allowed_html),
                'default' => true,
            ),

            array(
                'id' => 'poll_newsletter',
                'title' => esc_html__('Poll Newsletter Shortcode', 'senatory'),
                'type' => 'text',
                'desc' => 'Poll Form Shortcode',
            ),


        )
    ));


    /*----------------------------------
        Header & Footer Style
    -----------------------------------*/
    CSF::createSection($prefix . '_theme_options', array(
        'title' => esc_html__('Set Header & Footer Type', 'senatory'),
        'id' => 'header_footer_style_options',
        'icon' => 'eicon-banner',
        'fields' => array(
            array(
                'type' => 'subheading',
                'content' => esc_html__('Global Header Style', 'senatory'),
            ),
            array(
                'id' => 'navbar_type',
                'title' => esc_html__('Navbar Type', 'senatory'),
                'type' => 'image_select',
                'options' => array(
                    '' => SENATORY_THEME_SETTINGS_IMAGES . '/header/01.png',
                    'style-01' => SENATORY_THEME_SETTINGS_IMAGES . '/header/02.png',
                    'style-02' => SENATORY_THEME_SETTINGS_IMAGES . '/header/03.png',
                    'style-03' => SENATORY_THEME_SETTINGS_IMAGES . '/header/04.png',
                    'style-04' => SENATORY_THEME_SETTINGS_IMAGES . '/header/05.png',
                    'style-05' => SENATORY_THEME_SETTINGS_IMAGES . '/header/06.png',
                  
                ),
                'default' => '',
                'desc' => wp_kses(__('you can set <mark>navbar type</mark> it will show in every page except you select specific navbar type form page settings.', 'senatory'), $allowed_html),
            ),
            array(
                'type' => 'subheading',
                'content' => esc_html__('Global Footer Style', 'senatory'),
            ),
            array(
                'id' => 'footer_type',
                'title' => esc_html__('Footer Type', 'senatory'),
                'type' => 'image_select',
                'options' => array(
                    '' => SENATORY_THEME_SETTINGS_IMAGES . '/footer/01.png',
                    'style-01' => SENATORY_THEME_SETTINGS_IMAGES . '/footer/02.png',
                    'style-02' => SENATORY_THEME_SETTINGS_IMAGES . '/footer/03.png',
                    'style-03' => SENATORY_THEME_SETTINGS_IMAGES . '/footer/04.png',
                    'style-04' => SENATORY_THEME_SETTINGS_IMAGES . '/footer/05.webp'
                ),
                'default' => '',
                'desc' => wp_kses(__('you can set <mark>footer type</mark> it will show in every page except you select specific navbar type form page settings.', 'senatory'), $allowed_html),
            ),
        )
    ));

    /*-------------------------------------------------------
       ** Entire Site Header  Options
   --------------------------------------------------------*/
    CSF::createSection($prefix . '_theme_options', array(
        'id' => 'headers_settings',
        'title' => esc_html__('Headers', 'senatory'),
        'icon' => 'fa fa-home'
    ));


    /* Header Style 01 */
    CSF::createSection($prefix . '_theme_options', array(
        'title' => esc_html__('Header One', 'senatory'),
        'id' => 'theme_header_one_options',
        'icon' => 'fa fa-image',
        'parent' => 'headers_settings',
        'fields' => array(

            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Theme Logo', 'senatory') . '</h3>'
            ),

            array(
                'id' => 'header_one_logo',
                'type' => 'media',
                'title' => esc_html__('Logo', 'senatory'),
                'library' => 'image',
                'desc' => wp_kses(__('you can upload <mark> logo</mark> here it will overwrite customizer uploaded logo', 'senatory'), $allowed_html),
            ),



             array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Social Options', 'senatory') . '</h3>'
            ),

            array(
                'id' => 'sidebar_social_icon_header_one',
                'type' => 'switcher',
                'title' => esc_html__('Social Icons', 'senatory'),
                'default' => true,
                'desc' => wp_kses(__('You can <mark> show/hide</mark> navbar button of header two', 'senatory'), $allowed_html),
            ),

            array(
                'id' => 'sidebar_social_repeater_header_one',
                'type' => 'repeater',
                'title' => esc_html__('Add Social Icon', 'senatory'),
                'dependency' => array('sidebar_social_icon_header_one', '==', 'true'),
                'fields' => array(
                    array(
                        'id' => 'sidebar_social_icon_item_icon_one',
                        'type' => 'icon',
                        'title' => esc_html__('Choose Social Icon', 'senatory'),
                        'default' => 'fab fa-facebook-f'
                    ),
                    array(
                        'id' => 'sidebar_social_icon_item_url_one',
                        'type' => 'text',
                        'title' => esc_html__('Insert Social URL', 'senatory'),
                        'default' => '#'
                    ),
                )
            ),



            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Contact Box', 'senatory') . '</h3>'
            ),

            array(
                'id' => 'header_two_info_item',
                'type' => 'switcher',
                'title' => esc_html__('Show Contact Box', 'senatory'),
                'default' => true,
                'desc' => wp_kses(__('you can <mark> show/hide</mark> info item of header five', 'senatory'), $allowed_html),
            ),

            array(
                'id' => 'header_two_info_item_repeater',
                'type' => 'repeater',
                'title' => esc_html__('Add Conact Box Item', 'senatory'),
                'dependency' => array('header_two_info_item', '==', 'true'),
                'fields' => array(
                    array(
                        'id' => 'header_two_info_item_icon',
                        'type' => 'icon',
                        'title' => esc_html__('Info Item Icon', 'senatory'),
                        'default' => 'flaticon-call'
                    ),
                    array(
                        'id' => 'header_two_info_item_number',
                        'type' => 'text',
                        'title' => esc_html__('Info Number', 'senatory'),
                        'default' => esc_html__('+91 458 654 528', 'senatory')
                    ),
                    array(
                        'id' => 'header_two_info_item_url',
                        'type' => 'text',
                        'title' => esc_html__('Info URL', 'senatory'),
                        'default' => '#'
                    ),
                )
            ),


            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Email Box', 'senatory') . '</h3>'
            ),

            array(
                'id' => 'header_two_info_item_email',
                'type' => 'switcher',
                'title' => esc_html__('Show Email Box', 'senatory'),
                'default' => true,
                'desc' => wp_kses(__('you can <mark> show/hide</mark> info item of header five', 'senatory'), $allowed_html),
            ),

            array(
                'id' => 'header_two_info_item_repeater_email',
                'type' => 'repeater',
                'title' => esc_html__('Add Mail Box Item', 'senatory'),
                'dependency' => array('header_two_info_item_email', '==', 'true'),
                'fields' => array(
                    array(
                        'id' => 'header_two_info_item_icon_email',
                        'type' => 'icon',
                        'title' => esc_html__('Mail Item Icon', 'senatory'),
                        'default' => 'flaticon-call'
                    ),
                    array(
                        'id' => 'header_two_info_item_number_email',
                        'type' => 'text',
                        'title' => esc_html__('Mail Address', 'senatory'),
                        'default' => esc_html__('info@gmail.com', 'senatory')
                    ),

                    array(
                        'id' => 'header_two_info_item_url_email',
                        'type' => 'text',
                        'title' => esc_html__('Mail URL', 'senatory'),
                        'default' => '#'
                    ),

                )
            ),


            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Info Box', 'senatory') . '</h3>'
            ),

            array(
                'id' => 'header_two_info_item_new',
                'type' => 'switcher',
                'title' => esc_html__('Show Info Box', 'senatory'),
                'default' => false,
                'desc' => wp_kses(__('you can <mark> show/hide</mark> info item', 'senatory'), $allowed_html),
            ),

            array(
                'id' => 'header_two_info_item_repeater_new',
                'type' => 'repeater',
                'title' => esc_html__('Add Info Box Item', 'senatory'),
                'dependency' => array('header_two_info_item_new', '==', 'true'),
                'fields' => array(
                    array(
                        'id' => 'header_two_info_item_icon_new',
                        'type' => 'icon',
                        'title' => esc_html__('Info Item Icon', 'senatory'),
                        'default' => 'flaticon-call'
                    ),
                    array(
                        'id' => 'header_two_info_item_number_new',
                        'type' => 'text',
                        'title' => esc_html__('Info Text', 'senatory'),
                        'default' => esc_html__('Test Content', 'senatory')
                    ),

                    array(
                        'id' => 'header_two_info_item_url_new',
                        'type' => 'text',
                        'title' => esc_html__('#', 'senatory'),
                        'default' => '#'
                    ),

                )
            ),


            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Search Bar', 'senatory') . '</h3>'
            ),

            array(
                'id' => 'search_bar_enable',
                'title' => esc_html__('Display Search Bar', 'senatory'),
                'type' => 'switcher',
                'desc' => esc_html__('Enable or Disable Search Bar', 'senatory'),
                'default' => true,
            ),


            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Header Button', 'senatory') . '</h3>'
            ),

            array(
                'id' => 'header_btn_enable',
                'title' => esc_html__('Display Header Right Button', 'senatory'),
                'type' => 'switcher',
                'desc' => esc_html__('Enable or Disable Button', 'senatory'),
                'default' => true,
            ),

            array(
                'id' => 'top_text_btn',
                'type' => 'text',
                'title' => esc_html__('Top Button Text', 'senatory'),
                'default' => esc_html__('Donate Now', 'senatory'),
                'desc' => esc_html__('Type text', 'senatory'),
                'dependency' => array('header_btn_enable', '==', 'true'),
            ),

            array(
                'id' => 'top_text_btn_link',
                'type' => 'text',
                'title' => esc_html__('Top Button Link', 'senatory'),
                'default' => esc_html__('#', 'senatory'),
                'desc' => esc_html__('Type Button Link', 'senatory'),
                'dependency' => array('header_btn_enable', '==', 'true'),
            ),


        )
    ));

    /* Header Style 02 */
    CSF::createSection($prefix . '_theme_options', array(
        'title' => esc_html__('Header Two', 'senatory'),
        'id' => 'theme_header_two_options',
        'icon' => 'fa fa-image',
        'parent' => 'headers_settings',
        'fields' => array(


            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Theme Logo', 'senatory') . '</h3>'
            ),

            array(
                'id' => 'header_two_logo',
                'type' => 'media',
                'title' => esc_html__('Logo', 'senatory'),
                'library' => 'image',
                'desc' => wp_kses(__('you can upload <mark> logo</mark> here it will overwrite customizer uploaded logo', 'senatory'), $allowed_html),
            ),


            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Header Button', 'senatory') . '</h3>'
            ),

            array(
                'id' => 'header_btn_enable_two',
                'title' => esc_html__('Display Header Right Button', 'senatory'),
                'type' => 'switcher',
                'desc' => esc_html__('Enable or Disable Button', 'senatory'),
                'default' => true,
            ),

            array(
                'id' => 'top_text_btn_two',
                'type' => 'text',
                'title' => esc_html__('Top Button Text', 'senatory'),
                'default' => esc_html__('Donate Now', 'senatory'),
                'desc' => esc_html__('Type text', 'senatory'),
                'dependency' => array('header_btn_enable_two', '==', 'true'),
            ),

            array(
                'id' => 'top_text_btn_link_two',
                'type' => 'text',
                'title' => esc_html__('Top Button Link', 'senatory'),
                'default' => esc_html__('#', 'senatory'),
                'desc' => esc_html__('Type Button Link', 'senatory'),
                'dependency' => array('header_btn_enable_two', '==', 'true'),
            ),


        )
    ));


    /* Header Style 03 */
    CSF::createSection($prefix . '_theme_options', array(
        'title' => esc_html__('Header Three', 'senatory'),
        'id' => 'theme_header_three_options',
        'icon' => 'fa fa-image',
        'parent' => 'headers_settings',
        'fields' => array(


            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Theme Logo', 'senatory') . '</h3>'
            ),

            array(
                'id' => 'header_three_logo',
                'type' => 'media',
                'title' => esc_html__('Logo', 'senatory'),
                'library' => 'image',
                'desc' => wp_kses(__('you can upload <mark> logo</mark> here it will overwrite customizer uploaded logo', 'senatory'), $allowed_html),
            ),


            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Header Button', 'senatory') . '</h3>'
            ),

            array(
                'id' => 'header_btn_enable_three',
                'title' => esc_html__('Display Header Right Button', 'senatory'),
                'type' => 'switcher',
                'desc' => esc_html__('Enable or Disable Button', 'senatory'),
                'default' => true,
            ),

            array(
                'id' => 'top_text_btn_three',
                'type' => 'text',
                'title' => esc_html__('Top Button Text', 'senatory'),
                'default' => esc_html__('Donate Now', 'senatory'),
                'desc' => esc_html__('Type text', 'senatory'),
                'dependency' => array('header_btn_enable_three', '==', 'true'),
            ),

            array(
                'id' => 'top_text_btn_link_three',
                'type' => 'text',
                'title' => esc_html__('Top Button Link', 'senatory'),
                'default' => esc_html__('#', 'senatory'),
                'desc' => esc_html__('Type Button Link', 'senatory'),
                'dependency' => array('header_btn_enable_three', '==', 'true'),
            ),


        )
    ));


    /* Header Style 04 */
    CSF::createSection($prefix . '_theme_options', array(
        'title' => esc_html__('Header Four', 'senatory'),
        'id' => 'theme_header_four_options',
        'icon' => 'fa fa-image',
        'parent' => 'headers_settings',
        'fields' => array(

            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Theme Logo', 'senatory') . '</h3>'
            ),

            array(
                'id' => 'header_four_logo',
                'type' => 'media',
                'title' => esc_html__('Logo', 'senatory'),
                'library' => 'image',
                'desc' => wp_kses(__('you can upload <mark> logo</mark> here it will overwrite customizer uploaded logo', 'senatory'), $allowed_html),
            ),

            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Social Options', 'senatory') . '</h3>'
            ),

            array(
                'id' => 'sidebar_social_icon_header_four',
                'type' => 'switcher',
                'title' => esc_html__('Social Icons', 'senatory'),
                'default' => true,
                'desc' => wp_kses(__('You can <mark> show/hide</mark> navbar button of header two', 'senatory'), $allowed_html),
            ),

            array(
                'id' => 'sidebar_social_repeater_header_four',
                'type' => 'repeater',
                'title' => esc_html__('Add Social Icon', 'senatory'),
                'dependency' => array('sidebar_social_icon', '==', 'true'),
                'fields' => array(
                    array(
                        'id' => 'sidebar_social_icon_item_icon',
                        'type' => 'icon',
                        'title' => esc_html__('Choose Social Icon', 'senatory'),
                        'default' => 'fab fa-facebook-f'
                    ),
                    array(
                        'id' => 'sidebar_social_icon_item_url',
                        'type' => 'text',
                        'title' => esc_html__('Insert Social URL', 'senatory'),
                        'default' => '#'
                    ),
                )
            ),


            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Contact Box', 'senatory') . '</h3>'
            ),

            array(
                'id' => 'header_four_info_item',
                'type' => 'switcher',
                'title' => esc_html__('Show Contact Box', 'senatory'),
                'default' => true,
                'desc' => wp_kses(__('you can <mark> show/hide</mark> info item of header five', 'senatory'), $allowed_html),
            ),

            array(
                'id' => 'header_four_info_item_repeater',
                'type' => 'repeater',
                'title' => esc_html__('Add Conact Box Item', 'senatory'),
                'dependency' => array('header_two_info_item', '==', 'true'),
                'fields' => array(
                    array(
                        'id' => 'header_four_info_item_icon',
                        'type' => 'icon',
                        'title' => esc_html__('Info Item Icon', 'senatory'),
                        'default' => 'flaticon-call'
                    ),
                    array(
                        'id' => 'header_four_info_item_number',
                        'type' => 'text',
                        'title' => esc_html__('Info Number', 'senatory'),
                        'default' => esc_html__('+91 458 654 528', 'senatory')
                    ),
                    array(
                        'id' => 'header_four_info_item_url',
                        'type' => 'text',
                        'title' => esc_html__('Info URL', 'senatory'),
                        'default' => '#'
                    ),
                )
            ),


            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Email Box', 'senatory') . '</h3>'
            ),

            array(
                'id' => 'header_four_info_item_email',
                'type' => 'switcher',
                'title' => esc_html__('Show Email Box', 'senatory'),
                'default' => true,
                'desc' => wp_kses(__('you can <mark> show/hide</mark> info item of header five', 'senatory'), $allowed_html),
            ),

            array(
                'id' => 'header_four_info_item_repeater_email',
                'type' => 'repeater',
                'title' => esc_html__('Add Mail Box Item', 'senatory'),
                'dependency' => array('header_four_info_item_email', '==', 'true'),
                'fields' => array(
                    array(
                        'id' => 'header_four_info_item_icon_email',
                        'type' => 'icon',
                        'title' => esc_html__('Mail Item Icon', 'senatory'),
                        'default' => 'flaticon-call'
                    ),
                    array(
                        'id' => 'header_four_info_item_number_email',
                        'type' => 'text',
                        'title' => esc_html__('Mail Address', 'senatory'),
                        'default' => esc_html__('info@gmail.com', 'senatory')
                    ),

                    array(
                        'id' => 'header_four_info_item_url_email',
                        'type' => 'text',
                        'title' => esc_html__('Mail URL', 'senatory'),
                        'default' => '#'
                    ),

                )
            ),


            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Info Box', 'senatory') . '</h3>'
            ),

            array(
                'id' => 'header_four_info_item_new',
                'type' => 'switcher',
                'title' => esc_html__('Show Info Box', 'senatory'),
                'default' => false,
                'desc' => wp_kses(__('you can <mark> show/hide</mark> info item', 'senatory'), $allowed_html),
            ),

            array(
                'id' => 'header_four_info_item_repeater_new',
                'type' => 'repeater',
                'title' => esc_html__('Add Info Box Item', 'senatory'),
                'dependency' => array('header_four_info_item_new', '==', 'true'),
                'fields' => array(
                    array(
                        'id' => 'header_four_info_item_icon_new',
                        'type' => 'icon',
                        'title' => esc_html__('Info Item Icon', 'senatory'),
                        'default' => 'flaticon-call'
                    ),
                    array(
                        'id' => 'header_four_info_item_number_new',
                        'type' => 'text',
                        'title' => esc_html__('Info Text', 'senatory'),
                        'default' => esc_html__('Test Content', 'senatory')
                    ),

                    array(
                        'id' => 'header_four_info_item_url_new',
                        'type' => 'text',
                        'title' => esc_html__('#', 'senatory'),
                        'default' => '#'
                    ),

                )
            ),

            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Header Button', 'senatory') . '</h3>'
            ),

            array(
                'id' => 'header_four_btn_enable',
                'title' => esc_html__('Display Header Right Button', 'senatory'),
                'type' => 'switcher',
                'desc' => esc_html__('Enable or Disable Button', 'senatory'),
                'default' => true,
            ),

            array(
                'id' => 'top_text_btn_header_four',
                'type' => 'text',
                'title' => esc_html__('Top Button Text', 'senatory'),
                'default' => esc_html__('Donate Now', 'senatory'),
                'desc' => esc_html__('Type text', 'senatory'),
                'dependency' => array('header_btn_enable', '==', 'true'),
            ),

            array(
                'id' => 'top_text_btn_link_header_four',
                'type' => 'text',
                'title' => esc_html__('Top Button Link', 'senatory'),
                'default' => esc_html__('#', 'senatory'),
                'desc' => esc_html__('Type Button Link', 'senatory'),
                'dependency' => array('header_btn_enable', '==', 'true'),
            ),


        )
    ));
    /* Header Style 05 */
    CSF::createSection($prefix . '_theme_options', array(
        'title' => esc_html__('Header Five', 'senatory'),
        'id' => 'theme_header_five_options',
        'icon' => 'fa fa-image',
        'parent' => 'headers_settings',
        'fields' => array(

            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Theme Logo', 'senatory') . '</h3>'
            ),

            array(
                'id' => 'header_five_logo',
                'type' => 'media',
                'title' => esc_html__('Logo', 'senatory'),
                'library' => 'image',
                'desc' => wp_kses(__('you can upload <mark> logo</mark> here it will overwrite customizer uploaded logo', 'senatory'), $allowed_html),
            ),

            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Social Options', 'senatory') . '</h3>'
            ),

            array(
                'id' => 'header_social_icon_five',
                'type' => 'switcher',
                'title' => esc_html__('Social Icons', 'senatory'),
                'default' => true,
                'desc' => wp_kses(__('You can <mark> show/hide</mark> navbar button of header two', 'senatory'), $allowed_html),
            ),

            array(
                'id' => 'sidebar_social_repeater_header_five',
                'type' => 'repeater',
                'title' => esc_html__('Add Social Icon', 'senatory'),
                'dependency' => array('header_social_icon_five', '==', 'true'),
                'fields' => array(
                    array(
                        'id' => 'header_social_icon_item_icon',
                        'type' => 'icon',
                        'title' => esc_html__('Choose Social Icon', 'senatory'),
                        'default' => 'fab fa-facebook-f'
                    ),
                    array(
                        'id' => 'header_social_icon_item_url',
                        'type' => 'text',
                        'title' => esc_html__('Insert Social URL', 'senatory'),
                        'default' => '#'
                    ),
                )
            ),
            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Contact Box', 'senatory') . '</h3>'
            ),

            array(
                'id' => 'header_five_info_item',
                'type' => 'switcher',
                'title' => esc_html__('Show Contact Box', 'senatory'),
                'default' => true,
                'desc' => wp_kses(__('you can <mark> show/hide</mark> info item of header five', 'senatory'), $allowed_html),
            ),

            array(
                'id' => 'header_five_info_item_repeater',
                'type' => 'repeater',
                'title' => esc_html__('Add Conact Box Item', 'senatory'),
                'dependency' => array('header_two_info_item', '==', 'true'),
                'fields' => array(
                    array(
                        'id' => 'header_five_info_item_icon',
                        'type' => 'icon',
                        'title' => esc_html__('Info Item Icon', 'senatory'),
                        'default' => 'flaticon-call'
                    ),
                    array(
                        'id' => 'header_five_info_item_number',
                        'type' => 'text',
                        'title' => esc_html__('Info Number', 'senatory'),
                        'default' => esc_html__('+91 458 654 528', 'senatory')
                    ),
                    array(
                        'id' => 'header_five_info_item_url',
                        'type' => 'text',
                        'title' => esc_html__('Info URL', 'senatory'),
                        'default' => '#'
                    ),
                )
            ),


            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Email Box', 'senatory') . '</h3>'
            ),

            array(
                'id' => 'header_five_info_item_email',
                'type' => 'switcher',
                'title' => esc_html__('Show Email Box', 'senatory'),
                'default' => true,
                'desc' => wp_kses(__('you can <mark> show/hide</mark> info item of header five', 'senatory'), $allowed_html),
            ),

            array(
                'id' => 'header_five_info_item_repeater_email',
                'type' => 'repeater',
                'title' => esc_html__('Add Mail Box Item', 'senatory'),
                'dependency' => array('header_four_info_item_email', '==', 'true'),
                'fields' => array(
                    array(
                        'id' => 'header_four_info_item_icon_email',
                        'type' => 'icon',
                        'title' => esc_html__('Mail Item Icon', 'senatory'),
                        'default' => 'flaticon-call'
                    ),
                    array(
                        'id' => 'header_five_info_item_number_email',
                        'type' => 'text',
                        'title' => esc_html__('Mail Address', 'senatory'),
                        'default' => esc_html__('info@gmail.com', 'senatory')
                    ),

                    array(
                        'id' => 'header_five_info_item_url_email',
                        'type' => 'text',
                        'title' => esc_html__('Mail URL', 'senatory'),
                        'default' => '#'
                    ),

                )
            ),
            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Info Box', 'senatory') . '</h3>'
            ),

            array(
                'id' => 'header_five_info_item_new',
                'type' => 'switcher',
                'title' => esc_html__('Show Info Box', 'senatory'),
                'default' => false,
                'desc' => wp_kses(__('you can <mark> show/hide</mark> info item', 'senatory'), $allowed_html),
            ),

            array(
                'id' => 'header_five_info_item_repeater_new',
                'type' => 'repeater',
                'title' => esc_html__('Add Info Box Item', 'senatory'),
                'dependency' => array('header_five_info_item_new', '==', 'true'),
                'fields' => array(
                    array(
                        'id' => 'header_five_info_item_icon_new',
                        'type' => 'icon',
                        'title' => esc_html__('Info Item Icon', 'senatory'),
                        'default' => 'flaticon-call'
                    ),
                    array(
                        'id' => 'header_five_info_item_number_new',
                        'type' => 'text',
                        'title' => esc_html__('Info Text', 'senatory'),
                        'default' => esc_html__('Test Content', 'senatory')
                    ),

                    array(
                        'id' => 'header_five_info_item_url_new',
                        'type' => 'text',
                        'title' => esc_html__('#', 'senatory'),
                        'default' => '#'
                    ),

                )
            ),

            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Header Button', 'senatory') . '</h3>'
            ),

            array(
                'id' => 'header_five_btn_enable',
                'title' => esc_html__('Display Header Right Button', 'senatory'),
                'type' => 'switcher',
                'desc' => esc_html__('Enable or Disable Button', 'senatory'),
                'default' => true,
            ),

            array(
                'id' => 'top_text_btn_header_five',
                'type' => 'text',
                'title' => esc_html__('Top Button Text', 'senatory'),
                'default' => esc_html__('Donate Now', 'senatory'),
                'desc' => esc_html__('Type text', 'senatory'),
                'dependency' => array('header_btn_enable', '==', 'true'),
            ),

            array(
                'id' => 'top_text_btn_link_header_five',
                'type' => 'text',
                'title' => esc_html__('Top Button Link', 'senatory'),
                'default' => esc_html__('#', 'senatory'),
                'desc' => esc_html__('Type Button Link', 'senatory'),
                'dependency' => array('header_btn_enable', '==', 'true'),
            ),


        )
    ));

    /* Breadcrumb */
    CSF::createSection($prefix . '_theme_options', array(
        'title' => esc_html__('Breadcrumb', 'senatory'),
        'id' => 'breadcrumb_options',
        'icon' => ' eicon-product-breadcrumbs',
        'fields' => array(
            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Breadcrumb Options', 'senatory') . '</h3>'
            ),
            array(
                'id' => 'breadcrumb_enable',
                'title' => esc_html__('Breadcrumb', 'senatory'),
                'type' => 'switcher',
                'desc' => wp_kses(__('you can set <mark>Yes / No</mark> to show/hide breadcrumb', 'senatory'), $allowed_html),
                'default' => true,
            ),
            array(
                'id' => $prefix .'_breadcrumb_style',
                'type' => 'select',
                'title' => esc_html__('Select Breadcrumb', 'senatory'),
                'options' => array(
                    'breadcumb_style_1' => esc_html__('Style 1', 'senatory'),
                    'breadcumb_style_2' => esc_html__('Style 2', 'senatory'),
                ),
                'default' => 'breadcumb_style_1',
                'dependency' => array('breadcrumb_enable', '==', 'true')
            ),
            array(
                'id' => $prefix .'_breadcrumb_separator',
                'type' => 'select',
                'title' => esc_html__('Select Separator', 'senatory'),
                'desc' => esc_html__('Choose Breadcrumb Separator', 'senatory'),
                'options' => array(
                    '|' => esc_html__('|', 'senatory'),
                    '/' => esc_html__('/', 'senatory'),
                ),
                'default' => '|',
                'dependency' => array('breadcrumb_enable', '==', 'true')
            ),
            array(
                'id' => $prefix .'_breadcrumb_list_bg',
                'title' => esc_html__('Breadcrumb List Background', 'senatory'),
                'type' => 'color',
                'default' => 'transparent',
                'desc' => esc_html__('you can set breadcrumb list background', 'senatory'),
                'dependency' => array('breadcrumb_enable', '==', 'true')
            ),
            array(
                'id' => 'breadcrumb_bg',
                'title' => esc_html__('Background Image', 'senatory'),
                'type' => 'background',
                'desc' => wp_kses(__('you can set <mark>background</mark> for breadcrumb', 'senatory'), $allowed_html),
                'default' => array(
                    'background-size' => 'cover',
                    'background-position' => 'center bottom',
                    'background-repeat' => 'no-repeat',
                ),
                'background_color' => false,
                'dependency' => array('breadcrumb_enable', '==', 'true')
            ),
            array(
                'id' => 'breadcrumb_bg_color',
                'title' => esc_html__('Breadcrumb Background Color', 'senatory'),
                'type' => 'color',
                'default' => 'rgba(0, 27, 97, 0.502)',
                'desc' => wp_kses(__('you can set <mark>overlay color</mark> for Breadcrumb background image', 'senatory'), $allowed_html),
                'dependency' => array('breadcrumb_enable', '==', 'true')
            ),
        )
    ));


    /*-------------------------------------------------------
           ** Footer  Options
    --------------------------------------------------------*/
    CSF::createSection($prefix . '_theme_options', array(
        'title' => esc_html__('Footer', 'senatory'),
        'id' => 'footer_options',
        'icon' => ' eicon-footer',

    ));
    CSF::createSection($prefix . '_theme_options', array(
        'parent' => 'footer_options',
        'id' => 'footer_general_options',
        'title' => esc_html__('Footer One', 'senatory'),
        'icon' => 'fa fa-list-ul',
        'fields' => array(
            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Footer Settings One', 'senatory') . '</h3>'
            ),
            array(
                'id' => 'footer_spacing',
                'title' => esc_html__('Footer Spacing', 'senatory'),
                'type' => 'switcher',
                'desc' => wp_kses(__('you can set <mark>Yes / No</mark> to set footer spacing', 'senatory'), $allowed_html),
                'default' => true,
            ),
            array(
                'id' => 'footer_top_spacing',
                'title' => esc_html__('Footer Top Spacing', 'senatory'),
                'type' => 'slider',
                'desc' => wp_kses(__('you can set <mark>padding</mark> for footer top', 'senatory'), $allowed_html),
                'min' => 0,
                'max' => 500,
                'step' => 1,
                'unit' => 'px',
                'default' => 100,
                'dependency' => array('footer_spacing', '==', 'true')
            ),
            array(
                'id' => 'footer_bottom_spacing',
                'title' => esc_html__('Footer Bottom Spacing', 'senatory'),
                'type' => 'slider',
                'desc' => wp_kses(__('you can set <mark>padding</mark> for footer bottom', 'senatory'), $allowed_html),
                'min' => 0,
                'max' => 500,
                'step' => 1,
                'unit' => 'px',
                'default' => 65,
                'dependency' => array('footer_spacing', '==', 'true')
            ),
            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Footer Copyright Area Options', 'senatory') . '</h3>'
            ),
            array(
                'id' => 'copyright_area_spacing',
                'title' => esc_html__('Copyright Area Spacing', 'senatory'),
                'type' => 'switcher',
                'desc' => wp_kses(__('you can set <mark>Yes / No</mark> to set copyright area spacing', 'senatory'), $allowed_html),
                'default' => true,
            ),
            array(
                'id' => 'copyright_text',
                'title' => esc_html__('Copyright Area Text', 'senatory'),
                'type' => 'textarea',
                'desc' => wp_kses(__('use  <mark>{copy}</mark> for copyright symbol, use <mark>{year}</mark> for current year, ', 'senatory'), $allowed_html)
            ),
            array(
                'id' => 'copyright_area_top_spacing',
                'title' => esc_html__('Copyright Area Top Spacing', 'senatory'),
                'type' => 'slider',
                'desc' => wp_kses(__('you can set <mark>padding</mark> for copyright area top', 'senatory'), $allowed_html),
                'min' => 0,
                'max' => 500,
                'step' => 1,
                'unit' => 'px',
                'default' => 20,
                'dependency' => array('copyright_area_spacing', '==', 'true')
            ),
            array(
                'id' => 'copyright_area_bottom_spacing',
                'title' => esc_html__('Copyright Area Bottom Spacing', 'senatory'),
                'type' => 'slider',
                'desc' => wp_kses(__('you can set <mark>padding</mark> for copyright area bottom', 'senatory'), $allowed_html),
                'min' => 0,
                'max' => 500,
                'step' => 1,
                'unit' => 'px',
                'default' => 20,
                'dependency' => array('copyright_area_spacing', '==', 'true')
            )
        )
    ));

    // Footer 02
    CSF::createSection($prefix . '_theme_options', array(
        'parent' => 'footer_options',
        'id' => 'footer_two_options',
        'title' => esc_html__('Footer Two', 'senatory'),
        'icon' => 'fa fa-list-ul',
        'fields' => array(
            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Footer Top Settings', 'senatory') . '</h3>'
            ),
            array(
                'id' => 'footer_two_logo',
                'type' => 'media',
                'title' => esc_html__('Logo', 'senatory'),
                'library' => 'image',
                'desc' => wp_kses(__('you can upload <mark> logo</mark> here it will overwrite customizer uploaded logo', 'senatory'), $allowed_html),
            ),
            array(
                'id' => 'footer_two_paragraph',
                'title' => esc_html__('Paragraph Area Text', 'senatory'),
                'type' => 'textarea',
                'desc' => wp_kses(__('Enter Your Footer Paragraph', 'senatory'), $allowed_html)
            ),

            array(

                'id' => 'footer_two_top_repeater',
                'type' => 'repeater',
                'title' => esc_html__('Footer Top Widget Repeater', 'senatory'),
                'fields' => array(

                    array(
                        'id' => 'footer_two_info_icon',
                        'type' => 'icon',
                        'title' => esc_html__('Info Item Icon', 'senatory'),
                        'default' => 'flaticon-call'
                    ),

                    array(
                        'id' => 'footer_two_top_info',
                        'type' => 'textarea',
                        'title' => esc_html__('Footer Top Widget Info Box', 'senatory'),
                        'default' => esc_html__('Europe 45 Gloucester Road London DT1M 3BF +44 (0)20 3671 5709', 'senatory'),
                    ),


                )
            ),

            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Footer Newsletter Shortcode', 'senatory') . '</h3>'
            ),

            array(
                'id' => 'footer_two_newsletter_title',
                'title' => esc_html__('Footer Newsletter Title', 'senatory'),
                'type' => 'text',
                'default' => esc_html__('Join Our Newsletter', 'senatory'),
                'desc' => wp_kses(__('Insert Footer Newsletter title', 'senatory'), $allowed_html)
            ),

            array(
                'id' => 'footer_two_newsletter',
                'title' => esc_html__('Footer Newsletter Shortcode', 'senatory'),
                'type' => 'text',
                'desc' => 'Form Shortcode',
            ),

            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Footer Settings Two', 'senatory') . '</h3>'
            ),

            array(
                'id' => 'footer_two_spacing',
                'title' => esc_html__('Footer Spacing', 'senatory'),
                'type' => 'switcher',
                'desc' => wp_kses(__('you can set <mark>Yes / No</mark> to set footer spacing', 'senatory'), $allowed_html),
                'default' => true,
            ),

            array(
                'id' => 'footer_two_top_spacing',
                'title' => esc_html__('Footer Top Spacing', 'senatory'),
                'type' => 'slider',
                'desc' => wp_kses(__('you can set <mark>padding</mark> for footer top', 'senatory'), $allowed_html),
                'min' => 0,
                'max' => 500,
                'step' => 1,
                'unit' => 'px',
                'default' => 100,
                'dependency' => array('footer_two_spacing', '==', 'true')
            ),
            array(
                'id' => 'footer_two_bottom_spacing',
                'title' => esc_html__('Footer Bottom Spacing', 'senatory'),
                'type' => 'slider',
                'desc' => wp_kses(__('you can set <mark>padding</mark> for footer bottom', 'senatory'), $allowed_html),
                'min' => 0,
                'max' => 500,
                'step' => 1,
                'unit' => 'px',
                'default' => 65,
                'dependency' => array('footer_two_spacing', '==', 'true')
            ),
            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Footer Copyright Area Options', 'senatory') . '</h3>'
            ),
            array(
                'id' => 'copyright_two_area_spacing',
                'title' => esc_html__('Copyright Area Spacing', 'senatory'),
                'type' => 'switcher',
                'desc' => wp_kses(__('you can set <mark>Yes / No</mark> to set copyright area spacing', 'senatory'), $allowed_html),
                'default' => true,
            ),
            array(
                'id' => 'copyright_text',
                'title' => esc_html__('Copyright Area Text', 'senatory'),
                'type' => 'textarea',
                'desc' => wp_kses(__('use  <mark>{copy}</mark> for copyright symbol, use <mark>{year}</mark> for current year, ', 'senatory'), $allowed_html)
            ),
            array(
                'id' => 'copyright_two_area_top_spacing',
                'title' => esc_html__('Copyright Area Top Spacing', 'senatory'),
                'type' => 'slider',
                'desc' => wp_kses(__('you can set <mark>padding</mark> for copyright area top', 'senatory'), $allowed_html),
                'min' => 0,
                'max' => 500,
                'step' => 1,
                'unit' => 'px',
                'default' => 20,
                'dependency' => array('copyright_two_area_spacing', '==', 'true')
            ),


            array(
                'id' => 'copyright_two_area_bottom_spacing',
                'title' => esc_html__('Copyright Area Bottom Spacing', 'senatory'),
                'type' => 'slider',
                'desc' => wp_kses(__('you can set <mark>padding</mark> for copyright area bottom', 'senatory'), $allowed_html),
                'min' => 0,
                'max' => 500,
                'step' => 1,
                'unit' => 'px',
                'default' => 20,
                'dependency' => array('copyright_two_area_spacing', '==', 'true')
            ),


            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Footer Background Image Options', 'senatory') . '</h3>'
            ),
            array(
                'id' => 'footer_two_enable',
                'title' => esc_html__('Footer', 'senatory'),
                'type' => 'switcher',
                'desc' => wp_kses(__('you can set <mark>Yes / No</mark> to show/hide footer', 'senatory'), $allowed_html),
                'default' => true,
            ),
            array(
                'id' => 'footer_two_bg_image',
                'title' => esc_html__('Background Image', 'senatory'),
                'type' => 'background',
                'desc' => wp_kses(__('you can set <mark>background</mark> for footer', 'senatory'), $allowed_html),
                'default' => array(
                    'background-size' => 'cover',
                    'background-position' => 'center bottom',
                    'background-repeat' => 'no-repeat',
                ),
                'background_color' => false,
                'dependency' => array('footer_two_enable', '==', 'true')
            ),
            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Footer About Item Settings', 'senatory') . '</h3>'
            ),
            array(
                'id' => 'footer_social_icon',
                'type' => 'switcher',
                'title' => esc_html__('Social Icon', 'senatory'),
                'default' => true,
                'desc' => wp_kses(__('you can <mark> show/hide</mark> navbar button of header two', 'senatory'), $allowed_html),
            ),
            array(
                'id' => 'footer_social_repeater',
                'type' => 'repeater',
                'title' => esc_html__('Social Item Repeater', 'senatory'),
                'dependency' => array('footer_social_icon', '==', 'true'),
                'fields' => array(
                    array(
                        'id' => 'footer_social_icon_item_icon',
                        'type' => 'icon',
                        'title' => esc_html__('Social Item Icon', 'senatory'),
                        'default' => 'flaticon-call'
                    ),
                    array(
                        'id' => 'footer_social_icon_item_url',
                        'type' => 'text',
                        'title' => esc_html__('Social URL', 'senatory'),
                        'default' => '#'
                    ),
                )
            ),
        )
    ));
    // Footer 03
    CSF::createSection($prefix . '_theme_options', array(
        'parent' => 'footer_options',
        'id' => 'footer_three_general_options',
        'title' => esc_html__('Footer Three', 'senatory'),
        'icon' => 'fa fa-list-ul',
        'fields' => array(
            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Call To Action Settings Three', 'senatory') . '</h3>'
            ),
            array(
                'id' => 'call_to_action_enable',
                'title' => esc_html__('Call To Action Background Image', 'senatory'),
                'type' => 'switcher',
                'desc' => wp_kses(__('you can set <mark>Yes / No</mark> to show/hide footer', 'senatory'), $allowed_html),
                'default' => true,
            ),

            array(
                'id' => 'call_to_action_bg',
                'title' => esc_html__('CTA Background Image', 'senatory'),
                'type' => 'background',
                'desc' => wp_kses(__('you can set <mark>background</mark> for call to action', 'senatory'), $allowed_html),
                'default' => array(
                    'background-size' => 'cover',
                    'background-position' => 'center bottom',
                    'background-repeat' => 'no-repeat',
                ),
                'background_gradient' => true
            ),


            array(
                'id' => 'call_to_action_text',
                'title' => esc_html__('CTA Text Title', 'senatory'),
                'type' => 'textarea',
                'default' => esc_html__('Would you like to become one of our members?', 'senatory'),
                'desc' => wp_kses(__('use  <mark>Title</mark> Call To Action Text, use <mark>Span</mark> For strong tag, ', 'senatory'), $allowed_html)
            ),
            array(
                'id' => 'call_to_action_button_title',
                'type' => 'text',
                'title' => esc_html__('Button Title', 'senatory'),
                'default' => esc_html__('JOIN NOW', 'senatory')
            ),
            array(
                'id' => 'call_to_action_button_url',
                'type' => 'text',
                'title' => esc_html__('Button URL', 'senatory'),
                'default' => '#'
            ),
            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Footer Settings Three', 'senatory') . '</h3>'
            ),
            array(
                'id' => 'footer_three_bg_image',
                'title' => esc_html__('Background Image', 'senatory'),
                'type' => 'background',
                'desc' => wp_kses(__('you can set <mark>background</mark> for footer', 'senatory'), $allowed_html),
                'default' => array(
                    'background-size' => 'cover',
                    'background-position' => 'center bottom',
                    'background-repeat' => 'no-repeat',
                ),
                'background_gradient' => true
            ),
            array(
                'id' => 'footer_three_spacing',
                'title' => esc_html__('Footer Spacing', 'senatory'),
                'type' => 'switcher',
                'desc' => wp_kses(__('you can set <mark>Yes / No</mark> to set footer spacing', 'senatory'), $allowed_html),
                'default' => true,
            ),
            array(
                'id' => 'footer_three_top_spacing',
                'title' => esc_html__('Footer Top Spacing', 'senatory'),
                'type' => 'slider',
                'desc' => wp_kses(__('you can set <mark>padding</mark> for footer top', 'senatory'), $allowed_html),
                'min' => 0,
                'max' => 500,
                'step' => 1,
                'unit' => 'px',
                'default' => 100,
                'dependency' => array('footer_three_spacing', '==', 'true')
            ),
            array(
                'id' => 'footer_three_bottom_spacing',
                'title' => esc_html__('Footer Bottom Spacing', 'senatory'),
                'type' => 'slider',
                'desc' => wp_kses(__('you can set <mark>padding</mark> for footer bottom', 'senatory'), $allowed_html),
                'min' => 0,
                'max' => 500,
                'step' => 1,
                'unit' => 'px',
                'default' => 65,
                'dependency' => array('footer_three_spacing', '==', 'true')
            ),
            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Footer Copyright Area Options', 'senatory') . '</h3>'
            ),
            array(
                'id' => 'copyright_three_area_spacing',
                'title' => esc_html__('Copyright Area Spacing', 'senatory'),
                'type' => 'switcher',
                'desc' => wp_kses(__('you can set <mark>Yes / No</mark> to set copyright area spacing', 'senatory'), $allowed_html),
                'default' => true,
            ),
            array(
                'id' => 'copyright_three_text',
                'title' => esc_html__('Copyright Area Text', 'senatory'),
                'type' => 'textarea',
                'desc' => wp_kses(__('use  <mark>{copy}</mark> for copyright symbol, use <mark>{year}</mark> for current year, ', 'senatory'), $allowed_html)
            ),
            array(
                'id' => 'copyright_three_area_top_spacing',
                'title' => esc_html__('Copyright Area Top Spacing', 'senatory'),
                'type' => 'slider',
                'desc' => wp_kses(__('you can set <mark>padding</mark> for copyright area top', 'senatory'), $allowed_html),
                'min' => 0,
                'max' => 500,
                'step' => 1,
                'unit' => 'px',
                'default' => 20,
                'dependency' => array('copyright_three_area_spacing', '==', 'true')
            ),
            array(
                'id' => 'copyright_three_area_bottom_spacing',
                'title' => esc_html__('Copyright Area Bottom Spacing', 'senatory'),
                'type' => 'slider',
                'desc' => wp_kses(__('you can set <mark>padding</mark> for copyright area bottom', 'senatory'), $allowed_html),
                'min' => 0,
                'max' => 500,
                'step' => 1,
                'unit' => 'px',
                'default' => 20,
                'dependency' => array('copyright_three_area_spacing', '==', 'true')
            )
        )
    ));
    
    // footer 04
    CSF::createSection($prefix . '_theme_options', array(
        'parent' => 'footer_options',
        'id' => 'footer_four_general_options',
        'title' => esc_html__('Footer Four', 'senatory'),
        'icon' => 'fa fa-list-ul',
        'fields' => array(
            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Footer Settings Three', 'senatory') . '</h3>'
            ),
            array(
                'id' => 'footer_four_bg_image',
                'title' => esc_html__('Background Image', 'senatory'),
                'type' => 'background',
                'desc' => wp_kses(__('you can set <mark>background</mark> for footer', 'senatory'), $allowed_html),
                'default' => array(
                    'background-size' => 'cover',
                    'background-position' => 'center bottom',
                    'background-repeat' => 'no-repeat',
                ),
                'background_gradient' => true
            ),
            array(
                'id' => 'footer_four_spacing',
                'title' => esc_html__('Footer Spacing', 'senatory'),
                'type' => 'switcher',
                'desc' => wp_kses(__('you can set <mark>Yes / No</mark> to set footer spacing', 'senatory'), $allowed_html),
                'default' => true,
            ),
            array(
                'id' => 'footer_four_top_spacing',
                'title' => esc_html__('Footer Top Spacing', 'senatory'),
                'type' => 'slider',
                'desc' => wp_kses(__('you can set <mark>padding</mark> for footer top', 'senatory'), $allowed_html),
                'min' => 0,
                'max' => 500,
                'step' => 1,
                'unit' => 'px',
                'default' => 100,
                'dependency' => array('footer_three_spacing', '==', 'true')
            ),
            array(
                'id' => 'footer_four_bottom_spacing',
                'title' => esc_html__('Footer Bottom Spacing', 'senatory'),
                'type' => 'slider',
                'desc' => wp_kses(__('you can set <mark>padding</mark> for footer bottom', 'senatory'), $allowed_html),
                'min' => 0,
                'max' => 500,
                'step' => 1,
                'unit' => 'px',
                'default' => 65,
                'dependency' => array('footer_four_spacing', '==', 'true')
            ),
            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Footer Copyright Area Options', 'senatory') . '</h3>'
            ),
            array(
                'id' => 'copyright_four_area_spacing',
                'title' => esc_html__('Copyright Area Spacing', 'senatory'),
                'type' => 'switcher',
                'desc' => wp_kses(__('you can set <mark>Yes / No</mark> to set copyright area spacing', 'senatory'), $allowed_html),
                'default' => true,
            ),
            array(
                'id' => 'copyright_four_text',
                'title' => esc_html__('Copyright Area Text', 'senatory'),
                'type' => 'textarea',
                'desc' => wp_kses(__('use  <mark>{copy}</mark> for copyright symbol, use <mark>{year}</mark> for current year, ', 'senatory'), $allowed_html)
            ),
            array(
                'id' => 'copyright_four_area_top_spacing',
                'title' => esc_html__('Copyright Area Top Spacing', 'senatory'),
                'type' => 'slider',
                'desc' => wp_kses(__('you can set <mark>padding</mark> for copyright area top', 'senatory'), $allowed_html),
                'min' => 0,
                'max' => 500,
                'step' => 1,
                'unit' => 'px',
                'default' => 20,
                'dependency' => array('copyright_four_area_spacing', '==', 'true')
            ),
            array(
                'id' => 'copyright_four_area_bottom_spacing',
                'title' => esc_html__('Copyright Area Bottom Spacing', 'senatory'),
                'type' => 'slider',
                'desc' => wp_kses(__('you can set <mark>padding</mark> for copyright area bottom', 'senatory'), $allowed_html),
                'min' => 0,
                'max' => 500,
                'step' => 1,
                'unit' => 'px',
                'default' => 20,
                'dependency' => array('copyright_four_area_spacing', '==', 'true')
            )
        )
    ));
    // Footer 05
    CSF::createSection($prefix . '_theme_options', array(
        'parent' => 'footer_options',
        'id' => 'footer_five_options',
        'title' => esc_html__('Footer Five', 'senatory'),
        'icon' => 'fa fa-list-ul',
        'fields' => array(
            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Footer Top Settings', 'senatory') . '</h3>'
            ),
            array(
                'id' => 'footer_five_logo',
                'type' => 'media',
                'title' => esc_html__('Logo', 'senatory'),
                'library' => 'image',
                'desc' => wp_kses(__('you can upload <mark> logo</mark> here it will overwrite customizer uploaded logo', 'senatory'), $allowed_html),
            ),
            array(
                'id' => 'footer_five_paragraph',
                'title' => esc_html__('Paragraph Area Text', 'senatory'),
                'type' => 'textarea',
                'desc' => wp_kses(__('Enter Your Footer Paragraph', 'senatory'), $allowed_html)
            ),

            array(
                'id' => 'footer_five_top_repeater',
                'type' => 'repeater',
                'title' => esc_html__('Footer Top Widget Repeater', 'senatory'),
                'fields' => array(

                    array(
                        'id' => 'footer_five_info_icon',
                        'type' => 'icon',
                        'title' => esc_html__('Info Item Icon', 'senatory'),
                        'default' => 'flaticon-call'
                    ),

                    array(
                        'id' => 'footer_five_top_info',
                        'type' => 'textarea',
                        'title' => esc_html__('Footer Top Widget Info Box', 'senatory'),
                        'default' => esc_html__('Europe 45 Gloucester Road London DT1M 3BF +44 (0)20 3671 5709', 'senatory'),
                    ),
                )
            ),

            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Footer Newsletter Shortcode', 'senatory') . '</h3>'
            ),
            array(
                'id' => 'footer_five_newsletter_enable',
                'title' => esc_html__('Newsletter Background Image', 'senatory'),
                'type' => 'switcher',
                'desc' => wp_kses(__('you can set <mark>Yes / No</mark> to show/hide footer', 'senatory'), $allowed_html),
                'default' => true,
            ),

            array(
                'id' => 'footer_five_newsletter_bg',
                'title' => esc_html__('Newsletter Background Image', 'senatory'),
                'type' => 'background',
                'desc' => wp_kses(__('you can set <mark>background</mark> for call to action', 'senatory'), $allowed_html),
                'default' => array(
                    'background-size' => 'cover',
                    'background-position' => 'center bottom',
                    'background-repeat' => 'no-repeat',
                ),
                'background_gradient' => true,
                'dependency' => array('footer_five_newsletter_enable', '==', 'true')
            ),
            array(
                'id' => 'footer_five_newsletter_title',
                'title' => esc_html__('Footer Newsletter Title', 'senatory'),
                'type' => 'text',
                'default' => esc_html__('Join Our Newsletter', 'senatory'),
                'desc' => wp_kses(__('Insert Footer Newsletter title', 'senatory'), $allowed_html)
            ),

            array(
                'id' => 'footer_five_newsletter',
                'title' => esc_html__('Footer Newsletter Shortcode', 'senatory'),
                'type' => 'text',
                'desc' => 'Form Shortcode',
            ),

            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Footer Settings Two', 'senatory') . '</h3>'
            ),

            array(
                'id' => 'footer_five_spacing',
                'title' => esc_html__('Footer Spacing', 'senatory'),
                'type' => 'switcher',
                'desc' => wp_kses(__('you can set <mark>Yes / No</mark> to set footer spacing', 'senatory'), $allowed_html),
                'default' => true,
            ),

            array(
                'id' => 'footer_five_top_spacing',
                'title' => esc_html__('Footer Top Spacing', 'senatory'),
                'type' => 'slider',
                'desc' => wp_kses(__('you can set <mark>padding</mark> for footer top', 'senatory'), $allowed_html),
                'min' => 0,
                'max' => 500,
                'step' => 1,
                'unit' => 'px',
                'default' => 100,
                'dependency' => array('footer_five_spacing', '==', 'true')
            ),
            array(
                'id' => 'footer_five_bottom_spacing',
                'title' => esc_html__('Footer Bottom Spacing', 'senatory'),
                'type' => 'slider',
                'desc' => wp_kses(__('you can set <mark>padding</mark> for footer bottom', 'senatory'), $allowed_html),
                'min' => 0,
                'max' => 500,
                'step' => 1,
                'unit' => 'px',
                'default' => 65,
                'dependency' => array('footer_five_spacing', '==', 'true')
            ),
            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Footer Copyright Area Options', 'senatory') . '</h3>'
            ),
            array(
                'id' => 'copyright_five_area_spacing',
                'title' => esc_html__('Copyright Area Spacing', 'senatory'),
                'type' => 'switcher',
                'desc' => wp_kses(__('you can set <mark>Yes / No</mark> to set copyright area spacing', 'senatory'), $allowed_html),
                'default' => true,
            ),
            array(
                'id' => 'copyright_text',
                'title' => esc_html__('Copyright Area Text', 'senatory'),
                'type' => 'textarea',
                'desc' => wp_kses(__('use  <mark>{copy}</mark> for copyright symbol, use <mark>{year}</mark> for current year, ', 'senatory'), $allowed_html)
            ),
            array(
                'id' => 'copyright_five_area_top_spacing',
                'title' => esc_html__('Copyright Area Top Spacing', 'senatory'),
                'type' => 'slider',
                'desc' => wp_kses(__('you can set <mark>padding</mark> for copyright area top', 'senatory'), $allowed_html),
                'min' => 0,
                'max' => 500,
                'step' => 1,
                'unit' => 'px',
                'default' => 20,
                'dependency' => array('copyright_five_area_spacing', '==', 'true')
            ),
            array(
                'id' => 'copyright_five_area_bottom_spacing',
                'title' => esc_html__('Copyright Area Bottom Spacing', 'senatory'),
                'type' => 'slider',
                'desc' => wp_kses(__('you can set <mark>padding</mark> for copyright area bottom', 'senatory'), $allowed_html),
                'min' => 0,
                'max' => 500,
                'step' => 1,
                'unit' => 'px',
                'default' => 20,
                'dependency' => array('copyright_five_area_spacing', '==', 'true')
            ),


            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Footer Background Image Options', 'senatory') . '</h3>'
            ),
            array(
                'id' => 'footer_five_bg_enable',
                'title' => esc_html__('Footer', 'senatory'),
                'type' => 'switcher',
                'desc' => wp_kses(__('you can set <mark>Yes / No</mark> to show/hide footer', 'senatory'), $allowed_html),
                'default' => true,
            ),
            array(
                'id' => 'footer_five_bg_image',
                'title' => esc_html__('Background Image', 'senatory'),
                'type' => 'background',
                'desc' => wp_kses(__('you can set <mark>background</mark> for footer', 'senatory'), $allowed_html),
                'default' => array(
                    'background-size' => 'cover',
                    'background-position' => 'center bottom',
                    'background-repeat' => 'no-repeat',
                ),
                'background_color' => false,
                'dependency' => array('footer_five_bg_enable', '==', 'true')
            ),
            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Footer About Item Settings', 'senatory') . '</h3>'
            ),
            array(
                'id' => 'footer_social_icon',
                'type' => 'switcher',
                'title' => esc_html__('Social Icon', 'senatory'),
                'default' => true,
                'desc' => wp_kses(__('you can <mark> show/hide</mark> navbar button of header two', 'senatory'), $allowed_html),
            ),
            array(
                'id' => 'footer_social_repeater',
                'type' => 'repeater',
                'title' => esc_html__('Social Item Repeater', 'senatory'),
                'dependency' => array('footer_social_icon', '==', 'true'),
                'fields' => array(
                    array(
                        'id' => 'footer_social_icon_item_icon',
                        'type' => 'icon',
                        'title' => esc_html__('Social Item Icon', 'senatory'),
                        'default' => 'flaticon-call'
                    ),
                    array(
                        'id' => 'footer_social_icon_item_url',
                        'type' => 'text',
                        'title' => esc_html__('Social URL', 'senatory'),
                        'default' => '#'
                    ),
                )
            ),
        )
    ));
    /*-------------------------------------------------------
          ** Blog  Options
    --------------------------------------------------------*/
    CSF::createSection($prefix . '_theme_options', array(
        'id' => 'blog_settings',
        'title' => esc_html__('Blog Settings', 'senatory'),
        'icon' => 'fa fa-book'
    ));
    CSF::createSection($prefix . '_theme_options', array(
        'parent' => 'blog_settings',
        'id' => 'blog_post_options',
        'title' => esc_html__('Blog Post', 'senatory'),
        'icon' => 'fa fa-list-ul',
        'fields' => senatory_Group_Fields::post_meta('blog_post', esc_html__('Blog Page', 'senatory'))
    ));
    CSF::createSection($prefix . '_theme_options', array(
        'parent' => 'blog_settings',
        'id' => 'blog_single_post_options',
        'title' => esc_html__('Single Post', 'senatory'),
        'icon' => 'fa fa-list-alt',
        'fields' => senatory_Group_Fields::post_meta('blog_single_post', esc_html__('Blog Single Page', 'senatory'))
    ));

    CSF::createSection($prefix . '_theme_options', array(
        'id' => 'shop_settings',
        'title' => esc_html__('Shop Settings', 'senatory'),
        'icon' => 'fas fa-shopping-basket',
    ));
    /*  Product page options */
    CSF::createSection($prefix . '_theme_options', array(
        'id' => 'product_shop_page',
        'title' => esc_html__('Product Page', 'senatory'),
        'parent' => 'shop_settings',
        'icon' => 'fas fa-shopping-basket',
        'fields' => Senatory_Group_Fields::page_layout_options(esc_html__('Product Shop Page', 'senatory'), 'product_shop')
    ));
    /*  Product single page options */
    CSF::createSection($prefix . '_theme_options', array(
        'id' => 'product_shop_single_page',
        'title' => esc_html__('Product Single Page', 'senatory'),
        'parent' => 'shop_settings',
        'icon' => 'fas fa-shopping-basket',
        'fields' => array(
            array(
                'id' => 'product_shop_single_page_bg_color',
                'type' => 'color',
                'title' => esc_html__('Page Background Color', 'senatory'),
                'default' => '#fff'
            ),
            array(
                'id' => 'product_shop_single_page_spacing_top',
                'title' => esc_html__('Page Spacing Top', 'senatory'),
                'type' => 'slider',
                'desc' => wp_kses(__('you can set <mark>Padding Top</mark> for page content area.', 'senatory'), $allowed_html),
                'min' => 0,
                'max' => 500,
                'step' => 1,
                'unit' => 'px',
                'default' => 120,
            ),
            array(
                'id' => 'product_shop_single_page_spacing_bottom',
                'title' => esc_html__('Page Spacing Bottom', 'senatory'),
                'type' => 'slider',
                'desc' => wp_kses(__('you can set <mark>Padding Bottom</mark> for page content area.', 'senatory'), $allowed_html),
                'min' => 0,
                'max' => 500,
                'step' => 1,
                'unit' => 'px',
                'default' => 100,
            ),
        ),
    ));

    /*-------------------------------------------------------
          ** Pages & templates Options
   --------------------------------------------------------*/
    CSF::createSection($prefix . '_theme_options', array(
        'id' => 'pages_and_template',
        'title' => esc_html__('Pages Settings', 'senatory'),
        'icon' => 'fa fa-files-o'
    ));
    /*  404 page options */
    CSF::createSection($prefix . '_theme_options', array(
        'id' => '404_page',
        'title' => esc_html__('404 Page', 'senatory'),
        'parent' => 'pages_and_template',
        'icon' => 'fa fa-exclamation-triangle',
        'fields' => array(
            array(
                'id' => 'error_bg_switch',
                'title' => esc_html__('404 Image Enable', 'senatory'),
                'type' => 'switcher',
                'desc' => wp_kses(__('you can set <mark>Yes / No</mark> to show/hide breadcrumb', 'senatory'), $allowed_html),
                'default' => true,
            ),
            array(
                'id' => 'error_bg',
                'title' => esc_html__('404 Image', 'senatory'),
                'type' => 'media',
                'desc' => wp_kses(__('you can set <mark>background</mark> for breadcrumb', 'senatory'), $allowed_html),
                'dependency' => array('error_bg_switch', '==', 'true')
            ),
            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('404 Page Options', 'senatory') . '</h3>',
            ),
            array(
                'id' => '404_bg_color',
                'type' => 'color',
                'title' => esc_html__('Page Background Color', 'senatory'),
                'default' => '#ffffff'
            ),
            array(
                'id' => '404_title',
                'title' => esc_html__('Title', 'senatory'),
                'type' => 'text',
                'info' => wp_kses(__('you can change <mark>title</mark> of 404 page', 'senatory'), $allowed_html),
                'attributes' => array('placeholder' => esc_html__('Sorry! The Page Not Found', 'senatory'))
            ),
            array(
                'id' => '404_paragraph',
                'title' => esc_html__('Paragraph', 'senatory'),
                'type' => 'textarea',
                'info' => wp_kses(__('you can change <mark>paragraph</mark> of 404 page', 'senatory'), $allowed_html),
                'attributes' => array('placeholder' => esc_html__('Oops! The page you are looking for does not exit. it might been moved or deleted.', 'senatory'))
            ),
            array(
                'id' => '404_button_text',
                'title' => esc_html__('Button Text', 'senatory'),
                'type' => 'text',
                'info' => wp_kses(__('you can change <mark>button text</mark> of 404 page', 'senatory'), $allowed_html),
                'attributes' => array('placeholder' => esc_html__('back to home', 'senatory'))
            ),
            array(
                'id' => '404_spacing_top',
                'title' => esc_html__('Page Spacing Top', 'senatory'),
                'type' => 'slider',
                'desc' => wp_kses(__('you can set <mark>Padding Top</mark> for page content area.', 'senatory'), $allowed_html),
                'min' => 0,
                'max' => 500,
                'step' => 1,
                'unit' => 'px',
                'default' => 120,
            ),
            array(
                'id' => '404_spacing_bottom',
                'title' => esc_html__('Page Spacing Bottom', 'senatory'),
                'type' => 'slider',
                'desc' => wp_kses(__('you can set <mark>Padding Bottom</mark> for page content area.', 'senatory'), $allowed_html),
                'min' => 0,
                'max' => 500,
                'step' => 1,
                'unit' => 'px',
                'default' => 120,
            ),
        )
    ));

    /*  blog page options */
    CSF::createSection($prefix . '_theme_options', array(
        'id' => 'blog_page',
        'title' => esc_html__('Blog Page', 'senatory'),
        'parent' => 'pages_and_template',
        'icon' => 'fa fa-indent',
        'fields' => senatory_Group_Fields::page_layout_options(esc_html__('Blog', 'senatory'), 'blog')
    ));
    /*  blog single page options */
    CSF::createSection($prefix . '_theme_options', array(
        'id' => 'blog_single_page',
        'title' => esc_html__('Blog Single Page', 'senatory'),
        'parent' => 'pages_and_template',
        'icon' => 'fa fa-indent',
        'fields' => senatory_Group_Fields::page_layout_options(esc_html__('Blog Single', 'senatory'), 'blog_single')
    ));
    /*  archive page options */
    CSF::createSection($prefix . '_theme_options', array(
        'id' => 'archive_page',
        'title' => esc_html__('Archive Page', 'senatory'),
        'parent' => 'pages_and_template',
        'icon' => 'fa fa-archive',
        'fields' => senatory_Group_Fields::page_layout_options(esc_html__('Archive', 'senatory'), 'archive')
    ));
    /*  search page options */
    CSF::createSection($prefix . '_theme_options', array(
        'id' => 'search_page',
        'title' => esc_html__('Search Page', 'senatory'),
        'parent' => 'pages_and_template',
        'icon' => 'fa fa-search',
        'fields' => senatory_Group_Fields::page_layout_options(esc_html__('Search', 'senatory'), 'search')
    ));

    
    /*-------------------------------------------------------
          *** Custom Post Single Options ****
   --------------------------------------------------------*/

  
    
    /*-------------------------------------------------------
        **Issue  Options
    --------------------------------------------------------*/
   CSF::createSection($prefix . '_theme_options', array(
    'id' => 'issues_pages_and_template',
    'title' => esc_html__('Issue Settings', 'senatory'),
    'icon' => 'fa fa-files-o'
    ));
    CSF::createSection($prefix . '_theme_options', array(
        'id' => 'issues_single_page',
        'title' => esc_html__('Issue Single Layout', 'senatory'),
        'parent' => 'issues_pages_and_template',
        'icon' => 'fa fa-indent',
        'fields' => senatory_Group_Fields::page_layout_options(esc_html__('Issue', 'senatory'), 'issue_single')
    ));
    /*  Issues page options */
    CSF::createSection($prefix . '_theme_options', array(
        'id' => 'issues_page_layout',
        'title' => esc_html__('Issues Single Options', 'senatory'),
        'parent' => 'issues_pages_and_template',
        'icon' => 'fa fa-indent',
        'fields' => array(
            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__(' Issues Single Pages Options', 'senatory') . '</h3>',
            ),
            array(
                'id'      => $prefix .'_issues_thumbnail_switcher',
                'type'    => 'switcher',
                'title'   => esc_html__('Show /Hide Thumbnail', 'senatory'),
                'subtitle'=> esc_html__('Show /Hide Single Post Thumbnail', 'senatory'),
                'desc'   =>  esc_html__('Do you want activate it ?', 'senatory'),
                'default' => true
              ),
            array(
                'id'      => $prefix .'_issues_related_post_switcher',
                'type'    => 'switcher',
                'title'   => esc_html__('Show /Hide Related Post', 'senatory'),
                'desc'   =>  esc_html__('Do you want activate it ?', 'senatory'),
                'default' => true
              ),
            // A text field with dependency conditions
            array(
                'id'         => $prefix .'_issues_related_post_heading',
                'type'       => 'text',
                'title'      => esc_html__('Related Post Heading', 'senatory'),
                'default'   => esc_html__('Issues Around Us', 'senatory'),
                'dependency' => array( 'senatory_issues_related_post_switcher', '==', 'true' ),
            ),
            array(
                'id'         => $prefix .'_issues_related_post_sub_heading',
                'type'       => 'textarea',
                'title'      => esc_html__('Related Post Sub Heading', 'senatory'),
                'default' => esc_html__('Every pleasures is to welcomed pain avoided owing to the duty the obligations of business it will frequently.', 'senatory'),
                'dependency' => array( 'senatory_issues_related_post_switcher', '==', 'true' ),
            ),
            array(
                'id'      => $prefix .'_issues_issues_comment',
                'type'    => 'switcher',
                'title'   => esc_html__('Show /Hide Comment', 'senatory'),
                'desc'   =>  esc_html__('Do you want activate it ?', 'senatory'),
                'default' => false
            )



        )
    ));


    /*-------------------------------------------------------
           ** Events  Options
    --------------------------------------------------------*/
  
    CSF::createSection($prefix . '_theme_options', array(
    'id' => 'events_pages_and_template',
    'title' => esc_html__('Events Settings', 'senatory'),
    'icon' => 'fa fa-calendar'
    ));
    CSF::createSection($prefix . '_theme_options', array(
        'id' => 'events_single_page',
        'title' => esc_html__('Event Page Layout', 'senatory'),
        'parent' => 'events_pages_and_template',
        'icon' => 'fa fa-indent',
        'fields' => senatory_Group_Fields::page_layout_options(esc_html__('Events', 'senatory'), 'events_single')
    ));
    /*  Events page options */
    CSF::createSection($prefix . '_theme_options', array(
        'id' => 'events_page_layout',
        'title' => esc_html__('Events Single Options', 'senatory'),
        'parent' => 'events_pages_and_template',
        'icon' => 'fa fa-indent',
        'fields' => array(
            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__(' Events Single Pages Options', 'senatory') . '</h3>',
            ),
            array(
                'id' => $prefix .'_event_single_style',
                'type' => 'select',
                'title' => esc_html__('Select Content Style', 'senatory'),
                'options' => array(
                    'one' => esc_html__('Style 1', 'senatory'),
                    'two' => esc_html__('Style 2', 'senatory'),
                ),
                'default' => 'one',
            ),
                array(
                'id'      => $prefix .'_events_related_post_switcher',
                'type'    => 'switcher',
                'title'   => esc_html__('Show /Hide Related Post', 'senatory'),
                'desc'   =>  esc_html__('Do you want activate it ?', 'senatory'),
                'default' => true
                ),
            // A text field with dependency conditions
            array(
                'id'         => $prefix .'_events_related_post_heading',
                'type'       => 'text',
                'title'      => esc_html__('Related Post Heading', 'senatory'),
                'default'   => esc_html__('Events Around Us', 'senatory'),
                'dependency' => array( 'senatory_events_related_post_switcher', '==', 'true' ),
            ),
            array(
                'id'         => $prefix .'_events_related_post_sub_heading',
                'type'       => 'textarea',
                'title'      => esc_html__('Related Post Sub Heading', 'senatory'),
                'default' => esc_html__('Every pleasures is to welcomed pain avoided owing to the duty the obligations of business it will frequently.', 'senatory'),
                'dependency' => array( 'senatory_events_related_post_switcher', '==', 'true' ),
            ),
            array(
                'id'      => $prefix .'_events_comment',
                'type'    => 'switcher',
                'title'   => esc_html__('Show /Hide Comment', 'senatory'),
                'desc'   =>  esc_html__('Do you want activate it ?', 'senatory'),
                'default' => false
            )

        )
    ));

    /*-------------------------------------------------------
           ** Donation  Options
    --------------------------------------------------------*/

        CSF::createSection($prefix . '_theme_options', array(
        'id' => 'donation_pages_and_template',
        'title' => esc_html__('Donation Settings', 'senatory'),
        'icon' => 'fa fa-calendar'
        ));
        CSF::createSection($prefix . '_theme_options', array(
            'id' => 'donation_single_page',
            'title' => esc_html__('Donation Page Layout', 'senatory'),
            'parent' => 'donation_pages_and_template',
            'icon' => 'fa fa-indent',
            'fields' => senatory_Group_Fields::page_layout_options(esc_html__('Donation', 'senatory'), 'donation_single')
        ));
        /*  Events page options */
        CSF::createSection($prefix . '_theme_options', array(
            'id' => 'donation_page_layout',
            'title' => esc_html__('Donation Single Page', 'senatory'),
            'parent' => 'donation_pages_and_template',
            'icon' => 'fa fa-indent',
            'fields' => array(
                array(
                    'type' => 'subheading',
                    'content' => '<h3>' . esc_html__(' Donation Single Pages Options', 'senatory') . '</h3>',
                ),
                array(
                    'id' => $prefix .'_donation_single_style',
                    'type' => 'select',
                    'title' => esc_html__('Select Content Style', 'senatory'),
                    'options' => array(
                        'one' => esc_html__('Style 1', 'senatory'),
                        'two' => esc_html__('Style 2', 'senatory'),
                    ),
                    'default' => 'one',
                ),
                    array(
                    'id'      => $prefix .'_donation_related_post_switcher',
                    'type'    => 'switcher',
                    'title'   => esc_html__('Show /Hide Related Post', 'senatory'),
                    'desc'   =>  esc_html__('Do you want activate it ?', 'senatory'),
                    'default' => true
                    ),
                // A text field with dependency conditions
                array(
                    'id'         => $prefix .'_donation_related_post_heading',
                    'type'       => 'text',
                    'title'      => esc_html__('Related Post Heading', 'senatory'),
                    'default'   => esc_html__('Donation Around Us', 'senatory'),
                    'dependency' => array( 'senatory_donation_related_post_switcher', '==', 'true' ),
                ),
                array(
                    'id'         => $prefix .'_donation_related_post_sub_heading',
                    'type'       => 'textarea',
                    'title'      => esc_html__('Related Post Sub Heading', 'senatory'),
                    'default' => esc_html__('Every pleasures is to welcomed pain avoided owing to the duty the obligations of business it will frequently.', 'senatory'),
                    'dependency' => array( 'senatory_donation_related_post_switcher', '==', 'true' ),
                ),
                array(
                    'id'      => $prefix .'_donation_comment',
                    'type'    => 'switcher',
                    'title'   => esc_html__('Show /Hide Comment', 'senatory'),
                    'desc'   =>  esc_html__('Do you want activate it ?', 'senatory'),
                    'default' => false
                )
    
            )
        ));




















    /*-------------------------------------------------------
           ** Backup  Options
    --------------------------------------------------------*/
    CSF::createSection($prefix . '_theme_options', array(
        'id' => 'backup',
        'title' => esc_html__('Import / Export', 'senatory'),
        'icon' => 'eicon-export-kit',
        'fields' => array(
            array(
                'type' => 'notice',
                'style' => 'warning',
                'content' => esc_html__('You can save your current options. Download a Backup and Import.', 'senatory'),
            ),
            array(
                'type' => 'backup',
                'title' => esc_html__('Backup & Import', 'senatory')
            )
        )
    ));
}
