<?php
/**
 * Issue Single Template
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package senatory
 */

get_header();
$senatory = senatory();
$page_layout_meta = Senatory_Group_Fields_Value::issue_single_page_layout_options('issue_single');
$full_width_class = $page_layout_meta['content_column_class'] === 'col-lg-12' ? ' full-width-content ' : '';

if ($senatory->is_senatory_core_active()){
    senatory_core()->setPostViews(get_the_ID());
}

?>
  <!-- Issues Details Section Start Here -->
  <div id="primary" class="issues-details-section issue-detls-two margin-top-90 <?php echo esc_attr($full_width_class);?>">
            <div class="container">
                <div class="row">
                    <div class="<?php echo esc_attr($page_layout_meta['content_column_class']);?>">
                        <?php
                        while ( have_posts() ) :  the_post();
                            get_template_part( 'template-parts/content-issue', 'single' );


                            // If comments are open or we have at least one comment, load up the comment template.
                            if ( comments_open() || get_comments_number() || get_option( 'thread_comments' )) :
                                comments_template();
                            endif;

                        endwhile; // End of the loop.
                        ?>
                    </div>
                    <?php if ($page_layout_meta['sidebar_enable']): ?>
                        <div class="<?php echo esc_attr($page_layout_meta['sidebar_column_class']);?>">
                            <?php get_sidebar();?>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
    </div><!-- #primary -->

  <!-- Issues Details Section End Here -->

  <!-- More Issue Section Start Here -->
  <?php if(cs_get_option('senatory_issues_related_post_switcher') === '1'):  ?>
  <div class="more-issue-section margin-top-120">
    <div class="container">
      <div class="row">

        <div class="col-lg-6">
          <div class="section-title">
            <?php if(!empty(cs_get_option('senatory_issues_related_post_heading'))): ?>
              <h4 class="title style-02 wow animate__animated animate__fadeInUp">
              <?php echo esc_html(cs_get_option('senatory_issues_related_post_heading')); ?>
              </h4>
            <?php endif; ?>
            <?php if(!empty(cs_get_option('senatory_issues_related_post_sub_heading'))): ?>
              <p class="description style-02 wow animate__animated animate__fadeInUp">
                  <?php echo esc_html(cs_get_option('senatory_issues_related_post_sub_heading')); ?>
              </p>
            <?php endif; ?>
            </div>
        </div>
      </div>
      <div class="row">
        <div class="testimonial-carousel-six">

        <?php
            $related_query = new WP_Query(array(
                'post_type' => 'issue',
                'category__in' => wp_get_post_categories(get_the_ID()),
                'post__not_in' => array(get_the_ID()),
                'posts_per_page' => -1,
                'orderby' => 'date',
            ));
        ?>
        <?php if($related_query->have_posts()): ?>
            <?php while ($related_query->have_posts()) : $related_query->the_post(); 
                
                $post_id = get_the_ID();;
                $img_id = get_post_thumbnail_id($post_id) ? get_post_thumbnail_id($post_id) : false;
                $img_url_val = $img_id ? wp_get_attachment_image_src($img_id, 'full', false) : '';
                $img_url = is_array($img_url_val) && !empty($img_url_val) ? $img_url_val[0] : '';

                ?>
                    <div class="issues-single-items style-01">
                        <div class="issue-img" style="background-image: url(<?php echo esc_url($img_url ); ?>);">
                            <div class="content">
                                <h4 class="title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h4>
                                <p><?php echo wp_trim_words( get_the_content(), 25,  ); ?></p>
                            </div>
                        </div>
                    </div>
            <?php endwhile; ?>

        <?php endif; ?>


        </div>
      </div>
    </div>
  </div>
  <?php endif; ?>
  <!-- More Issue Section Start Here -->
	

	
<?php
get_footer();
