<?php
/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package senatory
 */
$post_id = get_the_ID();
$_give_form_goal_progress = get_post_meta($post_id,'_give_form_goal_progress',true);



?>

<div class="col-lg-6">
	<div class="issues-single-items">

	<article id="post-<?php the_ID(); ?>" <?php post_class('contribute-single-item'); ?>>

	<?php
	$featured_img_url = get_the_post_thumbnail_url($post->ID, 'full');
	?>

		<div class="issue-img" style="background-image: url(<?php echo esc_url($featured_img_url); ?>);">

			<div class="content">
				<h4 class="title"><a href="<?php echo esc_url( get_the_permalink() );?>"><?php esc_html(the_title());?></a></h4>
				<div class="progress-content">
				  <div class="progress-item">
					  <div class="single-progressbar">
						  <div class="hn-donation-progress rprogressbar"  data-percentage="<?php echo esc_attr($_give_form_goal_progress);?>"></div>
					  </div>
				  </div>
				  <div class="goal">
					<h4 class="raised"><?php esc_html_e('Raised : ','senatory');?> <span class="fund-font"><?php echo senatory()->give_wp_raised();?></span></h4>
                    <h4 class="raised"><?php esc_html_e('Goal : ','senatory');?> <span class="fund-font"><?php echo senatory()->give_wp_goal();?></span></h4>
				  </div>
			  </div>
			</div>
		</div>

	 </article><!-- #post-<?php the_ID(); ?> -->

	</div>
</div>
			
			
			
