<?php
/**
 * Template part for displaying single post
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package senatory
 */

$senatory = senatory();
$post_meta = get_post_meta(get_the_ID(), 'senatory_post_gallery_options', true);
$post_meta_gallery = isset($post_meta['gallery_images']) && !empty($post_meta['gallery_images']) ? $post_meta['gallery_images'] : '';
$post_single_meta = Senatory_Group_Fields_Value::post_meta('blog_single_post');

?>

<article id="post-<?php the_ID(); ?>" <?php post_class('blog-single-content-wrap blog-details-items'); ?>>
    <?php
    if (has_post_thumbnail() || !empty($post_meta_gallery)):
        $get_post_format = get_post_format();
        if ('video' == $get_post_format || 'gallery' == $get_post_format) {
            get_template_part('template-parts/content/thumbnail', $get_post_format);
        } else {
            get_template_part('template-parts/content/thumbnail');
        }
    endif;
    ?>
    <div class="entry-content">
        <?php if ('post' == get_post_type()): ?>
            <?php if ($post_single_meta['posted_category']): ?>
                <div class="cats"><?php the_category(' ', ' ') ?></div>
            <?php endif; ?>
            <ul class="post-meta">
                <?php if ($post_single_meta['posted_by']): ?>
                    <li><?php $senatory->posted_by(); ?></li>
                <?php endif; ?>
                <li>
                    <?php
                    $senatory->posted_on();
                    ?>
                </li>
                <li>
                    <?php
                    $senatory->comment_count();
                    ?>
                </li>
            </ul>
        <?php endif;
        the_content();
        $senatory->link_pages();
        ?>
    </div>
    <?php if ('post' == get_post_type() && ((has_tag() && $post_single_meta['posted_tag']) || (shortcode_exists('senatory_post_share') && $post_single_meta['posted_share']))): ?>
        <div class="blog-details-footer">
            <?php if (has_tag() && $post_single_meta['posted_tag']): ?>
                <div class="left">
                    <h3 class="title"><?php echo esc_html__('Tags :', 'senatory') ?></h3>
                    <?php $senatory->posted_tag(); ?>
                </div>
            <?php endif; ?>
            <?php if (shortcode_exists('senatory_post_share') && $post_single_meta['posted_share']) : ?>
                <div class="right">
                    <h3 class="title"><?php echo esc_html__('Social Share :', 'senatory') ?></h3>
                    <?php
                    if (shortcode_exists('senatory_post_share') && $post_single_meta['posted_share']) {
                        echo do_shortcode('[senatory_post_share]');
                    }
                    ?>
                </div>
            <?php endif; ?>
        </div>
    <?php endif;
    if ($post_single_meta['next_post_nav_btn'] && $senatory->is_senatory_core_active()) {
        echo wp_kses($senatory->post_navigation(), $senatory->kses_allowed_html('all'));
    }
    if ($senatory->is_senatory_core_active()) {
        if ($post_single_meta['get_related_post'] == '1') {
            $senatory->get_related_post([
                'post_type' => 'post',
                'taxonomy' => 'category',
                'exclude_id' => get_the_ID(),
                'posts_per_page' => 2
            ]);
        }
    }
    ?>

</article><!-- #post-<?php the_ID(); ?> -->


<!-- Top Ratec Section Start Here -->
<?php
if ($post_single_meta['get_related_post'] == '1') : ?>
<div class="top-rated-section">
    <div class="container">
        <div class="row">
            <div class="top-rated-title">
                <h4 class="title wow animate__animated animate__fadeInUp">Top Related Post</h4>
            </div>
            <!-- Wrapper -->
            <div class="testimonial-carousel-six">
                    <?php
                        $related_post_query = new WP_Query(array(
                            'post_type' => 'post',
                            'category__in' => wp_get_post_categories(get_the_ID()),
                            'post__not_in' => array(get_the_ID()),
                            'posts_per_page' => -1,
                            'orderby' => 'date',
                        ));
                    ?>
                    <?php if($related_post_query->have_posts()): ?>
                        <?php while ($related_post_query->have_posts()) : $related_post_query->the_post(); 
                        
                        $post_id = get_the_ID();;
                        $img_id = get_post_thumbnail_id($post_id) ? get_post_thumbnail_id($post_id) : false;
                        $img_url_val = $img_id ? wp_get_attachment_image_src($img_id, 'full', false) : '';
                        $img_url = is_array($img_url_val) && !empty($img_url_val) ? $img_url_val[0] : '';

                        ?>
                        <!-- Items Start -->
                            <div class="news-single-items wow animate__animated animate__fadeInUp">
                                <div class="news-bg" style="background-image: url(<?php echo esc_url($img_url); ?>);">
                                    <span class="even">
                                    <?php
                                        $blog_category = get_the_category(); echo   $blog_category[0]->cat_name;
                                    ?>
                                    </span>
                                    <div class="content">
                                        <h4 class="title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h4>
                                        <div class="author-meta">
                                            <p class="author-name">
                                            <?php if ($post_single_meta['posted_by']): $senatory->posted_by(); endif; ?></p>
                                            <p><?php $senatory->posted_on(); ?></p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php endwhile; ?>
                    <?php endif; ?>
                    <!-- End Items -->    
            </div>
        </div>
    </div>
</div>
<?php endif; ?>
<!-- Top Rated Section End Here -->
