<?php
/**
 * Template part for displaying single team post
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package senatory
 */

$senatory = senatory();
$senatory_meta = get_post_meta(get_the_ID(), 'senatory_team_options', true);

$img_id = get_post_thumbnail_id(get_the_ID()) ? get_post_thumbnail_id(get_the_ID()) : false;
$img_url_val = $img_id ? wp_get_attachment_image_src($img_id, 'medium', false) : '';
$img_url = is_array($img_url_val) && !empty($img_url_val) ? $img_url_val[0] : '';
$img_alt = $img_id ? get_post_meta($img_id, '_wp_attachment_image_alt', true) : '';
$designation = isset($senatory_meta['designation']) && !empty($senatory_meta['designation']) ? $senatory_meta['designation'] : '';
$description = isset($senatory_meta['description']) && !empty($senatory_meta['description']) ? $senatory_meta['description'] : '';
$experience = isset($senatory_meta['experience']) && !empty($senatory_meta['experience']) ? $senatory_meta['experience'] : '';
$team_info = isset($senatory_meta['team-info']) && !empty($senatory_meta['team-info']) ? $senatory_meta['team-info'] : '';
$social_icons = isset($senatory_meta['social-icons']) && !empty($senatory_meta['social-icons']) ? $senatory_meta['social-icons'] : '';

?>

<article id="post-<?php the_ID(); ?>" <?php post_class('senatory-details-content-area'); ?>>
    <div class="entry-content">
        <div class="pl-lg-2 pr-lg-2">
        <div class="team-area-wrap">
            <div class="row">
                <?php if(!empty($img_url)) : ?>
                    <div class="col-lg-5 pr-lg-5">
                        <div class="img-wrapper">
                            <img class="w-100" src="<?php echo esc_url($img_url); ?>" alt="<?php echo esc_attr($img_alt); ?>">
                        </div>
                    </div>
                <?php endif; ?>
                <?php 
                    $pl_lg_5 = 'col-lg-12';
                    if(!empty($img_url)) : 
                    	$pl_lg_5 = 'col-lg-7';
                    endif; 
                ?>
                <div class="mt-4 mt-lg-0 <?php echo esc_attr($pl_lg_5); ?>">
                    <div class="details-inner">
                        <h2 class="title"><?php echo esc_html(the_title()); ?></h2>
                        <p class="designation"><?php echo esc_html($designation); ?> <i class="icomoon-bullet"></i></p>
                        <p class="content"><?php echo esc_html($description); ?></p>
                        <div class="contact-info">
                            <div class="row">
                                <div class="col-lg-7">
                                    <div class="team-contact-list">
                                        <ul>
                                            <?php
	                                            if (!empty($team_info)) {

	                                                foreach ($team_info as $info) {
	                                                    printf('<li><i class="%2$s"></i>%1$s</li>', esc_html($info['title']), esc_attr($info['icon']));
	                                                }
	                                            }
                                            ?>
                                        </ul>
                                    </div>
                                    <div class="social-links">

				                        <?php
				                            if (!empty($social_icons)) {
				                                foreach ($social_icons as $s_info) {
				                                    printf('<a href="%2$s"><i class="%1$s"></i></a>', esc_attr($s_info['icon']), esc_url($s_info['url']));
				                                }
				                            }
				                        ?>

				                      </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
				</div>
            </div>
        </div>
        <?php
        the_content();
        $senatory->link_pages();
        ?>
    </div>
</article><!-- #post-<?php the_ID(); ?> -->
