<?php


$events_label_singular = tribe_get_event_label_singular();
$events_label_plural = tribe_get_event_label_plural();
$event_id = get_the_ID();

$event_start_time = get_post_meta($event_id, '_EventStartDate', true);

// Check for skeleton mode (no outer wrappers per section)
$not_skeleton = !apply_filters('tribe_events_single_event_the_meta_skeleton', false, get_the_ID());

// Do we want to group venue meta separately?
$set_venue_apart = apply_filters('tribe_events_single_event_the_meta_group_venue', false, get_the_ID());


$event_single_meta_data = get_post_meta(get_the_ID(), 'senatory_event_options', true);
$event_breadcrumb_img = isset($event_single_meta_data['event_breadcrumb_image']) ? $event_single_meta_data['event_breadcrumb_image'] : [];

if (array_key_exists('event_form', $event_single_meta_data)) {
    $event_form_shortcode = $event_single_meta_data['event_form'];
} else {
    $event_form_shortcode = '';
}

?>



    <div class="event-single-items">
        <!-- Event header -->
        <!-- Notices -->
        <?php tribe_the_notices() ?>
                <img src="<?php echo SENATORY_THEME_SETTINGS_IMAGES . '/event-single-shape.png'; ?>"
                        class="event-single-shape" alt="<?php esc_attr_e('event image','senatory');?>">


                <div class="bg-wrapper">
                    <div class="event-bg">

                        <?php echo tribe_event_featured_image($event_id, 'senatory_full', false); ?>

                        <div class="post-mate style-01">
                            <h2 class="post-date"><?php echo esc_html(date('d', strtotime($event_start_time))) ?></h2>
                            <div class="post-month"><?php echo esc_html(date('M', strtotime($event_start_time))) ?></div>
                        </div>

                        <div id="mycountdown" class="counter-single-item"
                                data-countdown="<?php echo tribe_get_display_end_date(null,false,'Y/m/d'); ?>">
                            <ul class="countdown">
                                <li class="counter-item">
                                    <span class="days"></span>
                                    <h6> <?php echo esc_html__('Days', 'senatory'); ?> </h6>
                                </li>
                                <li class="counter-item">
                                    <span class="hours"></span>
                                    <h6> <?php echo esc_html__('Hours', 'senatory'); ?> </h6>
                                </li>
                                <li class="counter-item">
                                    <span class="mins"></span>
                                    <h6> <?php echo esc_html__('Minute', 'senatory'); ?> </h6>
                                </li>
                                <li class="counter-item">
                                    <span class="secs"></span>
                                    <h6> <?php echo esc_html__('Second', 'senatory'); ?> </h6>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>


                <div class="content style-01">
                    <div class="subtitle">
                        <div class="location">
                            <div class="icon">
                                <i class="fas fa-map-marker-alt"></i>
                            </div>
                            <p><?php echo tribe_get_full_address($event_id); ?></p>
                        </div>
                        <div class="time">
                            <div class="icon">
                                <i class="far fa-clock"></i>
                            </div>
                            <p><?php echo tribe_get_start_date(null, false, 'h:i'); ?>
                                - <?php echo tribe_get_end_date(null, false, 'h:i'); ?></p>
                        </div>
                    </div>
                    <!-- Event content -->
                    <?php do_action('tribe_events_single_event_before_the_content') ?>
                    <div class="tribe-events-single-event-description tribe-events-content">
                        <?php the_content(); ?>
                    </div>
                </div>
    </div>
    <div class="event-location">
        <div class="row">
            <div class="col-lg-4">
                <div class="contact-page-wrapper style-01 wow animate__ animate__fadeInRight animated">
                    <div class="contact-form contact-bg event-contact-bg">
                        <div class="content desktop-center">
                            <img src="<?php echo SENATORY_THEME_SETTINGS_IMAGES . '/circle-title.png'; ?>"
                                    class="title-shape style-01" alt="<?php esc_html_e('Event Circle Image','senatory')?>">
                            <h6 class="title"><?php esc_html_e('Join the event','senatory')?></h6>
                        </div>
                        <?php echo do_shortcode($event_form_shortcode); ?>
                    </div>
                </div>
            </div>
            <div class="col-lg-8">
                <div class="contact_map">
                    <?php
                    do_action('tribe_events_single_event_meta_secondary_section_start');
                    tribe_get_template_part('modules/meta/map');
                    do_action('tribe_events_single_event_meta_secondary_section_end');
                    ?>

                </div>
            </div>
        </div>
    </div>







					
					