<?php 

$post_id = get_the_ID();
$img_id = get_post_thumbnail_id($post_id) ? get_post_thumbnail_id($post_id) : false;
$img_url_val = $img_id ? wp_get_attachment_image_src($img_id, 'full', false) : '';
$img_url = is_array($img_url_val) && !empty($img_url_val) ? $img_url_val[0] : '';

$event_id             = Tribe__Main::post_id_helper();
$time_format          = get_option( 'time_format', Tribe__Date_Utils::TIMEFORMAT );
$start_date = tribe_get_start_date( null, false );
$start_time = tribe_get_start_date( null, false, $time_format );


?>

    <div class="event-single-items home-six">
        <img src="assets/img/event-single-shape.png" class="event-single-shape style-01" alt="">
        <div class="bg-wrapper">
            <?php if(has_post_thumbnail()): ?>
            <div class="event-bg style-01" style="background-image: url(<?php echo esc_url($img_url); ?>);">
            <?php endif; ?>
            <div class="icon-box-wrapper">
                <div class="icon-box-item">
                    <div class="icon">
                        <img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/icon/calendar.png" alt="">
                    </div>
                    <div class="event-meta">
                        <span class="start-text">Start date</span>
                        <p class="date"><?php echo esc_html($start_date); ?></p>
                    </div>
                </div>
                <div class="icon-box-item">
                    <div class="icon">
                        <img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/icon/stopwatch.png" alt="">
                    </div>
                    <div class="event-meta">
                        <span class="start-text">Start time</span>
                        <p class="date"><?php echo esc_html($start_time); ?></p>
                    </div>
                </div>
                <div class="icon-box-item">
                    <div class="icon">
                        <img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/icon/mark.png" alt="">
                    </div>
                    <div class="event-meta">
                        <span class="start-text">Address</span>
                        <p class="date"><?php echo tribe_get_full_address($event_id); ?></p>
                    </div>
                </div>
            </div>
        </div>
        <?php the_content(); ?>


        </div>

        <!-- Organizar -->
        <div class="organizar-wrap">
        <?php 
        $args = array(
            'post_type' => 'tribe_organizer',
            'posts_per_page' => 1,
        );
        $organizer_qry = new WP_Query($args);
        
        ?>
        <?php while( $organizer_qry->have_posts( )): $organizer_qry->the_post(); 
        

            $post_id = get_the_ID();
            $img_id = get_post_thumbnail_id($post_id) ? get_post_thumbnail_id($post_id) : false;
            $img_url_val = $img_id ? wp_get_attachment_image_src($img_id, 'full', false) : '';
            $img_url = is_array($img_url_val) && !empty($img_url_val) ? $img_url_val[0] : '';
            // Organizer
            $phone = tribe_get_organizer_phone($post_id);
            $email = tribe_get_organizer_email($post_id);
            $website = tribe_get_organizer_website_link($post_id);
        ?>
            <div class="row">
                <div class="col-lg-6 col-md-6">
                    <div class="organizar-item">
                        <h6 class="title">Organizer</h6>
                    <?php if($img_url): ?>
                        <div class="thumbnail">
                            <img src="<?php echo esc_url($img_url); ?>" alt="">
                        </div>
                    <?php endif; ?>

          
                    </div>
                </div>
                <div class="col-lg-6 col-md-6">
                    <div class="organizar-items">
                        <div class="organizar-content">
                            <h6 class="title"><?php the_title(); ?></h6>
                            <p><?php the_content(); ?></p>
                        </div>
                        <div class="address-wrap">
                            <?php if(!empty($phone)): ?>
                            <p><a href="tel:<?php echo esc_attr($phone); ?>"><span><?php esc_html_e( 'Phone:', 'senatory' ); ?></span><?php echo esc_html($phone); ?></a></p>
                            <?php endif; ?>
                            <?php if(!empty($email)): ?>
                            <p><span><?php esc_html_e( 'Email:', 'senatory' ); ?></span><?php echo esc_html($email); ?></p>
                            <?php endif; ?>
                        </div>
                        <ul class="social-area">
                            <li><a href="#0"><i class="fab fa-facebook-f"></i></a></li>
                            <li><a href="#0"><i class="fab fa-twitter"></i></a></li>
                            <li><a href="#0"><i class="fab fa-instagram"></i></a></li>
                            <li><a href="#0"><i class="fab fa-youtube"></i></a></li>
                        </ul>
                    </div>
                </div>
            </div>

        <?php endwhile; ?>


        </div>


        <!-- <div class="legend-area">
            <h4 class="title">Legend Speakers</h4>
            <div class="legend-slider-one">
                <div class="team-single-items-02">
                    <div class="thumbnail">
                        <img src="assets/img/home-six/team/team-01.png" alt="">
                    </div>
                    <div class="team-content">
                        <h6 class="member-name">Hadward Alen</h6>
                        <p class="designation">Politician</p>
                    </div>  
                </div>
                <div class="team-single-items-02">
                    <div class="thumbnail">
                        <img src="assets/img/home-six/team/team-02.png" alt="">
                    </div>
                    <div class="team-content">
                        <h6 class="member-name">Lopic Thaous</h6>
                        <p class="designation">Politician</p>
                    </div>  
                </div>
                <div class="team-single-items-02">
                    <div class="thumbnail">
                        <img src="assets/img/home-six/team/team-03.png" alt="">
                    </div>
                    <div class="team-content">
                        <h6 class="member-name">Pie Goodman</h6>
                        <p class="designation">Politician</p>
                    </div>  
                </div>
                <div class="team-single-items-02">
                    <div class="thumbnail">
                        <img src="assets/img/home-six/team/team-04.png" alt="">
                    </div>
                    <div class="team-content">
                        <h6 class="member-name">Jon Brown</h6>
                        <p class="designation">Politician</p>
                    </div>  
                </div>
            </div>


        </div> -->

    </div>