<?php
/**
 * Footer Style 01
 * @package senatory
 * @since 1.0.0
 */

$copyright_text = !empty(cs_get_option('copyright_text')) ? cs_get_option('copyright_text') : esc_html__('Copyright © 2022 Senatory. All Rights Reserved. Designed by pizza . ', 'senatory') . '<a href="' . esc_url('https://themeforest.net/user/themeim/portfolio') . '">' . esc_html__('ThemeIM', 'senatory') . '</a>';
$copyright_text = str_replace('{copy}', '&copy;', $copyright_text);
$copyright_text = str_replace('{year}', date('Y'), $copyright_text);
$socialIcon = cs_get_option('footer_social_repeater');

$footer_two_newsletter = cs_get_option('footer_two_newsletter');

?>

<!-- footer area start -->
<footer class="theme-footer-one footer-area line-bg">
    <div class="footer-top issue style-01">
        <div class="container fone-custom-container">
            <div class="footer-top-border subscribe-wrap-footer">
                <div class="row">
                    <div class="col-lg-4 col-md-6">
                        <div class="footer-widget widget">
                            <div class="about_us_widget wow animate__animated animate__fadeInUp">
                                <?php
                                $footer_two_logo = cs_get_option('footer_two_logo');
                                if (has_custom_logo() && empty($footer_two_logo['id'])) {
                                    the_custom_logo();
                                } elseif (!empty($footer_two_logo['id'])) {
                                    printf('<a class="site-logo footer-logo" href="%1$s"><img src="%2$s" alt="%3$s"/></a>', esc_url(get_home_url()), $footer_two_logo['url'], $footer_two_logo['alt']);
                                } else {
                                    printf('<a class="site-title" href="%1$s">%2$s</a>', esc_url(get_home_url()), esc_html(get_bloginfo('title')));
                                }
                                ?>
                                <p><?php echo cs_get_option('footer_two_paragraph') ?> </p>

                                <div class="social-links">
                                    <?php
                                    if (!empty($socialIcon)) :
                                        foreach ($socialIcon as $icon) :
                                            echo '<a href=" ' . $icon['footer_social_icon_item_url'] . ' ">
									<i class="' . $icon['footer_social_icon_item_icon'] . '"></i></a>';
                                        endforeach;
                                    endif;
                                    ?>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-lg-3 col-md-6">
                        <ul class="contact_info_list wow animate__animated animate__fadeInUp">


                            <?php
                            $infoItem = cs_get_option('footer_two_top_repeater');
                            if (!empty($infoItem)) :
                                foreach ($infoItem as $item) :


                                    echo '
					<li class="single-info-item">
						<div class="icon style-01">
						<i class="' . $item['footer_two_info_icon'] . '"></i>
						</div>
						<div class="details style-01">
						' . $item['footer_two_top_info'] . '
						</div>
					</li>
					
					'; endforeach;
                            endif;
                            ?>
                        </ul>
                    </div>
                    <div class="col-lg-4 offset-xl-1 col-md-12">
                        <div class="footer-widget widget widget_subscribe subscribe-bg">
                            <div class="shape-01"></div>
                            <div class="shape-02"></div>
                            <div class="header-content">
                                <h4 class="title"><?php echo esc_html(cs_get_option('footer_two_newsletter_title')); ?></h4>
                            </div>
                            <?php echo do_shortcode($footer_two_newsletter); ?>
                        </div>
                    </div>
                </div>
            </div>
            <div class="footer-bottom-border">
                <div class="row">
                    <?php dynamic_sidebar('footer-widget'); ?>
                </div>
            </div>
            <div class="copyright-area">
                <div class="container">
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="copyright-area-inner">
                                <?php
                                echo wp_kses($copyright_text, senatory()->kses_allowed_html(array('a')));
                                ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</footer>
<!-- footer area end -->
  
 