<?php
/**
 * Footer Style 02
 * @package senatory
 * @since 1.0.0
 */

$call_to_action_text = !empty(cs_get_option('call_to_action_text')) ? cs_get_option('call_to_action_text') : esc_html__('Start Your Flight Training Today', 'senatory') . '<span>' . esc_html__('call us now!', 'senatory') . '</span>';
$copyright_text = !empty(cs_get_option('copyright_text')) ? cs_get_option('copyright_text') : esc_html__('Copyright © 2023 . All Rights Reserved. Paid for by The Dale Folwell for Governor campaign ', 'senatory') . '<a href="' . esc_url('https://themeforest.net/user/') . '">' . esc_html__('ThemeIM', 'senatory') . '</a>';
$copyright_text = str_replace('{copy}', '&copy;', $copyright_text);
$copyright_text = str_replace('{year}', date('Y'), $copyright_text);


?>

<!-- footer area start -->
<footer class="footer-area footer-three-custombg">
    <div class="footer-top style-02">
        <div class="container">
            <div class="footer-top-border padding-bottom-35">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="footer-widget widget widget_subscribe political">
                            <div class="shape-03"></div>
                            <div class="header-content style-01">
                                <h4 class="title style-01">
                                    <?php
                                    echo wp_kses($call_to_action_text, senatory()->kses_allowed_html(array('span')));
                                    ?>
                                </h4>
                                <div class="btn-wrapper desktop-center">
                                    <a href="<?php echo esc_url(cs_get_option('call_to_action_button_url')) ?>"
                                       class="boxed-btn political-btn style-01"><?php echo esc_html(cs_get_option('call_to_action_button_title')); ?>
                                        <i class="fas fa-paper-plane"></i></a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <?php dynamic_sidebar('footer-widget-two'); ?>
                </div>
            </div>
            <div class="copyright-area">
                <div class="container">
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="copyright-area-inner">
                                <?php
                                echo wp_kses($copyright_text, senatory()->kses_allowed_html(array('a')));
                                ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</footer>
<!-- footer area end -->
  
  